/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetOrientation
extends PrintCommand {
    private int or;

    public SetOrientation(GuiFactory gf, int or) {
        super(gf, 19);
        this.or = or;
    }

    public SetOrientation(GuiFactory gf, RandomAccessFile inOut) throws IOException {
        super(gf, 19);
        this.or = inOut.readInt();
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        inOut.writeInt(this.or);
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, g2d, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        if (pc.orientation != this.or) {
            pc.orientation = this.or;
            PageFormat newPf = new PageFormat();
            switch (pc.orientation) {
                default: {
                    newPf.setOrientation(1);
                    break;
                }
                case 2: {
                    newPf.setOrientation(0);
                    break;
                }
                case 4: {
                    newPf.setOrientation(2);
                }
            }
            newPf.setPaper(pf.getPaper());
            pc.pf = newPf;
        }
        return true;
    }
}

