/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.OSValidator;
import com.iscobol.rts.RuntimeProperties;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;

public class RtsUtil {
    public static final String eol = System.getProperty("line.separator", "\n");
    public static final String pathSeparator = ";";
    public static final char NUM_PREFIX = '$';

    public static String getCopyHeader(String fileType, String uri, String other) {
        StringBuilder sb = new StringBuilder();
        sb.append("*> " + fileType + " File: " + uri);
        sb.append(eol);
        sb.append("*>");
        sb.append(eol);
        sb.append("*> Generated by ");
        sb.append(RuntimeProperties.getFullVersionNumber());
        sb.append(eol);
        if (other != null) {
            sb.append("*> ");
            sb.append(other);
            sb.append(eol);
        }
        sb.append(eol);
        return sb.toString();
    }

    public static String[] parseArguments(String args) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        char[] c = args.toCharArray();
        char stringDelim = '\u0000';
        block4: for (int i = 0; i < c.length; ++i) {
            switch (c[i]) {
                case ' ': {
                    if (stringDelim != '\u0000') {
                        sb.append(c[i]);
                        continue block4;
                    }
                    if (sb.length() <= 0) continue block4;
                    result.add(sb.toString());
                    sb = new StringBuilder();
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    if (stringDelim == c[i]) {
                        stringDelim = '\u0000';
                        continue block4;
                    }
                    if (stringDelim == '\u0000') {
                        stringDelim = c[i];
                        continue block4;
                    }
                    sb.append(c[i]);
                    continue block4;
                }
                default: {
                    sb.append(c[i]);
                }
            }
        }
        if (sb.length() > 0) {
            result.add(sb.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] parseArguments(String args, String delimiters) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        char[] c = args.toCharArray();
        char[] delims = delimiters.toCharArray();
        char stringDelim = '\u0000';
        block3: for (int i = 0; i < c.length; ++i) {
            switch (c[i]) {
                case '\"': 
                case '\'': {
                    if (stringDelim == c[i]) {
                        stringDelim = '\u0000';
                        continue block3;
                    }
                    if (stringDelim == '\u0000') {
                        stringDelim = c[i];
                        continue block3;
                    }
                    sb.append(c[i]);
                    continue block3;
                }
                default: {
                    boolean isSep = false;
                    for (char sep : delims) {
                        if (c[i] != sep) continue;
                        isSep = true;
                        break;
                    }
                    if (isSep) {
                        if (stringDelim != '\u0000') {
                            sb.append(c[i]);
                            continue block3;
                        }
                        if (sb.length() <= 0) continue block3;
                        result.add(sb.toString());
                        sb = new StringBuilder();
                        continue block3;
                    }
                    sb.append(c[i]);
                }
            }
        }
        if (sb.length() > 0) {
            result.add(sb.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public static int revisionCmp(String rev1, String rev2) {
        String[] ar2;
        String[] ar1 = rev1.split("\\.");
        int min = ar1.length < (ar2 = rev2.split("\\.")).length ? ar1.length : ar2.length;
        for (int i = 0; i < min; ++i) {
            try {
                int n1 = Integer.parseInt(ar1[i]);
                int n2 = Integer.parseInt(ar2[i]);
                if (n1 == n2) continue;
                return n1 - n2;
            }
            catch (NumberFormatException _ex) {
                return ar1[i].compareTo(ar2[i]);
            }
        }
        return ar1.length - ar2.length;
    }

    public static Thread newStreamDreaner(final InputStream in, final PrintStream out) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(in));
                    String s = r.readLine();
                    while (s != null) {
                        out.println(s);
                        s = r.readLine();
                    }
                    r.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public static String getIscobolInstallLocation() {
        return new File(RuntimeProperties.class.getProtectionDomain().getCodeSource().getLocation().getPath().replace("%20", " ")).getParentFile().getParentFile().getAbsolutePath();
    }

    public static int indexOf(byte[] buf, byte[] b, int fromIdx) {
        if (b == null || b.length == 0 || fromIdx >= buf.length) {
            return -1;
        }
        if (fromIdx < 0) {
            fromIdx = 0;
        }
        for (int i = fromIdx; i < buf.length; ++i) {
            int j;
            if (buf[i] != b[0]) continue;
            for (j = 1; i + j < buf.length && j < b.length && buf[i + j] == b[j]; ++j) {
            }
            if (j != b.length) continue;
            return i;
        }
        return -1;
    }

    public static void loadProperties(Properties props, String fileName) throws IOException {
        InputStreamReader rdr = new InputStreamReader(new FileInputStream(fileName));
        props.load(rdr);
        rdr.close();
    }

    public static void loadProperties(Properties props, File fileName) throws IOException {
        InputStreamReader rdr = new InputStreamReader(new FileInputStream(fileName));
        props.load(rdr);
        rdr.close();
    }

    public static void loadProperties(Properties props, InputStream in) throws IOException {
        InputStreamReader rdr = new InputStreamReader(in);
        props.load(rdr);
        rdr.close();
    }

    public static Collection<String> loadPropertiesWithImport(Properties props, String fileName) throws IOException {
        ConfigLoader cl = new ConfigLoader(fileName);
        props.putAll((Map<?, ?>)cl);
        return cl.getImportedFiles();
    }

    public static Collection<String> loadPropertiesWithImport(Properties props, File fileName) throws IOException {
        ConfigLoader cl = new ConfigLoader(fileName);
        props.putAll((Map<?, ?>)cl);
        return cl.getImportedFiles();
    }

    public static Collection<String> loadPropertiesWithImport(Properties props, InputStream in) throws IOException {
        ConfigLoader cl = new ConfigLoader(in);
        props.putAll((Map<?, ?>)cl);
        return cl.getImportedFiles();
    }

    public static Collection<String> loadPropertiesWithImport(Properties props) throws IOException {
        return RtsUtil.loadPropertiesWithImport(props, RtsUtil.class.getClassLoader().getResourceAsStream("iscobol.properties"));
    }

    public static String newUTFString(byte[] b) {
        try {
            return new String(b, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(b);
        }
    }

    public static byte[] getUTFBytes(String s) {
        try {
            return s.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }

    public static void openModule(Class c1, Class c2, String pn) {
        try {
            Method getModule = Class.class.getMethod("getModule", new Class[0]);
            Object m1 = getModule.invoke((Object)c1, new Object[0]);
            Object m2 = getModule.invoke((Object)c2, new Object[0]);
            Class<?> module = m1.getClass();
            module.getMethod("addOpens", String.class, module).invoke(m1, pn, m2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static SAXParserFactory newSAXParserFactory() {
        return RtsUtil.newSAXParserFactory(null, null);
    }

    public static SAXParserFactory newSAXParserFactory(String className, ClassLoader loader) {
        SAXParserFactory factory = className != null ? SAXParserFactory.newInstance(className, loader) : SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return factory;
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        return RtsUtil.newDocumentBuilderFactory(null, null);
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory(String className, ClassLoader loader) {
        DocumentBuilderFactory factory = className != null ? DocumentBuilderFactory.newInstance(className, loader) : DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        return factory;
    }

    public static String[] getPathList(String pathList) {
        return RtsUtil.getPathList(pathList, false);
    }

    public static String[] getPathList(String pathList, boolean addLineFeedSeparator) {
        String sep = pathSeparator;
        if (!OSValidator.isWindows()) {
            sep = sep + ":";
        }
        if (addLineFeedSeparator) {
            sep = sep + "\n";
        }
        StringTokenizer stn = new StringTokenizer(pathList, sep);
        String[] Return2 = new String[stn.countTokens()];
        for (int i = 0; i < Return2.length; ++i) {
            Return2[i] = stn.nextToken();
        }
        return Return2;
    }

    public static Iterable<String> getPathIterable(String pathList) {
        String sep = pathSeparator;
        if (!OSValidator.isWindows()) {
            sep = sep + ":";
        }
        final StringTokenizer stn = new StringTokenizer(pathList, sep);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return stn.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return stn.nextToken();
                    }
                };
            }
        };
    }

    public static String readUTF(DataInput dIn) throws IOException {
        String ret;
        int l = dIn.readInt();
        if (l == -1) {
            ret = null;
        } else if (l == 0) {
            ret = "";
        } else {
            byte[] bytes = new byte[l];
            dIn.readFully(bytes);
            ret = new String(bytes, "UTF-8");
        }
        return ret;
    }

    public static String readUTFOptmz(DataInput dIn) throws IOException {
        if (dIn.readBoolean()) {
            return dIn.readUTF();
        }
        return null;
    }

    public static void writeUTF(String s, DataOutput dOut) throws IOException {
        if (s == null) {
            dOut.writeInt(-1);
        } else if (s.length() == 0) {
            dOut.writeInt(0);
        } else {
            byte[] bytes = s.getBytes("UTF-8");
            int l = bytes.length;
            dOut.writeInt(l);
            dOut.write(bytes);
        }
    }

    public static void writeUTFOptmz(String s, DataOutput dOut) throws IOException {
        if (s != null) {
            dOut.writeBoolean(true);
            dOut.writeUTF(s);
        } else {
            dOut.writeBoolean(false);
        }
    }

    public static byte[] hexToBytes(String s) {
        byte[] bytes = new byte[s.length() / 2];
        char[] chars = s.toCharArray();
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            byte b = 0;
            char c = chars[i];
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    b = (byte)(c - 48);
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    b = (byte)(c - 55);
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    b = (byte)(c - 87);
                }
            }
            c = chars[i + 1];
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    b = (byte)(b << 4 | c - 48);
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    b = (byte)(b << 4 | c - 55);
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    b = (byte)(b << 4 | c - 87);
                }
            }
            bytes[j] = b;
            i += 2;
            ++j;
        }
        return bytes;
    }

    public static String bytesToHex(byte[] b, int offs, int len) {
        StringBuffer Return2 = new StringBuffer();
        block8: for (int i = offs; i < len; ++i) {
            int c = (b[i] & 0xF0) >>> 4;
            switch (c) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    Return2.append(c);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    Return2.append((char)(c + 55));
                }
            }
            c = b[i] & 0xF;
            switch (c) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    Return2.append(c);
                    continue block8;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    Return2.append((char)(c + 55));
                }
            }
        }
        return Return2.toString();
    }

    public static String normalizeClassName(String origName) {
        char[] n;
        StringBuffer sb = new StringBuffer();
        File f = new File(origName);
        String parent = f.getParent();
        if (parent == null) {
            n = origName.toCharArray();
        } else {
            sb.append(parent);
            sb.append(File.separator);
            n = f.getName().toCharArray();
        }
        if (n.length > 0 && !Character.isJavaIdentifierStart(n[0])) {
            sb.append('$');
        }
        for (int i = 0; i < n.length; ++i) {
            if (n[i] == '-') {
                sb.append('_');
                continue;
            }
            if (n[i] == '.' || n[i] == ' ') break;
            sb.append(Character.toUpperCase(n[i]));
        }
        return sb.toString();
    }

    public static void serializationCheck(Object obj) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new ByteArrayOutputStream());){
            oos.writeObject(obj);
        }
    }

    private static class ConfigLoader
    extends Properties {
        private TreeSet<String> confFiles = new TreeSet();
        private String mainFileName;

        ConfigLoader(String fileName) throws IOException {
            this.intLoad(fileName);
            this.mainFileName = new File(fileName).getAbsolutePath();
        }

        ConfigLoader(File fileName) throws IOException {
            this.intLoad(fileName);
            this.mainFileName = fileName.getAbsolutePath();
        }

        ConfigLoader(InputStream is) throws IOException {
            this.intLoad(is);
        }

        private void intLoad(String fileName) throws IOException {
            this.intLoad(new File(fileName));
        }

        private void intLoad(File fileName) throws IOException {
            String path;
            if (fileName.exists() && fileName.isFile() && fileName.canRead() && !this.confFiles.contains(path = fileName.getAbsolutePath())) {
                this.confFiles.add(path);
                try {
                    this.intLoad(new FileInputStream(path));
                }
                catch (IOException ex) {
                    this.confFiles.remove(path);
                    throw ex;
                }
            }
        }

        private void intLoad(InputStream is) throws IOException {
            InputStreamReader r = new InputStreamReader(is);
            this.load(r);
            r.close();
        }

        @Override
        public final Object put(Object key, Object value) {
            if ("iscobol.conf.copy".equals(key)) {
                if (value instanceof String) {
                    try {
                        this.intLoad((String)value);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
            return super.put(key, value);
        }

        Collection<String> getImportedFiles() {
            TreeSet<String> Return2 = new TreeSet<String>((SortedSet<String>)this.confFiles);
            if (this.mainFileName != null) {
                Return2.remove(this.mainFileName);
            }
            return Return2;
        }
    }
}

