/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Base64;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IXMLAttributes;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.SAJParser;
import com.iscobol.rts.XMLStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Stack;
import org.xml.sax.SAXException;

public class JSONStream
extends XMLStream {
    private static final int PLAIN = 0;
    private static final int BOOLEAN = 1;
    private static final int BASE64 = 2;
    private static final int HEX = 3;
    private static final int RAW = 4;
    private static final int NULLABLE = 16;
    private final String rootName;
    private int indentNumber = -1;
    private final Charset charSet;
    private boolean escapeAnyCharacter;

    public JSONStream(ICobolVar v, ICobolVar hasDummyRoot, Charset cs) {
        super(v);
        String s = hasDummyRoot != null ? hasDummyRoot.toStringNoGui() : "";
        this.charSet = cs;
        if (Config.isTrue(s)) {
            IXMLAttributes xml0 = v.getIXMLAttributes();
            this.rootName = xml0.getIdentifier();
        } else {
            this.rootName = null;
        }
    }

    public JSONStream(ICobolVar v, ICobolVar hasDummyRoot, ICobolVar cs) {
        this(v, hasDummyRoot, cs != null ? Charset.forName(cs.toStringNoGui().trim()) : null);
    }

    public JSONStream(ICobolVar v, ICobolVar hasDummyRoot) {
        this(v, hasDummyRoot, (Charset)null);
    }

    public JSONStream(ICobolVar v) {
        this(v, null);
    }

    private void eol(PrintWriter out) {
        if (this.indentNumber >= 0) {
            out.println("");
        }
    }

    private void spaces(PrintWriter out, int indnt) {
        if (this.indentNumber > 0) {
            for (int i = 0; i < indnt; ++i) {
                out.print(' ');
            }
        }
    }

    private boolean dummyRoot() {
        return this.rootName != null;
    }

    @Override
    protected int read(InputStream in) {
        return this.read(new InputStreamReader(in));
    }

    @Override
    protected int read(Reader in) {
        ICobolVar var;
        this.readConfiguration();
        this.varStack = new Stack();
        if (this.initializeOnRead) {
            this.xmlVar.initialize(null, null, true);
        }
        if ((var = this.arrayOnly()) != null) {
            this.pushNode(var.getIParent(), null, null);
            this.pushNode(var, null, null);
        } else {
            this.pushNode(this.xmlVar, null, null);
        }
        try {
            SAJParser sajParser = new SAJParser(this.escapeAnyCharacter);
            sajParser.parse(in, this, this.rootName);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (SAXException _ex) {
            if (_ex.getException() != null) {
                throw new IscobolRuntimeException(_ex.getException());
            }
            throw new IscobolRuntimeException(_ex);
        }
        return 1;
    }

    protected void createTransformerHandler() {
    }

    @Override
    public void setPrintWriter(PrintWriter pw) {
        this.out = pw;
    }

    @Override
    public void setFileName(String fn, String encoding) {
        if (fn != null) {
            try {
                Charset cs = encoding != null ? Charset.forName(encoding) : this.charSet;
                if (cs != null) {
                    this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fn.trim()), cs));
                }
                this.out = new PrintWriter(new FileWriter(fn.trim()));
            }
            catch (FileNotFoundException _ex) {
                throw new IscobolRuntimeException(130, _ex.getMessage());
            }
            catch (IOException _ex) {
                throw new IscobolRuntimeException(133, _ex.getMessage());
            }
        } else {
            this.out = new PrintWriter(System.out);
        }
        this.createTransformerHandler();
    }

    private String JSEscape(String s) {
        StringBuffer Return2 = new StringBuffer();
        int len = s.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': {
                    Return2.append("\\O");
                    continue block10;
                }
                case '\b': {
                    Return2.append("\\b");
                    continue block10;
                }
                case '\f': {
                    Return2.append("\\f");
                    continue block10;
                }
                case '\n': {
                    Return2.append("\\n");
                    continue block10;
                }
                case '\r': {
                    Return2.append("\\r");
                    continue block10;
                }
                case '\t': {
                    Return2.append("\\t");
                    continue block10;
                }
                case '\"': {
                    Return2.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    Return2.append("\\\\");
                    continue block10;
                }
                default: {
                    Return2.append(c);
                }
            }
        }
        return Return2.toString();
    }

    private ICobolVar arrayOnly() {
        ICobolVar var = null;
        IXMLAttributes xml0 = this.xmlVar.getIXMLAttributes();
        if (xml0 == null || xml0.getIdentifier().length() == 0) {
            Enumeration chldrn = this.xmlVar.getChildren();
            int cnt = 0;
            while (chldrn.hasMoreElements()) {
                var = (ICobolVar)chldrn.nextElement();
                ++cnt;
            }
            if (cnt == 1 && ((xml0 = var.getIXMLAttributes()) == null || xml0.getIdentifier().length() == 0) && var.getDimensions() != null) {
                return var;
            }
        }
        return null;
    }

    @Override
    protected int internalWrite(boolean writeQualifiedTagNames) {
        ICobolVar var;
        this.readConfiguration();
        if (this.out == null) {
            this.setOutputStream(System.out);
        }
        if ((var = this.arrayOnly()) != null) {
            this.possibleArray(var, null, this.indentNumber, 0);
        } else if (this.dummyRoot()) {
            this.writeObject(this.xmlVar, null, 0);
        } else {
            this.out.print('{');
            this.eol(this.out);
            this.writeObject(this.xmlVar, null, this.indentNumber);
            this.eol(this.out);
            this.out.print('}');
        }
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        return 1;
    }

    private int getType(IXMLAttributes a) {
        int t;
        int n = t = a.isNullable() ? 16 : 0;
        if (a.isBoolean()) {
            return t + 1;
        }
        if (a.isBase64Binary()) {
            return t + 2;
        }
        if (a.isHexBinary()) {
            return t + 3;
        }
        if (a.isRaw()) {
            return t + 4;
        }
        return t + 0;
    }

    @Override
    protected boolean isEmpty(ICobolVar var, int[] dim) {
        IXMLAttributes a = var.getIXMLAttributes();
        if (a != null && a.isNullable()) {
            return false;
        }
        return super.isEmpty(var, dim);
    }

    protected boolean isNull(String attr, boolean isNumeric) {
        if (isNumeric) {
            try {
                return Integer.parseInt(attr) == 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return attr.trim().length() == 0;
    }

    private void writeObject(ICobolVar var, int[] dim, int indent) {
        boolean isNullable;
        IXMLAttributes xml0 = var.getIXMLAttributes();
        if (xml0 == null) {
            throw new IllegalArgumentException(var.getName());
        }
        int type = this.getType(xml0);
        boolean bl = isNullable = (type & 0x10) == 16;
        if (this.dummyRoot() && var == this.xmlVar) {
            this.possibleArray(var, dim, indent + this.indentNumber, this.getType(xml0));
        } else {
            String id = xml0.getIdentifier();
            this.spaces(this.out, indent);
            this.out.print('\"');
            this.out.print(id);
            this.out.print('\"');
            this.out.print(':');
            if (!isNullable && this.omitEmptyElements && this.isEmpty(var, dim)) {
                boolean hasChildren = false;
                Enumeration e = var.getChildren();
                while (e.hasMoreElements()) {
                    ICobolVar child = (ICobolVar)e.nextElement();
                    IXMLAttributes a = child.getIXMLAttributes();
                    if (a == null || a.isAttribute()) continue;
                    hasChildren = true;
                    break;
                }
                if (hasChildren) {
                    this.out.print("{}");
                } else {
                    this.out.print("\"\"");
                }
            } else {
                this.possibleArray(var, dim, indent + this.indentNumber, this.getType(xml0));
            }
        }
    }

    private void writeArray(ICobolVar var, int dimIdx, int n, int[] dim, int indent, int type) {
        boolean isNullable = (type & 0x10) == 16;
        this.out.print('[');
        if (n > 0) {
            boolean isObject = JSONStream.isObject(var);
            boolean writeComma = false;
            int i = 1;
            while (true) {
                dim[dimIdx] = ++i;
                if (isObject) {
                    if (isNullable || !this.omitEmptyElements || !this.isEmpty(var, dim)) {
                        if (writeComma) {
                            this.out.print(',');
                        } else {
                            writeComma = true;
                        }
                        this.eol(this.out);
                        this.spaces(this.out, indent);
                        this.out.print('{');
                        this.eol(this.out);
                        this.writeChildren(var, dim, indent + this.indentNumber, type);
                        this.eol(this.out);
                        this.spaces(this.out, indent);
                        this.out.print('}');
                    }
                } else if (!this.omitEmptyElements || !this.isEmpty(var, dim)) {
                    if (writeComma) {
                        this.out.print(',');
                    } else {
                        writeComma = true;
                    }
                    this.eol(this.out);
                    this.spaces(this.out, indent + this.indentNumber);
                    this.writeChildren(var, dim, indent + this.indentNumber, type);
                }
                if (i == n) break;
            }
            dim[dimIdx] = i;
            this.eol(this.out);
            this.spaces(this.out, isObject ? indent - this.indentNumber : indent);
        }
        this.out.print(']');
    }

    private void possibleArray(ICobolVar var, int[] dim, int indent, int type) {
        int[] myDim = var.getDimensions();
        if (dim == null) {
            if (myDim == null) {
                if (JSONStream.isObject(var)) {
                    this.out.print('{');
                    this.eol(this.out);
                    this.writeChildren(var, dim, indent, type);
                    this.eol(this.out);
                    this.spaces(this.out, indent - this.indentNumber);
                    this.out.print('}');
                } else {
                    this.writeChildren(var, dim, indent, type);
                }
            } else {
                dim = new int[1];
                this.writeArray(var, 0, myDim[0], dim, indent, type);
            }
        } else if (dim.length == myDim.length) {
            if (JSONStream.isObject(var)) {
                this.out.print('{');
                this.eol(this.out);
                this.writeChildren(var, dim, indent, type);
                this.eol(this.out);
                this.spaces(this.out, indent);
                this.out.print('}');
            } else {
                this.writeChildren(var, dim, indent, type);
            }
        } else {
            int[] newDim = new int[myDim.length];
            for (int i = 0; i < dim.length; ++i) {
                newDim[i] = dim[i];
            }
            dim = newDim;
            int n = this.getDimension(var, dim, myDim[myDim.length - 1]);
            this.writeArray(var, myDim.length - 1, n, dim, indent, type);
        }
    }

    private int getRTrimLen(byte[] b) {
        int len = b.length;
        if (this.rtrim) {
            for (int i = b.length - 1; i >= 0 && b[i] == 32; --i) {
                --len;
            }
        }
        return len;
    }

    private void writeValue(ICobolVar var, int type) {
        boolean isNullable = (type & 0x10) == 16;
        boolean isNumeric = var instanceof INumericVar;
        if (isNullable && this.isNull(var.toStringNoGui(), isNumeric)) {
            this.out.print("null");
        } else if (isNumeric) {
            switch (type) {
                case 1: {
                    this.out.print(var.toint() != 0);
                    break;
                }
                case 2: {
                    byte[] b = var.getBytes();
                    String s = new String(Base64.encode(b, 0, b.length));
                    this.out.print("\"" + s + "\"");
                    break;
                }
                case 3: {
                    byte[] b = var.getBytes();
                    String s = RtsUtil.bytesToHex(b, 0, b.length);
                    this.out.print("\"" + s + "\"");
                    break;
                }
                default: {
                    String s = var.toStringNoGui();
                    if (type != 4) {
                        s = s.replace(',', '.');
                    }
                    this.out.print(s);
                    break;
                }
            }
        } else {
            switch (type) {
                case 1: {
                    this.out.print(Boolean.parseBoolean(var.toStringNoGui().trim()));
                    break;
                }
                case 2: {
                    byte[] b = var.getBytes();
                    int len = this.getRTrimLen(b);
                    String s = new String(Base64.encode(b, 0, len));
                    this.out.print("\"" + s + "\"");
                    break;
                }
                case 3: {
                    byte[] b = var.getBytes();
                    int len = this.getRTrimLen(b);
                    String s = RtsUtil.bytesToHex(b, 0, len);
                    this.out.print("\"" + s + "\"");
                    break;
                }
                case 4: {
                    String s = var.toStringNoGui();
                    if (this.rtrim) {
                        s = Factory.rightTrim(s);
                    }
                    this.out.print(s);
                    break;
                }
                default: {
                    String s = var.toStringNoGui();
                    if (this.rtrim) {
                        s = Factory.rightTrim(s);
                    }
                    s = this.JSEscape(s);
                    this.out.print("\"" + s + "\"");
                }
            }
        }
    }

    private ICobolVar getNextElement(Enumeration e, int[] dim, boolean isNullable) {
        while (e.hasMoreElements()) {
            ICobolVar cv = (ICobolVar)e.nextElement();
            if (!isNullable && this.omitEmptyElements && this.isEmpty(cv, dim)) continue;
            return cv;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeChildren(ICobolVar var, int[] dim, int indent, int type) {
        ICobolVar child;
        boolean isNullable;
        Enumeration chldrn = var.getChildren();
        boolean bl = isNullable = (type & 0x10) == 16;
        if (chldrn == null || (child = this.getNextElement(chldrn, dim, isNullable)) == null) return;
        while (true) {
            IXMLAttributes xml0;
            if ((xml0 = child.getIXMLAttributes()) != null) {
                if (!xml0.isAttribute()) {
                    String id = xml0.getIdentifier();
                    if (id == null) throw new IscobolRuntimeException(3, "Invalid json struct:" + child.getName());
                    this.writeIdentified(id, child, dim, indent, this.getType(xml0));
                }
            } else {
                Enumeration myChldrn = child.getChildren();
                if (myChldrn != null && myChldrn.hasMoreElements()) {
                    this.possibleArray(child, dim, indent, type);
                } else {
                    if (dim != null) {
                        child = child.intIAt(dim);
                    }
                    this.writeValue(child, type);
                }
            }
            if ((child = this.getNextElement(chldrn, dim, isNullable)) == null) return;
            this.out.print(',');
            this.eol(this.out);
        }
    }

    private static boolean isObject(ICobolVar var) {
        Enumeration chldrn = var.getChildren();
        while (chldrn.hasMoreElements()) {
            ICobolVar child = (ICobolVar)chldrn.nextElement();
            IXMLAttributes xml0 = child.getIXMLAttributes();
            if (xml0 == null) continue;
            return true;
        }
        return false;
    }

    private void writeIdentified(String id, ICobolVar var, int[] dim, int indent, int type) {
        if (JSONStream.isObject(var)) {
            this.writeObject(var, dim, indent);
        } else {
            this.spaces(this.out, indent);
            this.out.print('\"');
            this.out.print(id);
            this.out.print('\"');
            this.out.print(':');
            this.possibleArray(var, dim, indent, type);
        }
    }

    @Override
    protected void readConfiguration() {
        this.indentNumber = Config.getProperty(".jsonstream.indent_number", -1);
        this.omitEmptyElements = Config.getProperty(".jsonstream.omit_empty_elements", true);
        this.rtrim = Config.getProperty(".jsonstream.rtrim", false);
        this.escapeAnyCharacter = Config.getProperty(".jsonstream.allow_backslash_escaping_any_character", false);
        this.initializeOnRead = Config.getProperty(".jsonstream.initialize_on_read", false);
    }
}

