/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.io.PathTokenizer;
import com.iscobol.rts.Base64;
import com.iscobol.rts.Config;
import com.iscobol.rts.File;
import com.iscobol.rts.HTTPData;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.IXMLAttributes;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.JSONStream;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.XMLStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class HTTPHandler {
    public static final int RESPONSE_TYPE_NORMAL = 0;
    public static final int RESPONSE_TYPE_ERROR = 1;
    public static final int RESPONSE_TYPE_REDIRECT = 2;
    private static HashMap outData = new HashMap();
    private final Map _inputData;
    private final Map headerInData;
    private Map headerOutData;
    private StringBuffer outMessage;
    private InputStream outBinaryFile;
    private Reader outTextFile;
    private String outMimeType = "text/plain";
    private int responseType = 0;
    private int error = 0;
    private boolean isSessionInvalid;
    private InputStream inputStream;
    private final Charset charSet;
    private String requestMethod;
    private String contentType;
    private String htmlPrefix;
    private java.io.File[] htmlPrefixArray;
    private Object request;
    private Object response;
    private Object session;

    public static HTTPHandler get() {
        HTTPHandler Return2 = (HTTPHandler)outData.get(Thread.currentThread());
        if (Return2 == null) {
            throw new IscobolRuntimeException(35, "No HTTP connection found");
        }
        return Return2;
    }

    public static HTTPHandler remove() {
        return (HTTPHandler)outData.remove(Thread.currentThread());
    }

    public HTTPHandler(Map inp, InputStream is, Map hd, Charset cs) {
        this._inputData = inp;
        this.inputStream = is;
        this.headerInData = hd;
        this.charSet = cs;
        outData.put(Thread.currentThread(), this);
        this.request = null;
        this.response = null;
        this.session = null;
    }

    public HTTPHandler(Map inp) {
        this(inp, null, null, null);
    }

    private Object inputDataGet(String key) {
        Object Return2 = this._inputData.get(key);
        if (Return2 == null) {
            for (Map.Entry item : this._inputData.entrySet()) {
                if (!key.equalsIgnoreCase(item.getKey().toString())) continue;
                Return2 = item.getValue();
                break;
            }
        }
        return Return2;
    }

    public Object getInputParameter(String key) {
        Object obj = this.inputDataGet(key);
        if (obj instanceof byte[]) {
            return obj;
        }
        if (obj instanceof String[] && ((String[])obj).length > 0) {
            return ((String[])obj)[0];
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public void accept(ICobolVar var) {
        this.accept(var, null);
    }

    private int set(ICobolVar var, String value) {
        if (value == null) {
            var.initialize(null, null, false);
            return 0;
        }
        if (var instanceof IPicNumEdit) {
            var.set(value.getBytes());
        } else {
            var.set(value);
        }
        return value.length();
    }

    private void accept(ICobolVar var, IXMLAttributes xml) {
        String identifier = xml != null ? xml.getIdentifier() : null;
        Enumeration chldrn = var.getChildren();
        IXMLAttributes xml0 = var.getIXMLAttributes();
        boolean initVar = Config.getProperty(".http.cgi_clear_missing_values", true);
        if (xml0 != null && !xml0.isCDATA() && xml0.getIdentifier() != null) {
            identifier = xml0.getIdentifier();
        }
        if (chldrn != null && chldrn.hasMoreElements()) {
            while (chldrn.hasMoreElements()) {
                this.accept((ICobolVar)chldrn.nextElement(), xml0);
            }
        } else {
            String paramName = identifier != null ? identifier : var.getName().toLowerCase().replace('-', '_');
            Object value = this.inputDataGet(paramName);
            if (value != null) {
                if (value instanceof byte[]) {
                    var.set((byte[])value);
                } else if (value instanceof String) {
                    this.set(var, xml, (String)value);
                } else if (value instanceof String[]) {
                    String[] values = (String[])value;
                    int[] dim = var.getDimensions();
                    if (dim != null && dim.length == 1) {
                        int i;
                        int minSize = Math.min(dim[0], values.length);
                        for (i = 0; i < minSize; ++i) {
                            this.set(var.intIAt(i + 1), xml, values[i]);
                        }
                        if (initVar) {
                            while (i < dim[0]) {
                                this.set(var.intIAt(i + 1), null);
                                ++i;
                            }
                        }
                    } else {
                        this.set(var, xml, values[0]);
                    }
                }
            } else if (initVar) {
                this.set(var, null);
            }
        }
    }

    private void set(ICobolVar var, IXMLAttributes xml, String s) {
        if (xml != null) {
            if (xml.isBase64Binary()) {
                byte[] b = Base64.decode(s.getBytes());
                if (b != null) {
                    var.set(b);
                } else {
                    this.set(var, s);
                }
            } else if (xml.isHexBinary()) {
                var.set(RtsUtil.hexToBytes(s));
            } else if (xml.isBoolean()) {
                boolean b = Boolean.parseBoolean(s);
                if (var instanceof INumericVar) {
                    var.set(b ? 1 : 0);
                } else {
                    var.set(Boolean.toString(b));
                }
            } else {
                this.set(var, s);
            }
        } else {
            this.set(var, s);
        }
    }

    public void acceptAllParameters(ICobolVar var) {
        String eol = System.getProperty("line.separator", "\n");
        StringBuffer result = new StringBuffer();
        for (Map.Entry e : this._inputData.entrySet()) {
            result.append(e.getKey());
            result.append('=');
            result.append(((String[])e.getValue())[0]);
            result.append(eol);
        }
        var.set(result.toString());
    }

    public String getHeader(String name) {
        String Return2;
        if (this.headerInData != null) {
            Return2 = (String)this.headerInData.get(name);
            if (Return2 == null) {
                Return2 = "";
            }
        } else {
            Return2 = "";
        }
        return Return2;
    }

    public int getIntHeader(String name) {
        String num = this.getHeader(name);
        if (num.length() > 0) {
            try {
                return Integer.parseInt(num);
            }
            catch (NumberFormatException _ex) {
                return -1;
            }
        }
        return -1;
    }

    public void acceptEx(ICobolVar v) {
        if (this.contentType.contains("xml") || Config.getProperty(".rest.default_stream", "json").equalsIgnoreCase("xml")) {
            this.acceptFromXML(v);
        } else {
            this.acceptFromJSON(v);
        }
    }

    public void acceptEx(ICobolVar v, ICobolVar hasDummyRoot) {
        if (this.contentType.contains("xml") || Config.getProperty(".rest.default_stream", "json").equalsIgnoreCase("xml")) {
            this.acceptFromXML(v);
        } else {
            this.acceptFromJSON(v, hasDummyRoot);
        }
    }

    public void acceptFromXML(ICobolVar v) {
        XMLStream xmlStream = new XMLStream(v);
        if (this.inputStream == null) {
            throw new IscobolRuntimeException(4, "stream=null");
        }
        xmlStream.readFromStream(this.inputStream);
    }

    public void acceptFromJSON(ICobolVar v) {
        JSONStream jsonStream = new JSONStream(v, null, this.charSet);
        if (this.inputStream == null) {
            throw new IscobolRuntimeException(4, "stream=null");
        }
        jsonStream.readFromStream(this.inputStream);
    }

    public void acceptFromJSON(ICobolVar v, ICobolVar hasDummyRoot) {
        JSONStream jsonStream = new JSONStream(v, hasDummyRoot, this.charSet);
        if (this.inputStream == null) {
            throw new IscobolRuntimeException(4, "stream=null");
        }
        jsonStream.readFromStream(this.inputStream);
    }

    public String getOutputMimeType() {
        return this.outMimeType;
    }

    public String getOutputMessage() {
        String Return2;
        if (this.outMessage != null) {
            Return2 = this.outMessage.toString();
        } else if (this.outTextFile != null) {
            this.outMessage = new StringBuffer();
            char[] buff = new char[512];
            try {
                int len;
                while ((len = this.outTextFile.read(buff)) > 0) {
                    this.outMessage.append(buff, 0, len);
                }
                this.outTextFile.close();
                this.outTextFile = null;
            }
            catch (IOException _ex) {
                this.outMessage.append(_ex.toString());
            }
            Return2 = this.outMessage.toString();
        } else {
            Return2 = null;
        }
        this.outMessage = null;
        return Return2;
    }

    public InputStream getOutputBinaryFile() {
        return this.outBinaryFile;
    }

    public Reader getOutputTextFile() {
        return this.outTextFile;
    }

    public int getResponseType() {
        return this.responseType;
    }

    public int getError() {
        return this.error;
    }

    public void addOutHeader(ICobolVar name, ICobolVar value) {
        this.addOutHeader(name.toStringNoGui().trim(), value == null ? null : value.toStringNoGui().trim());
    }

    private void addOutHeader(String k, String v) {
        if (this.headerOutData == null) {
            this.headerOutData = new HashMap();
        }
        if (v == null || v.length() == 0) {
            this.headerOutData.remove(k);
        } else {
            this.headerOutData.put(k, v);
        }
    }

    public Map getOutHeader() {
        return this.headerOutData;
    }

    public void displayEx(ICobolVar v) {
        this.displayEx(v, null, null);
    }

    public void displayEx(ICobolVar v, ICobolVar hasDummyRoot) {
        this.displayEx(v, hasDummyRoot, null);
    }

    public void displayEx(ICobolVar v, ICobolVar hasDummyRoot, ICobolVar cs) {
        if (this.contentType.contains("xml") || Config.getProperty(".rest.default_stream", "json").equalsIgnoreCase("xml")) {
            this.displayXML(v);
        } else {
            this.displayJSON(v, hasDummyRoot, cs);
        }
    }

    public void displayXML(ICobolVar var) {
        this.outMessage = new StringBuffer();
        this.outMimeType = "text/xml";
        this.responseType = 0;
        this.error = 0;
        XMLStream xs = new XMLStream(var);
        xs.writeToStringBuffer(this.outMessage);
    }

    public void displayJSON(ICobolVar var) {
        this.outMessage = new StringBuffer();
        this.outMimeType = "application/json";
        this.responseType = 0;
        this.error = 0;
        JSONStream js = new JSONStream(var);
        js.writeToStringBuffer(this.outMessage);
    }

    public void displayJSON(ICobolVar var, ICobolVar hasDummyRoot) {
        this.outMessage = new StringBuffer();
        this.outMimeType = "application/json";
        this.responseType = 0;
        this.error = 0;
        JSONStream js = new JSONStream(var, hasDummyRoot);
        js.writeToStringBuffer(this.outMessage);
    }

    public void displayJSON(ICobolVar var, ICobolVar hasDummyRoot, ICobolVar characterSet) {
        this.outMessage = new StringBuffer();
        this.outMimeType = "application/json";
        this.responseType = 0;
        this.error = 0;
        JSONStream js = new JSONStream(var, hasDummyRoot, characterSet);
        js.writeToStringBuffer(this.outMessage);
    }

    public void displayHTML(ICobolVar var, ICobolVar docType) {
        String type = docType == null ? "" : docType.toStringNoGui().trim();
        this.outMessage = new StringBuffer();
        this.outMimeType = "text/html";
        this.responseType = 0;
        this.error = 0;
        XMLStream xs = new XMLStream(var);
        xs.writeToStringBuffer(this.outMessage);
        if (type.length() > 0) {
            this.outMessage.insert(0, type);
        }
    }

    private void display(String str) {
        this.responseType = 0;
        this.error = 0;
        if (this.outMessage == null) {
            this.outMessage = new StringBuffer(str);
        } else {
            this.outMessage.append(str);
        }
    }

    public void displayText(ICobolVar var) {
        this.outMimeType = "text/plain";
        this.display(var.toStringNoGui().trim());
    }

    public void displayText(ICobolVar var, ICobolVar mimeType) {
        this.outMimeType = mimeType.toStringNoGui();
        this.display(var.toStringNoGui().trim());
    }

    public void displayBinaryFile(ICobolVar fileName, ICobolVar mimeType) {
        this.outMimeType = mimeType.toStringNoGui();
        this.outMessage = null;
        try {
            this.outBinaryFile = new FileInputStream(fileName.toStringNoGui().trim());
            this.responseType = 0;
            this.error = 0;
        }
        catch (IOException _ex) {
            StringWriter sw = new StringWriter();
            _ex.printStackTrace(new PrintWriter(sw));
            this.responseType = 1;
            this.error = 404;
            this.outMessage = sw.getBuffer();
            this.outBinaryFile = null;
        }
    }

    private void _displayTextFile(String fileName, String mimeType) {
        this.outMimeType = mimeType;
        this.outMessage = null;
        try {
            this.outTextFile = new FileReader(fileName.trim());
            this.responseType = 0;
            this.error = 0;
        }
        catch (IOException _ex) {
            StringWriter sw = new StringWriter();
            _ex.printStackTrace(new PrintWriter(sw));
            this.responseType = 1;
            this.error = 404;
            this.outMessage = sw.getBuffer();
            this.outBinaryFile = null;
        }
    }

    public void displayTextFile(ICobolVar fileName, ICobolVar mimeType) {
        this._displayTextFile(fileName.toStringNoGui().trim(), mimeType.toStringNoGui().trim());
    }

    public void displayTextFile(ICobolVar fileName) {
        this._displayTextFile(fileName.toStringNoGui().trim(), "text/plain");
    }

    public void displayError(int errnum, ICobolVar var) {
        this.displayError(errnum, var.toStringNoGui().trim());
    }

    public void displayError(int errnum, String var) {
        this.responseType = 1;
        this.error = errnum;
        this.outMessage = var != null ? new StringBuffer(var) : new StringBuffer("(null)");
    }

    public void redirect(ICobolVar var) {
        this.redirect(var, null);
    }

    public void redirect(ICobolVar var, HTTPData.Params p) {
        this.responseType = 2;
        this.error = 0;
        String strUrl = var.toStringNoGui().trim();
        this.outMessage = new StringBuffer(strUrl);
        if (p != null) {
            this.outMessage.append(strUrl.indexOf(63) >= 0 ? "&" : "?");
            p.getUrlencodedParameters(this.outMessage);
        }
    }

    public boolean isRedirect() {
        return this.responseType == 2;
    }

    public void invalidateSession() {
        this.isSessionInvalid = true;
    }

    public boolean isSessionInvalidated() {
        return this.isSessionInvalid;
    }

    private void getVarValue(ICobolVar var, StringBuffer sp) {
        StringBuffer sb = new StringBuffer();
        this.getVarValueRec(var, sb);
        sp.append(sb.toString().trim());
    }

    private void getVarValueRec(ICobolVar var, StringBuffer sp) {
        Enumeration chldrn = var.getChildren();
        if (chldrn != null && chldrn.hasMoreElements()) {
            while (chldrn.hasMoreElements()) {
                this.getVarValueRec((ICobolVar)chldrn.nextElement(), sp);
            }
        } else {
            sp.append(var.toStringNoGui());
        }
    }

    private void doHtmlProcess(Reader in, Map vars) throws IOException {
        if (Config.getProperty(".http.value_prefix_colon", false)) {
            this.doHtmlProcessColon(in, vars);
        } else {
            this.doHtmlProcessPercent(in, vars);
        }
    }

    private void doHtmlProcessPercent(Reader in, Map vars) throws IOException {
        int c;
        while ((c = in.read()) >= 0) {
            if (c == 37) {
                c = in.read();
                if (c == 37) {
                    StringBuffer sb = new StringBuffer();
                    while ((c = in.read()) >= 0 && c != 37) {
                        sb.append((char)c);
                    }
                    if (c == 37) {
                        c = in.read();
                        if (c == 37) {
                            ICobolVar var = (ICobolVar)vars.get(sb.toString().toUpperCase());
                            if (var == null) continue;
                            this.getVarValue(var, this.outMessage);
                            continue;
                        }
                        this.outMessage.append('%');
                        this.outMessage.append('%');
                        this.outMessage.append(sb);
                        this.outMessage.append('%');
                        this.outMessage.append((char)c);
                        continue;
                    }
                    this.outMessage.append('%');
                    this.outMessage.append('%');
                    this.outMessage.append(sb);
                    continue;
                }
                this.outMessage.append('%');
                this.outMessage.append((char)c);
                continue;
            }
            this.outMessage.append((char)c);
        }
    }

    private static boolean isCobolIdentifier(int c) {
        return Character.isJavaIdentifierPart((char)c) || c == 45;
    }

    private void doHtmlProcessColon(Reader in, Map vars) throws IOException {
        int c;
        while ((c = in.read()) >= 0) {
            if (c == 58) {
                c = in.read();
                if (HTTPHandler.isCobolIdentifier(c)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append((char)c);
                    while (HTTPHandler.isCobolIdentifier(c = in.read())) {
                        sb.append((char)c);
                    }
                    ICobolVar var = (ICobolVar)vars.get(sb.toString().toUpperCase());
                    if (var != null) {
                        this.getVarValue(var, this.outMessage);
                    } else {
                        this.outMessage.append(':');
                        this.outMessage.append(sb);
                    }
                } else {
                    this.outMessage.append(':');
                }
                if (c < 0) continue;
                this.outMessage.append((char)c);
                continue;
            }
            this.outMessage.append((char)c);
        }
    }

    private void addVar(ICobolVar var, Map vars) {
        Enumeration chldrn;
        IXMLAttributes xml = var.getIXMLAttributes();
        if (xml != null) {
            String name;
            if (!xml.isCDATA() && (name = xml.getIdentifier()) != null) {
                vars.put(name.toUpperCase(), var);
            }
        } else {
            vars.put(var.getName().toUpperCase(), var);
        }
        if ((chldrn = var.getChildren()) != null) {
            while (chldrn.hasMoreElements()) {
                this.addVar((ICobolVar)chldrn.nextElement(), vars);
            }
        }
    }

    private java.io.File getTemplate(String name) {
        String fp = Config.getProperty(".http.html_template_prefix", "");
        if (!fp.equals(this.htmlPrefix)) {
            this.htmlPrefix = fp;
            if (this.htmlPrefix.length() > 0) {
                PathTokenizer st = new PathTokenizer(this.htmlPrefix);
                int nt = st.countTokens();
                if (nt > 0) {
                    this.htmlPrefixArray = new java.io.File[nt];
                    for (int i = 0; i < nt; ++i) {
                        this.htmlPrefixArray[i] = File.get(st.nextToken());
                    }
                } else {
                    this.htmlPrefixArray = new java.io.File[]{File.get("")};
                }
            } else {
                this.htmlPrefixArray = new java.io.File[]{File.get("")};
            }
        }
        for (int i = 0; i < this.htmlPrefixArray.length; ++i) {
            java.io.File f;
            if (!name.endsWith(".htm") && !name.endsWith(".html")) {
                f = new java.io.File(this.htmlPrefixArray[i], name + ".html");
                if (f.exists()) {
                    return f;
                }
                f = new java.io.File(this.htmlPrefixArray[i], name + ".htm");
                if (f.exists()) {
                    return f;
                }
            }
            if (!(f = new java.io.File(this.htmlPrefixArray[i], name)).exists()) continue;
            return f;
        }
        return null;
    }

    public boolean processHtmlString(ICobolVar txt, ICobolVar var) {
        Enumeration chldrn;
        StringReader in = new StringReader(txt.toStringNoGui());
        if (Config.getProperty(".http.cgi_no_cache", true)) {
            this.addOutHeader("Pragma", "no-cache");
        }
        this.outMimeType = Config.getProperty(".http.cgi_content_type", "text/html");
        IXMLAttributes xml0 = var != null ? var.getIXMLAttributes() : null;
        if (this.outMessage == null) {
            this.outMessage = new StringBuffer();
        }
        HashMap vars = new HashMap();
        if (xml0 != null && !xml0.isCDATA() && (chldrn = var.getChildren()) != null && chldrn.hasMoreElements()) {
            while (chldrn.hasMoreElements()) {
                this.addVar((ICobolVar)chldrn.nextElement(), vars);
            }
        }
        try {
            this.doHtmlProcess(in, vars);
            ((Reader)in).close();
            return true;
        }
        catch (IOException _ex) {
            this.handleIOException(_ex);
            return false;
        }
    }

    public boolean processHtmlFile(ICobolVar var) {
        String fileName;
        IXMLAttributes xml0 = var.getIXMLAttributes();
        if (Config.getProperty(".http.cgi_no_cache", true)) {
            this.addOutHeader("Pragma", "no-cache");
        }
        this.outMimeType = Config.getProperty(".http.cgi_content_type", "text/html");
        if (this.outMessage == null) {
            this.outMessage = new StringBuffer();
        }
        if (xml0 != null && !xml0.isCDATA() && (fileName = xml0.getIdentifier()) != null) {
            Reader in = this.getPage(fileName);
            if (in != null) {
                HashMap vars = new HashMap();
                Enumeration chldrn = var.getChildren();
                if (chldrn != null && chldrn.hasMoreElements()) {
                    while (chldrn.hasMoreElements()) {
                        this.addVar((ICobolVar)chldrn.nextElement(), vars);
                    }
                }
                try {
                    this.doHtmlProcess(in, vars);
                    in.close();
                    return true;
                }
                catch (IOException _ex) {
                    this.handleIOException(_ex);
                }
            }
        } else {
            fileName = var.toStringNoGui().trim();
            Reader in = this.getPage(fileName);
            if (in != null) {
                char[] buff = new char[8192];
                try {
                    int len;
                    while ((len = in.read(buff)) > 0) {
                        this.outMessage.append(buff, 0, len);
                    }
                    in.close();
                    return true;
                }
                catch (IOException _ex) {
                    this.handleIOException(_ex);
                }
            }
        }
        return false;
    }

    private Reader getPage(String fileName) {
        java.io.File inf = this.getTemplate(fileName);
        if (inf != null) {
            try {
                return new FileReader(inf);
            }
            catch (IOException _ex) {
                this.handleIOException(_ex);
                return null;
            }
        }
        this.outMessage.append("File ");
        this.outMessage.append(fileName);
        this.outMessage.append(" doesn't exist.");
        this.outMessage.append("\nhttp.html_template_prefix=" + this.htmlPrefix);
        this.outMessage.append("\n");
        return null;
    }

    private void handleIOException(IOException _ex) {
        this.outMessage.append(_ex.toString());
        this.outMessage.append("\nhttp.html_template_prefix=" + this.htmlPrefix);
        this.outMessage.append("\n");
    }

    public String getMethod() {
        return this.requestMethod;
    }

    public void setMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType != null ? contentType.toLowerCase() : "";
    }

    public static int cgiGet(ICobolVar name, ICobolVar var, ICobolVar cobidx) {
        int Return2;
        int idx;
        HTTPHandler hndlr = HTTPHandler.get();
        Object value = hndlr.inputDataGet(name.toStringNoGui().trim());
        int n = idx = cobidx == null ? 0 : cobidx.toint();
        if (value instanceof byte[]) {
            if (idx <= 1) {
                var.set((byte[])value);
                Return2 = ((byte[])value).length;
            } else {
                Return2 = hndlr.set(var, "");
            }
        } else if (value instanceof String[]) {
            String[] values = (String[])value;
            Return2 = idx <= 1 ? hndlr.set(var, values[0]) : (--idx < values.length ? hndlr.set(var, values[idx]) : hndlr.set(var, ""));
        } else {
            Return2 = value != null ? (idx <= 1 ? hndlr.set(var, value.toString()) : hndlr.set(var, "")) : -1;
        }
        return Return2;
    }

    public static void cgiAccept(ICobolVar var) {
        HTTPHandler hndlr = HTTPHandler.get();
        hndlr.accept(var);
    }

    public static void cgiDisplay(ICobolVar var) {
        HTTPHandler hndlr = HTTPHandler.get();
        IXMLAttributes xml0 = var.getIXMLAttributes();
        if (xml0 != null && !xml0.isCDATA() && xml0.getIdentifier() != null) {
            hndlr.processHtmlFile(var);
        } else {
            hndlr.processHtmlString(var, null);
        }
    }

    public static void cgiDisplay(String var) {
        HTTPHandler hndlr = HTTPHandler.get();
        if (Config.getProperty(".http.cgi_no_cache", true)) {
            hndlr.addOutHeader("Pragma", "no-cache");
        }
        hndlr.outMimeType = Config.getProperty(".http.cgi_content_type", "text/html");
        hndlr.display(var);
    }

    public void setRequest(Object request) {
        this.request = request;
    }

    public Object getRequest() {
        return this.request;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public Object getResponse() {
        return this.response;
    }

    public void setSession(Object session) {
        this.session = session;
    }

    public Object getSession() {
        return this.session;
    }
}

