/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.EsqlCursor;
import com.iscobol.rts.EsqlRuntime;
import com.iscobol.rts.Factory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Vector;

public class EsqlPrepare {
    private String name;
    private boolean statNoData;
    private boolean call = false;
    private PreparedStatement hstmt;
    private int rowCount;
    private Connection con;
    private int type;
    private int holdability;
    private String query;
    private final Logger log = LoggerFactory.get(2048);
    private Vector<String> nameBind = new Vector();
    private static final boolean named_params = Config.getProperty(".esql.named_params", false);

    public EsqlPrepare(String name, int type, int holdabilit) {
        this.name = name;
        this.type = type;
        this.holdability = holdabilit;
    }

    public void setQuery(Connection co, String quer) throws SQLException {
        this.query = quer;
        this.con = co;
        this.statNoData = EsqlRuntime.isStatNoData(this.query);
        this.call = EsqlRuntime.isCall(this.query);
        if (this.hstmt != null) {
            try {
                if (this.log != null) {
                    this.log.info("Developers log: EsqlPrepare: before close PS " + this.hstmt);
                }
                this.hstmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (named_params && this.query.contains(":")) {
            this.getHostVars();
        }
        this.hstmt = EsqlRuntime.getStatement(this.con, this.query, this.type, this.holdability);
        if (this.log != null) {
            this.log.info("Developers log: EsqlPrepare: after open PS " + this.hstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet exec(int typ, int holdabilit, EsqlCursor ec) throws SQLException {
        if (this.type != typ || this.holdability != holdabilit) {
            this.type = typ;
            this.holdability = holdabilit;
            this.hstmt = EsqlRuntime.getStatement(this.con, this.query, this.type, this.holdability);
            if (this.log != null) {
                this.log.info("Developers log: EsqlPrepare: after open PS " + this.hstmt);
            }
            ec.setParams(this.hstmt);
        }
        ec.callExecuteHook(this.query, this.hstmt);
        this.rowCount = 0;
        if (this.hstmt != null) {
            boolean isExecute;
            block16: {
                if (!this.statNoData && Config.getProperty(".jdbc.fetch_size", 0) != 0) {
                    this.hstmt.setFetchSize(Config.getProperty(".jdbc.fetch_size", 0));
                }
                isExecute = false;
                if (!Factory.esqlTrace) {
                    isExecute = this.hstmt.execute();
                } else {
                    SQLException sqlEx = null;
                    long timestamp = Instant.now().toEpochMilli();
                    long start = System.nanoTime();
                    try {
                        isExecute = this.hstmt.execute();
                    }
                    catch (SQLException e) {
                        sqlEx = e;
                        return sqlEx;
                    }
                    finally {
                        EsqlRuntime.get().statementTracer(timestamp, System.nanoTime() - start, this.query, ec.getParams(), sqlEx);
                        if (sqlEx == null) break block16;
                        throw sqlEx;
                    }
                }
            }
            if (isExecute) {
                this.rowCount = 0;
                ResultSet rs = this.hstmt.getResultSet();
                if (this.log != null) {
                    this.log.info("Developers log: EsqlPrepare: after open RS " + this.hstmt + " call=" + this.call + " query[" + this.query + "]");
                }
                if (this.call) {
                    while (this.hstmt.getMoreResults()) {
                        if (this.log == null) continue;
                        this.log.info("Developers log: EsqlPrepare in while moreResult " + this.hstmt + " call=" + this.call);
                    }
                    if (this.log != null) {
                        this.log.info("Developers log: EsqlPrepare moreResult " + this.hstmt + " call=" + this.call);
                    }
                }
                return rs;
            }
            this.rowCount = this.hstmt.getUpdateCount();
            return null;
        }
        EsqlRuntime.esqlError(7, "/Syntax error");
        return null;
    }

    void setParams(EsqlCursor ec) throws SQLException {
        ec.setParams(this.hstmt);
    }

    public void close() throws SQLException {
        if (this.hstmt != null) {
            if (this.log != null) {
                this.log.info("Developers log: EsqlPrepare: before close PS " + this.hstmt);
            }
            this.hstmt.close();
        }
    }

    public boolean isStatNoData() {
        return this.statNoData;
    }

    public boolean isCall() {
        return this.call;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String getQuery() {
        return this.query;
    }

    public String getName() {
        return this.name;
    }

    public PreparedStatement getHstmt() {
        return this.hstmt;
    }

    public Vector getNameBind() {
        return this.nameBind;
    }

    void getHostVars() {
        String hostVar = "";
        int len = this.query.length();
        boolean quote = false;
        boolean dQuote = false;
        String intQuery = "";
        for (int i = 0; i < len; ++i) {
            if (!dQuote && !quote && this.query.charAt(i) == ':' && i < len - 1 && (this.query.charAt(i + 1) >= 'a' && this.query.charAt(i + 1) <= 'z' || this.query.charAt(i + 1) >= 'A' && this.query.charAt(i + 1) <= 'Z')) {
                hostVar = "";
                ++i;
                intQuery = intQuery + "?";
                while (i < len && this.query.charAt(i) != ' ' && this.query.charAt(i) != '.' && this.query.charAt(i) != ';' && this.query.charAt(i) != ',' && this.query.charAt(i) != '(' && this.query.charAt(i) != ')' && this.query.charAt(i) != '+' && this.query.charAt(i) != '/') {
                    hostVar = hostVar + this.query.charAt(i);
                    ++i;
                }
                if (i < len) {
                    intQuery = intQuery + this.query.charAt(i);
                }
                this.nameBind.addElement(hostVar);
                continue;
            }
            intQuery = intQuery + this.query.charAt(i);
            if (this.query.charAt(i) == '\'') {
                if (!quote) {
                    quote = true;
                    continue;
                }
                quote = false;
                continue;
            }
            if (this.query.charAt(i) != '\"') continue;
            dQuote = !dQuote;
        }
        this.query = intQuery;
    }
}

