/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICoverage;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.OSValidator;
import com.iscobol.rts.RuntimeInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class CallLoader {
    public static final String separator = File.separator;
    public static final char separatorChar = File.separatorChar;
    public static final String ext = ".class";
    public static final int RELOAD_ON_DEMAND = 0;
    public static final int RELOAD_WHEN_MODIFIED = 1;
    public static final int RELOAD_ALL_ON_DEMAND = 2;
    private static Map<String, LoaderWithTime> fastRepos = new ConcurrentHashMap<String, LoaderWithTime>();
    private static Map<String, LoaderWithTime> repos = new ConcurrentHashMap<String, LoaderWithTime>();
    private static int codePrefixReload;
    private static SharedClassLoader currentSharedClassLoader;
    private static final File DEFAULT_LOC;
    private final SharedClassLoader sharedClassLoader;
    private final PathItem[] callpath;
    private final boolean applyCodePath;

    private CallLoader(String[] path, boolean applyCodePath, SharedClassLoader scl) {
        this.callpath = new PathItem[path.length];
        for (int i = 0; i < this.callpath.length; ++i) {
            this.callpath[i] = new PathItem(path[i]);
        }
        this.applyCodePath = applyCodePath;
        this.sharedClassLoader = scl;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        File classFile;
        block20: {
            File parentDir;
            block21: {
                classFile = new File(className);
                Path p = classFile.toPath();
                Path r = p.getRoot();
                if (r != null) {
                    String rs = r.toString();
                    if (rs.equals("\\")) {
                        if (!this.applyCodePath) {
                            className = p.toAbsolutePath().getRoot().toString() + p.subpath(0, p.getNameCount()).toString();
                            classFile = new File(className);
                        }
                    } else if (rs.equals("/") && this.applyCodePath) {
                        className = p.subpath(0, p.getNameCount()).toString();
                        classFile = new File(className);
                    }
                }
                switch (codePrefixReload) {
                    case 0: {
                        LoaderWithTime cl = fastRepos.get(className);
                        if (cl != null) {
                            return cl.clazz;
                        }
                    }
                    default: {
                        Logger log = LoggerFactory.get(2);
                        if (this.callpath != null && this.callpath.length > 0 && !classFile.isAbsolute()) {
                            ClassNotFoundException excpt = null;
                            for (int i = 0; i < this.callpath.length; ++i) {
                                if (this.callpath[i].isJar) {
                                    try {
                                        if (log != null) {
                                            log.info("TRY LOADING:" + this.callpath[i].path + "/" + className);
                                        }
                                        return this.loadClass(this.callpath[i].path, className);
                                    }
                                    catch (ClassNotFoundException e) {
                                        excpt = e;
                                        if (log == null) continue;
                                        log.info(this.callpath[i].path + "/" + className + " FAILED!");
                                        continue;
                                    }
                                }
                                StringBuffer sb = new StringBuffer(this.callpath[i].path);
                                try {
                                    sb.append(separator);
                                    sb.append(className);
                                    sb.append(ext);
                                    if (log != null) {
                                        log.info("TRY LOADING:" + sb.toString());
                                    }
                                    return this.loadClass(this.callpath[i].path, new File(sb.toString()), className);
                                }
                                catch (ClassNotFoundException e) {
                                    excpt = e;
                                    if (log == null) continue;
                                    log.info(sb.toString() + " FAILED!");
                                }
                            }
                            throw excpt;
                        }
                        return this.loadClass("", new File(className + ext), className);
                    }
                    case 2: 
                }
                parentDir = classFile.getParentFile();
                if (parentDir == null) break block20;
                if (!parentDir.isAbsolute()) break block21;
                if (!new File(className + ext).exists()) break block20;
                CallLoader.appendURLs(this.sharedClassLoader, new String[]{parentDir.getPath()});
                break block20;
            }
            for (int i = 0; i < this.callpath.length; ++i) {
                if (this.callpath[i].isJar || !new File(this.callpath[i].path + separator + className + ext).exists()) continue;
                CallLoader.appendURLs(this.sharedClassLoader, new String[]{this.callpath[i].path + separator + parentDir.getPath()});
                break;
            }
        }
        return CallLoader.intLoadClass(classFile.getName(), DEFAULT_LOC, this.sharedClassLoader);
    }

    private static void appendURLs(SharedClassLoader scl, String[] paths) {
        for (String path : paths) {
            File f = new File(path);
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                scl.addURL(f.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public static CallLoader getInstance(String codePfx) {
        return CallLoader.getInstance(codePfx, false);
    }

    public static CallLoader getInstance(String codePfx, boolean applyCodePath) {
        CallLoader Return2 = null;
        StringTokenizer st = new StringTokenizer(codePfx, "\n" + File.pathSeparatorChar);
        int nt = st.countTokens();
        if (nt > 0) {
            SharedClassLoader scl;
            ArrayList<String> codePrefix = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                File f = new File(path);
                if ("*".equals(f.getName())) {
                    File p = f.getParentFile();
                    if (p == null || !p.exists()) continue;
                    String dir = p.getPath() + File.separator;
                    for (File jar : p.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".jar");
                        }
                    })) {
                        codePrefix.add(dir + jar.getName());
                    }
                    continue;
                }
                if (".".equals(f.getName())) {
                    codePrefix.add(0, path);
                    continue;
                }
                codePrefix.add(path);
            }
            String[] paths = codePrefix.toArray(new String[codePrefix.size()]);
            if (codePrefixReload == 2) {
                scl = (SharedClassLoader)IscobolSystem.get(SharedClassLoader.class);
                if (scl == null) {
                    if (currentSharedClassLoader == null) {
                        currentSharedClassLoader = new SharedClassLoader();
                    }
                    scl = currentSharedClassLoader;
                    IscobolSystem.set(SharedClassLoader.class, scl);
                }
                CallLoader.appendURLs(scl, paths);
            } else {
                scl = null;
            }
            Return2 = new CallLoader(paths, applyCodePath, scl);
        }
        return Return2;
    }

    private Class loadClass(String jarName, String className) throws ClassNotFoundException {
        String repId = jarName + "!" + className;
        File jarFile = new File(jarName);
        LoaderWithTime cl = repos.get(repId);
        if (cl == null || codePrefixReload == 1 && jarFile.lastModified() != cl.timestamp) {
            if (cl != null) {
                try {
                    cl.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                cl = new LoaderWithTime(jarFile, className);
            }
            catch (MalformedURLException e) {
                throw new ClassNotFoundException(className + ", " + e);
            }
            repos.put(repId, cl);
            if (codePrefixReload == 0) {
                cl.repId = repId;
                fastRepos.put(className, cl);
            }
            System.gc();
        } else if (cl != null && codePrefixReload == 0) {
            fastRepos.put(className, cl);
            cl.fastRepIds.add(className);
        }
        return cl.clazz;
    }

    private Class loadClass(String callPath, File classFile, String className) throws ClassNotFoundException {
        File parent;
        String repId;
        try {
            repId = classFile.getCanonicalPath();
            classFile = new File(repId);
            parent = classFile.getParentFile();
        }
        catch (IOException e) {
            throw new ClassNotFoundException(classFile.getPath() + ", " + e);
        }
        LoaderWithTime cl = repos.get(repId);
        if (cl == null || codePrefixReload == 1 && classFile.lastModified() != cl.timestamp) {
            if (cl != null) {
                try {
                    cl.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                cl = new LoaderWithTime(callPath, parent, classFile);
            }
            catch (MalformedURLException e) {
                throw new ClassNotFoundException(classFile.getPath() + ", " + e);
            }
            repos.put(repId, cl);
            if (codePrefixReload == 0) {
                cl.repId = repId;
                fastRepos.put(className, cl);
            }
            System.gc();
        } else if (cl != null && codePrefixReload == 0) {
            fastRepos.put(className, cl);
            cl.fastRepIds.add(className);
        }
        return cl.clazz;
    }

    public static int unloadClass(String[] className) {
        String[] regex;
        boolean unloadAll;
        switch (codePrefixReload) {
            case 1: {
                return 0;
            }
            case 2: {
                currentSharedClassLoader = new SharedClassLoader();
                RuntimeInfo rInfo = (RuntimeInfo)IscobolSystem.get(RuntimeInfo.class);
                if (rInfo != null) {
                    switch (rInfo.getRuntimeEnvironmentType()) {
                        case STANDALONE: 
                        case STANDALONE_CHARVA: 
                        case MOBILE: {
                            return 0;
                        }
                    }
                    return 1;
                }
                return 0;
            }
        }
        boolean bl = unloadAll = className == null;
        if (unloadAll) {
            regex = new String[1];
        } else {
            regex = new String[className.length];
            for (int i = 0; i < className.length; ++i) {
                StringBuilder sb = new StringBuilder();
                StringBuilder sb0 = new StringBuilder();
                for (char c : className[i].toCharArray()) {
                    if (c == '*') {
                        if (sb0.length() > 0) {
                            sb.append(Pattern.quote(sb0.toString()));
                        }
                        sb.append(".*");
                        sb0 = new StringBuilder();
                        continue;
                    }
                    sb0.append(c);
                }
                if (sb0.length() > 0) {
                    sb.append(Pattern.quote(sb0.toString()));
                }
                regex[i] = sb.toString();
            }
        }
        int Return2 = 0;
        if (regex.length > 0) {
            for (Object k : fastRepos.keySet().toArray()) {
                for (String r : regex) {
                    LoaderWithTime cl;
                    if (!unloadAll && !k.toString().matches(r) || (cl = fastRepos.remove(k)) == null) continue;
                    try {
                        cl.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    for (String fRepId : cl.fastRepIds) {
                        fastRepos.remove(fRepId);
                    }
                    repos.remove(cl.repId);
                    ++Return2;
                }
            }
        }
        if (Return2 > 0) {
            System.gc();
        }
        return Return2;
    }

    public static void init() {
        String val = Config.getProperty("iscobol.code_prefix.reload", Integer.toString(1));
        try {
            codePrefixReload = Integer.parseInt(val);
            if (codePrefixReload < 0 || codePrefixReload > 2) {
                codePrefixReload = 1;
            }
        }
        catch (NumberFormatException ex) {
            codePrefixReload = Config.isTrue(val) ? 1 : 0;
        }
    }

    public static Vector<Vector<String>> getLoadedClasses() {
        Vector<Vector<String>> Return2 = new Vector<Vector<String>>();
        if (codePrefixReload == 2) {
            return Return2;
        }
        final boolean isWindows = OSValidator.isWindows();
        Comparator<String> comp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return isWindows ? o1.compareToIgnoreCase(o2) : o1.compareTo(o2);
            }
        };
        TreeMap<String, TreeSet<String>> map = new TreeMap<String, TreeSet<String>>(comp);
        Map<String, LoaderWithTime> rep = codePrefixReload == 1 ? repos : fastRepos;
        for (String className : rep.keySet()) {
            LoaderWithTime cl = rep.get(className);
            String classLoc = cl.callPath;
            TreeSet<String> l = (TreeSet<String>)map.get(classLoc);
            if (l == null) {
                l = new TreeSet<String>(comp);
                map.put(classLoc, l);
            }
            l.add(className + "," + cl.timestamp);
        }
        for (String path : map.keySet()) {
            Vector<String> v = new Vector<String>();
            Return2.addElement(v);
            v.addElement(path);
            for (String className : (Set)map.get(path)) {
                v.addElement(className);
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class intLoadClass(String className, File classLocation, ClassLoader cl) throws ClassNotFoundException {
        Class c;
        ICoverage cov;
        if (IscobolSystem.isUnitTest()) {
            cl.setDefaultAssertionStatus(true);
        }
        if ((cov = IscobolSystem.getCoverage()) != null) {
            ICoverage iCoverage = cov;
            synchronized (iCoverage) {
                c = cov.loadClass(classLocation.getAbsolutePath(), className, false, cl);
            }
        } else {
            c = cl.loadClass(className);
        }
        return c;
    }

    private static ClassLoader getParentClassLoader() {
        ClassLoader Return2 = Thread.currentThread().getContextClassLoader();
        if (Return2 == null) {
            Return2 = ClassLoader.getSystemClassLoader();
        }
        return Return2;
    }

    static {
        DEFAULT_LOC = new File(".");
        CallLoader.init();
    }

    public static class LoaderWithTime
    extends URLClassLoader {
        final long timestamp;
        final Class clazz;
        private final File classLocation;
        private final String callPath;
        private Vector<String> fastRepIds = new Vector();
        private String repId;

        LoaderWithTime(String callPath, File classFolder, File classFile) throws ClassNotFoundException, MalformedURLException {
            super(new URL[]{classFolder.toURI().toURL()}, CallLoader.getParentClassLoader());
            this.callPath = callPath;
            this.classLocation = classFolder;
            String className = classFile.getName();
            className = className.substring(0, className.length() - CallLoader.ext.length());
            this.timestamp = classFile.lastModified();
            this.clazz = CallLoader.intLoadClass(className, this.classLocation, this);
        }

        LoaderWithTime(File jarFile, String className) throws ClassNotFoundException, MalformedURLException {
            super(new URL[]{jarFile.toURI().toURL()}, CallLoader.getParentClassLoader());
            this.callPath = jarFile.getPath();
            this.classLocation = jarFile;
            this.timestamp = jarFile.lastModified();
            this.clazz = CallLoader.intLoadClass(className, this.classLocation, this);
        }

        public File getClassLocation() {
            return this.classLocation;
        }

        public String toString() {
            return this.getClass().getName() + "[class location: " + this.classLocation + "]";
        }
    }

    public static class SharedClassLoader
    extends URLClassLoader {
        SharedClassLoader() {
            super(new URL[0], CallLoader.getParentClassLoader());
            if (IscobolSystem.isUnitTest()) {
                this.setDefaultAssertionStatus(true);
            }
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }

    static final class PathItem {
        final String path;
        final boolean isJar;

        PathItem(String p) {
            this.path = p;
            this.isJar = new File(p).isFile();
        }

        public final String toString() {
            return this.path;
        }
    }
}

