/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.common;

import java.util.ArrayList;

public class ThreadDiagnostics {
    private ArrayList threadList = new ArrayList();

    public static ThreadGroup getTopLevelThreadGroup() {
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public static void dumpStack() {
        Thread.dumpStack();
    }

    public ArrayList getAllThreads() {
        this.setThreadList(new ArrayList());
        ThreadGroup root = ThreadDiagnostics.getTopLevelThreadGroup();
        this.visit(root, 0);
        return this.getThreadList();
    }

    public void visit(ThreadGroup group, int level) {
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            this.getThreadList().add(thread);
        }
        int numGroups = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = group.enumerate(groups, false);
        for (int i = 0; i < numGroups; ++i) {
            this.visit(groups[i], level + 1);
        }
    }

    public static void main(String[] args) {
        ThreadDiagnostics o = new ThreadDiagnostics();
        ArrayList threads = o.getAllThreads();
        System.out.println("no of threads is:" + threads.size());
        for (Thread t : threads) {
            System.out.println("*****************************");
            System.out.println("thread name: " + t.getName());
            ThreadGroup tg = t.getThreadGroup();
            System.out.println("thread group name: " + tg.getName());
            ThreadDiagnostics.dumpStack();
        }
    }

    protected void setThreadList(ArrayList threadList) {
        this.threadList = threadList;
    }

    protected ArrayList getThreadList() {
        return this.threadList;
    }
}

