/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.common;

import com.iscobol.rpc.messageserver.common.ISessionControl;
import com.iscobol.rpc.messageserver.common.InboundMessageHandler;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.OutboundMessageHandler;
import com.iscobol.rpc.messageserver.common.SessionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class Session {
    private Socket socket = null;
    private ObjectInputStream instream = null;
    private ObjectOutputStream outstream = null;
    private int sessionId;
    private InboundMessageHandler inboundHandler = null;
    private OutboundMessageHandler outboundHandler = null;
    private ISessionControl sessionControl = null;
    private boolean client;
    private boolean maxConnectionLimitExceeded;

    public Session(ISessionControl sessionControl, Socket socket) throws IOException {
        this(sessionControl, socket, false);
    }

    public Session(ISessionControl sessionControl, Socket socket, boolean client) throws IOException {
        this.setSessionControl(sessionControl);
        this.setSocket(socket);
        this.setOutstream(new ObjectOutputStream(new BufferedOutputStream(this.getSocket().getOutputStream())));
        this.outstream.flush();
        this.setInstream(new ObjectInputStream(new BufferedInputStream(this.getSocket().getInputStream())));
        this.setSessionId(socket.hashCode());
        this.setInboundHandler(new InboundMessageHandler(this));
        this.setOutboundHandler(new OutboundMessageHandler(this));
        this.getInboundHandler().setDaemon(true);
        this.getOutboundHandler().setDaemon(true);
        this.client = client;
    }

    public boolean isClientSession() {
        return this.client;
    }

    public void startMessageHandlers() {
        this.getInboundHandler().start();
        this.getOutboundHandler().start();
    }

    public String getRemoteHost() {
        return this.getSocket().getInetAddress().getHostAddress();
    }

    public int getRemotePort() {
        return this.getSocket().getPort();
    }

    public synchronized void sendMessage(Message msg) throws SessionException {
        if (!this.getSessionControl().isSendAndReceiveMessages()) {
            throw new SessionException("sendMessage() activity is suspended");
        }
        this.getOutboundHandler().sendMessage(msg);
    }

    public Message getMessage(boolean blockUntilMessage) throws SessionException {
        Message message = null;
        if (!this.getSessionControl().isSendAndReceiveMessages()) {
            throw new SessionException("getMessage() activity is suspended");
        }
        message = this.getInboundHandler().getMessage(blockUntilMessage);
        return message;
    }

    public synchronized void closeSession() {
        this.getInboundHandler().setSignalToStop(true);
        this.getOutboundHandler().setSignalToStop(true);
        try {
            this.getSocket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    protected void setInstream(ObjectInputStream instream) {
        this.instream = instream;
    }

    protected ObjectInputStream getInstream() {
        return this.instream;
    }

    protected void setOutstream(ObjectOutputStream outstream) {
        this.outstream = outstream;
    }

    protected ObjectOutputStream getOutstream() {
        return this.outstream;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    protected void setInboundHandler(InboundMessageHandler inboundHandler) {
        this.inboundHandler = inboundHandler;
    }

    protected InboundMessageHandler getInboundHandler() {
        return this.inboundHandler;
    }

    protected void setOutboundHandler(OutboundMessageHandler outboundHandler) {
        this.outboundHandler = outboundHandler;
    }

    protected OutboundMessageHandler getOutboundHandler() {
        return this.outboundHandler;
    }

    public void setSessionControl(ISessionControl sessionControl) {
        this.sessionControl = sessionControl;
    }

    public ISessionControl getSessionControl() {
        return this.sessionControl;
    }

    public boolean isMaxConnectionLimitExceeded() {
        return this.maxConnectionLimitExceeded;
    }

    public void setMaxConnectionLimitExceeded(boolean maxConnectionLimitExceeded) {
        this.maxConnectionLimitExceeded = maxConnectionLimitExceeded;
    }
}

