/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.common;

import com.iscobol.logger.Logger;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.MessageSerializationException;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import com.iscobol.rpc.messageserver.common.ThreadsafeQueue;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;

public class OutboundMessageHandler
extends Thread {
    private Session session = null;
    private ObjectOutputStream outstream = null;
    private ThreadsafeQueue queue = new ThreadsafeQueue();
    private boolean signalToStop = false;
    private IMessageSerializer messageSerializer = null;

    public OutboundMessageHandler(Session session) {
        this.setSession(session);
        this.setOutstream(session.getOutstream());
        this.setMessageSerializer(this.getSession().getSessionControl().getMessageSerializer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSignalToStop(boolean signalToStop) {
        this.signalToStop = signalToStop;
        ThreadsafeQueue threadsafeQueue = this.queue;
        synchronized (threadsafeQueue) {
            this.queue.notifyAll();
        }
    }

    public void sendMessage(Message msg) throws SessionException {
        if (this.isSignalToStop()) {
            throw new SessionException("Connection is closed");
        }
        this.queue.put(msg);
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.getClass().getName() + ":hashcode=" + this.hashCode() + ":sessionId=" + this.getSession().getSessionId());
        Config.markNoIscobolRuntimeThread();
        Message msg = null;
        while (!this.isSignalToStop()) {
            try {
                msg = (Message)this.queue.get();
                Logger log = this.getSession().isClientSession() ? RemoteRegistry.getClientProblemLogger() : RemoteRegistry.getProblemLogger(this.getSession().getSessionId());
                int compressLevel = RemoteRegistry.getCompressLevel(this.getSession().getSessionId());
                int minSizeCompress = RemoteRegistry.getMinSizeCompress(this.getSession().getSessionId());
                this.getMessageSerializer().serialize(msg, this.outstream, log, compressLevel, minSizeCompress);
                this.outstream.flush();
            }
            catch (MessageSerializationException mse) {
                try {
                    Object pl = msg.getPayload();
                    if (pl != null) {
                        Method m = pl.getClass().getMethod("setException", Throwable.class);
                        m.invoke(pl, mse);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.getSession().closeSession();
            }
            catch (Exception ex) {
                this.getSession().closeSession();
            }
            IscobolSystem.destroyEnv(this);
            Thread.yield();
        }
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    protected void setOutstream(ObjectOutputStream outstream) {
        this.outstream = outstream;
    }

    protected ObjectOutputStream getOutstream() {
        return this.outstream;
    }

    protected synchronized boolean isSignalToStop() {
        return this.signalToStop;
    }

    public void setMessageSerializer(IMessageSerializer messageSerializer) {
        this.messageSerializer = messageSerializer;
    }

    public IMessageSerializer getMessageSerializer() {
        return this.messageSerializer;
    }
}

