/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rmi;

import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.server.ServerRemoteObject;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.RpcCallPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayload;
import com.iscobol.rpc.dualrpc.common.RpcWorker;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class Worker
extends RpcWorker {
    private RemoteRegistry registry;

    public Worker(IRpcMessageDispatcher disp, Message message, RemoteRegistry reg) {
        super(disp, message);
        this.registry = reg;
    }

    @Override
    protected void configureThread() {
        super.configureThread();
        Config.markNoIscobolRuntimeThread();
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            IscobolSystem.destroyEnv(this);
        }
    }

    @Override
    public void processRpcCallMessage(Message message) throws SessionException {
        block12: {
            IRpcMessageDispatcher dispatcher = this.getDispatcher();
            Session session = dispatcher.getSession();
            long sessionId = session.getSessionId();
            RpcCallPayload payload = null;
            int messageId = message.getId();
            try {
                Method handlerMethod;
                Object handler;
                payload = (RpcCallPayload)message.getPayload();
                ArrayList paramList = payload.getParameters();
                Object[] paramArray = null;
                if (paramList != null) {
                    paramArray = new Object[paramList.size()];
                    paramList.toArray(paramArray);
                }
                int objectId = payload.getObjectId();
                boolean oldStringTransmission = false;
                if (objectId >= 0) {
                    handler = this.registry.get(objectId);
                    short metIdx = payload.getMethodId();
                    handlerMethod = ServerRemoteObject.getMethod(handler.getClass(), metIdx);
                } else {
                    String handlerClassname = payload.getHandlerName();
                    String handlerMethodName = payload.getMethodName();
                    oldStringTransmission = "getCsVersion".equals(handlerMethodName);
                    handler = dispatcher.getHandler(handlerClassname);
                    if (handler == null) {
                        throw new ClassNotFoundException(handlerClassname);
                    }
                    Class[] paramClassArray = paramList != null ? new Class[paramList.size()] : new Class[]{};
                    for (int i = 0; i < paramClassArray.length; ++i) {
                        Object p = paramList.get(i);
                        paramClassArray[i] = p != null ? p.getClass() : null;
                    }
                    handlerMethod = this.findMethod(handler.getClass(), handlerMethodName, paramClassArray);
                    if (handlerMethod == null) {
                        throw new NoSuchMethodException(handlerMethodName);
                    }
                }
                Object returnObject = handlerMethod.invoke(handler, paramArray);
                if (payload.isSendResults()) {
                    RpcResultPayload rpcresult = new RpcResultPayload(returnObject, messageId, oldStringTransmission);
                    Message outboundMessage = new Message(-1, 2, rpcresult);
                    session.sendMessage(outboundMessage);
                }
            }
            catch (InvocationTargetException itex) {
                if (itex.getTargetException() != null) {
                    itex.getTargetException().printStackTrace();
                }
                if (payload != null && payload.isSendResults()) {
                    String errmsg = this.buildFaultErrorMessage(sessionId, itex.getTargetException());
                    this.sendFaultMessage(messageId, errmsg);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (payload == null || !payload.isSendResults()) break block12;
                String errmsg = this.buildFaultErrorMessage(sessionId, ex);
                this.sendFaultMessage(messageId, errmsg);
            }
        }
    }
}

