/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rmi;

import com.iscobol.logger.Logger;
import com.iscobol.rmi.Remote;
import com.iscobol.rmi.RemoteCaller;
import com.iscobol.rmi.client.ClientCaller;
import com.iscobol.rts.ArrayTable;
import java.util.Hashtable;

public class RemoteRegistry {
    private ArrayTable remoteObjectsTable = new ArrayTable();
    private static RemoteRegistry sharedRegistry;
    private static ClientCaller clientCaller;
    private static RemoteCallersTable remoteCallers;
    public static final int MIN_SIZE_COMPRESS = 32768;

    public static ClientCaller getClientCaller() {
        return clientCaller;
    }

    public static Logger getClientProblemLogger() {
        if (clientCaller != null) {
            return clientCaller.getProblemLog();
        }
        return null;
    }

    public static Logger getClientRpcCallLogger() {
        if (clientCaller != null) {
            return clientCaller.getRpcCallLog();
        }
        return null;
    }

    public static void setClientCaller(ClientCaller c) {
        clientCaller = c;
    }

    public static void setClientProblemLogger(Logger log) {
        if (clientCaller != null) {
            RemoteRegistry.clientCaller.problemLog = log;
        }
    }

    public static void setClientRpcCallLogger(Logger log) {
        if (clientCaller != null) {
            RemoteRegistry.clientCaller.rpcCallLog = log;
        }
    }

    public static RemoteCaller getCaller(int sessionId) {
        return remoteCallers.get(sessionId);
    }

    public static Logger getProblemLogger(int sessionId) {
        RemoteCaller rc = remoteCallers.get(sessionId);
        if (rc != null) {
            return rc.problemLog;
        }
        return null;
    }

    public static Logger getRpcCallLogger(int sessionId) {
        RemoteCaller rc = remoteCallers.get(sessionId);
        if (rc != null) {
            return rc.rpcCallLog;
        }
        return null;
    }

    public static int getCompressLevel(int sessionId) {
        RemoteCaller rc = remoteCallers.get(sessionId);
        if (rc != null) {
            return rc.compressLevel;
        }
        return 0;
    }

    public static int getMinSizeCompress(int sessionId) {
        RemoteCaller rc = remoteCallers.get(sessionId);
        if (rc != null) {
            return rc.minSizeCompress;
        }
        return 32768;
    }

    public static void setProblemLogger(int sessionId, Logger log) {
        RemoteCaller rc = remoteCallers.get(sessionId);
        if (rc != null) {
            rc.problemLog = log;
        }
    }

    public static void setRpcCallLogger(int sessionId, Logger log) {
        RemoteCaller rc = remoteCallers.get(sessionId);
        if (rc != null) {
            rc.rpcCallLog = log;
        }
    }

    public static void setCompressLevel(int sessionId, int compressLevel) {
        RemoteCaller rc = remoteCallers.get(sessionId);
        if (rc != null) {
            rc.compressLevel = compressLevel;
        }
    }

    public static void setMinSizeCompress(int sessionId, int minSizeCompress) {
        RemoteCaller rc = remoteCallers.get(sessionId);
        if (rc != null) {
            rc.minSizeCompress = minSizeCompress;
        }
    }

    public Remote get(int id) {
        return (Remote)this.remoteObjectsTable.get(id);
    }

    public int put(Remote obj) {
        return this.remoteObjectsTable.put(obj);
    }

    public Remote remove(int id) {
        return (Remote)this.remoteObjectsTable.remove(id);
    }

    public Remote remove(Integer id) {
        return (Remote)this.remoteObjectsTable.remove(id);
    }

    public void clear() {
        this.remoteObjectsTable.clear();
    }

    public static RemoteRegistry getSharedRegistry() {
        return sharedRegistry;
    }

    public static void setSharedRegistry(RemoteRegistry registry) {
        sharedRegistry = registry;
    }

    public static int setCaller(RemoteCaller caller) {
        return remoteCallers.put(caller);
    }

    public static RemoteCaller removeCaller(int sessionId) {
        return remoteCallers.remove(sessionId);
    }

    public static int skipProg() {
        return RemoteCallersTable.nextProg();
    }

    static {
        remoteCallers = new RemoteCallersTable();
    }

    static class RemoteCallersTable
    extends Hashtable {
        private static int _idProg;

        RemoteCallersTable() {
        }

        private static final int nextProg() {
            if (++_idProg < 0) {
                _idProg = 1;
            }
            return _idProg;
        }

        final int put(RemoteCaller rc) {
            int Return2 = RemoteCallersTable.nextProg();
            this.put(new Integer(Return2), rc);
            return Return2;
        }

        final RemoteCaller get(int id) {
            return (RemoteCaller)this.get(new Integer(id));
        }

        final RemoteCaller remove(int id) {
            return (RemoteCaller)this.remove(new Integer(id));
        }
    }
}

