/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.xls;

import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.misc.export.ss.SSListBoxExporter;
import com.iscobol.misc.export.xls.XLSExportHelper;
import java.awt.Color;
import java.awt.Font;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class XLSListBoxExporter
extends SSListBoxExporter {
    @Override
    protected SSExportHelper createExportHelper() {
        return new XLSExportHelper();
    }

    @Override
    public void setCellStyleAttrs(CellStyle cellStyle, int rowIdx, int colIdx, String numericFormat) {
        VerticalAlignment verticalAlign = VerticalAlignment.CENTER;
        HorizontalAlignment horizontalAlign = HorizontalAlignment.LEFT;
        Font f = this.provider.getFont();
        Color bkg = this.provider.getBackgroundColor(rowIdx);
        Color frg = this.provider.getForegroundColor(rowIdx);
        int halign = this.provider.getColumnAlignment(colIdx);
        org.apache.poi.ss.usermodel.Font font = this.getFont(f, frg);
        XLSExportHelper ee = (XLSExportHelper)this.helper;
        cellStyle.setFont(font);
        cellStyle.setFillForegroundColor(ee.getColor(bkg, HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        switch (halign) {
            case 1: {
                horizontalAlign = HorizontalAlignment.CENTER;
                break;
            }
            case 2: {
                horizontalAlign = HorizontalAlignment.RIGHT;
            }
        }
        cellStyle.setAlignment(horizontalAlign);
        cellStyle.setVerticalAlignment(verticalAlign);
        Color dividerColor = this.provider.getDividerColor();
        short colorIdx = ee.getColor(dividerColor, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        cellStyle.setBorderRight(ee.getBorder(this.provider.getColumnDivider(colIdx)));
        cellStyle.setRightBorderColor(colorIdx);
        if (numericFormat != null) {
            cellStyle.setDataFormat(this.helper.getFormat(numericFormat));
        }
    }
}

