/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.xls;

import com.iscobol.misc.export.UnitConverter;
import com.iscobol.misc.export.ss.SSExportHelper;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class XLSExportHelper
extends SSExportHelper {
    private final Map<Integer, Short> COLORS = new HashMap<Integer, Short>();
    private final Set<Short> COLORS_INDEXES = new HashSet<Short>();

    public XLSExportHelper() {
        this.init();
    }

    private void init() {
        this.COLORS_INDEXES.add(new Short(HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
        this.COLORS.put(new Integer(0xFFFFFF & Color.white.getRGB()), new Short(HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
        this.COLORS_INDEXES.add(new Short(HSSFColor.HSSFColorPredefined.BLACK.getIndex()));
        this.COLORS.put(new Integer(0xFFFFFF & Color.black.getRGB()), new Short(HSSFColor.HSSFColorPredefined.BLACK.getIndex()));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.COLORS.clear();
        this.COLORS_INDEXES.clear();
        this.init();
    }

    @Override
    public int getSheetColorCount() {
        return this.COLORS.size();
    }

    @Override
    public int computeAnchorX(int colWidth, int left) {
        float colWmm = UnitConverter.pixelToCentimeter(colWidth) * 10.0f;
        float xMM = UnitConverter.pixelToCentimeter(left) * 10.0f;
        float colCoordinatesPerMM = 1023.0f / colWmm;
        return Math.min(1023, Math.round(colCoordinatesPerMM * xMM));
    }

    @Override
    public int computeAnchorY(int rowHeight, int top) {
        float rowHmm = UnitConverter.pixelToCentimeter(rowHeight) * 10.0f;
        float yMM = UnitConverter.pixelToCentimeter(top) * 10.0f;
        float rowCoordinatesPerMM = 255.0f / rowHmm;
        return Math.min(255, Math.round(rowCoordinatesPerMM * yMM));
    }

    @Override
    public void setBorderedCellStyleAttrs(CellStyle cellStyle, boolean top, boolean bottom, boolean left, boolean right, int borderWidth, Color borderColor) {
        BorderStyle borderStyle = this.getBorder(borderWidth);
        short colIdx = this.getColor(borderColor, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        if (top) {
            cellStyle.setBorderTop(borderStyle);
            cellStyle.setTopBorderColor(colIdx);
        }
        if (bottom) {
            cellStyle.setBorderBottom(borderStyle);
            cellStyle.setBottomBorderColor(colIdx);
        }
        if (left) {
            cellStyle.setBorderLeft(borderStyle);
            cellStyle.setLeftBorderColor(colIdx);
        }
        if (right) {
            cellStyle.setBorderRight(borderStyle);
            cellStyle.setRightBorderColor(colIdx);
        }
    }

    @Override
    public void setFontColor(Font font, Color foreground) {
        font.setColor(this.getColor(foreground, HSSFColor.HSSFColorPredefined.BLACK.getIndex()));
    }

    public short getColor(Color c, short def) {
        Integer I2 = new Integer(0xFFFFFF & c.getRGB());
        Short Return2 = this.COLORS.get(I2);
        if (Return2 == null) {
            HSSFPalette palette = ((HSSFWorkbook)this.getWorkbook()).getCustomPalette();
            HSSFColor hc = palette.findColor((byte)c.getRed(), (byte)c.getGreen(), (byte)c.getBlue());
            if (hc != null) {
                Return2 = new Short(hc.getIndex());
            } else {
                for (short s = 8; s <= 64 && Return2 == null; s = (short)(s + 1)) {
                    Short S2 = new Short(s);
                    if (this.COLORS_INDEXES.contains(S2)) continue;
                    int rgb = I2;
                    byte r = (byte)((0xFF0000 & rgb) >>> 16);
                    byte g = (byte)((0xFF00 & rgb) >>> 8);
                    byte b = (byte)(0xFF & rgb);
                    palette.setColorAtIndex(s, r, g, b);
                    Return2 = S2;
                }
            }
            if (Return2 != null) {
                this.COLORS_INDEXES.add(Return2);
            } else {
                Return2 = new Short(def);
            }
            this.COLORS.put(I2, Return2);
        }
        return Return2;
    }

    public BorderStyle getBorder(int borderWidth) {
        if (borderWidth > 0) {
            short pts = (short)UnitConverter.pixel2ExcelHeightPoints(borderWidth);
            if (pts >= 4) {
                return BorderStyle.THICK;
            }
            if (pts >= 2) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THIN;
        }
        return BorderStyle.NONE;
    }

    @Override
    protected Workbook createWorkbook() {
        return new HSSFWorkbook();
    }

    @Override
    public void setBackgroundAttrs(CellStyle cellStyle, Color background) {
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(this.getColor(background, HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
    }

    @Override
    public Color getBackgroundColor(CellStyle cellStyle) {
        Color Return2 = null;
        short colorIndex = cellStyle.getFillForegroundColor();
        if (colorIndex >= 0) {
            HSSFPalette palette = ((HSSFWorkbook)this.getWorkbook()).getCustomPalette();
            HSSFColor hc = palette.getColor(colorIndex);
            short[] rgb = hc.getTriplet();
            Return2 = new Color(rgb[0], rgb[1], rgb[2]);
        }
        return Return2;
    }

    @Override
    public int getMaxRowsPerSheet() {
        return 65536;
    }
}

