/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.ss;

import com.iscobol.gui.export.ExportDataProvider;
import com.iscobol.gui.export.ExportMonitor;
import com.iscobol.gui.export.Exporter;
import com.iscobol.gui.export.ListBoxDataProvider;
import com.iscobol.misc.export.UnitConverter;
import com.iscobol.misc.export.ss.SSExportHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class SSListBoxExporter
implements Exporter {
    private static final int FLUSH_ROW_RATE = 1000;
    private static final float screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
    private final Map<String, CellStyle> CELL_STYLES = new TreeMap<String, CellStyle>();
    private String outputFile;
    private String reportName;
    protected ListBoxDataProvider provider;
    private ExportMonitor monitor;
    private int tickRate;
    protected SSExportHelper helper;
    private CellStyle defaultCellStyle;

    public abstract void setCellStyleAttrs(CellStyle var1, int var2, int var3, String var4);

    @Override
    public void setOutputFile(String filename) {
        this.outputFile = filename;
    }

    @Override
    public String getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setDataProvider(ExportDataProvider provider) {
        if (!(provider instanceof ListBoxDataProvider)) {
            throw new IllegalArgumentException("Invalid Data Provider!");
        }
        this.provider = (ListBoxDataProvider)provider;
    }

    @Override
    public ExportDataProvider getDataProvider() {
        return this.provider;
    }

    @Override
    public void export() throws Exception {
        if (this.provider == null) {
            throw new Exception("data provider is null");
        }
        if (this.outputFile == null) {
            throw new Exception("output file is null");
        }
        this.helper = this.createExportHelper();
        this.defaultCellStyle = this.helper.getWorkbook().createCellStyle();
        this.reportName = new File(this.outputFile).getName();
        int rowCount = this.provider.getRowCount();
        int colCount = this.provider.getColumnCount();
        int rowCountRate = rowCount / (this.tickRate - 1);
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            if (rowIdx > 0 && rowIdx % 1000 == 0) {
                this.helper.flushRows(this.getSheet(rowIdx));
            }
            if (this.monitor != null && rowCountRate > 0 && rowIdx > 0 && rowIdx % rowCountRate == 0) {
                this.monitor.worked(rowIdx / rowCountRate);
            }
            Row row = this.getSheet(rowIdx).createRow(rowIdx);
            row.setHeightInPoints((float)UnitConverter.pixel2ExcelHeightPoints(this.provider.getRowHeight(rowIdx)));
            String[] cellValues = this.provider.getCellData(rowIdx);
            for (int colIdx = 0; colIdx < colCount; ++colIdx) {
                Cell cell = row.createCell(colIdx);
                String cellValue = colIdx < cellValues.length && cellValues[colIdx] != null ? cellValues[colIdx] : "";
                String trimmed = cellValue.trim();
                Double numericValue = this.helper.getNumericValue(trimmed);
                int[] decimals = numericValue != null ? this.helper.getDecimals(trimmed) : new int[2];
                CellStyle cellStyle = this.getCellStyle(rowIdx, colIdx, decimals);
                cell.setCellStyle(cellStyle);
                if (numericValue != null) {
                    cell.setCellValue(numericValue.doubleValue());
                    continue;
                }
                cell.setCellValue(cellValue);
            }
        }
        this.helper.write(this.outputFile);
        this.helper.getWorkbook().close();
        this.CELL_STYLES.clear();
        this.helper.dispose();
        this.helper = null;
        this.defaultCellStyle = null;
        if (this.monitor != null) {
            this.monitor.worked(this.tickRate);
            this.monitor.done();
        }
    }

    private String getStyleKey(int rowIdx, int colIdx, int[] numericType) {
        StringBuilder sb = new StringBuilder();
        Font f = this.provider.getFont();
        sb.append("font=[");
        sb.append(f.getFamily());
        sb.append(",");
        sb.append(f.getSize2D());
        sb.append(",");
        sb.append(f.isBold() ? "1" : "0");
        sb.append(",");
        sb.append(f.isItalic() ? "1]" : "0]");
        sb.append(",color=[");
        Color bkg = this.provider.getBackgroundColor(rowIdx);
        Color frg = this.provider.getForegroundColor(rowIdx);
        sb.append(bkg.getRGB());
        sb.append(",");
        sb.append(frg.getRGB());
        sb.append("],align=");
        sb.append(this.provider.getColumnAlignment(colIdx));
        sb.append(",div=");
        sb.append(this.provider.getColumnDivider(colIdx));
        sb.append(",nt=");
        sb.append(numericType[0] + "," + numericType[1]);
        return sb.toString();
    }

    private CellStyle getCellStyle(int rowIdx, int colIdx, int[] decimals) {
        String key = this.getStyleKey(rowIdx, colIdx, decimals);
        CellStyle cellStyle = this.CELL_STYLES.get(key);
        if (cellStyle == null) {
            String format;
            try {
                cellStyle = this.helper.getWorkbook().createCellStyle();
            }
            catch (Exception ex) {
                return this.defaultCellStyle;
            }
            if (decimals[0] > 0) {
                format = decimals[1] > 0 ? "#,##0." : "0.";
                for (int i = 0; i < decimals[0]; ++i) {
                    format = format + "0";
                }
            } else {
                format = decimals[1] > 0 ? "#,###" : null;
            }
            this.setCellStyleAttrs(cellStyle, rowIdx, colIdx, format);
            this.CELL_STYLES.put(key, cellStyle);
        }
        return cellStyle;
    }

    protected Sheet getSheet(int rowNum) {
        int sheetIdx = rowNum / this.helper.getMaxRowsPerSheet();
        if (sheetIdx >= this.helper.getSheetCount()) {
            this.createSheet(this.reportName + " " + String.valueOf(this.helper.getSheetCount() + 1));
        }
        return this.helper.getSheetAt(sheetIdx);
    }

    protected Sheet createSheet(String reportName) {
        Sheet sheet = this.helper.createSheet(reportName);
        int columnCount = this.provider.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            sheet.setColumnWidth(i, UnitConverter.pixel2ExcelWidthUnits(this.provider.getColumnWidth(i)));
        }
        return sheet;
    }

    protected abstract SSExportHelper createExportHelper();

    public org.apache.poi.ss.usermodel.Font getFont(Font f, Color fg) {
        return this.helper.getFont(f.getFamily(), f.getSize2D() * 72.0f / screenResolution, f.isBold(), f.isItalic(), false, fg);
    }

    @Override
    public void setMonitor(ExportMonitor monitor, int tickRate) {
        this.monitor = monitor;
        this.tickRate = Math.max(2, tickRate);
    }
}

