/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.math;

import java.io.Serializable;

public class BigCobolInt
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final long VALUPLIMIT = 1000000000L;
    static final String VALUPLIMITSTR = "1000000000";
    static final int MAXDECDIGITS;
    static final int NDIGITS = 4;
    static final int MAX_PRECISION;
    static final String[] ZEROFILL;
    static final int[] TENPOW;
    static final int MINUS = 10;
    static final int POINT = 11;
    protected int[] value = new int[4];
    protected boolean negative;
    protected int uvi;

    public static void main(String[] argv) {
    }

    public BigCobolInt() {
    }

    public BigCobolInt(byte[] v, int v0, int vLen, boolean signed) {
        int i;
        if (signed && v[v0] < 0) {
            byte[] newval = new byte[vLen];
            int inter = 1;
            i = vLen - 1;
            int j = i + v0;
            while (i >= 0) {
                newval[i] = (byte)(inter += ~v[j] & 0xFF);
                inter >>= 8;
                --i;
                --j;
            }
            v = newval;
            v0 = 0;
            this.negative = true;
        }
        this.uvi = BigCobolInt.oneDigitAdd(this.value, this.uvi, v[v0] & 0xFF, this.value);
        int end = v0 + vLen;
        for (i = v0 + 1; i < end && this.uvi < this.value.length; ++i) {
            this.uvi = BigCobolInt.oneDigitMultiply(this.value, this.uvi, 256L, this.value);
            if (this.uvi >= this.value.length) continue;
            this.uvi = BigCobolInt.oneDigitAdd(this.value, this.uvi, v[i] & 0xFF, this.value);
        }
        if (this.uvi == this.value.length) {
            --this.uvi;
        }
    }

    public BigCobolInt(BigCobolInt bcn) {
        this.negative = bcn.negative;
        this.uvi = bcn.uvi;
        this.value[0] = bcn.value[0];
        this.value[1] = bcn.value[1];
        this.value[2] = bcn.value[2];
        this.value[3] = bcn.value[3];
    }

    public BigCobolInt(int i) {
        if (i < 0) {
            this.negative = true;
            i = -i;
        }
        if ((long)i < 1000000000L) {
            this.value[0] = i;
        } else {
            this.value[0] = (int)((long)i % 1000000000L);
            this.value[1] = (int)((long)i / 1000000000L);
        }
    }

    public BigCobolInt(long l) {
        if (l < 0L) {
            this.negative = true;
            l = -l;
        }
        if (l < 1000000000L) {
            this.value[0] = (int)l;
        } else {
            this.value[0] = (int)(l % 1000000000L);
            if ((l /= 1000000000L) < 1000000000L) {
                this.uvi = 1;
                this.value[1] = (int)l;
            } else {
                this.uvi = 2;
                this.value[1] = (int)(l % 1000000000L);
                this.value[2] = (int)(l / 1000000000L);
            }
        }
    }

    public BigCobolInt(String val) {
        BigCobolInt.parseInt(this, val);
    }

    public static BigCobolInt parseInt(BigCobolInt Return2, String val) {
        int i;
        int base = 10;
        long fact = 1L;
        int len = val.length();
        NumberFormatException exception = null;
        Return2.setZero();
        if (len == 0) {
            throw new NumberFormatException("zero length");
        }
        long inter = 0L;
        fact = 1L;
        for (i = len - 1; i >= 0; --i) {
            int c = val.charAt(i);
            if (c <= 57) {
                c -= 48;
            } else if (c <= 90) {
                c -= 65;
                c += 10;
            } else if (c <= 122) {
                c -= 97;
                c += 10;
            }
            if (c < 0 || c >= 10) {
                if (val.charAt(i) == '-') break;
                exception = new NumberFormatException("For input string: \"" + val + "\"");
                break;
            }
            inter += (long)c * fact;
            if (fact >= 1000000000L) {
                if (Return2.uvi == Return2.value.length) {
                    if (inter != 0L && exception == null) {
                        exception = new NumberFormatException("overflow: " + val);
                    }
                } else {
                    Return2.value[Return2.uvi++] = (int)(inter % fact);
                }
                inter /= fact;
                fact = 1L;
            }
            fact *= 10L;
        }
        if (inter > 0L) {
            if (Return2.uvi == Return2.value.length) {
                if (inter != 0L && exception == null) {
                    exception = new NumberFormatException("overflow: " + val);
                }
                --Return2.uvi;
            } else {
                Return2.value[Return2.uvi] = (int)inter;
            }
        } else if (Return2.uvi > 0) {
            --Return2.uvi;
        }
        if (i >= 0 && val.charAt(i) == '-') {
            Return2.negative = true;
        }
        Return2.adjustUvi();
        if (exception != null) {
            throw exception;
        }
        return Return2;
    }

    public static final int shift(int[] avalue, int auvi, int tenExp) {
        if (tenExp > 0) {
            boolean overflow;
            while (tenExp > MAXDECDIGITS) {
                if (++auvi == avalue.length) {
                    overflow = true;
                }
                for (int i = --auvi; i > 0; --i) {
                    avalue[i] = avalue[i - 1];
                }
                avalue[0] = 0;
                tenExp -= MAXDECDIGITS;
            }
            if (tenExp > 0 && (auvi = BigCobolInt.oneDigitMultiply(avalue, auvi, TENPOW[tenExp], avalue)) == avalue.length) {
                overflow = true;
                --auvi;
            }
        } else if (tenExp < 0) {
            tenExp *= -1;
            while (tenExp > MAXDECDIGITS) {
                if (--auvi < 0) {
                    avalue[0] = 0;
                    return 0;
                }
                for (int i = 0; i <= auvi; ++i) {
                    avalue[i] = avalue[i + 1];
                }
                avalue[i] = 0;
                tenExp -= MAXDECDIGITS;
            }
            if (tenExp > 0 && (auvi = BigCobolInt.oneDigitDivide(avalue, auvi, TENPOW[tenExp], avalue, null)) == avalue.length) {
                boolean overflow = true;
                --auvi;
            }
        }
        return auvi;
    }

    public final void shift(int tenExp) {
        this.uvi = BigCobolInt.shift(this.value, this.uvi, tenExp);
    }

    public static final int precision(int intg) {
        if (intg < 10000) {
            if (intg < 100) {
                if (intg < 10) {
                    return 1;
                }
                return 2;
            }
            if (intg < 1000) {
                return 3;
            }
            return 4;
        }
        if (intg < 1000000) {
            if (intg < 100000) {
                return 5;
            }
            return 6;
        }
        if (intg < 100000000) {
            if (intg < 10000000) {
                return 7;
            }
            return 8;
        }
        return 9;
    }

    public int precision() {
        return BigCobolInt.precision(this.value[this.uvi]) + this.uvi * MAXDECDIGITS;
    }

    public BigCobolInt set(BigCobolInt bcn) {
        this.negative = bcn.negative;
        this.uvi = bcn.uvi;
        this.value[0] = bcn.value[0];
        this.value[1] = bcn.value[1];
        this.value[2] = bcn.value[2];
        this.value[3] = bcn.value[3];
        return this;
    }

    public BigCobolInt setZero() {
        this.negative = false;
        this.uvi = 0;
        this.value[0] = 0;
        this.value[1] = 0;
        this.value[2] = 0;
        this.value[3] = 0;
        return this;
    }

    private static final int absAdd(int[] a1, int[] a2, int[] result, int uvi) {
        int i;
        int inter = 0;
        for (i = 0; i <= uvi; ++i) {
            inter += a1[i];
            if ((long)(inter += a2[i]) >= 1000000000L) {
                result[i] = inter = (int)((long)inter % 1000000000L);
                inter = 1;
                continue;
            }
            result[i] = inter;
            inter = 0;
        }
        if (inter != 0 && i < result.length) {
            result[i] = inter;
            return i;
        }
        return uvi;
    }

    private static final int absSub(int[] bigger, int[] smaller, int[] result, int uvi) {
        int inter = 0;
        int Return2 = 0;
        for (int i = 0; i <= uvi; ++i) {
            inter += bigger[i];
            if ((inter -= smaller[i]) != 0) {
                Return2 = i;
                if (inter < 0) {
                    result[i] = inter = (int)((long)inter + 1000000000L);
                    inter = -1;
                    continue;
                }
                result[i] = inter;
                inter = 0;
                continue;
            }
            result[i] = 0;
        }
        return Return2;
    }

    static final int absMul(int[] f1, int uvi1, int[] f2, int uvi2, int[] result) {
        int Return2 = uvi1 + uvi2;
        if (Return2 >= result.length) {
            int[] bigResult = new int[Return2 + 1];
            BigCobolInt.absMul_(f1, uvi1, f2, uvi2, bigResult, Return2);
            Return2 = result.length - 1;
            for (int i = 0; i <= Return2; ++i) {
                result[i] = bigResult[i];
            }
        } else {
            Return2 = BigCobolInt.absMul_(f1, uvi1, f2, uvi2, result, Return2);
        }
        return Return2;
    }

    private static final int absMul_(int[] f1, int uvi1, int[] f2, int uvi2, int[] result, int Return2) {
        int j;
        int i;
        long inter = 0L;
        long carry = 0L;
        for (i = 0; i < uvi1; ++i) {
            for (j = 0; j <= uvi2; ++j) {
                inter = f1[i];
                inter *= (long)f2[j];
                inter += carry;
                if ((inter += (long)result[i + j]) >= 1000000000L) {
                    carry = inter;
                    carry /= 1000000000L;
                    result[i + j] = (int)(inter %= 1000000000L);
                    continue;
                }
                carry = 0L;
                result[i + j] = (int)inter;
            }
            if (carry == 0L) continue;
            if (i + j < result.length) {
                result[i + j] = (int)carry;
            }
            carry = 0L;
        }
        for (j = 0; j <= uvi2; ++j) {
            inter = f1[i];
            inter *= (long)f2[j];
            inter += carry;
            if ((inter += (long)result[i + j]) >= 1000000000L) {
                carry = inter;
                carry /= 1000000000L;
                result[i + j] = (int)(inter %= 1000000000L);
                continue;
            }
            carry = 0L;
            result[i + j] = (int)inter;
        }
        if (carry != 0L && i + j < result.length) {
            result[i + j] = (int)carry;
            ++Return2;
        }
        return Return2;
    }

    protected static final int absCompareTo(int[] t_value, int t_uvi, int[] b_value, int b_uvi) {
        int diff = t_uvi - b_uvi;
        if (diff < 0) {
            while (b_uvi > t_uvi) {
                if (b_value[b_uvi] != 0) {
                    return diff;
                }
                --b_uvi;
            }
        } else if (diff > 0) {
            while (t_uvi > b_uvi) {
                if (t_value[t_uvi] != 0) {
                    return diff;
                }
                --t_uvi;
            }
        }
        for (int i = t_uvi; i >= 0; --i) {
            diff = t_value[i] - b_value[i];
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public final int absCompareTo(BigCobolInt bcn) {
        return BigCobolInt.absCompareTo(this.value, this.uvi, bcn.value, bcn.uvi);
    }

    public final boolean isZero() {
        for (int i = this.uvi; i >= 0; --i) {
            if (this.value[i] == 0) continue;
            return false;
        }
        return true;
    }

    public final int signum() {
        if (this.isZero()) {
            return 0;
        }
        if (this.negative) {
            return -1;
        }
        return 1;
    }

    public final boolean isNegative() {
        if (this.negative && this.isZero()) {
            this.negative = false;
        }
        return this.negative;
    }

    public int compareTo(BigCobolInt bcn) {
        if (this.negative) {
            if (bcn.negative) {
                return -this.absCompareTo(bcn);
            }
            return -1;
        }
        if (bcn.negative) {
            return 1;
        }
        return this.absCompareTo(bcn);
    }

    protected final void addSub(BigCobolInt bcn, boolean bcn_negative) {
        if (this.negative == bcn_negative) {
            this.uvi = BigCobolInt.absAdd(this.value, bcn.value, this.value, this.uvi > bcn.uvi ? this.uvi : bcn.uvi);
        } else if (this.absCompareTo(bcn) >= 0) {
            this.uvi = BigCobolInt.absSub(this.value, bcn.value, this.value, this.uvi);
        } else {
            this.uvi = BigCobolInt.absSub(bcn.value, this.value, this.value, bcn.uvi);
            this.negative = !this.negative;
        }
    }

    public final void subFromMe(BigCobolInt bcn) {
        this.addSub(bcn, !bcn.negative);
    }

    public final void addToMe(BigCobolInt bcn) {
        this.addSub(bcn, bcn.negative);
    }

    protected static final int oneDigitAdd(int[] a1, int uvi, int sum, int[] result) {
        int i;
        for (i = 0; i <= uvi; ++i) {
            if ((long)(sum += a1[i]) >= 1000000000L) {
                result[i] = sum = (int)((long)sum % 1000000000L);
                sum = 1;
                continue;
            }
            result[i] = sum;
            sum = 0;
        }
        if (sum != 0 && i < result.length) {
            result[i] = sum;
            return i;
        }
        return uvi;
    }

    protected static final int oneDigitMultiply(int[] num, int uvi, long digit, int[] res) {
        int i;
        int carry = 0;
        for (i = 0; i <= uvi; ++i) {
            long value = digit * (long)num[i] + (long)carry;
            res[i] = (int)(value % 1000000000L);
            carry = (int)(value / 1000000000L);
        }
        if (carry > 0) {
            if (i < res.length) {
                res[i] = carry;
            }
            return i;
        }
        return uvi;
    }

    private static final int oneDigitDivide(int[] u, int m, int v, int[] q, int[] r) {
        int j = 0;
        int k = 0;
        int s = 0;
        for (j = m; j >= 0; --j) {
            s = u[j];
            q[j] = (int)(((long)k * 1000000000L + (long)s) / (long)v);
            k = (int)((long)k * 1000000000L + (long)s - (long)(q[j] * v));
        }
        if (r != null) {
            r[0] = k;
        }
        while (m > 0 && q[m] == 0) {
            --m;
        }
        return m;
    }

    protected static final int absDiv(int[] u, int m, int[] v, int n, int[] q, int[] r) {
        int quvi;
        int i;
        int j;
        if (n == 0) {
            return BigCobolInt.oneDigitDivide(u, m, v[0], q, r);
        }
        int[] vn = new int[(n + 1) * 2];
        System.arraycopy(v, 0, vn, 0, n + 1);
        int[] un = new int[m + 2];
        System.arraycopy(u, 0, un, 0, m + 1);
        int s = (int)(1000000000L / (long)(v[n] + 1));
        if (s != 1) {
            BigCobolInt.oneDigitMultiply(un, m, s, un);
            BigCobolInt.oneDigitMultiply(vn, n, s, vn);
        }
        for (j = m - n; j >= 0; --j) {
            long t;
            long qhat;
            long rhat = (long)un[j + n + 1] * 1000000000L + (long)un[j + n] - qhat * (long)vn[n];
            for (qhat = ((long)un[j + n + 1] * 1000000000L + (long)un[j + n]) / (long)vn[n]; qhat >= 1000000000L || qhat * (long)vn[n - 1] > 1000000000L * rhat + (long)un[j + n - 1]; --qhat) {
                if ((rhat += (long)vn[n]) < 1000000000L) continue;
            }
            long k = 0L;
            for (i = 0; i <= n; ++i) {
                long p = qhat * (long)vn[i];
                t = (long)un[i + j] - k - p % 1000000000L;
                k = 0L;
                if (t < 0L) {
                    k = 1L - (t + 1L) / 1000000000L;
                    un[i + j] = (int)(t + 1000000000L * k);
                } else {
                    un[i + j] = (int)t;
                    k -= (t /= 1000000000L);
                }
                k += (p /= 1000000000L);
            }
            t = (long)un[j + i] - k;
            un[j + i] = (int)t;
            q[j] = (int)qhat;
            if (t >= 0L) continue;
            int n2 = j;
            q[n2] = q[n2] - 1;
            k = 0L;
            for (i = 0; i <= n; ++i) {
                t = (long)(un[i + j] + vn[i]) + k;
                un[i + j] = (int)(t % 1000000000L);
                k = t /= 1000000000L;
            }
            int n3 = j + i;
            un[n3] = (int)((long)un[n3] + k);
        }
        for (quvi = m - n; quvi > 0 && q[quvi] == 0; --quvi) {
        }
        if (r == null) {
            return quvi;
        }
        if (s > 1) {
            while (m > 0 && un[m] == 0) {
                --m;
            }
            return BigCobolInt.oneDigitDivide(un, m, s, r, null) << 8 | quvi;
        }
        for (i = m; i >= 0 && un[i] == 0; --i) {
        }
        if (i < 0) {
            r[0] = 0;
            return quvi;
        }
        for (j = i; j >= 0; --j) {
            r[j] = un[j];
        }
        return i << 8 | quvi;
    }

    public final BigCobolInt addInt(BigCobolInt bcn) {
        BigCobolInt Return2 = new BigCobolInt(this);
        Return2.addToMe(bcn);
        return Return2;
    }

    public final BigCobolInt subtractInt(BigCobolInt bcn) {
        BigCobolInt Return2 = new BigCobolInt(this);
        Return2.subFromMe(bcn);
        return Return2;
    }

    public final BigCobolInt multiplyInt(BigCobolInt bcn) {
        BigCobolInt Return2 = new BigCobolInt();
        if (!this.isZero() && !bcn.isZero()) {
            Return2.uvi = BigCobolInt.absMul(this.value, this.uvi, bcn.value, bcn.uvi, Return2.value);
            Return2.negative = this.negative != bcn.negative;
        }
        return Return2;
    }

    public final void divideAndRemainderMe(BigCobolInt b, BigCobolInt r) {
        BigCobolInt q = this.divideAndRemainder(b, r);
        this.value = q.value;
        this.uvi = q.uvi;
        this.negative = q.negative;
    }

    public final BigCobolInt divideAndRemainder(BigCobolInt b, BigCobolInt r) {
        int qlen;
        if (b.isZero()) {
            throw new ArithmeticException("BigCobolInt divide by zero");
        }
        if (this.isZero()) {
            if (r != null) {
                r.setZero();
            }
            return new BigCobolInt();
        }
        int cmp = this.absCompareTo(b);
        if (cmp < 0) {
            if (r != null) {
                r.set(this);
            }
            return new BigCobolInt();
        }
        if (cmp == 0) {
            if (r != null) {
                r.setZero();
            }
            BigCobolInt q = new BigCobolInt(1);
            q.negative = this.negative != b.negative;
            return q;
        }
        BigCobolInt q = new BigCobolInt();
        if (r == null) {
            qlen = BigCobolInt.absDiv(this.value, this.uvi, b.value, b.uvi, q.value, null);
        } else {
            qlen = BigCobolInt.absDiv(this.value, this.uvi, b.value, b.uvi, q.value, r.value);
            r.uvi = (qlen & 0xFF00) >> 8;
            r.negative = this.negative;
        }
        q.uvi = qlen & 0xFF;
        q.negative = this.negative != b.negative;
        return q;
    }

    private final void setFromBinary(char[] val) {
        int i;
        this.setZero();
        if (val[val.length - 1] >= '\u8000') {
            int inter = 1;
            for (i = 0; i < val.length; ++i) {
                val[i] = (char)(inter += (char)(~val[i]));
                inter >>= 16;
            }
            this.negative = true;
        }
        for (i = val.length - 1; i > 0 && val[i] == '\u0000'; --i) {
        }
        this.uvi = BigCobolInt.oneDigitAdd(this.value, this.uvi, val[i], this.value);
        --i;
        while (i >= 0) {
            this.uvi = BigCobolInt.oneDigitMultiply(this.value, this.uvi, 65536L, this.value);
            this.uvi = BigCobolInt.oneDigitAdd(this.value, this.uvi, val[i], this.value);
            --i;
        }
    }

    public final byte[] toByteArray() {
        int i;
        byte[] work = new byte[this.value.length << 2];
        int[] q = new int[this.value.length];
        int quvi = this.uvi;
        int[] r = new int[1];
        int j = 0;
        for (i = quvi; i >= 0; --i) {
            q[i] = this.value[i];
        }
        do {
            quvi = BigCobolInt.oneDigitDivide(q, quvi, 256, q, r);
            work[j++] = (byte)r[0];
        } while (quvi != 0 || q[0] != 0);
        if (this.negative) {
            int inter = 1;
            for (i = 0; i < work.length; ++i) {
                work[i] = (byte)(inter += ~work[i] & 0xFF);
                inter >>= 8;
            }
            if (work[j - 1] >= 0) {
                ++j;
            }
        } else if (work[j - 1] < 0) {
            ++j;
        }
        byte[] Return2 = new byte[j];
        --j;
        i = 0;
        while (j >= 0) {
            Return2[j] = work[i];
            ++i;
            --j;
        }
        return Return2;
    }

    private final char[] toBinary() {
        int i;
        char[] Return2 = new char[this.value.length << 1];
        int[] q = new int[this.value.length];
        int quvi = this.uvi;
        int[] r = new int[1];
        int j = 0;
        for (i = quvi; i >= 0; --i) {
            q[i] = this.value[i];
        }
        do {
            quvi = BigCobolInt.oneDigitDivide(q, quvi, 65536, q, r);
            Return2[j++] = (char)r[0];
        } while (quvi != 0 || q[0] != 0);
        if (this.negative) {
            int inter = 1;
            for (i = 0; i < Return2.length; ++i) {
                Return2[i] = (char)(inter += (char)(~Return2[i]));
                inter >>= 16;
            }
        }
        return Return2;
    }

    public final void narrowMe(int nDigits) {
        int nuvi = (nDigits - 1) / MAXDECDIGITS;
        if (nuvi < this.uvi) {
            for (int i = this.uvi; i > nuvi; --i) {
                this.value[i] = 0;
            }
            this.uvi = nuvi;
        }
        if (nuvi == this.uvi && (nDigits %= MAXDECDIGITS) > 0) {
            int n = this.uvi;
            this.value[n] = this.value[n] % TENPOW[nDigits];
        }
    }

    public static final byte getDecDigit(int[] avalue, int auvi, int pos) {
        int tuvi = pos / MAXDECDIGITS;
        if (tuvi > auvi) {
            return 0;
        }
        return (byte)(avalue[tuvi] / TENPOW[pos %= MAXDECDIGITS] % 10);
    }

    public final byte getDecDigit(int pos) {
        return BigCobolInt.getDecDigit(this.value, this.uvi, pos);
    }

    public final void andMe(BigCobolInt n) {
        char[] b0 = this.toBinary();
        char[] b1 = n.toBinary();
        for (int i = b0.length - 1; i >= 0; --i) {
            int n2 = i;
            b0[n2] = (char)(b0[n2] & b1[i]);
        }
        this.setFromBinary(b0);
    }

    public final BigCobolInt and(BigCobolInt n) {
        BigCobolInt Return2 = new BigCobolInt(this);
        Return2.andMe(n);
        return Return2;
    }

    protected void adjustUvi() {
        this.uvi = this.value.length - 1;
        while (this.uvi > 0 && this.value[this.uvi] == 0) {
            --this.uvi;
        }
    }

    protected final void normalize() {
        while (this.uvi > 0) {
            if (this.value[this.uvi] == 0) {
                --this.uvi;
                continue;
            }
            return;
        }
        if (this.negative && this.value[0] == 0) {
            this.negative = false;
        }
    }

    public long longValue() {
        char[] bin = this.toBinary();
        int len = bin.length;
        if (len > 4) {
            len = 4;
        }
        long Return2 = bin[0];
        int shift = 16;
        for (int i = 1; i < len; ++i) {
            Return2 |= (long)bin[i] << shift;
            shift += 16;
        }
        if (this.negative) {
            if (Return2 > 0L) {
                return -Return2;
            }
            return Return2;
        }
        if (Return2 < 0L) {
            return Return2 &= Long.MAX_VALUE;
        }
        return Return2;
    }

    public double doubleValue() {
        int i = this.value.length - 1;
        double Return2 = this.value[i];
        --i;
        while (i >= 0) {
            Return2 *= 1.0E9;
            Return2 += (double)this.value[i];
            --i;
        }
        if (this.negative) {
            return -Return2;
        }
        return Return2;
    }

    private static int append(byte[] str, int offs, int n, byte[] encoded_digits) {
        int pr = BigCobolInt.precision(n);
        int end = offs >= 0 ? offs : 0;
        for (int i = offs + pr - 1; i >= end; --i) {
            str[i] = encoded_digits[n % 10];
            n /= 10;
        }
        return offs + pr;
    }

    public void toCobolByteArray(byte[] str, int len, byte[] encoded_digits) {
        int idx;
        int pr = this.precision();
        int zeros = len - pr;
        if (zeros > 0) {
            for (idx = 0; idx < zeros; ++idx) {
                str[idx] = encoded_digits[0];
            }
        } else {
            idx = zeros;
        }
        int i = this.uvi;
        idx = BigCobolInt.append(str, idx, this.value[i], encoded_digits);
        --i;
        while (i >= 0) {
            for (int j = MAXDECDIGITS - BigCobolInt.precision(this.value[i]); j > 0; --j) {
                if (idx >= 0) {
                    str[idx++] = encoded_digits[0];
                    continue;
                }
                ++idx;
            }
            idx = BigCobolInt.append(str, idx, this.value[i], encoded_digits);
            --i;
        }
    }

    public int toByteArray(byte[] str, byte[] encoded_digits) {
        int idx = 0;
        if (this.isZero()) {
            str[idx++] = encoded_digits[0];
        } else {
            if (this.isNegative()) {
                str[idx++] = encoded_digits[10];
            }
            int i = this.uvi;
            idx = BigCobolInt.append(str, idx, this.value[i], encoded_digits);
            --i;
            while (i >= 0) {
                for (int j = MAXDECDIGITS - BigCobolInt.precision(this.value[i]); j > 0; --j) {
                    str[idx++] = encoded_digits[0];
                }
                idx = BigCobolInt.append(str, idx, this.value[i], encoded_digits);
                --i;
            }
        }
        return idx;
    }

    public String toString() {
        StringBuffer Return2 = new StringBuffer();
        Return2 = this.isNegative() ? new StringBuffer("-") : new StringBuffer();
        int i = this.uvi;
        if (i >= 0) {
            Return2.append(this.value[i]);
            --i;
            while (i >= 0) {
                Return2.append(ZEROFILL[BigCobolInt.precision(this.value[i])]);
                Return2.append(this.value[i]);
                --i;
            }
            return Return2.toString();
        }
        return "0";
    }

    public int hashCode() {
        int Return2 = 0;
        for (int i = 0; i < this.value.length; ++i) {
            Return2 = 31 * Return2 + this.value[i];
        }
        if (this.negative) {
            return -Return2;
        }
        return Return2;
    }

    public void negateMe() {
        this.negative = !this.negative;
    }

    static {
        int i;
        MAXDECDIGITS = VALUPLIMITSTR.length() - 1;
        MAX_PRECISION = 4 * MAXDECDIGITS;
        ZEROFILL = new String[MAXDECDIGITS + 1];
        for (i = 1; i <= MAXDECDIGITS; ++i) {
            BigCobolInt.ZEROFILL[i] = VALUPLIMITSTR.substring(i + 1);
        }
        TENPOW = new int[MAXDECDIGITS + 1];
        BigCobolInt.TENPOW[0] = 1;
        for (i = 1; i <= MAXDECDIGITS; ++i) {
            BigCobolInt.TENPOW[i] = TENPOW[i - 1] * 10;
        }
    }
}

