/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.logger;

import com.iscobol.as.ClientInfo;
import com.iscobol.logger.Logger;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.io.IOException;
import java.util.logging.Handler;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
implements Logger {
    private String filename = "System.err";
    private static org.slf4j.Logger log = null;
    private static org.slf4j.Logger err = null;
    private Handler handler;

    Slf4jLogger() {
    }

    @Override
    public void setFileName(String name) throws IOException {
        this.setFileName(name, false);
    }

    @Override
    public void setFileName(String logFile, boolean append) throws IOException {
        this.setFileName(logFile, -1, 1, append);
    }

    @Override
    public void setFileName(String logFile, int logLen, int count, boolean append) throws IOException {
        ClientInfo info;
        this.filename = logFile;
        if (logFile == null) {
            String name = Config.getPrefix();
            int l = 0;
            if (name != null && (l = name.length()) > 0) {
                if (name.charAt(l - 1) == '.') {
                    name = name.substring(0, l - 1);
                }
            } else {
                name = "";
            }
            logFile = Config.getProperty(".logfile", "%t/" + name + "%g.log");
        }
        if ((info = (ClientInfo)IscobolSystem.get(ClientInfo.class)) != null) {
            logFile = logFile + "." + info.getThreadId();
        }
        log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public void severe(String msg) {
        log.error("SEVERE Slf4j: " + msg);
    }

    @Override
    public void info(String msg) {
        log.info("INFO Slf4j: " + msg);
    }

    @Override
    public void warning(String msg) {
        log.warn("WARNING Slf4j:" + msg);
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public void close() {
    }
}

