/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib_n;

import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts_n.Factory;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public abstract class CBLScanDir
implements IscobolCall {
    static final long RET_SUCCESS = 0L;
    static final long RET_CANNOT_START = 1L;
    static final long RET_INVALID_HANDLE = 2L;
    static final long RET_SEARCH_FINISHED = 3L;
    static final long RET_OTHER_ERROR = 127L;
    final NumericVar RETURN_CODE = Factory.getVarBinary(Factory.getMem(8), 0, 8, false, null, null, null, "RETURN-CODE", false, 18, 0, true, false, false);

    static Entries getObject(int hndl) {
        return (Entries)UserHandles.getId(hndl);
    }

    static int getHandle(Entries obj) {
        return UserHandles.ssetId(obj);
    }

    static Entries delObject(int hndl) {
        Entries Return2 = CBLScanDir.getObject(hndl);
        if (Return2 != null) {
            UserHandles.free(hndl);
        }
        return Return2;
    }

    public abstract String getName();

    final String getString(CobolVar cv) {
        String Return2 = cv.toString();
        int zeroPos = Return2.indexOf(0);
        if (zeroPos >= 0) {
            Return2 = zeroPos == 0 ? "" : Return2.substring(0, zeroPos);
        }
        return Return2;
    }

    @Override
    public void finalize() {
    }

    @Override
    public void perform(int begin, int end) {
    }

    static class Entries
    implements FilenameFilter {
        int index = 0;
        private final File[] list;
        private final int searchAttr;
        private final int flags;
        private File directory;
        private final String match;

        Entries(String pattern, int searchAttr, int flags) {
            File tmp;
            pattern = pattern.trim();
            File patternFile = com.iscobol.rts.File.get(pattern);
            this.searchAttr = searchAttr & 7;
            this.flags = flags;
            try {
                tmp = new File(patternFile.getCanonicalPath());
            }
            catch (IOException _ex) {
                tmp = new File(patternFile.getAbsolutePath());
            }
            this.directory = tmp;
            if (this.directory.isDirectory()) {
                this.match = null;
                this.directory = patternFile;
            } else {
                this.match = this.directory.getName();
                this.directory = patternFile.getParentFile();
            }
            this.list = this.directory.listFiles(this);
        }

        File next() {
            if (this.list != null && this.index < this.list.length) {
                return this.list[this.index++];
            }
            return null;
        }

        private boolean checkType(File dir, String name) {
            if (this.searchAttr == 7) {
                return true;
            }
            if (this.searchAttr == 0) {
                return false;
            }
            File f = new File(dir, name);
            int type = f.isFile() ? 1 : (f.isDirectory() ? 2 : 4);
            return (type & this.searchAttr) != 0;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.match == null) {
                return this.checkType(dir, name);
            }
            if ((this.flags & 2) == 2) {
                if (this.match(name, this.match)) {
                    return this.checkType(dir, name);
                }
                return false;
            }
            if (name.equals(this.match)) {
                return this.checkType(dir, name);
            }
            return false;
        }

        private boolean recurMatch(char[] str, int is, char[] match, int im) {
            while (im < match.length && is < str.length) {
                switch (match[im]) {
                    case '*': {
                        ++im;
                        while (im < match.length && match[im] == '*') {
                            ++im;
                        }
                        if (im >= match.length) {
                            return true;
                        }
                        while (is < str.length) {
                            if (this.recurMatch(str, is, match, im)) {
                                return true;
                            }
                            ++is;
                        }
                        break;
                    }
                    case '?': {
                        ++im;
                        break;
                    }
                    case '!': {
                        if ((this.flags & 1) == 1 && ++im >= match.length) break;
                    }
                    default: {
                        if (match[im] != str[is]) {
                            return false;
                        }
                        ++im;
                    }
                }
                ++is;
            }
            while (im < match.length && match[im] == '*') {
                ++im;
            }
            return im >= match.length && is >= str.length;
        }

        boolean match(String str, String match) {
            return this.recurMatch(str.toCharArray(), 0, match.toCharArray(), 0);
        }

        String getName(File f) {
            String Return2 = f.getName();
            return Return2;
        }
    }
}

