/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class C$DESKTOP
implements IscobolCall {
    public static final int CDESKTOP_BROWSE = 1;
    public static final int CDESKTOP_EDIT = 2;
    public static final int CDESKTOP_MAIL = 3;
    public static final int CDESKTOP_OPEN = 4;
    public static final int CDESKTOP_PRINT = 5;
    private String msg = "";

    @Override
    public Object call(Object[] argv) {
        if (argv == null) {
            return this.call((CobolVar[])null);
        }
        CobolVar[] argv2 = new CobolVar[argv.length];
        for (int i = 0; i < argv.length; ++i) {
            argv2[i] = (CobolVar)argv[i];
        }
        return this.call(argv2);
    }

    private CobolVar call(CobolVar[] argv) {
        int Return2 = 0;
        Logger log = LoggerFactory.get(8);
        if (ScreenUtility.isWD2()) {
            this.msg = "Screen utility is WD2";
            Return2 = -1;
        } else if (argv != null && argv.length >= 2 && argv[0] instanceof NumericVar) {
            int op_code = argv[0].toint();
            String uri = argv[1].toString().trim();
            boolean executeOnClient = IscobolSystem.isAS() && argv.length > 2 && argv[2] instanceof NumericVar && argv[2].toint() != 0;
            GuiFactory gf = ScreenUtility.getGuiFactory();
            switch (op_code) {
                case 1: {
                    Return2 = this.desktop1(gf, "BROWSE", uri, executeOnClient);
                    break;
                }
                case 3: {
                    Return2 = this.desktop1(gf, "MAIL", uri, executeOnClient);
                    break;
                }
                case 4: {
                    Return2 = this.desktop2(gf, "OPEN", uri, executeOnClient);
                    break;
                }
                case 2: {
                    Return2 = this.desktop2(gf, "EDIT", uri, executeOnClient);
                    break;
                }
                case 5: {
                    Return2 = this.desktop2(gf, "PRINT", uri, executeOnClient);
                    break;
                }
                default: {
                    this.msg = "Invalid operation code";
                    break;
                }
            }
        } else {
            this.msg = "Invalid arguments";
            Return2 = -2;
        }
        if (log != null && this.msg.length() > 0) {
            log.info("C$DESKTOP: errmsg=" + this.msg);
        }
        return NumericVar.literal(Return2, false);
    }

    private int desktop1(GuiFactory gf, String operation, String uri, boolean executeOnClient) {
        if (executeOnClient) {
            try {
                return gf.desktop(operation, uri);
            }
            catch (IOException e) {
                this.msg = e.getMessage();
                return -3;
            }
        }
        return ScreenUtility.desktop(operation, uri);
    }

    private int desktop2(GuiFactory gf, String operation, String fileName, boolean executeOnClient) {
        if (executeOnClient) {
            try {
                File f = new File(fileName);
                FileInputStream in = new FileInputStream(f);
                byte[] contents = new byte[in.available()];
                in.read(contents);
                in.close();
                return gf.desktop(operation, f.getName(), contents);
            }
            catch (IOException e) {
                this.msg = e.getMessage();
                return -3;
            }
        }
        return ScreenUtility.desktop(operation, fileName);
    }

    @Override
    public void finalize() {
    }

    @Override
    public void perform(int begin, int end) {
    }
}

