/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.java.generator;

import com.iscobol.rts.Factory;
import com.iscobol.types.CobolNum;
import com.iscobol.types.NumericLiteralAll;
import com.iscobol.types.NumericVar;
import com.iscobol.types.Pic1;

public class NumConst {
    private static final NumConst dpc = new NumConst(true);
    private static final NumConst nodpc = new NumConst(false);
    private final boolean decimalPointComma;

    private NumConst(boolean b) {
        this.decimalPointComma = b;
    }

    public static NumConst getInstance(boolean decimalPointComma) {
        return decimalPointComma ? dpc : nodpc;
    }

    public NumericVar get(long lit) {
        return this.get(lit, CobolNum.getNumDigits(lit));
    }

    public NumericVar get(long lit, int digits) {
        return Factory.getNumLiteral(lit, digits, 0, this.decimalPointComma);
    }

    public NumericVar get(String lit) {
        return Factory.getNumLiteral(lit, this.decimalPointComma);
    }

    public Pic1 getBoolean(String lit) {
        return Factory.getBooleanLiteral(lit);
    }

    public NumericLiteralAll getAll(long lit) {
        return this.getAll(lit, CobolNum.getNumDigits(lit));
    }

    public NumericLiteralAll getAll(long lit, int digits) {
        return Factory.getAllNumLiteral(lit, digits, 0, this.decimalPointComma);
    }

    public NumericVar getAll(String lit) {
        return Factory.getAllNumLiteral(Double.parseDouble(lit.replace(',', '.')), this.decimalPointComma);
    }

    public NumericLiteralAll ZERO() {
        return Factory.getFigurativeZero(this.decimalPointComma);
    }
}

