/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.rts.IOConstants;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;

class RMKFile
implements IOConstants,
RuntimeErrorsNumbers {
    static final int HEADER_NODE = 1;
    static final int INDEX_NODE = 5;
    static final int DATA_NODE = 6;
    static final int CURRDATA_NODE = 7;
    static final int BLANK_NODE = 8;
    static final int KFLAG_MASK = 7;
    static final int KFLAG_DUPS = 1;
    static final int KFLAG_PART = 2;
    static final int SIGN = 1380797254;
    static final int MAXKEYS = 255;
    static final int MAX_KEY_SIZE = 255;
    static final int HEADERSIZE = 55;
    static final int KEYSIZE = 36;
    static final NodeItemDesc INITIAL = new NodeItemDesc(null);
    final char vVersion;
    private final File vFile;
    private final RandomAccessFile vRAFile;
    private final char unkn1;
    private final char unkn2;
    private final char unkn3;
    final int minRec;
    final int maxRec;
    final byte dataCompress;
    private final byte spaceCode;
    private final byte numberCode;
    final byte keyCompress;
    private final byte keyNumberCode;
    private final int blockSize;
    private final byte integrityFlag;
    private final long numOfRecords;
    private short nDupKeys;
    private int currIndex;
    private NodeItemDesc curr = INITIAL;
    private NodeItemDesc next;
    final int nKeys;
    final int nKeyParts;
    final Key[] keys;
    private long validRecordsNum;
    private long currBlockNum;
    private int currBlockSize;
    private int currBlockOffs;
    private int errno = 0;
    private final String blanks = "                                            ";

    private static int memcmp(byte[] b1, int o1, byte[] b2, int o2, int len) {
        while (len > 0) {
            if (b1[o1] != b2[o2]) {
                return (b1[o1] & 0xFF) - (b2[o2] & 0xFF);
            }
            ++o1;
            ++o2;
            --len;
        }
        return 0;
    }

    private static long getNumber(byte[] buf, int offs, int len) {
        long Return2 = 0L;
        switch (len) {
            case 8: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 56;
            }
            case 7: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 48;
            }
            case 6: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 40;
            }
            case 5: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 32;
            }
            case 4: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 24;
            }
            case 3: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 16;
            }
            case 2: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 8;
            }
            case 1: {
                Return2 |= (long)(buf[offs] & 0xFF);
            }
        }
        return Return2;
    }

    public RMKFile(String fileName) throws IOException {
        this.vVersion = '\u0000';
        this.vFile = new File(fileName);
        this.vRAFile = new RandomAccessFile(this.vFile, "r");
        try {
            int i;
            char nodeType = this.vRAFile.readChar();
            long nextHeader = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
            int signature = this.vRAFile.readInt();
            if (nodeType != '\u0001' || signature != 1380797254) {
                throw new IOException("Unrecognized RMKF file!");
            }
            this.vRAFile.seek(10L);
            this.unkn1 = this.vRAFile.readChar();
            this.unkn2 = this.vRAFile.readChar();
            this.unkn3 = this.vRAFile.readChar();
            this.minRec = this.vRAFile.readChar();
            this.maxRec = this.vRAFile.readChar();
            this.dataCompress = this.vRAFile.readByte();
            this.spaceCode = this.vRAFile.readByte();
            this.numberCode = this.vRAFile.readByte();
            this.keyCompress = this.vRAFile.readByte();
            this.keyNumberCode = this.vRAFile.readByte();
            this.nKeyParts = this.vRAFile.readByte() & 0xFF;
            this.blockSize = this.vRAFile.readChar();
            this.vRAFile.seek(50L);
            this.validRecordsNum = this.numOfRecords = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
            this.integrityFlag = this.vRAFile.readByte();
            int fOffs = 256;
            this.vRAFile.seek(fOffs);
            this.currBlockOffs = this.blockSize;
            ArrayList<Key> klist = new ArrayList<Key>();
            ArrayList<KeyPart> parts = null;
            byte[] dummy = new byte[36];
            for (i = 0; i < this.nKeyParts; ++i) {
                if (fOffs + 36 <= this.blockSize) {
                    char offset = this.vRAFile.readChar();
                    char length = this.vRAFile.readChar();
                    byte kFlags = this.vRAFile.readByte();
                    byte emptyBlocks = this.vRAFile.readByte();
                    long root = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    this.vRAFile.read(dummy, 0, 26);
                    if ((kFlags & 2) == 2) {
                        if (parts == null) {
                            parts = new ArrayList<KeyPart>();
                        }
                        parts.add(new KeyPart(offset, length));
                    } else if (offset == '\u0000' && length == '\u0000') {
                        --i;
                    } else {
                        boolean dups;
                        boolean bl = dups = (kFlags & 1) == 1;
                        if (dups) {
                            this.nDupKeys = (short)(this.nDupKeys + 1);
                        }
                        if (parts != null) {
                            int size = parts.size();
                            KeyPart[] ap = new KeyPart[size + 1];
                            ap[size--] = new KeyPart(offset, length);
                            while (size >= 0) {
                                ap[size] = (KeyPart)parts.get(size);
                                --size;
                            }
                            klist.add(new Key(ap, root, dups));
                        } else {
                            klist.add(new Key(new KeyPart[]{new KeyPart(offset, length)}, root, dups));
                        }
                        parts = null;
                    }
                    fOffs += 36;
                    continue;
                }
                if (nextHeader != 0L) {
                    this.vRAFile.seek(nextHeader * (long)this.blockSize);
                    nodeType = this.vRAFile.readChar();
                    if (nodeType != '\u0001') {
                        throw new IOException("Unexpected type: " + nodeType + ", offset: " + nextHeader);
                    }
                    nextHeader = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
                    fOffs = 6;
                    ++this.currBlockNum;
                    --i;
                    continue;
                }
                throw new IOException("Next header == 0");
            }
            this.keys = new Key[klist.size()];
            for (i = 0; i < this.keys.length; ++i) {
                this.keys[i] = (Key)klist.get(i);
            }
            this.nKeys = this.keys.length;
        }
        catch (IOException _ex) {
            this.close();
            throw _ex;
        }
    }

    public int getErrno() {
        return this.errno;
    }

    public void close() {
        if (this.vRAFile != null) {
            try {
                this.vRAFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public long getValidRecordsNum() {
        return this.validRecordsNum;
    }

    private boolean nextDataBlock() throws IOException {
        while (true) {
            byte nodeType;
            ++this.currBlockNum;
            try {
                this.vRAFile.seek(this.currBlockNum * (long)this.blockSize);
                byte keyNum = this.vRAFile.readByte();
                nodeType = this.vRAFile.readByte();
                long nextBrot = (long)this.vRAFile.readInt() & 0xFFFFFFFFL;
            }
            catch (IOException _ex) {
                return false;
            }
            if (nodeType != 6 && nodeType != 7) continue;
            this.currBlockSize = this.vRAFile.readChar() - 10;
            if (this.currBlockSize > 0) break;
        }
        this.currBlockOffs = 0;
        return true;
    }

    private int readRecord(byte[] b, int offs, NodeDesc node, int blkPos) {
        int k;
        int Return2 = 0;
        int pnt = 8;
        int i = 1;
        while (pnt < node.usedSize) {
            int seqNum = (int)RMKFile.getNumber(node.buffer, pnt, 2);
            pnt += 2;
            for (k = 0; k < this.nDupKeys; ++k) {
                int seqLong = (int)RMKFile.getNumber(node.buffer, pnt, 4);
                pnt += 4;
            }
            if (seqNum == blkPos) break;
            pnt += (int)RMKFile.getNumber(node.buffer, pnt, 2);
            pnt += 2;
            ++i;
        }
        if (pnt < node.usedSize) {
            int recLen = (int)RMKFile.getNumber(node.buffer, pnt, 2);
            pnt += 2;
            if (this.dataCompress == 2) {
                for (int j = 0; j < recLen; ++j) {
                    int lenOrComp;
                    if ((lenOrComp = node.buffer[pnt++] & 0xFF) > 127) {
                        int chr;
                        int rpt;
                        if (lenOrComp > 231) {
                            rpt = lenOrComp - 229;
                            chr = node.buffer[pnt++];
                            ++j;
                        } else if (lenOrComp > 211) {
                            rpt = lenOrComp - 210;
                            chr = 0;
                        } else if (lenOrComp > 191) {
                            rpt = lenOrComp - 190;
                            chr = 48;
                        } else {
                            rpt = lenOrComp - 126;
                            chr = 32;
                        }
                        for (k = 0; k < rpt; ++k) {
                            b[offs + Return2++] = chr;
                        }
                        continue;
                    }
                    for (k = 0; k < lenOrComp; ++k) {
                        b[offs + Return2++] = node.buffer[pnt++];
                    }
                    j += lenOrComp;
                }
            } else {
                for (Return2 = 0; Return2 < recLen; ++Return2) {
                    b[offs++] = node.buffer[pnt++];
                }
            }
        } else {
            this.errno = 105;
            Return2 = 0;
        }
        return Return2;
    }

    public int readNext(byte[] b, int offs, int len) throws IOException {
        int Return2;
        this.errno = 0;
        if (this.next == null) {
            if (this.curr == INITIAL) {
                this.start(b, offs, 0, 0, 0);
            } else if (this.curr != null) {
                this.next = this.nextKey(this.curr);
            } else {
                this.errno = 112;
                return 0;
            }
        }
        if (this.next == null || this.next.blockNum == 0L) {
            this.errno = 110;
            Return2 = 0;
            this.curr = null;
        } else {
            NodeDesc node = this.readNode(this.keys[this.currIndex], this.next.blockNum);
            Return2 = this.readRecord(b, offs, node, this.next.blockPos);
            if (Return2 >= 0) {
                this.curr = this.next;
                this.next = null;
            }
        }
        return Return2;
    }

    public int readNextPh(byte[] b, int offs, int len) throws IOException {
        int j;
        int Return2 = 0;
        this.errno = 0;
        if (this.currBlockOffs >= this.currBlockSize && !this.nextDataBlock()) {
            return -1;
        }
        short seqNum = this.vRAFile.readShort();
        for (int k = 0; k < this.nDupKeys; ++k) {
            int seqLong = this.vRAFile.readInt();
        }
        int recLen = this.vRAFile.readChar();
        for (j = 0; j < recLen; ++j) {
            int k;
            int lenOrComp = this.vRAFile.readByte() & 0xFF;
            if (lenOrComp > 127) {
                int chr;
                int rpt;
                if (lenOrComp > 231) {
                    rpt = lenOrComp - 229;
                    chr = this.vRAFile.readByte();
                    ++j;
                } else if (lenOrComp > 211) {
                    rpt = lenOrComp - 210;
                    chr = 0;
                } else if (lenOrComp > 191) {
                    rpt = lenOrComp - 190;
                    chr = 48;
                } else {
                    rpt = lenOrComp - 126;
                    chr = 32;
                }
                for (k = 0; k < rpt; ++k) {
                    b[offs + Return2++] = chr;
                }
                continue;
            }
            for (k = 0; k < lenOrComp; ++k) {
                b[offs + Return2++] = this.vRAFile.readByte();
            }
            j += lenOrComp;
        }
        if (j != recLen) {
            throw new IOException("Record length doesn't match");
        }
        this.currBlockOffs += 4 + this.nDupKeys * 4;
        this.currBlockOffs += recLen;
        return Return2;
    }

    private byte[] buildKey(byte[] rec, Key key) {
        byte[] Return2 = new byte[key.length];
        int offs = 0;
        for (int i = 0; i < key.parts.length; ++i) {
            System.arraycopy(rec, key.parts[i].offset, Return2, offs, key.parts[i].length);
            offs += key.parts[i].length;
        }
        return Return2;
    }

    private NodeDesc readNode(Key key, long nNode) throws IOException {
        int psz = key.duplicates ? 4 : 0;
        NodeDesc Return2 = new NodeDesc(key, this.blockSize);
        this.vRAFile.seek(nNode * (long)this.blockSize);
        this.vRAFile.read(Return2.buffer, 0, this.blockSize);
        Return2.keyNum = Return2.buffer[0];
        Return2.nodeType = Return2.buffer[1];
        Return2.nextBrot = RMKFile.getNumber(Return2.buffer, 2, 4);
        Return2.usedSize = (int)RMKFile.getNumber(Return2.buffer, 6, 2);
        Return2.branchDepth = (int)RMKFile.getNumber(Return2.buffer, 8, 2);
        return Return2;
    }

    private NodeItemDesc nextKey(NodeItemDesc n) throws IOException {
        NodeItemDesc Return2 = n.node.next(n.index);
        if (Return2 == null && n.node.nextBrot > 0L) {
            NodeDesc node = this.readNode(n.node.key, n.node.nextBrot);
            Return2 = node.next(0L);
        }
        return Return2;
    }

    private NodeItemDesc findKey(byte[] kBuff, long nNode, Key key, int mode) throws IOException {
        NodeItemDesc Return2 = null;
        NodeDesc node = this.readNode(key, nNode);
        if (node.branchDepth != 0) {
            Return2 = node.search(kBuff, mode);
            if (Return2 != null) {
                Return2 = this.findKey(kBuff, Return2.blockNum, key, mode);
            }
        } else {
            Return2 = node.search(kBuff, mode);
        }
        return Return2;
    }

    public int start(byte[] record, int offs, int kNum, int kSize, int mode) throws IOException {
        int Return2;
        Key key = this.keys[kNum];
        byte[] kBuff = this.buildKey(record, key);
        this.errno = 0;
        this.currIndex = kNum;
        NodeItemDesc found = this.findKey(kBuff, key.root, key, mode);
        if (found != null) {
            this.next = found;
            if (mode == 1 || mode == 8 || mode == 9) {
                this.curr = null;
            }
            this.errno = 0;
            Return2 = 1;
        } else {
            Return2 = 0;
            this.errno = 111;
        }
        return Return2;
    }

    String fmt(String Return2, int len, boolean left) {
        int sLen = Return2.length();
        if (sLen < len) {
            Return2 = left ? Return2 + "                                            ".substring(0, len - sLen) : "                                            ".substring(0, len - sLen) + Return2;
        }
        return Return2;
    }

    String fmt(String s, int len) {
        return this.fmt(s, len, false);
    }

    String fmt(long n, int len, boolean left) {
        String s = "" + n;
        return this.fmt(s, len, left);
    }

    String fmt(long n, int len) {
        return this.fmt(n, len, false);
    }

    public void printInfo() {
        System.out.println(this.vFile.getPath() + "  [RMKF version " + this.vVersion + "]");
        System.out.println("");
        System.out.println("# of records:" + this.fmt(this.numOfRecords, 18));
        System.out.println("file size: " + this.fmt(this.vFile.length(), 20) + " (" + this.vFile.getPath() + ")");
        System.out.println("block size:" + this.fmt(this.blockSize, 20));
        String c = " dataCompress=" + this.dataCompress + " keyCompress=" + this.keyCompress;
        if (this.minRec == this.maxRec) {
            System.out.println("record size:" + this.fmt(this.maxRec, 19) + c);
        } else {
            System.out.println("record size (min/max):" + this.fmt(this.minRec, 9) + "/" + this.maxRec + c);
        }
        System.out.println("# of keys: " + this.fmt(this.nKeys, 20));
        System.out.println("integrity: " + this.fmt(this.integrityFlag, 20));
        System.out.println("");
        System.out.println("Key  Dups    Seg-1     Seg-2     Seg-3     Seg-4     Seg-5     Seg-6");
        System.out.println("            (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)");
        System.out.println("");
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.nKeys; ++i) {
            out.delete(0, out.length());
            out.append(this.fmt(i, 3));
            out.append(this.fmt(this.keys[i].duplicates ? "Y" : "N", 5));
            out.append("  ");
            for (int j = 0; j < this.keys[i].nparts; ++j) {
                out.append(this.fmt(this.keys[i].parts[j].length, 3));
                out.append("/");
                out.append(this.fmt(this.keys[i].parts[j].offset, 6, true));
            }
            System.out.println(out);
        }
    }

    static class NodeItemDesc {
        long blockNum;
        short blockPos;
        long keyProg;
        short nRepeatedChar;
        short keyValLen;
        int index;
        long nodeAddr;
        byte[] keyVal = new byte[260];
        final NodeDesc node;

        NodeItemDesc(NodeDesc n) {
            this.node = n;
        }

        NodeItemDesc copy(NodeItemDesc cp) {
            this.blockNum = cp.blockNum;
            this.blockPos = cp.blockPos;
            this.keyProg = cp.keyProg;
            this.nRepeatedChar = cp.nRepeatedChar;
            this.keyValLen = cp.keyValLen;
            this.index = cp.index;
            this.nodeAddr = cp.nodeAddr;
            System.arraycopy(cp.keyVal, 0, this.keyVal, 0, this.keyVal.length);
            return this;
        }
    }

    class NodeDesc {
        short nodeType;
        short keyNum;
        long nextBrot;
        long prevBrot;
        int usedSize;
        int branchDepth;
        int rc;
        short progSize;
        long nodeAddr;
        final Key key;
        final byte[] buffer;

        NodeDesc(Key k, int size) {
            this.key = k;
            this.buffer = new byte[size];
        }

        NodeItemDesc next(long index) {
            NodeItemDesc found = new NodeItemDesc(this);
            int pnt = 10;
            found.index = 1;
            while (pnt < this.usedSize) {
                found.blockNum = RMKFile.getNumber(this.buffer, pnt, 4);
                pnt += 4;
                if (this.branchDepth == 0) {
                    found.blockPos = (short)(this.buffer[pnt++] & 0xFF);
                }
                if (this.key.duplicates) {
                    found.keyProg = RMKFile.getNumber(this.buffer, pnt, 4);
                    pnt += 4;
                }
                if (RMKFile.this.keyCompress == 2) {
                    found.nRepeatedChar = this.buffer[pnt++];
                    found.keyValLen = this.buffer[pnt++];
                    pnt += found.keyValLen;
                } else {
                    pnt += this.key.length;
                }
                if ((long)found.index > index) {
                    return found;
                }
                ++found.index;
            }
            return null;
        }

        NodeItemDesc search(byte[] keyArea, int mode) {
            NodeItemDesc prev = new NodeItemDesc(this);
            NodeItemDesc found = new NodeItemDesc(this);
            int pnt = 10;
            found.index = 1;
            while (pnt < this.usedSize) {
                int kLen;
                found.blockNum = RMKFile.getNumber(this.buffer, pnt, 4);
                pnt += 4;
                if (this.branchDepth == 0) {
                    found.blockPos = (short)(this.buffer[pnt++] & 0xFF);
                }
                if (this.key.duplicates) {
                    found.keyProg = RMKFile.getNumber(this.buffer, pnt, 4);
                    pnt += 4;
                }
                found.nRepeatedChar = this.buffer[pnt++];
                found.keyValLen = this.buffer[pnt++];
                if (found.keyValLen > 0) {
                    System.arraycopy(this.buffer, pnt, found.keyVal, found.nRepeatedChar, found.keyValLen);
                    kLen = found.nRepeatedChar + found.keyValLen;
                } else {
                    kLen = found.nRepeatedChar;
                }
                int kFill = this.key.length - kLen;
                if (kFill > 0) {
                    Arrays.fill(found.keyVal, kLen, kLen + kFill, (byte)32);
                }
                pnt += found.keyValLen;
                this.rc = RMKFile.memcmp(found.keyVal, 0, keyArea, 0, this.key.length);
                switch (mode) {
                    case 9: {
                        if (this.rc <= 0) {
                            prev.copy(found);
                            break;
                        }
                        return prev;
                    }
                    case 8: {
                        if (this.rc < 0) {
                            prev.copy(found);
                            break;
                        }
                        return prev;
                    }
                    case 7: {
                        if (this.rc < 0) break;
                        return found;
                    }
                    case 5: {
                        if (this.branchDepth != 0) {
                            if (this.rc < 0) break;
                            return found;
                        }
                        if (this.rc == 0) {
                            return found;
                        }
                        if (this.rc <= 0) break;
                        return null;
                    }
                    case 6: {
                        if (this.rc <= 0) break;
                        return found;
                    }
                    case 0: {
                        return found;
                    }
                    case 1: {
                        prev.copy(found);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                ++found.index;
            }
            return prev;
        }
    }

    static class Key {
        final int nparts;
        final long root;
        final boolean duplicates;
        final int length;
        final KeyPart[] parts;

        Key(KeyPart[] p, long rt, boolean dups) {
            this.root = rt;
            this.nparts = p.length;
            this.parts = p;
            this.duplicates = dups;
            int len = 0;
            for (int i = 0; i < this.parts.length; ++i) {
                len += this.parts[i].length;
            }
            this.length = len;
        }
    }

    static class KeyPart {
        final int offset;
        final int length;

        KeyPart(int o, int l) {
            this.offset = o;
            this.length = l;
        }
    }
}

