/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.BaseFile;
import com.iscobol.io.LockManager;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyValue;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class LockManagerHandler {
    public static final HashMap files = new HashMap();
    public final Class theLockManager;
    final LinkedList openFiles;

    public static LockManagerHandler get() {
        LockManagerHandler Return2 = (LockManagerHandler)IscobolSystem.get(LockManagerHandler.class);
        if (Return2 == null) {
            Return2 = new LockManagerHandler();
            IscobolSystem.set(LockManagerHandler.class, Return2);
        }
        return Return2;
    }

    private LockManagerHandler() {
        block6: {
            this.openFiles = new LinkedList();
            if (IscobolSystem.isAS()) {
                String lm = Config.getProperty(".file.lock_manager", null);
                if (lm != null) {
                    try {
                        this.theLockManager = Class.forName(lm);
                        if (!LockManager.class.isAssignableFrom(this.theLockManager)) {
                            throw new InstantiationException(lm + "!=" + LockManager.class);
                        }
                        break block6;
                    }
                    catch (Exception _ex) {
                        throw new IscobolRuntimeException(_ex);
                    }
                }
                this.theLockManager = null;
            } else {
                this.theLockManager = null;
            }
        }
    }

    public DynamicFile get(DynamicFile theFile) {
        if (this.theLockManager != null) {
            try {
                LockManager lm = (LockManager)this.theLockManager.newInstance();
                lm.init(theFile);
                return lm;
            }
            catch (IllegalAccessException _ex) {
                throw new IscobolRuntimeException(_ex);
            }
            catch (InstantiationException _ex) {
                throw new IscobolRuntimeException(_ex);
            }
        }
        return theFile;
    }

    public static synchronized FileUnique getFileUnique(String name, boolean ext) {
        String canonicalPath;
        File uId = ext ? new File(BaseFile.expandFileName(name)) : new File(name);
        try {
            canonicalPath = uId.getCanonicalPath();
        }
        catch (IOException _ex) {
            canonicalPath = uId.getName();
        }
        FileUnique Return2 = (FileUnique)files.get(canonicalPath);
        if (Return2 == null) {
            Return2 = new FileUnique(name);
            files.put(canonicalPath, Return2);
        }
        return Return2;
    }

    public static synchronized void release(int tid) {
        for (FileUnique fu : files.values()) {
            fu.release(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Vector getInfo(String file, int tid) {
        Vector<Info> Return2 = new Vector<Info>();
        Iterator i = files.values().iterator();
        while (i.hasNext()) {
            FileUnique fu;
            FileUnique fileUnique = fu = (FileUnique)i.next();
            synchronized (fileUnique) {
                if (file == null || file.equals(fu.name)) {
                    for (Records recs : fu.files.values()) {
                        if (tid > 0 && tid != recs.threadId) continue;
                        for (KeyValue kv : recs.recs) {
                            Return2.addElement(new Info(fu.name, recs.threadId, recs.openMode, recs.lockMode, kv));
                        }
                    }
                }
            }
        }
        Collections.sort(Return2);
        return Return2;
    }

    public static class Info
    implements Comparable {
        public final String fileName;
        public final int threadId;
        public final int openMode;
        public final int lockMode;
        public final KeyValue key;

        public Info(String name, int tid, int om, int lm, KeyValue k) {
            this.fileName = name;
            this.threadId = tid;
            this.openMode = om;
            this.lockMode = lm;
            this.key = k;
        }

        public int compareTo(Object c) {
            Info cfrt = (Info)c;
            int Return2 = this.fileName.compareTo(cfrt.fileName);
            if (Return2 != 0) {
                return Return2;
            }
            Return2 = this.threadId - cfrt.threadId;
            if (Return2 != 0) {
                return Return2;
            }
            Return2 = this.openMode - cfrt.openMode;
            if (Return2 != 0) {
                return Return2;
            }
            Return2 = this.lockMode - cfrt.lockMode;
            if (Return2 != 0) {
                return Return2;
            }
            Return2 = this.key.compareTo(cfrt.key);
            return Return2;
        }

        public boolean equals(Object c) {
            if (c instanceof Info) {
                return this.compareTo(c) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.fileName.hashCode() | this.threadId | this.openMode | this.key.hashCode();
        }

        public String toString() {
            return "[" + this.fileName + "," + this.threadId + "," + this.openMode + "," + this.lockMode + "," + this.key + "]";
        }
    }

    public static class FileUnique {
        private String name;
        private volatile HashMap files = new HashMap();
        private volatile HashMap pkeys = new HashMap();
        private Records exclLock;
        private int openedCnt;

        FileUnique(String name) {
            this.name = name;
        }

        public synchronized Records getLockExcl() {
            return this.exclLock;
        }

        public synchronized Records tryLockExcl(int tid, DynamicFile f, int openMode, int lockMode) {
            if (this.exclLock != null || this.openedCnt > 0) {
                return null;
            }
            this.exclLock = new Records(tid, f, openMode, lockMode);
            return this.exclLock;
        }

        public synchronized boolean unlockExcl(DynamicFile f) {
            if (this.exclLock != null) {
                this.release(f);
                this.exclLock = null;
                return true;
            }
            return false;
        }

        public synchronized void addOpened() {
            ++this.openedCnt;
        }

        public synchronized void removeOpened() {
            --this.openedCnt;
        }

        public synchronized void lock(int tid, DynamicFile f, int openMode, int lockMode, KeyValue val, int type) {
            Records recs = (Records)this.files.get(f);
            if (recs == null) {
                recs = new Records(tid, f, openMode, lockMode);
                this.files.put(f, recs);
            }
            recs.recs.add(val);
            this.pkeys.put(val, recs);
        }

        public synchronized void release(DynamicFile f, KeyValue val) {
            Records recs = (Records)this.files.get(f);
            if (recs != null) {
                recs.recs.remove(val);
                this.pkeys.remove(val);
                this.notifyAll();
            }
        }

        public synchronized void release(DynamicFile f) {
            Records recs = (Records)this.files.remove(f);
            if (recs != null) {
                for (KeyValue k : recs.recs) {
                    this.pkeys.remove(k);
                }
                this.notifyAll();
            }
        }

        public synchronized void release(int tid) {
            Object[] fileArray = this.files.values().toArray();
            for (int i = fileArray.length - 1; i >= 0; --i) {
                if (fileArray[i] == null) continue;
                Records recs = (Records)fileArray[i];
                if (tid != recs.threadId) continue;
                this.release(recs.file);
            }
        }

        public synchronized int getLockTid(KeyValue val) {
            Records recs = (Records)this.pkeys.get(val);
            if (recs != null) {
                return recs.threadId;
            }
            return 0;
        }

        public synchronized boolean isLocked(KeyValue val, DynamicFile f) {
            Records recs = (Records)this.pkeys.get(val);
            if (recs == null) {
                return false;
            }
            return recs.file != f;
        }

        public synchronized Records tryLock(int tid, DynamicFile f, int openMode, int lockMode, KeyValue val, int type) {
            Records Return2 = (Records)this.pkeys.get(val);
            if (Return2 != null) {
                if (Return2.file == f) {
                    Return2 = null;
                } else if (type == 3) {
                    try {
                        do {
                            this.wait();
                        } while (this.pkeys.containsKey(val));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.lock(tid, f, openMode, lockMode, val, type);
                    Return2 = null;
                }
            } else {
                this.lock(tid, f, openMode, lockMode, val, type);
            }
            return Return2;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Records {
        public final int threadId;
        public final DynamicFile file;
        public final int openMode;
        public final int lockMode;
        private final HashSet recs = new HashSet();

        public Records(int tid, DynamicFile f, int oMode, int lMode) {
            this.file = f;
            this.openMode = oMode;
            this.lockMode = lMode;
            this.threadId = tid;
        }
    }
}

