/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DeviceFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicN;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.PicX;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class LineSeqFile
extends DeviceFile
implements CobolFile,
RuntimeErrorsNumbers {
    public static final String encoding = Config.getProperty(".encoding", new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding());
    private final IPicN nationalBuffer;
    int minRecSize;
    boolean stripTrailingSpace = false;
    private static final PicX eol = new PicX(System.getProperty("line.separator", "\n"));

    public LineSeqFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, Class clazz) {
        super(nam, maxLen, memBuf, minLen, opt, false, clazz);
        this.nationalBuffer = memBuf instanceof IPicN ? (IPicN)memBuf : null;
    }

    public LineSeqFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, String clazz) {
        super(nam, maxLen, memBuf, minLen, opt, false, clazz);
        this.nationalBuffer = memBuf instanceof IPicN ? (IPicN)memBuf : null;
    }

    public LineSeqFile(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt) {
        super(nam, maxLen, memBuf, minLen, opt, false);
        this.nationalBuffer = memBuf instanceof IPicN ? (IPicN)memBuf : null;
    }

    @Override
    public void peerOpen(String path, int openType, int lockType) {
        this.stripTrailingSpace = Config.getProperty(".file.strip_trailing_spaces", ".strip_trailing_spaces", this.stripTrailingSpace);
        super.peerOpen(path, openType, lockType);
        if (this.stripTrailingSpace && this.outFile != null) {
            this.minRecSize = Config.getProperty(".file.min_rec_size", ".min_rec_size", 1);
            if (this.minRecSize < 0) {
                this.minRecSize = 0;
            }
            this.outFile.setMinRecSize(this.minRecSize);
        }
    }

    @Override
    public boolean write(boolean lock, int len) {
        super.write(lock, len);
        this.outFile.write(this.getBufferAsVar(), len, this.stripTrailingSpace);
        this.outFile.write(eol, eol.length(), false);
        return false;
    }

    @Override
    public boolean write(boolean lock, int len, int opts) {
        return this.write(lock, len);
    }

    @Override
    public boolean writeAdvancing(int kind, int lines, boolean lock, int len, int opts) {
        super.write(lock, len);
        opts = this.stripTrailingSpace ? (opts &= 0xFFFFFFFD) : (opts |= 2);
        return super.writeAdvancing(2, 1, lock, len, opts);
    }

    @Override
    public int readNext(boolean lock, ICobolVar into) {
        return this.readNext(lock ? 1 : 0, into);
    }

    @Override
    public int readNext(int lock, ICobolVar into) {
        int Return2 = 0;
        if (lock != -1) {
            super.readNext(lock &= this.lockMask, into);
        } else {
            super.readNext(lock &= 0xFFFFFFFF, into);
        }
        if (this.inpFile == null) {
            AtEndException.get(this, 6);
            return Return2;
        }
        try {
            String s = this.inpFile.readLine();
            if (s == null) {
                AtEndException.get(this, 6);
                return Return2;
            }
            byte[] in = s.getBytes(encoding);
            Return2 = in.length;
            this.updateBuffer(in);
            if (into != null) {
                into.setUsingMaxLen(in);
            }
        }
        catch (IOException ex) {
            CobolIOException.get(ex, this, 6);
        }
        return Return2;
    }

    private void myWrite(char[] ca) throws IOException {
        for (int i = 0; i < ca.length; ++i) {
            this.outFile.write(ca[i]);
        }
    }

    @Override
    public char[] getBufferAsChars() {
        if (this.nationalBuffer != null) {
            return this.nationalBuffer.basicToString().toCharArray();
        }
        return super.getBufferAsChars();
    }

    @Override
    protected ICobolVar getBufferAsVar() {
        if (this.nationalBuffer != null) {
            return this.nationalBuffer;
        }
        return super.getBufferAsVar();
    }

    public void setTrailingSpaces() {
        this.stripTrailingSpace = true;
    }
}

