/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;
import com.iscobol.io.BaseFile;
import com.iscobol.io.DynamicSequential;
import com.iscobol.io.FileLock;
import com.iscobol.rts.KeyDescription;
import java.util.GregorianCalendar;

public class DynamicMFSequential
extends DynamicSequential {
    private static final byte[] padding = new byte[]{0, 0, 0};
    private static byte[] dummy = new byte[]{0, 0, 0};
    private final int HEADER_LEN = 128;
    private boolean varLen;
    private long lastLen;
    private int recHeaderLen;
    private FileLock lock;

    private int getRecHeaderLen() {
        return this.maxRecordSize >= 4095 ? 4 : 2;
    }

    private void writeHeader(OSFile f) throws IsamException {
        byte[] header = new byte[128];
        header[0] = 48;
        if (this.getRecHeaderLen() == 4) {
            header[3] = 124;
        } else {
            header[1] = 126;
        }
        GregorianCalendar now = new GregorianCalendar();
        int year = now.get(1);
        int month = now.get(2) + 1;
        int day = now.get(5);
        int hour = now.get(11);
        int minute = now.get(12);
        int second = now.get(13);
        int cent = now.get(14) / 10;
        header[22] = header[8] = (byte)(48 + year % 100 / 10);
        header[23] = header[9] = (byte)(48 + year % 10);
        header[24] = header[10] = (byte)(48 + month / 10);
        header[25] = header[11] = (byte)(48 + month % 10);
        header[26] = header[12] = (byte)(48 + day / 10);
        header[27] = header[13] = (byte)(48 + day % 10);
        header[28] = header[14] = (byte)(48 + hour / 10);
        header[29] = header[15] = (byte)(48 + hour % 10);
        header[30] = header[16] = (byte)(48 + minute / 10);
        header[31] = header[17] = (byte)(48 + minute % 10);
        header[32] = header[18] = (byte)(48 + second / 10);
        header[33] = header[19] = (byte)(48 + second % 10);
        header[34] = header[20] = (byte)(48 + cent / 10);
        header[35] = header[21] = (byte)(48 + cent % 10);
        header[37] = 62;
        header[39] = 1;
        header[48] = 1;
        header[54] = (byte)((this.maxRecordSize & 0xFF000000) >>> 24);
        header[55] = (byte)((this.maxRecordSize & 0xFF0000) >>> 16);
        header[56] = (byte)((this.maxRecordSize & 0xFF00) >>> 8);
        header[57] = (byte)(this.maxRecordSize & 0xFF);
        header[58] = (byte)((this.minRecordSize & 0xFF000000) >>> 24);
        header[59] = (byte)((this.minRecordSize & 0xFF0000) >>> 16);
        header[60] = (byte)((this.minRecordSize & 0xFF00) >>> 8);
        header[61] = (byte)(this.minRecordSize & 0xFF);
        header[78] = 1;
        header[108] = 88;
        header[109] = 106;
        header[110] = 57;
        header[111] = 119;
        f.write(header, 0, header.length);
        this.currPos = header.length;
        this.fileLen = header.length;
        this.lastLen = 0L;
    }

    private int readHeader() {
        byte[] header = new byte[128];
        try {
            int rc = this.theFile.read(header, 0, header.length);
            if (rc != header.length) {
                return this.mapError(new IsamException(102));
            }
            int hMaxLen = (header[54] & 0xFF) << 24 | (header[55] & 0xFF) << 16 | (header[56] & 0xFF) << 8 | header[57] & 0xFF;
            if (hMaxLen > this.maxRecordSize) {
                return this.mapError(new IsamException(102));
            }
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1;
    }

    private int getRecHeader() throws IsamException {
        int Return2;
        if (this.recHeaderLen == 4) {
            Return2 = this.theFile.readInt();
            Return2 &= 0xFFFFFFF;
        } else {
            Return2 = this.theFile.readChar();
            Return2 &= 0xFFF;
        }
        return Return2;
    }

    private void putRecHeader(int len) throws IsamException {
        if (this.recHeaderLen == 4) {
            this.theFile.writeInt(len | 0x40000000);
        } else {
            this.theFile.writeChar(len | 0x4000);
        }
    }

    @Override
    protected OSFile getOSFile(boolean xLock) {
        return new OSFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int ecryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean assignExt) {
        if (assignExt) {
            path = BaseFile.expandFileName(path);
        }
        this.maxRecordSize = maxRecordSize;
        this.minRecordSize = minRecordSize;
        this.varLen = minRecordSize != 0 && maxRecordSize != minRecordSize;
        f = new OSFile();
        this.lock = null;
        opened = false;
        try {
            f.open(path, 1);
            opened = true;
            this.lock = new FileLock(path, f, true, false);
        }
        catch (IsamException _ex) {
            switch (_ex.getIserrno()) {
                case 130: {
                    ** break;
lbl18:
                    // 1 sources

                    break;
                }
                default: {
                    var17_20 = this.mapError(_ex);
                    return var17_20;
                }
            }
        }
        finally {
            try {
                if (this.lock != null) {
                    this.lock.finalize();
                    this.lock = null;
                }
                if (opened) {
                    f.close();
                }
            }
            catch (IsamException _ex) {}
        }
        try {
            f.open(path, 577);
            if (this.varLen) {
                this.writeHeader(f);
            }
            f.close();
            Return = 1;
        }
        catch (IsamException _ex) {
            Return = this.mapError(_ex);
        }
        return Return;
    }

    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accessMode, boolean optional, boolean assignExt) {
        this.varLen = minRec != 0 && maxRec != minRec;
        int myOpen = openType == 6 ? 3 : openType;
        int Return2 = super.open(path, myOpen, lockType, k, maxRec, minRec, nKeys, accessMode, optional, assignExt);
        if (Return2 == 1) {
            if (this.varLen) {
                Return2 = this.readHeader();
                this.recHeaderLen = this.getRecHeaderLen();
            }
            if (openType == 6) {
                try {
                    this.currPos = this.fileLen;
                    this.theFile.seek(this.currPos);
                    this.openMode = 6;
                }
                catch (IsamException _ex) {
                    Return2 = this.mapError(_ex);
                }
            }
        }
        return Return2;
    }

    @Override
    public long write(byte[] record, int offs, int len, boolean lock) {
        block7: {
            try {
                this.errno = 0;
                long fLen = this.theFile.length();
                if (this.openMode == 6 || this.currPos == fLen) {
                    this.theFile.seek(this.theFile.length());
                }
                if (!this.varLen) {
                    return super.write(record, offs, len, lock);
                }
                if (len > this.maxRecordSize) {
                    len = this.maxRecordSize;
                }
                if (this.currPos >= this.fileLen) {
                    this.putRecHeader(len);
                    this.theFile.write(record, offs, len);
                    this.lastLen = len;
                    int padlen = (len += this.recHeaderLen) % 4;
                    if (padlen > 0) {
                        this.theFile.write(padding, 0, 4 - padlen);
                        len += padlen;
                    }
                    this.currPos += (long)len;
                    this.fileLen += (long)len;
                    break block7;
                }
                return this.mapError(new IsamException(100));
            }
            catch (IsamException _ex) {
                return this.mapError(_ex);
            }
        }
        return 1L;
    }

    @Override
    public long rewrite(byte[] record, int offs, int len, boolean lock) {
        this.errno = 0;
        if (!this.varLen) {
            return super.rewrite(record, offs, len, lock);
        }
        if (this.lastLen != (long)len) {
            this.errno = -2;
            return 0L;
        }
        if (this.currPos == 0L || this.currPos - (long)len - (long)this.recHeaderLen < 0L) {
            this.errno = -2;
            return 0L;
        }
        try {
            this.theFile.seek(this.currPos - (long)len);
            this.theFile.write(record, offs, len);
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1L;
    }

    @Override
    public long delete(byte[] record, int offs) {
        if (this.varLen) {
            this.errno = -3;
            return 0L;
        }
        return super.delete(record, offs);
    }

    @Override
    public synchronized long next(byte[] record, int offs, int lock) {
        int Return2;
        this.errno = 0;
        if (!this.varLen) {
            return super.next(record, offs, lock);
        }
        try {
            if (this.currPos < 0L) {
                return this.mapError(new IsamException(112));
            }
            int len = this.getRecHeader();
            if (len < this.minRecordSize || len > this.maxRecordSize) {
                return this.mapError(new IsamException(105));
            }
            Return2 = this.theFile.read(record, offs, len);
            this.lastLen = Return2;
            int padlen = (len += this.recHeaderLen) % 4;
            if (padlen > 0) {
                this.theFile.read(dummy, 0, 4 - padlen);
                len += padlen;
            }
            if (Return2 <= 0) {
                this.currPos = -1L;
                return this.mapError(new IsamException(110));
            }
            if (lock > 0) {
                this.lock(this.currPos, len);
            }
            this.currPos += (long)len;
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public synchronized long previous(byte[] record, int offs, int lock) {
        this.errno = 0;
        if (this.varLen) {
            this.errno = -3;
            return 0L;
        }
        return super.previous(record, offs, lock);
    }
}

