/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;

public class BufferedOSFile
extends OSFile {
    private static int DEFAULT_CACHE_SIZE = 8192;
    private static byte[] cacheFiller = new byte[DEFAULT_CACHE_SIZE];
    private int CACHE_SIZE = DEFAULT_CACHE_SIZE;
    private byte[] cache = new byte[this.CACHE_SIZE];
    private long cacheStart;
    private int cacheEnd;
    private int cachePos;
    private boolean cacheRead;
    private boolean cacheWrite;
    private long filePos;
    private long fileLen;
    private byte[] b4 = new byte[4];

    @Override
    public synchronized void open(String name, int mode) throws IsamException {
        super.open(name, mode);
        this.cachePos = 0;
        this.filePos = 0;
        this.cacheEnd = this.CACHE_SIZE;
        this.fileLen = super.length();
    }

    private void resetCache(boolean clean) throws IsamException {
        if (this.cacheWrite) {
            super.seek(this.cacheStart);
            if (this.cachePos > 0) {
                super.write(this.cache, 0, this.cachePos);
                this.filePos = this.cacheStart + (long)this.cachePos;
            }
            this.cacheWrite = false;
        } else if (this.cacheRead) {
            this.filePos = this.cacheStart + (long)this.cachePos;
            super.seek(this.filePos);
            this.cacheRead = false;
        }
        this.cacheEnd = 0;
        this.cachePos = 0;
        this.cacheStart = this.filePos;
        if (clean) {
            System.arraycopy(cacheFiller, 0, this.cache, 0, this.cache.length);
        }
    }

    private int fillCache() throws IsamException {
        int Return2;
        if (this.cacheRead && this.cacheStart + (long)this.cachePos != this.filePos) {
            this.filePos = this.cacheStart + (long)this.cachePos;
            super.seek(this.filePos);
        }
        if ((Return2 = super.read(this.cache, 0, this.CACHE_SIZE)) >= 0) {
            this.cacheStart = this.filePos;
            this.filePos += (long)Return2;
            this.cacheEnd = Return2;
            this.cachePos = 0;
            this.cacheRead = true;
        } else {
            this.cacheEnd = 0;
            this.cachePos = 0;
        }
        return Return2;
    }

    private void resizeCache(int len) throws IsamException {
        this.resetCache(false);
        this.CACHE_SIZE = len;
        this.cache = new byte[this.CACHE_SIZE];
        if (len > cacheFiller.length) {
            cacheFiller = new byte[len];
        }
    }

    @Override
    public int read(byte[] b) throws IsamException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int offs, int len) throws IsamException {
        if (len > this.CACHE_SIZE) {
            this.resizeCache(len);
        }
        if (this.cacheWrite) {
            this.resetCache(true);
        }
        if (!this.cacheRead || this.cachePos + len > this.cacheEnd) {
            this.fillCache();
        }
        if (this.cachePos >= this.cacheEnd) {
            return -1;
        }
        if (len > this.cacheEnd - this.cachePos) {
            len = this.cacheEnd - this.cachePos;
        }
        System.arraycopy(this.cache, this.cachePos, b, offs, len);
        this.cachePos += len;
        return len;
    }

    @Override
    public synchronized char readChar() throws IsamException {
        if (this.read(this.b4, 0, 2) == 2) {
            return (char)(this.b4[0] << 8 | this.b4[1]);
        }
        throw new IsamException(110);
    }

    @Override
    public synchronized int readInt() throws IsamException {
        if (this.read(this.b4, 0, 4) == 4) {
            return this.b4[0] << 24 | this.b4[1] << 16 | this.b4[2] << 8 | this.b4[3];
        }
        throw new IsamException(110);
    }

    @Override
    public synchronized long tell() throws IsamException {
        if (this.cacheRead || this.cacheWrite) {
            return this.cacheStart + (long)this.cachePos;
        }
        this.filePos = super.tell();
        return this.filePos;
    }

    @Override
    public synchronized long length() throws IsamException {
        return this.fileLen;
    }

    @Override
    public synchronized void seek(long pos) throws IsamException {
        if (this.cacheRead) {
            if (pos >= this.cacheStart && pos < this.cacheStart + (long)this.cacheEnd) {
                this.cachePos = (int)(pos - this.cacheStart);
            } else {
                this.cacheRead = false;
                super.seek(pos);
                this.filePos = pos;
            }
        } else if (this.cacheWrite) {
            if (pos >= this.cacheStart && pos < this.cacheStart + (long)this.CACHE_SIZE) {
                this.cachePos = (int)(pos - this.cacheStart);
            } else {
                this.resetCache(true);
                super.seek(pos);
                this.filePos = pos;
            }
        } else {
            super.seek(pos);
            this.filePos = pos;
        }
    }

    @Override
    public synchronized void write(byte[] b, int offset, int len) throws IsamException {
        if (len > this.CACHE_SIZE) {
            this.resizeCache(len);
        }
        if (this.cacheRead) {
            this.resetCache(true);
        }
        if (this.cacheWrite) {
            if (this.cachePos + len > this.CACHE_SIZE) {
                this.resetCache(true);
            }
            this.cacheWrite = true;
        } else {
            this.cacheStart = this.filePos;
            this.cachePos = 0;
            this.cacheWrite = true;
        }
        System.arraycopy(b, offset, this.cache, this.cachePos, len);
        this.cachePos += len;
        if (this.cacheStart + (long)this.cachePos > this.fileLen) {
            this.fileLen = this.cacheStart + (long)this.cachePos;
        }
    }

    @Override
    public synchronized void writeChar(int v) throws IsamException {
        this.b4[0] = (byte)((v & 0xFF00) >>> 8);
        this.b4[1] = (byte)(v & 0xFF);
        this.write(this.b4, 0, 2);
    }

    @Override
    public synchronized void writeInt(int v) throws IsamException {
        this.b4[0] = (byte)((v & 0xFF000000) >>> 24);
        this.b4[1] = (byte)((v & 0xFF0000) >>> 16);
        this.b4[2] = (byte)((v & 0xFF00) >>> 8);
        this.b4[3] = (byte)(v & 0xFF);
        this.write(this.b4, 0, 4);
    }

    @Override
    public synchronized void close() throws IsamException {
        this.resetCache(true);
        super.close();
    }
}

