/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter;

import com.iscobol.htmlexporter.RptFont;
import java.awt.Color;

public class RptComponent {
    public static final int INPUT_IMG_WIDTH = 17;
    public static final int INPUT_IMG_HEIGHT = 17;
    public static final String CHECKED_CHECK_BOX = "$CheckedCheckBox$";
    public static final String CHECKED_RADIO_BUTTON = "$CheckedRadioButton$";
    public static final String UNCHECKED_CHECK_BOX = "$UncheckedCheckBox$";
    public static final String UNCHECKED_RADIO_BUTTON = "$UncheckedRadioButton$";
    public int x;
    public int y;
    public Color background;
    public Color foreground;
    public int width;
    public int height;
    public String text;
    public String imageFile;
    public String hyperlink;
    public String align;
    public String letterSpacing;
    public String position;
    public String cssClass;
    public String rptType;
    public RptFont font = new RptFont();
    public String name;
    public RptComponent parent;
    public RptComponent image;
    public String inputType;

    public RptComponent() {
    }

    public RptComponent(RptComponent parent, String name, int childIndex) {
        this.name = name;
        this.parent = parent;
        this.x = parent.x;
        this.y = parent.y;
        this.width = parent.width;
        this.height = parent.height;
        this.background = parent.background;
        this.foreground = parent.foreground;
        this.text = parent.text;
        this.imageFile = parent.imageFile;
        this.image = parent.image;
        this.hyperlink = parent.hyperlink;
        this.align = parent.align;
        this.letterSpacing = parent.letterSpacing;
        this.position = parent.position;
        this.inputType = parent.inputType;
        this.cssClass = parent.cssClass;
        this.rptType = parent.rptType;
        if (parent.font != null) {
            this.font = new RptFont(parent.font);
        }
    }

    public boolean isSection() {
        return this.rptType != null && this.rptType.equals("sec");
    }

    public boolean isTableComponent() {
        return this.rptType != null && this.rptType.equals("tb");
    }

    public boolean isTableCellComponent() {
        return this.rptType != null && this.rptType.startsWith("tc");
    }

    public boolean isLineComponent() {
        return this.rptType != null && this.rptType.equals("ln");
    }

    public boolean isBoxComponent() {
        return this.rptType != null && this.rptType.equals("bx");
    }

    public boolean isImageComponent() {
        return this.rptType != null && this.rptType.startsWith("im");
    }

    public boolean equalTo(RptComponent other) {
        return RptComponent.equal(this.cssClass, other.cssClass) && RptComponent.equal(this.text, other.text) && RptComponent.equal(this.background, other.background) && RptComponent.equal(this.foreground, other.foreground) && RptComponent.equal(this.imageFile, other.imageFile) && RptComponent.equal(this.hyperlink, other.hyperlink);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + this.name + " class='" + this.cssClass + "',rptType='" + this.rptType + "',x='" + this.x + "',y='" + this.y + "',width='" + this.width + "',height='" + this.height + "'");
        sb.append(",fontFamily='" + this.font.family + "'");
        sb.append(",fontSize='" + this.font.size + "'");
        sb.append(",fontBold='" + this.font.bold + "'");
        sb.append(",fontItalic='" + this.font.italic + "'");
        sb.append(",fontUnderline='" + this.font.underline + "'");
        if (this.background != null) {
            sb.append(",background='" + Integer.toHexString(this.background.getRGB()) + "'");
        }
        if (this.foreground != null) {
            sb.append(",foreground='" + Integer.toHexString(this.foreground.getRGB()) + "'");
        }
        if (this.align != null) {
            sb.append(",align='" + this.align + "'");
        }
        if (this.hyperlink != null) {
            sb.append(",hyperlink='" + this.hyperlink + "'");
        }
        if (this.image != null) {
            sb.append(",image='" + this.image + "'");
        }
        if (this.inputType != null) {
            sb.append(",input='" + this.inputType + "'");
        }
        if (this.text != null) {
            sb.append(",text='" + this.text + "'");
        }
        sb.append("/>");
        return sb.toString();
    }

    private static boolean equal(Object o1, Object o2) {
        if (o1 != null) {
            if (o2 != null) {
                return o1.equals(o2);
            }
            return false;
        }
        return o2 == null;
    }
}

