/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter;

import com.iscobol.htmlexporter.HTMLParser;
import com.iscobol.htmlexporter.RptComponent;
import com.iscobol.htmlrenderer.CSSStyle;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class HTMLNode {
    protected HTMLParser main;
    protected String name;
    protected Attributes attrs;
    protected CSSStyle style;
    protected int childCount;
    protected RptComponent cmp;

    public RptComponent getComponent() {
        return this.cmp;
    }

    public String getName() {
        return this.name;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public int getChildCount() {
        return this.childCount;
    }

    public void incChildCount() {
        ++this.childCount;
    }

    void init(HTMLParser m, String n, HTMLNode p, Attributes a) {
        int len;
        this.name = n;
        this.main = m;
        this.attrs = a;
        if (this.attrs != null && (len = this.attrs.getLength()) > 0) {
            String key;
            int i;
            for (i = 0; i < len; ++i) {
                key = this.attrs.getLocalName(i);
                if (!"style".equals(key)) continue;
                String str = this.attrs.getValue(i);
                this.style = new CSSStyle(str);
                try {
                    this.style.parse();
                }
                catch (CSSStyle.BadFormatException _ex) {
                    _ex.printStackTrace();
                }
                break;
            }
            for (i = 0; i < len; ++i) {
                key = this.attrs.getLocalName(i);
                if (!"class".equals(key)) continue;
                if (this.style == null) {
                    this.style = new CSSStyle("");
                }
                StringTokenizer st = new StringTokenizer(this.attrs.getValue(i));
                while (st.hasMoreTokens()) {
                    this.style.mixUp(this.main.getStyle(st.nextToken().toLowerCase()));
                }
                break;
            }
        }
    }

    public String toString() {
        return "<" + this.name + ">";
    }
}

