/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.server;

import com.iscobol.gui.Constants;
import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.RemoteFontComponent;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.interfaces.runtime.IFontCmp;
import com.iscobol.rts.Config;
import com.iscobol.rts.Handle;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolVar;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FontCmp
implements Constants,
IFontCmp,
Handle {
    private static final long serialVersionUID = 1L;
    private int style;
    private float size;
    private int cellWidth;
    private int cellHeight;
    private String name;
    private final Hashtable attrs;
    RemoteFontComponent fontPeer;
    int fontPeerId;

    private FontCmp(String name, int style, float size) {
        this.name = name;
        this.style = style;
        this.size = size;
        this.attrs = new Hashtable();
        this.attrs.put(FontAttribute.FAMILY, name);
        this.attrs.put(FontAttribute.SIZE, new Float(size));
        if ((style & 1) != 0) {
            this.attrs.put(FontAttribute.WEIGHT, FontAttribute.WEIGHT_BOLD);
        }
        if ((style & 2) != 0) {
            this.attrs.put(FontAttribute.POSTURE, FontAttribute.POSTURE_OBLIQUE);
        }
    }

    public FontCmp(RemoteFontComponent peer, Hashtable attrs) {
        this.fontPeer = peer;
        this.attrs = attrs;
        if (this.fontPeer != null) {
            try {
                this.fontPeerId = this.fontPeer.getTheObjectId();
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
            }
        }
    }

    public void setFont(RemoteFontComponent rf) {
        this.fontPeer = rf;
        if (this.fontPeer != null) {
            try {
                this.fontPeerId = this.fontPeer.getTheObjectId();
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
            }
        }
    }

    public FontCmp(RemoteFontComponent peer, int peerid, Hashtable attrs) {
        this.setFontPeer(peer, peerid);
        this.attrs = attrs;
    }

    private static int[] getCellSize(String stdFontName) {
        int[] Return2 = new int[2];
        String prop = Config.getProperty("iscobol.font." + stdFontName + ".cell", null);
        if (prop != null) {
            StringTokenizer stn = new StringTokenizer(prop, ",");
            try {
                Return2[0] = Integer.parseInt(stn.nextToken());
                Return2[1] = Integer.parseInt(stn.nextToken());
            }
            catch (Exception ex) {
                Return2[0] = 0;
                Return2[1] = 0;
            }
        } else {
            Return2[0] = 0;
            Return2[1] = 0;
        }
        return Return2;
    }

    public static FontCmp getStdFont(int index) {
        return FontCmp.getStdFont(index, "iscobol.font.");
    }

    public static FontCmp getStdFont(int index, String propPfx) {
        FontCmp Return2 = null;
        String nm = null;
        String fn = null;
        float sz = 9.0f;
        int st = 0;
        int[] cellSize = new int[]{0, 0};
        if (index == 5) {
            fn = Config.getProperty(propPfx + "default", null);
            if (fn != null) {
                nm = "SansSerif";
                st = 1;
            } else {
                index = 4;
            }
            cellSize = FontCmp.getCellSize("default");
        }
        switch (index) {
            case 0: {
                nm = "Monospaced";
                st = 1;
                fn = Config.getProperty(propPfx + "traditional", null);
                cellSize = FontCmp.getCellSize("traditional");
                break;
            }
            case 1: {
                nm = "Monospaced";
                st = 1;
                fn = Config.getProperty(propPfx + "fixed", null);
                cellSize = FontCmp.getCellSize("fixed");
                break;
            }
            case 2: {
                nm = "SansSerif";
                st = 1;
                sz = 10.0f;
                fn = Config.getProperty(propPfx + "large", null);
                cellSize = FontCmp.getCellSize("large");
                break;
            }
            case 3: {
                nm = "SansSerif";
                sz = 8.0f;
                fn = Config.getProperty(propPfx + "small", null);
                cellSize = FontCmp.getCellSize("small");
                break;
            }
            default: {
                if (index == 5) break;
                nm = "SansSerif";
                st = 1;
                fn = Config.getProperty(propPfx + "medium", null);
                cellSize = FontCmp.getCellSize("medium");
            }
        }
        if (fn != null) {
            Object[] ret = IsguiUtility.parseFontString(fn);
            Return2 = new FontCmp((String)ret[0], (int)((Integer)ret[1]), ((Float)ret[2]).floatValue());
        } else {
            Return2 = new FontCmp(nm, st, sz);
        }
        Return2.cellWidth = cellSize[0];
        Return2.cellHeight = cellSize[1];
        return Return2;
    }

    public static FontCmp[] getStdFonts() {
        return FontCmp.getStdFonts("iscobol.font.");
    }

    public static FontCmp[] getStdFonts(String propPfx) {
        FontCmp[] Return2 = new FontCmp[6];
        for (int n = 0; n < 6; ++n) {
            Return2[n] = FontCmp.getStdFont(n, propPfx);
        }
        return Return2;
    }

    private static FontCmp[] intGetStdFonts() {
        FontCmp[] Return2 = (FontCmp[])IscobolSystem.get(FontCmp[].class);
        if (Return2 == null) {
            Return2 = FontCmp.getStdFonts();
            IscobolSystem.set(FontCmp[].class, Return2);
        }
        return Return2;
    }

    public static FontCmp getFont(int fontId) {
        return FontCmp.intGetStdFonts()[fontId];
    }

    public static FontCmp getFont(CobolVar cv) {
        return FontCmp.getFont((ICobolVar)cv);
    }

    public static FontCmp getFont(ICobolVar cv) {
        Object Return2 = UserHandles.getId(cv.toint());
        if (Return2 instanceof FontCmp) {
            return (FontCmp)Return2;
        }
        return FontCmp.getFont(cv.toString());
    }

    private static int getFontIndex(String fontname) {
        int fontId = -1;
        if (fontname.equalsIgnoreCase("DEFAULT-FONT")) {
            fontId = 5;
        } else if (fontname.equalsIgnoreCase("FIXED-FONT")) {
            fontId = 1;
        } else if (fontname.equalsIgnoreCase("TRADITIONAL-FONT")) {
            fontId = 0;
        } else if (fontname.equalsIgnoreCase("SMALL-FONT")) {
            fontId = 3;
        } else if (fontname.equalsIgnoreCase("MEDIUM-FONT")) {
            fontId = 4;
        } else if (fontname.equalsIgnoreCase("LARGE-FONT")) {
            fontId = 2;
        }
        return fontId;
    }

    public static FontCmp getStdFont(String fontname) {
        return FontCmp.getStdFont(fontname, "iscobol.font.");
    }

    public static FontCmp getStdFont(String fontname, String propPfx) {
        int idx = FontCmp.getFontIndex(fontname);
        if (idx >= 0) {
            return FontCmp.getStdFont(idx, propPfx);
        }
        return FontCmp.getStdFont(5, propPfx);
    }

    public static FontCmp getFont(String fontname) {
        int idx = FontCmp.getFontIndex(fontname);
        if (idx >= 0) {
            return FontCmp.intGetStdFonts()[idx];
        }
        return FontCmp.intGetStdFonts()[5];
    }

    public static FontCmp getFontIfExists(String fontname) {
        int idx = FontCmp.getFontIndex(fontname);
        if (idx >= 0) {
            return FontCmp.intGetStdFonts()[idx];
        }
        return null;
    }

    public static FontCmp getDefaultFont() {
        return FontCmp.intGetStdFonts()[5];
    }

    public static FontCmp getDefaultWindowFont() {
        return FontCmp.intGetStdFonts()[1];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public int getCellWidth() {
        return this.cellWidth;
    }

    @Override
    public int getCellHeight() {
        return this.cellHeight;
    }

    public int getFontId(boolean printer) {
        if (this.fontPeer == null) {
            this.getFont(printer);
        }
        int Return2 = this.fontPeerId;
        return Return2;
    }

    public RemoteFontComponent getFont(boolean printer) {
        RemoteFontComponent Return2 = null;
        if (this.fontPeer != null) {
            Return2 = this.fontPeer;
        } else if (this.name != null) {
            GuiFactory gf = ScreenUtility.getGuiFactory();
            try {
                Return2 = this.fontPeer = gf.getFont(this.name, this.style, this.size, this.cellWidth, this.cellHeight, printer);
                this.fontPeerId = this.fontPeer.getTheObjectId();
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
            }
        }
        return Return2;
    }

    @Override
    public int type() {
        return 3;
    }

    public String toString() {
        return "FontCmp name=[" + this.name + "], size=[" + this.size + "],style=[" + this.style + "]";
    }

    @Override
    public boolean isStandardFont() {
        int lenstd = FontCmp.intGetStdFonts().length;
        for (int i = 0; i < lenstd; ++i) {
            if (FontCmp.getFont(i) != this) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        if (this.fontPeer == null || this.isStandardFont()) {
            return;
        }
        try {
            this.fontPeer.destroy();
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        this.fontPeer = null;
        this.fontPeerId = 0;
    }

    public Hashtable getAttrs() {
        return this.attrs;
    }

    public boolean isInitialized() {
        return this.fontPeer != null;
    }

    public void setFontPeer(RemoteFontComponent fontPeer, int fontPeerId) {
        this.fontPeer = fontPeer;
        if (fontPeer != null) {
            this.fontPeerId = fontPeerId;
        }
    }
}

