/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.server;

import com.iscobol.gui.ParamElementMenu;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.server.BaseGUIControl;
import com.iscobol.gui.server.CobolGUIEnvironment;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.ServerMenuManager;
import com.iscobol.rts.FileImage;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IObjectVar;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.UserHandles;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class CobolGUIMenu
extends BaseGUIControl {
    private int type;
    private int id;
    private Vector children = new Vector();
    private boolean isMenuBar;
    private boolean isDestroyed;
    private boolean isTrayMenuVisible;

    public CobolGUIMenu(CobolGUIEnvironment env, int type) {
        this(env, type, 0, 0, 0, -1);
    }

    public CobolGUIMenu(CobolGUIEnvironment env, int type, int scrollitems, int fixedtopitems, int fixedbottomitems, int scrollinterval) {
        super("", null, env);
        this.type = type;
        this.isEventGenerator = true;
        this.controlPeerServerId = env.setServerId(this);
        ParamElementMenu elem = null;
        switch (type) {
            case 0: {
                elem = ParamElementMenu.New(this.controlPeerServerId);
                break;
            }
            case 2: {
                elem = ParamElementMenu.NewPopup(this.controlPeerServerId);
                break;
            }
            case 4: {
                elem = ParamElementMenu.NewHamburger(this.controlPeerServerId);
            }
        }
        if (elem != null) {
            elem.setScrollIndexes(scrollitems, fixedtopitems, fixedbottomitems, scrollinterval);
        }
        ServerMenuManager.getDefault().getParamCSWindow().addElement(elem);
    }

    public CobolGUIMenu(CobolGUIEnvironment env, String trayTooltip, int trayExceptionValue, int trayExceptionValue2, ICobolVar trayBitmapHandle, int trayBitmapNumber, int trayBitmapWidth) {
        super("", null, env);
        FileImage fim;
        this.type = 3;
        this.isEventGenerator = true;
        this.controlPeerServerId = env.setServerId(this);
        int imageId = -1;
        if (trayBitmapHandle != null && (fim = CobolGUIMenu.getFileImage(trayBitmapHandle)) != null) {
            imageId = fim.getImageId();
        }
        ParamElementMenu elem = ParamElementMenu.NewTray(this.controlPeerServerId, trayTooltip, trayExceptionValue, trayExceptionValue2, imageId, trayBitmapNumber, trayBitmapWidth);
        ServerMenuManager.getDefault().getParamCSWindow().addElement(elem);
    }

    @Override
    protected void componentDisplayProp() throws IOException {
    }

    @Override
    protected String componentsetProp(int key, String[] values, boolean haveGiving) {
        return null;
    }

    @Override
    protected String componentsetProp(int key, ICobolVar valCV, int length, boolean haveGiving) {
        return null;
    }

    @Override
    protected void componentsetStyle(String style) throws IOException {
    }

    @Override
    protected int getExceptionValue() {
        return 0;
    }

    @Override
    protected String getPropName(int propId) {
        return "";
    }

    @Override
    protected String[] getStyleName(long style) {
        return null;
    }

    @Override
    protected int getTerminationValue() {
        return 0;
    }

    @Override
    protected void initialize() {
    }

    public void delete(int id) {
        this.sendParam(ParamElementMenu.Delete(this.controlPeerServerId, id));
    }

    private void sendParam(ParamElementMenu elem) {
        if (this.isDestroyed) {
            return;
        }
        ServerMenuManager smm = ServerMenuManager.getDefault();
        smm.getParamCSWindow().addElement(elem);
        DisplayWindow pWnd = this.parentWindow;
        CobolGUIMenu menu = this;
        while (pWnd == null && menu != null) {
            pWnd = menu.parentWindow;
            menu = (CobolGUIMenu)menu.parentControl;
        }
        if (pWnd != null && this.statusEnv != null) {
            this.statusEnv.refreshWin(pWnd);
        }
        if (pWnd != null || this.type == 3 && this.isTrayMenuVisible) {
            smm.sendParams(smm.getParamCSWindow());
        }
    }

    public void check(int id, boolean checked) {
        ParamElementMenu elem = checked ? ParamElementMenu.Check(this.controlPeerServerId, id) : ParamElementMenu.Uncheck(this.controlPeerServerId, id);
        this.sendParam(elem);
    }

    @Override
    public boolean isDisplayed() {
        return this.parentWindow != null && this == this.parentWindow.getMenuBar();
    }

    @Override
    public void destroy() {
        this.isDestroyed = true;
        this.intdestroy(true);
    }

    public void setTrayMenuVisible(boolean v) {
        this.isTrayMenuVisible = v;
    }

    public void intdestroy(boolean send) {
        ServerMenuManager smmok = (ServerMenuManager)IscobolSystem.getIfExists(ServerMenuManager.class, Thread.currentThread());
        if (this.isMenuBar) {
            if (this.isDisplayed()) {
                if (send) {
                    this.parentWindow.setMenuBar(null);
                } else {
                    if (smmok != null) {
                        ServerMenuManager.getDefault().getParamCSWindow().addElement(ParamElementMenu.Show(-1, this.parentWindow.getTheObjectId()));
                    }
                    CobolGUIMenu cm = this.parentWindow.getMenuBar();
                    this.parentWindow.resetMenuBar();
                    cm.setParentWindow(null);
                    cm.setMenuBar(false);
                }
            }
            this.isMenuBar = false;
        }
        this.children.clear();
        if (smmok != null) {
            ServerMenuManager smm = ServerMenuManager.getDefault();
            smm.getParamCSWindow().addElement(ParamElementMenu.Destroy(this.controlPeerServerId));
            if (send) {
                ServerMenuManager.getDefault().sendParams(ServerMenuManager.getDefault().getParamCSWindow());
            }
        }
        if (this.statusEnv != null) {
            this.statusEnv.delServerId(this.getControlPeerServerId());
        }
        this.isTrayMenuVisible = false;
        super.destroy();
    }

    public void addMenu(int pos, int flags, String text, int id, CobolGUIMenu submenu, boolean change) {
        this.addMenu(pos, flags, text, id, submenu, change, "");
    }

    public void addMenu(int pos, int flags, String text, int id, CobolGUIMenu submenu, boolean change, String exceptionvaluestr) {
        int smId;
        if (submenu != null) {
            smId = submenu.getControlPeerServerId();
            submenu.id = id;
            this.children.addElement(submenu);
            submenu.parentControl = this;
        } else {
            smId = -1;
        }
        ParamElementMenu elem = change ? ParamElementMenu.Change(this.controlPeerServerId, pos, flags, text, id, smId) : ParamElementMenu.Add(this.controlPeerServerId, pos, flags, text, id, smId, exceptionvaluestr);
        this.sendParam(elem);
    }

    void setMenuBar(boolean b) {
        this.isMenuBar = b;
    }

    public CobolGUIMenu findMenu(int id) {
        if (this.id == id) {
            return this;
        }
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            CobolGUIMenu cguimenu = ((CobolGUIMenu)e.nextElement()).findMenu(id);
            if (cguimenu == null) continue;
            return cguimenu;
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setEnabled(boolean en, int id) {
        ParamElementMenu elem = en ? ParamElementMenu.Enable(this.controlPeerServerId, id) : ParamElementMenu.Disable(this.controlPeerServerId, id);
        this.sendParam(elem);
    }

    public void setBlock(boolean b) {
        ParamElementMenu elem = b ? ParamElementMenu.Block(this.controlPeerServerId) : ParamElementMenu.Unblock(this.controlPeerServerId);
        this.sendParam(elem);
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setParentWindow(DisplayWindow cs) {
        this.parentWindow = cs;
    }

    @Override
    public void release() {
        this.sendParam(ParamElementMenu.Release(this.controlPeerServerId));
    }

    public void showPopup(DisplayWindow pWnd, int x, int y) {
        this.setParentWindow(pWnd);
        if (this.type == 2) {
            ServerMenuManager smm = ServerMenuManager.getDefault();
            smm.getParamCSWindow().addElement(ParamElementMenu.Popup(this.controlPeerServerId, pWnd.getTheObjectId(), x, y));
            smm.sendParams(smm.getParamCSWindow());
        }
    }

    private static FileImage getFileImage(ICobolVar bitmapHandle) {
        FileImage fim = null;
        Object oid = null;
        if (bitmapHandle instanceof IObjectVar) {
            oid = bitmapHandle.getOId();
        } else if (bitmapHandle instanceof INumericVar) {
            oid = UserHandles.getId(bitmapHandle.toint());
        }
        if (oid instanceof FileImage) {
            fim = (FileImage)oid;
        }
        return fim;
    }

    public void setBitmap(int id, ICobolVar bitmapHandle, int bitmapNumber, int bitmapWidth) {
        FileImage fim;
        ParamElementMenu elem = bitmapHandle != null ? ((fim = CobolGUIMenu.getFileImage(bitmapHandle)) != null ? ParamElementMenu.AddBitmap(this.controlPeerServerId, id, fim.getImageId(), bitmapNumber, bitmapWidth) : ParamElementMenu.DeleteBitmap(this.controlPeerServerId, id)) : ParamElementMenu.DeleteBitmap(this.controlPeerServerId, id);
        this.sendParam(elem);
    }

    @Override
    public int type() {
        return 5;
    }

    public CobolGUIMenu[] getChildren() {
        CobolGUIMenu[] Return2 = new CobolGUIMenu[this.children.size()];
        this.children.toArray(Return2);
        return Return2;
    }

    public void destroyMenuRecur() {
        this.intdestroyMenuRecur();
        ServerMenuManager smmok = (ServerMenuManager)IscobolSystem.getIfExists(ServerMenuManager.class, Thread.currentThread());
        if (smmok != null) {
            ServerMenuManager.getDefault().sendParams(ServerMenuManager.getDefault().getParamCSWindow());
        }
    }

    private void intdestroyMenuRecur() {
        CobolGUIMenu[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].intdestroyMenuRecur();
        }
        this.intdestroy(false);
        UserHandles uh = (UserHandles)IscobolSystem.getIfExists(UserHandles.class, Thread.currentThread());
        if (uh != null) {
            UserHandles.free(this);
        }
    }

    public void ensureVisible(int idv) {
        ParamElementMenu elem = ParamElementMenu.EnsureVisible(this.controlPeerServerId, idv);
        this.sendParam(elem);
    }

    @Override
    public int fireevent(RemoteRecordAccept rra) {
        return 0;
    }
}

