/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.ImageIcon;

public class TextOnIcon
extends ImageIcon {
    static final int POSITION_NORMAL = 0;
    static final int OFFSET_Y = 10;
    static final int OFFSET_X = 2;
    private String text;
    private Color foreground;
    private int textposition;
    private Font font;
    private int mnemonicIndex = -1;

    public TextOnIcon(Image bi) {
        super(bi);
    }

    public TextOnIcon(Image bi, String text, int textposition, Color foreground, Font font) {
        this(bi);
        this.setText(text);
        this.setTextPosition(textposition);
        this.foreground = foreground;
        this.font = font;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setTextPosition(int textposition) {
        this.textposition = textposition;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        int xtot = x;
        int ytot = y;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics();
        int textlen = fm.stringWidth(this.text) + 2;
        int fontheight = fm.getMaxDescent() + fm.getAscent();
        g.drawImage(this.getImage(), x, y, c);
        g.setColor(this.foreground);
        switch (this.textposition) {
            case 6: {
                xtot += 2;
                ytot += 10;
                break;
            }
            case 8: {
                xtot += width - textlen - 2;
                ytot += 10;
                break;
            }
            case 11: {
                xtot += 2;
                ytot += height - 10 + fontheight / 2;
                break;
            }
            case 13: {
                xtot += width - textlen - 2;
                ytot += height - 10 + fontheight / 2;
                break;
            }
            case 7: {
                xtot += width / 2 - textlen / 2;
                ytot += 10;
                break;
            }
            case 12: {
                xtot += width / 2 - textlen / 2;
                ytot += height - 10 + fontheight / 2;
                break;
            }
            case 9: {
                xtot += 2;
                ytot += height / 2 + fm.getMaxDescent();
                break;
            }
            case 10: {
                xtot += width - 2 - textlen;
                ytot += height / 2 + fm.getMaxDescent();
            }
        }
        if (xtot < 0) {
            xtot = 2;
        }
        if (ytot < 0) {
            ytot = 2;
        }
        if (this.mnemonicIndex >= 0 && this.mnemonicIndex < this.text.length()) {
            String s;
            Map<TextAttribute, ?> attrs = this.font.getAttributes();
            attrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            Font underlineFont = this.font.deriveFont(attrs);
            if (this.mnemonicIndex > 0) {
                s = this.text.substring(0, this.mnemonicIndex);
                g.setFont(this.font);
                g.drawString(s, xtot, ytot);
                xtot += fm.stringWidth(s);
            }
            s = "" + this.text.charAt(this.mnemonicIndex);
            g.setFont(underlineFont);
            g.drawString(s, xtot, ytot);
            xtot += fm.stringWidth(s);
            if (this.mnemonicIndex < this.text.length() - 1) {
                s = this.text.substring(this.mnemonicIndex + 1);
                g.setFont(this.font);
                g.drawString(s, xtot, ytot);
            }
        } else {
            g.drawString(this.text, xtot, ytot);
        }
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public void setMnemonicIndex(int mnemonicIndex) {
        this.mnemonicIndex = mnemonicIndex;
    }
}

