/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.TabNative;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TabClosableComponent
extends JPanel {
    private final JTabbedPane pane;
    private final JLabel label;
    private final Etichetta button;
    private boolean textnorotate = true;

    public TabClosableComponent(final JTabbedPane pane, boolean textnorotate, Image mouseentered, Image mouseexited) {
        if (pane.getTabPlacement() == 2 || pane.getTabPlacement() == 4) {
            this.textnorotate = textnorotate;
        }
        if (this.textnorotate) {
            this.setLayout(new FlowLayout(0, 0, 0));
        } else {
            this.setLayout(new BoxLayout(this, 3));
        }
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = pane;
        this.setOpaque(false);
        this.label = new JLabel(){

            @Override
            public String getText() {
                int i = pane.indexOfTabComponent(TabClosableComponent.this);
                if (i != -1) {
                    return pane.getTitleAt(i);
                }
                return null;
            }

            @Override
            public Icon getIcon() {
                int i = pane.indexOfTabComponent(TabClosableComponent.this);
                if (i != -1) {
                    return pane.getIconAt(i);
                }
                return null;
            }

            @Override
            public Icon getDisabledIcon() {
                int i = pane.indexOfTabComponent(TabClosableComponent.this);
                if (i != -1) {
                    return pane.getDisabledIconAt(i);
                }
                return null;
            }

            @Override
            public Font getFont() {
                return pane.getFont();
            }

            @Override
            public Color getForeground() {
                int i = pane.indexOfTabComponent(TabClosableComponent.this);
                if (i != -1) {
                    return pane.getForegroundAt(i);
                }
                return super.getForeground();
            }
        };
        this.add(this.label);
        this.button = new Etichetta(this.textnorotate, mouseentered, mouseexited);
        this.add(this.button);
        this.button.setVisible(false);
        if (this.textnorotate) {
            this.label.setAlignmentY(0.5f);
            this.button.setAlignmentY(0.5f);
        } else {
            this.label.setAlignmentX(0.5f);
            this.button.setAlignmentX(0.5f);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                MouseListener[] listeners;
                TabClosableComponent.this.button.setVisible(true);
                for (MouseListener lst : listeners = pane.getMouseListeners()) {
                    lst.mouseEntered(new MouseEvent((Component)me.getSource(), me.getID(), me.getWhen(), me.getModifiers(), TabClosableComponent.this.getX(), TabClosableComponent.this.getY(), me.getClickCount(), me.isPopupTrigger()));
                }
            }

            @Override
            public void mouseExited(MouseEvent me) {
                MouseListener[] listeners;
                TabClosableComponent.this.button.setVisible(false);
                for (MouseListener lst : listeners = pane.getMouseListeners()) {
                    lst.mouseExited(new MouseEvent((Component)me.getSource(), me.getID(), me.getWhen(), me.getModifiers(), TabClosableComponent.this.getX(), TabClosableComponent.this.getY(), me.getClickCount(), me.isPopupTrigger()));
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                MouseListener[] listeners;
                for (MouseListener lst : listeners = pane.getMouseListeners()) {
                    lst.mouseReleased(new MouseEvent((Component)me.getSource(), me.getID(), me.getWhen(), me.getModifiers(), TabClosableComponent.this.getX(), TabClosableComponent.this.getY(), me.getClickCount(), me.isPopupTrigger()));
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                MouseListener[] listeners;
                for (MouseListener lst : listeners = pane.getMouseListeners()) {
                    lst.mousePressed(new MouseEvent((Component)me.getSource(), me.getID(), me.getWhen(), me.getModifiers(), TabClosableComponent.this.getX(), TabClosableComponent.this.getY(), me.getClickCount(), me.isPopupTrigger()));
                }
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                MouseListener[] listeners;
                for (MouseListener listener : listeners = pane.getMouseListeners()) {
                    listener.mouseClicked(new MouseEvent((Component)me.getSource(), me.getID(), me.getWhen(), me.getModifiers(), TabClosableComponent.this.getX(), TabClosableComponent.this.getY(), me.getClickCount(), me.isPopupTrigger()));
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ld = this.label.getPreferredSize();
        Dimension bd = this.button.getPreferredSize();
        if (this.textnorotate) {
            return new Dimension(ld.width + bd.width, ld.height);
        }
        return new Dimension(ld.width + bd.width, ld.height + bd.height);
    }

    public void setIcons(Icon ic, Icon dic) {
    }

    @Override
    public void setToolTipText(String t) {
        super.setToolTipText(t);
        if (this.button != null) {
            this.button.setToolTipText(t);
        }
    }

    class Etichetta
    extends JLabel
    implements MouseListener {
        ImageIcon x1;
        ImageIcon x2;
        Image transparentImg;
        Image mouseentered;
        Image mouseexited;
        boolean textnorotate;

        Etichetta(boolean textnorotate, Image mouseentered, Image mouseexited) {
            this.textnorotate = textnorotate;
            this.mouseentered = mouseentered;
            this.mouseexited = mouseexited;
            this.x1 = mouseentered != null ? new ImageIcon(mouseentered) : new ImageIcon(this.getClass().getResource("tabcloseup.png"), "x");
            this.x2 = mouseexited != null ? new ImageIcon(mouseexited) : new ImageIcon(this.getClass().getResource("tabclosedown.png"), "x");
            int iconw = this.x2.getIconWidth();
            int iconh = this.x2.getIconHeight();
            if (this.x1.getIconWidth() > iconw) {
                iconw = this.x1.getIconWidth();
            }
            if (this.x1.getIconHeight() > iconh) {
                iconh = this.x1.getIconHeight();
            }
            if (this.textnorotate) {
                iconw += 3;
            } else {
                iconh += 3;
            }
            Dimension size = new Dimension(iconw, iconh);
            RGBImageFilter filter = new RGBImageFilter(){
                int transparentColor = Color.white.getRGB() | 0xFF000000;

                @Override
                public final int filterRGB(int x, int y, int rgb) {
                    if ((rgb | 0xFF000000) == this.transparentColor) {
                        return 0xFFFFFF & rgb;
                    }
                    return rgb;
                }
            };
            FilteredImageSource filteredImgProd = new FilteredImageSource(this.x2.getImage().getSource(), filter);
            this.transparentImg = Toolkit.getDefaultToolkit().createImage(filteredImgProd);
            this.setIcon(new ImageIcon(this.transparentImg));
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.setSize(size);
            this.setLayout(null);
            this.addMouseListener(this);
            if (this.textnorotate) {
                this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int i = TabClosableComponent.this.pane.indexOfTabComponent(TabClosableComponent.this);
            if (i != -1 && TabClosableComponent.this.pane instanceof TabNative) {
                ((TabNative)TabClosableComponent.this.pane).fireTabClosableEvent(i);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setVisible(true);
            this.setIcon(this.x1);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setIcon(new ImageIcon(this.transparentImg));
            this.setVisible(false);
        }

        public ImageIcon createImageIcon(String path) {
            URL imgURL = this.getClass().getResource(path);
            if (imgURL != null) {
                return new ImageIcon(imgURL);
            }
            return null;
        }
    }
}

