/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.RemoteProgressDialog;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.ClientRemoteObject;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.gui.client.swing.BorderedFrame;
import com.iscobol.rts.Factory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class RemoteProgressDialogImpl
extends ClientRemoteObject
implements RemoteProgressDialog {
    private Window progressDialog;
    private ProgressDialogPanel panel;
    private boolean autoTime;
    private boolean noTime;
    private String cancelMessage;
    private long time;

    public RemoteProgressDialogImpl() throws IOException {
    }

    public RemoteProgressDialogImpl(String title, String cancelMessage, int flags, LocalImage image, BorderedFrame activeWindow, AbstractGuiFactoryImpl gf) throws IOException {
        Window owner;
        if (title == null) {
            title = "W$PROGRESSDIALOG";
        }
        if (cancelMessage == null) {
            cancelMessage = "";
        }
        this.cancelMessage = cancelMessage;
        this.autoTime = (flags & 2) == 2;
        this.noTime = (flags & 4) == 4;
        boolean modal = (flags & 1) == 1;
        boolean indeterminate = (flags & 0x10) == 16;
        JFrame frame = null;
        JDialog dialog = null;
        if (modal) {
            if (activeWindow != null) {
                if (activeWindow.isJFrame()) {
                    dialog = new JDialog(activeWindow.getJFrame(), title, true);
                    this.progressDialog = dialog;
                    owner = activeWindow.getJFrame();
                } else {
                    dialog = new JDialog(activeWindow.getJDialog(), title, true);
                    this.progressDialog = dialog;
                    owner = activeWindow.getJDialog();
                }
            } else {
                dialog = new JDialog((Frame)null, title, true);
                this.progressDialog = dialog;
                owner = null;
            }
        } else {
            frame = new JFrame(title);
            this.progressDialog = frame;
            owner = null;
        }
        if (gf != null && gf.getIcon() != null) {
            if (frame != null) {
                frame.setIconImage(gf.getIcon());
            } else {
                dialog.setIconImage(gf.getIcon());
            }
        }
        this.panel = new ProgressDialogPanel(image != null ? image.getImage() : null, indeterminate, this.cancelMessage);
        this.progressDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RemoteProgressDialogImpl.this.panel.setCanceled();
            }
        });
        if (frame != null) {
            frame.setDefaultCloseOperation(0);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)this.panel, "Center");
            frame.setResizable(false);
        } else {
            dialog.setDefaultCloseOperation(0);
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add((Component)this.panel, "Center");
            dialog.setResizable(false);
        }
        this.progressDialog.pack();
        this.progressDialog.setLocationRelativeTo(owner);
        Runnable run = () -> this.progressDialog.setVisible(true);
        KeyboardBuffer.setBufferOff();
        if (modal) {
            new Thread(run).start();
        } else {
            run.run();
        }
        this.time = System.currentTimeMillis();
    }

    protected boolean isDestroyed() {
        return this.progressDialog == null;
    }

    @Override
    public void destroy() throws IOException {
        if (!this.isDestroyed()) {
            this.progressDialog.dispose();
            this.progressDialog = null;
            this.panel = null;
            this.time = 0L;
            KeyboardBuffer.setBufferOn();
        }
    }

    @Override
    public void setProgress(int completed, int total) throws IOException {
        if (!this.isDestroyed()) {
            total = Math.max(1, total);
            completed = Math.min(completed, total);
            int value = Math.round((float)completed / (float)total * 100.0f);
            this.panel.progress.setValue(value);
            if (this.autoTime && !this.noTime && value > 0) {
                long m;
                long timeElapsed = System.currentTimeMillis() - this.time;
                long timeRemaining = Math.round((double)timeElapsed * (double)(100 - value) / (double)value);
                StringBuilder sb = new StringBuilder();
                sb.append("About ");
                long h = timeRemaining / 3600000L;
                if (h > 0L) {
                    sb.append(h).append(" hour");
                    if (h > 1L) {
                        sb.append("s");
                    }
                    sb.append(" ");
                    timeRemaining %= 3600000L;
                }
                if ((m = timeRemaining / 60000L) > 0L) {
                    sb.append(m).append(" minute");
                    if (m > 1L) {
                        sb.append("s");
                    }
                    sb.append(" ");
                    timeRemaining %= 60000L;
                }
                long s = timeRemaining / 1000L;
                sb.append(s).append(" second");
                if (s != 1L) {
                    sb.append("s");
                }
                sb.append(" remaining");
                this.panel.line3.setText(sb.toString());
            }
        }
    }

    @Override
    public boolean queryCancel() throws IOException {
        if (!this.isDestroyed()) {
            return this.panel.canceled;
        }
        return false;
    }

    @Override
    public void setLine(String text, int lineIndex, boolean compactPath) throws IOException {
        if (!this.isDestroyed() && text != null) {
            switch (lineIndex) {
                case 1: {
                    this.panel.line1.setText(text);
                    break;
                }
                case 2: {
                    this.panel.line2.setText(text);
                    break;
                }
                case 3: {
                    if (this.autoTime || this.panel.canceled && this.cancelMessage.length() != 0) break;
                    this.panel.line3.setText(text);
                }
            }
        }
    }

    @Override
    public void resetTimer() throws IOException {
        if (!this.isDestroyed()) {
            this.time = System.currentTimeMillis();
        }
    }

    public static void main(String[] args) throws Exception {
        int i;
        Class<?> cls = Class.forName("com.iscobol.updater.NotificationWindow");
        RemoteProgressDialogImpl rpd = new RemoteProgressDialogImpl("Test", "Canceled.", 2, new LocalImage(Toolkit.getDefaultToolkit().createImage(cls.getResource("deficon64x64.png")), 0, 1), null, null);
        rpd.setLine("Download...", 1, false);
        rpd.setLine("File 'test.cbl'", 2, false);
        for (i = 100; i <= 300; i += 100) {
            Thread.sleep(1000L);
            if (rpd.queryCancel()) break;
            rpd.setProgress(i, 1000);
            rpd.setLine("Completed " + Math.round((float)i / 1000.0f * 100.0f) + "%", 3, false);
        }
        while (i <= 1000) {
            Thread.sleep(4000L);
            if (rpd.queryCancel()) break;
            rpd.setProgress(i, 1000);
            rpd.setLine("Completed " + Math.round((float)i / 1000.0f * 100.0f) + "%", 3, false);
            i += 100;
        }
        Thread.sleep(1000L);
        rpd.setLine("Finish.", 3, false);
        Thread.sleep(2000L);
        rpd.destroy();
    }

    private static class ProgressDialogPanel
    extends JPanel {
        JLabel line1;
        JLabel line2;
        JLabel line3;
        JLabel customIcon;
        JProgressBar progress;
        JButton cancel;
        boolean canceled;
        String cancelMessage;

        public ProgressDialogPanel(Image image, boolean indeterminate, String cancelMessage) {
            this.cancelMessage = cancelMessage;
            this.setLayout(new BorderLayout());
            JPanel topPanel = new JPanel(new BorderLayout(5, 10));
            this.line1 = new JLabel();
            this.line1.setFont(new Font("Dialog", 1, 20));
            this.line1.setPreferredSize(new Dimension(0, 40));
            topPanel.add((Component)this.line1, "Center");
            this.customIcon = new JLabel();
            if (image != null) {
                this.customIcon.setIcon(new ImageIcon(image));
            }
            topPanel.add((Component)this.customIcon, "East");
            topPanel.setPreferredSize(new Dimension(550, 100));
            topPanel.setBackground(Color.white);
            topPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
            this.add((Component)topPanel, "North");
            JPanel centerPanel = new JPanel(new BorderLayout(5, 10));
            JPanel infoPanel = new JPanel(new GridLayout(2, 0, 5, 10));
            infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            this.line2 = new JLabel();
            this.line2.setFont(new Font("Dialog", 0, 12));
            this.line2.setText("");
            this.line2.setPreferredSize(new Dimension(0, 20));
            infoPanel.add(this.line2);
            this.line3 = new JLabel();
            this.line3.setFont(new Font("Dialog", 0, 12));
            this.line3.setText("");
            this.line3.setPreferredSize(new Dimension(0, 20));
            infoPanel.add(this.line3);
            centerPanel.add((Component)infoPanel, "North");
            this.progress = new JProgressBar(0);
            this.progress.setPreferredSize(new Dimension(0, 25));
            if (indeterminate) {
                this.progress.setIndeterminate(true);
            } else {
                this.progress.setMinimum(0);
                this.progress.setMaximum(100);
                this.progress.setValue(0);
            }
            centerPanel.add((Component)this.progress, "Center");
            centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.add((Component)centerPanel, "Center");
            JPanel bottomPanel = new JPanel(new BorderLayout());
            this.cancel = new JButton(Factory.getSysMsg("msg_cancel"));
            bottomPanel.add((Component)this.cancel, "East");
            bottomPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            this.add((Component)bottomPanel, "South");
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setCanceled();
                }
            });
        }

        void setCanceled() {
            this.canceled = true;
            this.cancel.setEnabled(false);
            this.progress.setIndeterminate(true);
            if (this.cancelMessage != null && this.cancelMessage.length() > 0) {
                this.line3.setText(this.cancelMessage);
            }
        }
    }
}

