/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.PlaySound;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

class RemotePlaySound
implements PlaySound,
LineListener {
    private InputStream iStream;
    private int flags;
    private Clip clip;
    private static RemotePlaySound currentPlaying;

    public RemotePlaySound(byte[] sound, int flgs) {
        if (sound.length == 0 && currentPlaying != null) {
            currentPlaying.stop();
            currentPlaying = null;
        } else {
            this.iStream = new ByteArrayInputStream(sound);
            this.flags = flgs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        if (this.clip == null) {
            this.clip = RemotePlaySound.getClip(this.iStream);
        }
        if (this.clip == null) {
            return false;
        }
        this.clip.addLineListener(this);
        if ((this.flags & 4) != 0 && currentPlaying != null) {
            currentPlaying.stop();
        }
        RemotePlaySound remotePlaySound = this;
        synchronized (remotePlaySound) {
            if ((this.flags & 2) != 0) {
                this.clip.loop(-1);
                if ((this.flags & 1) != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                this.clip.start();
                if ((this.flags & 1) != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return true;
    }

    private static synchronized Clip getClip(InputStream iStream) {
        Clip Return2 = null;
        if (iStream == null) {
            return Return2;
        }
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(iStream);
            AudioFormat format = stream.getFormat();
            if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat tmp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                stream = AudioSystem.getAudioInputStream(tmp, stream);
                format = tmp;
            }
            DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
            Return2 = (Clip)AudioSystem.getLine(info);
            Return2.open(stream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
        }
        catch (LineUnavailableException lineUnavailableException) {
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Return2;
    }

    @Override
    public void stop() {
        if (this.clip != null) {
            this.clip.stop();
            this.clip.setFramePosition(0);
        }
    }

    @Override
    public void close() {
        if (this.clip != null) {
            this.clip.close();
            this.clip = null;
        }
    }

    public void finalize() {
        this.close();
    }

    @Override
    public synchronized void update(LineEvent e) {
        if (e.getType() == LineEvent.Type.STOP) {
            this.notify();
            currentPlaying = null;
        } else if (e.getType() == LineEvent.Type.START) {
            currentPlaying = this;
        }
    }
}

