/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CompositeLabel;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class RemoteLabel
extends RemoteBaseGUIControl {
    private boolean vertical;
    private boolean noKeyLetter;
    private boolean transparent;
    private boolean border;
    private String title = "";
    private boolean isLabelOffsetSet;
    private int labelOffset;
    private boolean centered;
    private boolean left;
    private boolean right;
    private boolean top;
    private boolean bottom;
    private boolean useDefaultBorderWithBoxedStyle;
    private final boolean alwaysShowPicobolLabel;

    public RemoteLabel(GuiFactoryImpl gf) {
        super(gf);
        this.useDefaultBorderWithBoxedStyle = gf.getCsProperty().get("iscobol.gui.native_style", false);
        this.alwaysShowPicobolLabel = gf.getCsProperty().get("iscobol.m25646", false);
    }

    @Override
    public float getDefaultWidth() {
        if (this.title.length() == 0) {
            return 0.0f;
        }
        return this.font.computeScreenWidth(this.title) / this.font.getWidth() + 1;
    }

    @Override
    public float getDefaultHeight() {
        if (this.vertical) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public void setCols(float c) {
    }

    @Override
    public void setRows(float r) {
    }

    @Override
    public void setRowsCols(float r, float c) {
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        this.labelInit();
    }

    void labelInit() {
        CompositeLabel lbl = new CompositeLabel(this.alwaysShowPicobolLabel);
        this.setComponent(lbl);
        super.intInitialize();
        lbl.setVertical(this.vertical);
        if (this.top) {
            lbl.setTop(true);
        } else if (this.bottom) {
            lbl.setBottom(true);
        }
        if (this.centered) {
            lbl.setCentered(true);
        } else if (this.left) {
            lbl.setLeft(true);
        } else if (this.right) {
            lbl.setRight(true);
        }
        this.setTitle(this.title);
        this.setBorder(this.border);
        lbl.setNoKeyLetter(this.noKeyLetter);
        lbl.setTransparent(this.transparent);
    }

    @Override
    public int getGUIControlHeight(float height) {
        int Return2 = 0;
        if (this.font != null) {
            Return2 = (int)((float)this.font.getHeight() * height);
        }
        return Return2;
    }

    @Override
    public int getGUIControlWidth(float width) {
        int Return2 = 0;
        if (this.font != null) {
            Return2 = (int)((float)this.font.getWidth() * width);
        }
        return Return2;
    }

    @Override
    public float getSizes() {
        float Return2 = super.getSizes();
        if (Return2 == 0.0f) {
            Dimension dim = this.guiComponent.getPreferredSize();
            Return2 = dim.width / this.font.getWidth();
        }
        return Return2;
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public void setBorder(boolean t) {
        this.border = t;
        if (this.guiComponent != null && !this.useDefaultBorderWithBoxedStyle) {
            ((CompositeLabel)this.getComponent()).setBorder(t);
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String t) {
        this.title = t;
        if (this.guiComponent != null) {
            ((CompositeLabel)this.guiComponent).setTitle(t);
        }
    }

    @Override
    public void setStyle(int s, boolean set) {
        CompositeLabel lbl = (CompositeLabel)this.guiComponent;
        if ((s & 0x1000) == 4096) {
            this.vertical = set;
            if (lbl != null) {
                lbl.setVertical(set);
            }
        }
        if ((s & 4) == 4) {
            this.centered = set;
            if (lbl != null) {
                lbl.setCentered(set);
            }
        }
        if ((s & 1) == 1) {
            this.left = set;
            if (lbl != null) {
                lbl.setLeft(set);
            }
        }
        if ((s & 2) == 2) {
            this.right = set;
            if (lbl != null) {
                lbl.setRight(set);
            }
        }
        if ((s & 0x100) == 256) {
            this.top = set;
            if (lbl != null) {
                lbl.setTop(set);
            }
        }
        if ((s & 0x200) == 512) {
            this.bottom = set;
            if (lbl != null) {
                lbl.setBottom(set);
            }
        }
        if ((s & 8) == 8) {
            this.noKeyLetter = set;
            if (lbl != null) {
                lbl.setNoKeyLetter(set);
            }
        }
        if ((s & 0x10) == 16) {
            this.transparent = set;
            if (lbl != null) {
                lbl.setTransparent(set);
            }
        }
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public boolean isInputField() {
        return false;
    }

    @Override
    public void displayProp() {
    }

    @Override
    protected void intFocusGained(boolean restore) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        String Return2 = "0";
        int intValue = -1;
        boolean error = false;
        try {
            intValue = (int)Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        if (key == 133) {
            if (!error) {
                if (this.guiComponent != null) {
                    this.y -= this.calcLabelOffsetPx(this.getLabelOffset());
                    this.labelOffset = intValue;
                    this.isLabelOffsetSet = true;
                    this.setLocation(this.x, this.y);
                } else {
                    this.labelOffset = intValue;
                    this.isLabelOffsetSet = true;
                }
                Return2 = "1";
            }
        } else {
            return super.setProp(key, value, length);
        }
        return "";
    }

    int getLabelOffset() {
        if (this.isLabelOffsetSet) {
            return this.labelOffset;
        }
        if (this.parentWindow != null) {
            return this.parentWindow.getLabelOffset();
        }
        return 0;
    }

    @Override
    public String setValue(String v) {
        this.setTitle(v);
        return null;
    }

    @Override
    public void setLocation(int x, int y, boolean setOnComp) {
        super.setLocation(x, y + this.calcLabelOffsetPx(this.getLabelOffset()), setOnComp);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle Return2 = this.getRealBounds();
        Return2.y -= this.calcLabelOffsetPx(this.getLabelOffset());
        return Return2;
    }

    @Override
    public Rectangle getRealBounds() {
        Rectangle Return2 = this.guiComponent != null ? this.guiComponent.getBounds() : new Rectangle(this.x, this.y, this.width, this.height);
        return Return2;
    }

    private int calcLabelOffsetPx(int offs) {
        return ((RemoteDisplayWindow)this.parentWindow).getCellHeight() * offs / 100;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        super.handleResponse(eventAction, rra);
    }

    @Override
    protected float paramgetDefaultHeight(ParamElementSize ps, int origHeight) {
        if (this.vertical) {
            return this.paramgetDefaultDimension(ps, origHeight, false);
        }
        return super.paramgetDefaultHeight(ps, origHeight);
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        if (this.vertical) {
            if (this.font != null) {
                return this.font.getHeight() / this.getParentBGW().getCellWidth();
            }
            return 1.7f;
        }
        return this.paramgetDefaultDimension(ps, origWidth, true);
    }

    private float paramgetDefaultDimension(ParamElementSize ps, int origDimValue, boolean getWidth) {
        if (getWidth && (ps.sizes > 0.0f || !ps.sizesInCells)) {
            return ps.sizes;
        }
        if (!getWidth && ps.lines > 0.0f) {
            return ps.lines;
        }
        if (ps.title != null) {
            String loctitle = ps.title;
            if (this.font == null) {
                if (getWidth) {
                    return loctitle.length();
                }
                return loctitle.length() * this.getParentBGW().getCellWidth() / this.getParentBGW().getCellHeight() + 1;
            }
            float r = 0.0f;
            r = getWidth ? this.font.computeScreenSizes(loctitle) : (float)(this.font.computeScreenWidth(loctitle) / this.font.getHeight() + 1);
            return r;
        }
        if (ps.ccOlen != -1) {
            int len = Math.max(ps.ccOlen, ps.ccPIClen != -1 ? ps.ccPIClen : 0);
            if (getWidth) {
                return len;
            }
            return len * this.getParentBGW().getCellWidth() / this.getParentBGW().getCellHeight() + 1;
        }
        return super.paramgetDefaultWidth(ps, origDimValue);
    }

    @Override
    public String getType() {
        return "label";
    }

    @Override
    public void adjustBounds(Rectangle Return2) {
        Return2.y -= this.calcLabelOffsetPx(this.getLabelOffset());
    }

    @Override
    public Dimension loadDimension0(Dimension Return2) {
        if (this.title == null || this.title.length() == 0) {
            return null;
        }
        return super.loadDimension0(Return2);
    }

    @Override
    public void setCurrentColumn(float f) {
        this.setcurrentcolumn = f;
    }

    @Override
    public float getCurrentColumn() {
        if (this.setcurrentcolumn > 0.0f) {
            return this.setcurrentcolumn;
        }
        return super.getCurrentColumn();
    }

    @Override
    public JComponent getDragDropComponent() {
        if (this.guiComponent != null) {
            return (CompositeLabel)this.guiComponent;
        }
        return null;
    }

    @Override
    public void setDragMode(int dm) {
        super.setDragMode(dm);
        if (dm > 0 && this.guiComponent != null) {
            ((CompositeLabel)this.guiComponent).setTransferHandler(new TransferHandler("text"));
            DragMouseAdapter listener = new DragMouseAdapter();
            ((CompositeLabel)this.guiComponent).addMouseListener(listener);
        }
    }

    private class DragMouseAdapter
    extends MouseAdapter {
        private DragMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JComponent c = (JComponent)e.getSource();
            CompositeLabel pl = (CompositeLabel)RemoteLabel.this.guiComponent;
            TransferHandler handler = pl.getTransferHandler();
            handler.exportAsDrag(pl, e, 1);
        }
    }
}

