/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.MainPanel;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class RemoteFrame
extends RemoteBaseGUIControl {
    public static final int STYLE_VERTICAL = 9;
    public static final int STYLE_HORIZONTAL = 10;
    public static final int STYLE_BOX = 11;
    public static final int STYLE_KEISEN = 12;
    public static final int STYLE_3D_NORMAL = 0;
    public static final int STYLE_3D_RAISED = 4;
    public static final int STYLE_3D_LOWERED = 5;
    public static final int STYLE_3D_ENGRAVED = 6;
    public static final int STYLE_3D_RIMMED = 7;
    public static final int TITLE_TOP_LEFT = 1;
    public static final int TITLE_TOP_CENTER = 2;
    public static final int TITLE_TOP_RIGHT = 3;
    public static final int TITLE_BOTTOM_LEFT = 4;
    public static final int TITLE_BOTTOM_CENTER = 5;
    public static final int TITLE_BOTTOM_RIGHT = 6;
    public static final int TITLE_FULL_CENTER = 7;
    private static final HashMap defaultHighColors = new HashMap();
    private static final HashMap defaultLowColors = new HashMap();
    private int style;
    private boolean titleTransparent;
    private int keisenAttr;
    private int keisenCmd;
    private int styleWidth;
    private int style3D;
    private boolean fullHeight;
    private boolean alternate;
    private String title;
    private int titlePosition;
    private String title2;
    private int titlePosition2 = -1;
    private Color defaultHighColor = Color.white;
    private Color highColor;
    private ColorCmp highColorCmp;
    private int highColorIdx = -1;
    private Color defaultLowColor = Color.gray;
    private Color lowColor;
    private ColorCmp lowColorCmp;
    private int lowColorIdx = -1;
    private Color fillColor = null;
    private ColorCmp fillColorCmp;
    private int fillColorIdx = -1;
    private Color fillColor2 = null;
    private ColorCmp fillColor2Cmp;
    private int fillColor2Idx = -1;
    private int fillPercent = 100;
    private GradientManager gradientMgr = new GradientManager();

    public RemoteFrame(GuiFactoryImpl gf) {
        super(gf);
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        this.setComponent(new BorderedFrameGUI());
        super.intInitialize();
        ((BorderedFrameGUI)this.getComponent()).repaint();
    }

    @Override
    public int getGUIControlHeight(float height) {
        int Return2 = 0;
        Return2 = this.style == 11 || this.style == 9 || this.style == 10 || this.style == 12 ? (int)((float)this.parentWindow.getCellHeight() * height) : (int)((float)this.font.getHeight() * height);
        return Return2;
    }

    @Override
    public int getGUIControlWidth(float width) {
        int Return2 = 0;
        Return2 = this.style == 11 || this.style == 9 || this.style == 10 || this.style == 12 ? (int)((float)this.parentWindow.getCellWidth() * width) : (int)((float)this.font.getWidth() * width);
        return Return2;
    }

    @Override
    public float getDefaultWidth() {
        float Return2 = 12.0f;
        if (this.style == 9) {
            Return2 = 1.0f;
        }
        return Return2;
    }

    @Override
    public float getDefaultHeight() {
        float Return2 = 5.0f;
        if (this.style == 10) {
            Return2 = 1.0f;
        }
        return Return2;
    }

    @Override
    public String getValue() {
        return this.title;
    }

    @Override
    public void setTitle(String t) {
        this.title = t;
        if (this.guiComponent != null) {
            ((BorderedFrameGUI)this.getComponent()).repaint();
        }
    }

    private final void updateTitlePosition(int t) {
        if (t == 7) {
            this.fullHeight = true;
        }
        if (this.guiComponent != null) {
            ((BorderedFrameGUI)this.getComponent()).repaint();
        }
    }

    public void setTitlePosition(int t) {
        this.titlePosition = t;
        this.updateTitlePosition(t);
    }

    public void setTitle2(String t) {
        this.title2 = t;
        this.setTitle(this.title);
    }

    public void setTitlePosition2(int t) {
        this.titlePosition2 = t;
        this.updateTitlePosition(t);
    }

    @Override
    public void setStyle(int s, boolean set) {
        boolean repaint = false;
        if ((s & 0x800) == 2048) {
            this.style = 12;
            this.keisenAttr = s & 0xFF;
            this.keisenCmd = s & 0xF0000;
            s &= 0xFFF0FF00;
            repaint = true;
        }
        if ((s & 0x1000) == 4096) {
            this.titleTransparent = set;
            repaint = true;
        }
        if ((s & 0x10) == 16) {
            this.styleWidth = set ? 1 : 0;
            repaint = true;
        }
        if ((s & 0x20) == 32) {
            this.styleWidth = set ? 2 : 0;
            repaint = true;
        }
        if ((s & 0x40) == 64) {
            this.alternate = set;
            repaint = true;
        }
        if ((s & 1) == 1) {
            this.style3D = set ? 4 : 0;
            repaint = true;
        }
        if ((s & 2) == 2) {
            this.style3D = set ? 5 : 0;
            repaint = true;
        }
        if ((s & 4) == 4) {
            this.style3D = set ? 6 : 0;
            repaint = true;
        }
        if ((s & 8) == 8) {
            this.style3D = set ? 7 : 0;
            repaint = true;
        }
        if ((s & 0x80) == 128) {
            this.fullHeight = set;
            repaint = true;
        }
        if ((s & 0x100) == 256) {
            this.style = 9;
            repaint = true;
        }
        if ((s & 0x200) == 512) {
            this.style = 10;
            repaint = true;
        }
        if ((s & 0x400) == 1024) {
            this.style = 11;
            repaint = true;
        }
        if (repaint && this.guiComponent != null) {
            ((BorderedFrameGUI)this.getComponent()).repaint();
        }
    }

    private void setDefaultHighLowColor() {
        Color bkg = this.getColorBackground();
        Color c = (Color)defaultHighColors.get(bkg);
        this.defaultHighColor = c != null ? c : Color.white;
        c = (Color)defaultLowColors.get(bkg);
        this.defaultLowColor = c != null ? c : Color.gray;
    }

    @Override
    public void setColorBackgroundIdx(int idx) {
        super.setColorBackgroundIdx(idx);
        this.setDefaultHighLowColor();
    }

    @Override
    public void setColorBackground(int r, int g, int b) {
        super.setColorBackground(r, g, b);
        this.setDefaultHighLowColor();
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        boolean isrgb = false;
        try {
            int v = (int)Float.parseFloat(value);
            switch (key) {
                case 2086: {
                    Object id = this.gf.getClient().getId(v);
                    this.gradientMgr.setImage(id instanceof LocalImage ? ((LocalImage)id).getImage() : null);
                    break;
                }
                case 2087: {
                    this.gradientMgr.setImageScale(v);
                    break;
                }
                case 2076: {
                    this.gradientMgr.setColor1(v, false, this.gf);
                    break;
                }
                case 2077: {
                    this.gradientMgr.setColor1(v, true, this.gf);
                    break;
                }
                case 2078: {
                    this.gradientMgr.setColor2(v, false, this.gf);
                    break;
                }
                case 2079: {
                    this.gradientMgr.setColor2(v, true, this.gf);
                    break;
                }
                case 2075: {
                    this.gradientMgr.setOrientation(v);
                    break;
                }
                case 116: 
                case 117: {
                    boolean bl = isrgb = key == 117;
                    if (v < 0 || isrgb) {
                        this.highColorCmp = new ColorCmp(true);
                        this.highColorIdx = -1;
                        this.highColorCmp.setForeRGB(v);
                        this.highColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.highColorCmp.getForeground(), false));
                    } else {
                        this.highColorCmp = new ColorCmp(v);
                        this.highColorIdx = v;
                        this.highColor = this.gf.getRemotePalette().getDefaultColor(this.highColorCmp.getForeground());
                    }
                    if (this.guiComponent != null) {
                        this.guiComponent.repaint();
                    }
                    break;
                }
                case 138: 
                case 139: {
                    boolean bl = isrgb = key == 139;
                    if (v < 0 || isrgb) {
                        this.lowColorCmp = new ColorCmp(true);
                        this.lowColorIdx = -1;
                        this.lowColorCmp.setForeRGB(v);
                        this.lowColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.lowColorCmp.getForeground(), false));
                    } else {
                        this.lowColorCmp = new ColorCmp(v);
                        this.lowColorIdx = v;
                        this.lowColor = this.gf.getRemotePalette().getDefaultColor(this.lowColorCmp.getForeground());
                    }
                    if (this.guiComponent != null) {
                        this.guiComponent.repaint();
                    }
                    break;
                }
                case 92: 
                case 93: {
                    boolean bl = isrgb = key == 93;
                    if (v < 0 || isrgb) {
                        this.fillColorCmp = new ColorCmp(true);
                        this.fillColorIdx = -1;
                        this.fillColorCmp.setForeRGB(v);
                        this.fillColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.fillColorCmp.getForeground(), false));
                    } else if (v == 0) {
                        this.fillColorCmp = null;
                        this.fillColorIdx = -1;
                        this.fillColor = null;
                    } else {
                        this.fillColorCmp = new ColorCmp(v);
                        this.fillColorIdx = v;
                        this.fillColor = this.gf.getRemotePalette().getDefaultColor(this.fillColorCmp.getForeground());
                    }
                    if (this.guiComponent != null) {
                        this.guiComponent.repaint();
                    }
                    break;
                }
                case 90: 
                case 91: {
                    boolean bl = isrgb = key == 91;
                    if (v < 0 || isrgb) {
                        this.fillColor2Cmp = new ColorCmp(true);
                        this.fillColor2Idx = -1;
                        this.fillColor2Cmp.setForeRGB(v);
                        this.fillColor2 = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.fillColor2Cmp.getForeground(), false));
                    } else if (v == 0) {
                        this.fillColor2Cmp = null;
                        this.fillColor2Idx = -1;
                        this.fillColor2 = null;
                    } else {
                        this.fillColor2Cmp = new ColorCmp(v);
                        this.fillColor2Idx = v;
                        this.fillColor2 = this.gf.getRemotePalette().getDefaultColor(this.fillColor2Cmp.getForeground());
                    }
                    if (this.guiComponent != null) {
                        this.guiComponent.repaint();
                    }
                    break;
                }
                case 94: {
                    this.fillPercent = v;
                    if (this.guiComponent != null) {
                        this.guiComponent.repaint();
                    }
                    break;
                }
                case 240: {
                    this.setTitlePosition(v);
                    break;
                }
                case 284: {
                    this.setTitle2(value);
                    break;
                }
                case 285: {
                    this.setTitlePosition2(v);
                    break;
                }
                default: {
                    return super.setProp(key, value, length);
                }
            }
        }
        catch (NumberFormatException e) {
            switch (key) {
                case 284: {
                    this.setTitle2(value);
                    break;
                }
                default: {
                    return super.setProp(key, value, length);
                }
            }
        }
        return "";
    }

    @Override
    public String getProp(int key) {
        String Return2 = "";
        switch (key) {
            case 2075: {
                Return2 = "" + this.gradientMgr.getOrientation();
                break;
            }
            case 2076: {
                Return2 = this.gradientMgr.getColor1AsString();
                break;
            }
            case 2078: {
                Return2 = this.gradientMgr.getColor2AsString();
                break;
            }
            case 116: {
                if (this.highColorCmp == null) break;
                if (this.highColorIdx >= 0) {
                    Return2 = String.valueOf(this.highColorIdx);
                    break;
                }
                Return2 = String.valueOf(this.highColorCmp.getForeground());
                break;
            }
            case 138: {
                if (this.lowColorCmp == null) break;
                if (this.lowColorIdx >= 0) {
                    Return2 = String.valueOf(this.lowColorIdx);
                    break;
                }
                Return2 = String.valueOf(this.lowColorCmp.getForeground());
                break;
            }
            case 92: {
                if (this.fillColorCmp == null) break;
                if (this.fillColorIdx >= 0) {
                    Return2 = String.valueOf(this.fillColorIdx);
                    break;
                }
                Return2 = String.valueOf(this.fillColorCmp.getForeground());
                break;
            }
            case 90: {
                if (this.fillColor2Cmp == null) break;
                if (this.fillColor2Idx >= 0) {
                    Return2 = String.valueOf(this.fillColor2Idx);
                    break;
                }
                Return2 = String.valueOf(this.fillColor2Cmp.getForeground());
                break;
            }
            default: {
                Return2 = super.getProp(key);
            }
        }
        return Return2;
    }

    @Override
    public boolean isInputField() {
        return false;
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void displayProp() {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    protected void intFocusGained(boolean restore) {
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
    }

    @Override
    public void setRowsCols(float rows, float cols) {
    }

    public boolean hasFillColor() {
        return this.fillColor != null;
    }

    @Override
    public String setValue(String v) {
        this.setTitle(v);
        if (this.guiComponent != null) {
            return v;
        }
        return null;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
    }

    @Override
    public void setCols(float cols) {
    }

    @Override
    public void setRows(float cols) {
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        if (ps.sizes > 0.0f) {
            return ps.sizes;
        }
        return super.paramgetDefaultWidth(ps, origWidth);
    }

    @Override
    public String getType() {
        return "frame";
    }

    @Override
    public boolean isOnCharTerminal() {
        return this.style == 9 || this.style == 10 || this.style == 11 || this.style == 12;
    }

    @Override
    public boolean usedToRender() {
        return true;
    }

    @Override
    public boolean usedToEdit() {
        return false;
    }

    @Override
    public void startCellRendering() {
        try {
            this.fillPercent = Integer.parseInt(this.title.trim());
            if (this.guiComponent != null) {
                this.guiComponent.repaint();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void setLocation(int xx, int yy, boolean setOnComp) {
        int oldX = this.x;
        int oldY = this.y;
        super.setLocation(xx, yy, setOnComp);
        if (this.guiComponent != null && this.parentWindow instanceof RemoteDisplayWindow && this.guiComponent.getParent() instanceof MainPanel && (oldX != 0 || oldY != 0) && (oldX != xx || oldY != yy)) {
            ((RemoteDisplayWindow)this.parentWindow).reorderComponents(new String[]{"tab", "bitmap"});
        }
    }

    @Override
    public void setSize(int w, int h, boolean setOnComp) {
        int oldW = this.width;
        int oldH = this.height;
        super.setSize(w, h, setOnComp);
        if (this.guiComponent != null && this.guiComponent.getParent() instanceof MainPanel && this.parentWindow instanceof RemoteDisplayWindow && (oldW != 0 || oldH != 0) && (oldW != w || oldH != h)) {
            ((RemoteDisplayWindow)this.parentWindow).reorderComponents(new String[]{"tab", "bitmap"});
        }
    }

    static {
        defaultHighColors.put(new Color(0, 0, 0), new Color(128, 128, 128));
        defaultHighColors.put(new Color(0, 0, 128), new Color(0, 0, 255));
        defaultHighColors.put(new Color(0, 128, 0), new Color(0, 255, 0));
        defaultHighColors.put(new Color(0, 128, 128), new Color(0, 255, 255));
        defaultHighColors.put(new Color(128, 0, 0), new Color(255, 0, 0));
        defaultHighColors.put(new Color(128, 0, 128), new Color(255, 0, 255));
        defaultHighColors.put(new Color(128, 128, 0), new Color(255, 255, 0));
        defaultHighColors.put(new Color(192, 192, 192), new Color(255, 255, 255));
        defaultLowColors.put(new Color(128, 128, 128), new Color(0, 0, 0));
        defaultLowColors.put(new Color(0, 0, 255), new Color(0, 0, 128));
        defaultLowColors.put(new Color(0, 255, 0), new Color(0, 128, 0));
        defaultLowColors.put(new Color(0, 255, 255), new Color(0, 128, 128));
        defaultLowColors.put(new Color(255, 0, 0), new Color(128, 0, 0));
        defaultLowColors.put(new Color(255, 0, 255), new Color(128, 0, 128));
        defaultLowColors.put(new Color(255, 255, 0), new Color(128, 128, 0));
        defaultLowColors.put(new Color(255, 255, 255), new Color(192, 192, 192));
    }

    class BorderedFrameGUI
    extends JComponent
    implements PicobolWidget {
        private static final long serialVersionUID = 1L;
        private boolean firstTime;
        private boolean activated;
        private boolean selfAct;

        BorderedFrameGUI() {
            RemoteFrame.this.gradientMgr.addPropertyChangeListener(e -> this.repaint());
        }

        @Override
        public void paintComponent(Graphics g1) {
            int height;
            int startY;
            Color lc;
            if (RemoteFrame.this.parentWindow == null || RemoteFrame.this.font == null) {
                return;
            }
            Graphics2D g = (Graphics2D)g1;
            Color fg = RemoteFrame.this.getColorForeground();
            Color colorTitle = fg != null ? fg : Color.black;
            Dimension size = this.getSize();
            Color hc = RemoteFrame.this.highColor != null ? RemoteFrame.this.highColor : RemoteFrame.this.defaultHighColor;
            Color color = lc = RemoteFrame.this.lowColor != null ? RemoteFrame.this.lowColor : RemoteFrame.this.defaultLowColor;
            if (RemoteFrame.this.style == 9 || RemoteFrame.this.style == 10 || RemoteFrame.this.style == 11 || RemoteFrame.this.style == 12) {
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            int fontHeight = fm.getHeight();
            int startX = 0;
            int width = size.width - startX - 1;
            int titleShift = RemoteFrame.this.fullHeight ? 1 : 1 + fontHeight / 2;
            switch (RemoteFrame.this.titlePosition) {
                default: {
                    startY = titleShift - 1;
                    height = size.height - startY - 2;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    startY = 1;
                    height = size.height - startY - titleShift;
                }
            }
            Rectangle fill = null;
            Rectangle fill2 = null;
            if (RemoteFrame.this.fillPercent < 100) {
                if (RemoteFrame.this.fillPercent > 0) {
                    int brk;
                    if (height > width) {
                        brk = height * (100 - RemoteFrame.this.fillPercent) / 100;
                        fill = new Rectangle(startX, startY + brk, width, height - brk);
                        fill2 = new Rectangle(startX, startY, width, brk);
                    } else {
                        brk = width * RemoteFrame.this.fillPercent / 100;
                        fill = new Rectangle(startX, startY, brk, height);
                        fill2 = new Rectangle(startX + brk, startY, width - brk, height);
                    }
                } else {
                    fill2 = new Rectangle(startX, startY, width, height);
                }
            } else {
                fill = new Rectangle(startX, startY, width, height);
            }
            if (RemoteFrame.this.fillColor != null && fill != null) {
                g.setColor(RemoteFrame.this.fillColor);
                g.fill(fill);
            }
            if (RemoteFrame.this.fillColor2 != null && fill2 != null) {
                g.setColor(RemoteFrame.this.fillColor2);
                g.fill(fill2);
            }
            if (RemoteFrame.this.fillColor == null && RemoteFrame.this.fillColor2 == null && RemoteFrame.this.gradientMgr.isPaintGradient()) {
                RemoteFrame.this.gradientMgr.paint(g, fill);
            }
            Rectangle titleRect = RemoteFrame.this.titleTransparent ? this.drawTitle(g, size, fontHeight, startY, colorTitle) : null;
            switch (RemoteFrame.this.style3D) {
                case 4: {
                    for (int i = 0; i <= RemoteFrame.this.styleWidth; ++i) {
                        if (RemoteFrame.this.alternate && i != 0 && i != RemoteFrame.this.styleWidth) continue;
                        g.setColor(lc);
                        this.drawLine(g, titleRect, startX + i, startY + height - i, startX + width - i, startY + height - i);
                        this.drawLine(g, titleRect, startX + width - i, startY + i, startX + width - i, startY + height - i);
                        g.setColor(hc);
                        this.drawLine(g, titleRect, startX + i, startY + i, startX + width - i, startY + i);
                        this.drawLine(g, titleRect, startX + i, startY + i, startX + i, startY + height - i);
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i <= RemoteFrame.this.styleWidth; ++i) {
                        if (RemoteFrame.this.alternate && i != 0 && i != RemoteFrame.this.styleWidth) continue;
                        g.setColor(hc);
                        this.drawLine(g, titleRect, startX + i, startY + height - i, startX + width - i, startY + height - i);
                        this.drawLine(g, titleRect, startX + width - i, startY + i, startX + width - i, startY + height - i);
                        g.setColor(lc);
                        this.drawLine(g, titleRect, startX + i, startY + i, startX + width - i, startY + i);
                        this.drawLine(g, titleRect, startX + i, startY + i, startX + i, startY + height - i);
                    }
                    break;
                }
                case 6: {
                    int i = 0;
                    g.setColor(lc);
                    this.drawLine(g, titleRect, startX + i, startY + i, startX + width - i, startY + i);
                    this.drawLine(g, titleRect, startX + i, startY + i, startX + i, startY + height - i);
                    g.setColor(hc);
                    this.drawLine(g, titleRect, startX + i, startY + height - i, startX + width - i, startY + height - i);
                    this.drawLine(g, titleRect, startX + width - i, startY + i, startX + width - i, startY + height - i);
                    i = RemoteFrame.this.styleWidth + 1;
                    g.setColor(lc);
                    this.drawLine(g, titleRect, startX + i, startY + height - i, startX + width - i, startY + height - i);
                    this.drawLine(g, titleRect, startX + width - i, startY + i, startX + width - i, startY + height - i);
                    g.setColor(hc);
                    this.drawLine(g, titleRect, startX + i, startY + i, startX + width - i, startY + i);
                    this.drawLine(g, titleRect, startX + i, startY + i, startX + i, startY + height - i);
                    if (!RemoteFrame.this.alternate) break;
                    g.setColor(colorTitle);
                    for (i = 1; i < RemoteFrame.this.styleWidth + 1; ++i) {
                        this.drawRect(g, titleRect, startX + i, startY + i, width - (i << 1), height - (i << 1));
                    }
                    break;
                }
                case 7: {
                    int i = 0;
                    g.setColor(hc);
                    this.drawLine(g, titleRect, startX + i, startY + i, startX + width - i, startY + i);
                    this.drawLine(g, titleRect, startX + i, startY + i, startX + i, startY + height - i);
                    g.setColor(lc);
                    this.drawLine(g, titleRect, startX + i, startY + height - i, startX + width - i, startY + height - i);
                    this.drawLine(g, titleRect, startX + width - i, startY + i, startX + width - i, startY + height - i);
                    i = RemoteFrame.this.styleWidth + 1;
                    g.setColor(hc);
                    this.drawLine(g, titleRect, startX + i, startY + height - i, startX + width - i, startY + height - i);
                    this.drawLine(g, titleRect, startX + width - i, startY + i, startX + width - i, startY + height - i);
                    g.setColor(lc);
                    this.drawLine(g, titleRect, startX + i, startY + i, startX + width - i, startY + i);
                    this.drawLine(g, titleRect, startX + i, startY + i, startX + i, startY + height - i);
                    if (!RemoteFrame.this.alternate) break;
                    g.setColor(colorTitle);
                    for (i = 1; i < RemoteFrame.this.styleWidth + 1; ++i) {
                        this.drawRect(g, titleRect, startX + i, startY + i, width - (i << 1), height - (i << 1));
                    }
                    break;
                }
                default: {
                    g.setColor(colorTitle);
                    for (int i = 0; i <= RemoteFrame.this.styleWidth; ++i) {
                        if (RemoteFrame.this.alternate && i != 0 && i != RemoteFrame.this.styleWidth) continue;
                        this.drawRect(g, titleRect, startX + i, startY + i, width - (i << 1), height - (i << 1));
                    }
                }
            }
            if (!RemoteFrame.this.titleTransparent) {
                this.drawTitle(g, size, fontHeight, startY, colorTitle);
            }
        }

        private Rectangle drawTitle(Graphics g, Dimension size, int fontHeight, int startY, Color colorTitle) {
            Rectangle titleRect = null;
            if (RemoteFrame.this.title != null && RemoteFrame.this.title.length() > 0) {
                int ty;
                int tx;
                Toolkit tk;
                Map map;
                Graphics2D g2 = (Graphics2D)g;
                if (AbstractGuiFactoryImpl.getFontHandlingProp() != 3 && (map = (Map)(tk = Toolkit.getDefaultToolkit()).getDesktopProperty("awt.font.desktophints")) != null) {
                    g2.addRenderingHints(map);
                }
                int tenthW = 10;
                StringBuffer sb = new StringBuffer(RemoteFrame.this.title.trim());
                int idx = ScreenUtility.getMnemonicIdx(sb);
                String frameTitle = " " + sb + " ";
                if (idx >= 0) {
                    ++idx;
                }
                FontMetrics fm = g.getFontMetrics();
                int lenTitle = fm.stringWidth(frameTitle) + 1;
                int descent = fm.getMaxDescent();
                switch (RemoteFrame.this.titlePosition) {
                    default: {
                        tx = tenthW - 1;
                        ty = fontHeight - fm.getDescent();
                        break;
                    }
                    case 2: {
                        tx = size.width / 2 - lenTitle / 2 - 1;
                        ty = fontHeight - fm.getDescent();
                        break;
                    }
                    case 3: {
                        tx = size.width - lenTitle - tenthW - 1;
                        ty = fontHeight - fm.getDescent();
                        break;
                    }
                    case 4: {
                        tx = tenthW - 1;
                        ty = size.height - descent;
                        break;
                    }
                    case 5: {
                        tx = size.width / 2 - lenTitle / 2 - 1;
                        ty = size.height - descent;
                        break;
                    }
                    case 6: {
                        tx = size.width - lenTitle - tenthW - 1;
                        ty = size.height - descent;
                        break;
                    }
                    case 7: {
                        tx = size.width / 2 - lenTitle / 2 - 1;
                        ty = (startY + RemoteFrame.this.height) / 2 + fontHeight / 2 - 2;
                    }
                }
                titleRect = new Rectangle(tx, ty - fontHeight + descent, lenTitle, fontHeight);
                if (RemoteFrame.this.titlePosition != 7 && !RemoteFrame.this.titleTransparent) {
                    g.setColor(this.getBackground());
                    g.fillRect(tx, ty - fontHeight + descent, lenTitle, fontHeight);
                }
                g.setColor(colorTitle);
                g.drawString(frameTitle, tx, ty);
                if (idx >= 0) {
                    int ux = tx + fm.stringWidth(frameTitle.substring(0, idx));
                    g.drawLine(ux, ty + 2, ux + fm.charWidth(frameTitle.charAt(idx)), ty + 2);
                }
            }
            return titleRect;
        }

        private void drawRect(Graphics g, Rectangle titleRect, int x, int y, int width, int height) {
            if (titleRect != null) {
                this.drawLine(g, titleRect, x, y, x + width - 1, y);
                this.drawLine(g, titleRect, x, y + height - 1, x + width - 1, y + height - 1);
                this.drawLine(g, titleRect, x, y + 1, x, y + height - 2);
                this.drawLine(g, titleRect, x + width - 1, y + 1, x + width - 1, y + height - 2);
            } else {
                g.drawRect(x, y, width, height);
            }
        }

        private void drawLine(Graphics g, Rectangle titleRect, int x1, int y1, int x2, int y2) {
            Rectangle ints = titleRect != null ? titleRect.intersection(new Rectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1)) : null;
            if (ints != null && !ints.isEmpty()) {
                if (x1 == x2) {
                    g.drawLine(x1, y1, x2, ints.y - 1);
                    g.drawLine(x1, ints.y + ints.height, x2, y2);
                } else {
                    g.drawLine(x1, y1, ints.x - 1, y2);
                    g.drawLine(ints.x + ints.width, y1, x2, y2);
                }
            } else {
                g.drawLine(x1, y1, x2, y2);
            }
        }

        @Override
        public void setActiveAccept(boolean b) {
            this.activated = b;
        }

        @Override
        public void asyncProcessEvent(AWTEvent e) {
        }

        @Override
        public boolean getActiveAccept() {
            return this.activated;
        }

        @Override
        public void setSelfAct(boolean b) {
            this.selfAct = b;
        }

        @Override
        public boolean getSelfAct() {
            return this.selfAct;
        }

        @Override
        public void setVisible(boolean b) {
            boolean isVisible = this.isVisible();
            if (RemoteFrame.this.style == 9 || RemoteFrame.this.style == 10 || RemoteFrame.this.style == 11 || RemoteFrame.this.style == 12) {
                if (b) {
                    RemoteDisplayWindow rdw = (RemoteDisplayWindow)RemoteFrame.this.parentWindow;
                    Color fg = RemoteFrame.this.getColorForeground();
                    Color bg = RemoteFrame.this.getColorBackground();
                    Color fgchar = fg != null ? fg : Color.white;
                    Color bgchar = bg != null ? bg : Color.black;
                    Dimension s = this.getSize();
                    Point p = this.getLocation();
                    int cellw = RemoteFrame.this.parentWindow.getCellWidth();
                    int cellh = RemoteFrame.this.parentWindow.getCellHeight();
                    int x = p.x / cellw;
                    int y = p.y / cellh;
                    int w = s.width / cellw;
                    int h = s.height / cellh;
                    if (RemoteFrame.this.style == 12) {
                        rdw.mainWindow.keisen(RemoteFrame.this.keisenCmd, x, y, w, h, RemoteFrame.this.keisenAttr);
                    } else {
                        rdw.mainWindow.box(x, y, w, h, fgchar, 0, bgchar, new String[]{RemoteFrame.this.title, RemoteFrame.this.title2}, new int[]{RemoteFrame.this.titlePosition, RemoteFrame.this.titlePosition2}, RemoteFrame.this.style == 9);
                    }
                    rdw.setDoRepaint(new Rectangle(x, y, w, h));
                }
            } else {
                super.setVisible(b);
                if (!this.firstTime || b != isVisible && b) {
                    this.firstTime = true;
                    this.repaint();
                }
            }
        }

        @Override
        public void setFont(Font f) {
            Font old = super.getFont();
            if (old != null && f != null && old.getName() == f.getName() && old.getStyle() == f.getStyle() && old.getSize() == f.getSize()) {
                return;
            }
            super.setFont(f);
        }
    }
}

