/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.ParamsValues;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolCheckbox;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteTab;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class RemoteCheckBox
extends RemoteBaseGUIControl {
    private static final float DEFAULT_WIDTH_INSETS = 17.0f;
    private static final float MINIMUM_HEIGHT = 15.0f;
    private static final String DEFAULT_OFF_VALUE = "0";
    private static final String DEFAULT_ON_VALUE = "1";
    private String title;
    private boolean state;
    private boolean selfAct;
    private boolean transparent;
    private boolean leftText;
    private int leftTextAlign;
    private float rows;
    private int bitmapNumber;
    private int bitmapDisabled;
    private int bitmapDisabledSelected;
    private int bitmapPressed;
    private int bitmapSelected;
    private int bitmapRollover;
    private int bitmapRolloverSelected;
    private int bitmapWidth;
    private boolean flat;
    private boolean multiline;
    private boolean vtop;
    private int titlePosition;
    private ActionListener al;
    private int imageId = -1;
    private Image image;
    private Integer disabledColor;
    private Integer disabledBackgroundColor;
    private Integer disabledForegroundColor;
    private boolean disabledBackgroundRgb;
    private boolean disabledForegroundRgb;
    private Integer rolloverColor;
    private Integer rolloverBackgroundColor;
    private Integer rolloverForegroundColor;
    private boolean rolloverBackgroundRgb;
    private boolean rolloverForegroundRgb;
    private String checkOffValue;
    private String checkOffValueDefault = " ";
    private String checkOnValue;
    private String valuealpha;
    private int bitmapScale;
    private final boolean iconsScaling;
    private final boolean m25647;
    private Color borderColor;
    private ColorCmp borderColorCmp;
    private int borderColorIdx;
    private Color rolloverBorderColor;
    private ColorCmp rolloverBorderColorCmp;
    private int rolloverBorderColorIdx;

    public RemoteCheckBox(GuiFactoryImpl gf) {
        super(gf);
        this.m25647 = gf.getCsProperty().get("iscobol.m25647", false);
        this.iconsScaling = gf.getCsProperty().get("iscobol.gui.icons_scaling", false);
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultWidth() {
        if (this.bitmapStyle) {
            return 16.0f;
        }
        if (this.title != null && this.title.length() > 0) {
            return (float)(this.font.computeScreenWidth(this.title) / this.font.computeScreenWidth(DEFAULT_OFF_VALUE)) + 1.2f;
        }
        return 0.0f;
    }

    @Override
    public float getDefaultHeight() {
        if (this.bitmapStyle) {
            return 15.0f;
        }
        return 1.0f;
    }

    @Override
    public int getGUIControlHeight(float h) {
        int Return2 = this.bitmapStyle ? (int)h : (int)((float)this.font.getHeight() * h);
        if ((float)Return2 < 15.0f) {
            Return2 = 15;
        }
        return Return2;
    }

    @Override
    public int getGUIControlWidth(float w) {
        int Return2 = 0;
        if (this.bitmapStyle) {
            Return2 = (int)w;
        } else if (w > 0.0f) {
            Return2 = (int)((float)this.font.getWidth() * w + 17.0f);
        }
        return Return2;
    }

    @Override
    public float getSizes() {
        float Return2 = super.getSizes();
        if (Return2 == 0.0f) {
            Dimension dim = this.guiComponent.getPreferredSize();
            Return2 = this.bitmapStyle ? (float)dim.width : ((float)dim.width - 17.0f) / (float)this.font.getWidth();
        }
        return Return2;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getValue() {
        boolean status = this.getState();
        if (this.checkOffValue != null || this.checkOnValue != null) {
            if (status) {
                return this.checkOnValue;
            }
            return this.checkOffValue != null ? this.checkOffValue : this.checkOffValueDefault;
        }
        if (status) {
            return DEFAULT_ON_VALUE;
        }
        return DEFAULT_OFF_VALUE;
    }

    @Override
    public void initialize() {
        Color fg;
        Color bg;
        Color[] cs;
        if (this.guiComponent != null) {
            return;
        }
        this.guiComponent = new PicobolCheckbox();
        PicobolCheckbox cb = (PicobolCheckbox)this.guiComponent;
        cb.addOutAcceptListener(this);
        super.intInitialize();
        cb.setMultiline(this.multiline || this.m25647 && this.rows >= 2.0f);
        cb.setHasBitmap(this.bitmapStyle);
        if (this.image == null && this.imageId >= 0) {
            this.setImage(1, 1, this.imageId, 1);
        }
        if (!this.bitmapStyle && this.leftText) {
            cb.setLeftText(this.leftText);
        }
        if (this.titlePosition > 0) {
            cb.setTitlePosition(this.titlePosition);
        }
        cb.setLeftTextAlignment(this.leftTextAlign);
        cb.setVTop(this.vtop);
        this.setTitle(this.title);
        cb.setBitmapWidth(this.bitmapWidth);
        cb.setBitmapNumber(this.bitmapNumber);
        cb.setBitmapDisabled(this.bitmapDisabled);
        cb.setBitmapDisabledSelected(this.bitmapDisabledSelected);
        cb.setBitmapRollover(this.bitmapRollover);
        cb.setBitmapPressed(this.bitmapPressed);
        cb.setBitmapSelected(this.bitmapSelected);
        cb.setBitmapRolloverSelected(this.bitmapRolloverSelected);
        if (this.disabledColor != null) {
            cs = this.getColors(this.disabledColor);
            cb.setDisabledBackground(cs[0]);
            cb.setDisabledForeground(cs[1]);
        } else {
            if (this.disabledBackgroundColor != null) {
                bg = this.getBackgroundColor(this.disabledBackgroundColor, this.disabledBackgroundRgb);
                cb.setDisabledBackground(bg);
            }
            if (this.disabledForegroundColor != null) {
                fg = this.getForegroundColor(this.disabledForegroundColor, this.disabledForegroundRgb);
                cb.setDisabledForeground(fg);
            }
        }
        if (this.rolloverColor != null) {
            cs = this.getColors(this.rolloverColor);
            cb.setRolloverBackground(cs[0]);
            cb.setRolloverForeground(cs[1]);
        } else {
            if (this.rolloverBackgroundColor != null) {
                bg = this.getBackgroundColor(this.rolloverBackgroundColor, this.rolloverBackgroundRgb);
                cb.setRolloverBackground(bg);
            }
            if (this.rolloverForegroundColor != null) {
                fg = this.getForegroundColor(this.rolloverForegroundColor, this.rolloverForegroundRgb);
                cb.setRolloverForeground(fg);
            }
        }
        cb.setBitmapScale(this.bitmapScale);
        this.guiComponent.setSelfAct(this.selfAct);
        this.setState(this.state);
        cb.setFlat(this.flat);
        this.setBoxedStyle();
        this.setRolloverBorderColor();
        cb.setScaleDefaultIcon(this.iconsScaling);
        cb.setOpaque(!this.transparent);
        this.al = e -> {
            if (this.skipNextEvent) {
                this.setState(!cb.isSelected());
            } else {
                this.responseOnAction(e);
            }
            this.skipNextEvent = false;
        };
        cb.addActionListener(this.al);
        this.guiComponent.addKeyListener(this);
        this.usedtorender = true;
    }

    void responseOnAction(ActionEvent evt) {
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(16, 17, evt.getID()));
        if (this.hasClickOverrideFocusChange() || (!this.getActiveAccept() || this.isProtectedField()) && !this.isSelfAct()) {
            if (this.hasClickOverrideFocusChange()) {
                cc.getRemoteRecordAccept().setResponse(true);
                cc.getRemoteRecordAccept().setWait(true);
            }
            if (this.hasClickOverrideFocusChange() && this.isSelfAct() && !this.getActiveAccept()) {
                this.setState(((PicobolCheckbox)this.guiComponent).isSelected());
            } else {
                this.setState(!((PicobolCheckbox)this.guiComponent).isSelected());
            }
        } else {
            this.state = ((PicobolCheckbox)this.guiComponent).isSelected();
        }
        this.pushEvent(cc, 4);
    }

    void setState(boolean b) {
        this.state = b;
        if (this.guiComponent != null && ((PicobolCheckbox)this.guiComponent).isSelected() != b) {
            ((PicobolCheckbox)this.guiComponent).setSelected(b);
        }
    }

    @Override
    public String getProp(int key) {
        PicobolCheckbox cb = (PicobolCheckbox)this.guiComponent;
        switch (key) {
            case 325: {
                if (this.borderColorCmp == null) break;
                return Integer.toString(this.borderColorIdx >= 0 ? this.borderColorIdx : this.borderColorCmp.getForeground());
            }
            case 427: {
                if (this.rolloverBorderColorCmp == null) break;
                return Integer.toString(this.rolloverBorderColorIdx >= 0 ? this.rolloverBorderColorIdx : this.rolloverBorderColorCmp.getForeground());
            }
            case 410: {
                if (!this.disabledBackgroundRgb && this.disabledBackgroundColor != null) {
                    return this.disabledBackgroundColor.toString();
                }
                if (cb == null || cb.getDisabledBackground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setBackRGB(cb.getDisabledBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 412: {
                if (!this.disabledForegroundRgb && this.disabledForegroundColor != null) {
                    return this.disabledForegroundColor.toString();
                }
                if (cb == null || cb.getDisabledForeground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setForeRGB(cb.getDisabledForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 409: {
                if (this.disabledColor != null) {
                    return this.disabledColor.toString();
                }
                return DEFAULT_OFF_VALUE;
            }
            case 415: {
                if (!this.rolloverBackgroundRgb && this.rolloverBackgroundColor != null) {
                    return this.rolloverBackgroundColor.toString();
                }
                if (cb == null || cb.getRolloverBackground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setBackRGB(cb.getRolloverBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 417: {
                if (!this.rolloverForegroundRgb && this.rolloverForegroundColor != null) {
                    return this.rolloverForegroundColor.toString();
                }
                if (cb == null || cb.getRolloverForeground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setForeRGB(cb.getRolloverForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 414: {
                if (this.rolloverColor != null) {
                    return this.rolloverColor.toString();
                }
                return DEFAULT_OFF_VALUE;
            }
        }
        return super.getProp(key);
    }

    boolean getState() {
        return this.state;
    }

    @Override
    protected void intFocusGained(boolean restore) {
    }

    @Override
    public boolean isSelfAct() {
        if (this.guiComponent != null) {
            return this.guiComponent.getSelfAct();
        }
        return this.selfAct;
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imid, int strip) {
        Rectangle r = this.getBounds();
        viewWidth = r.width;
        viewHeight = r.height;
        this.imageId = imid;
        if (viewWidth == 0 || !this.bitmapStyle) {
            return;
        }
        this.image = this.getLocalImage(this.imageId);
        if (this.bitmapWidth == 0) {
            this.bitmapWidth = viewWidth;
        }
        PicobolCheckbox cb = (PicobolCheckbox)this.guiComponent;
        if (this.guiComponent != null) {
            cb.setImage(this.image, this.bitmapWidth, viewHeight);
            if (this.image != null && this.title != null) {
                cb.setHasBitmap(this.bitmapStyle);
                cb.setTitle(this.title);
            }
        }
    }

    private void setBitmapNumber(int intValue, PicobolCheckbox cb) {
        this.bitmapNumber = intValue;
        if (cb != null) {
            cb.setBitmapNumber(this.bitmapNumber);
        }
    }

    private void setBitmapDisabled(int intValue, PicobolCheckbox cb) {
        this.bitmapDisabled = intValue;
        if (cb != null) {
            cb.setBitmapDisabled(this.bitmapDisabled);
        }
    }

    private void setBitmapDisabledSelected(int intValue, PicobolCheckbox cb) {
        this.bitmapDisabledSelected = intValue;
        if (cb != null) {
            cb.setBitmapDisabledSelected(this.bitmapDisabledSelected);
        }
    }

    private void setBitmapPressed(int intValue, PicobolCheckbox cb) {
        this.bitmapPressed = intValue;
        if (cb != null) {
            cb.setBitmapPressed(this.bitmapPressed);
        }
    }

    private void setBitmapRollover(int intValue, PicobolCheckbox cb) {
        this.bitmapRollover = intValue;
        if (cb != null) {
            cb.setBitmapRollover(this.bitmapRollover);
        }
    }

    private void setBitmapSelected(int intValue, PicobolCheckbox cb) {
        this.bitmapSelected = intValue;
        if (cb != null) {
            cb.setBitmapSelected(this.bitmapSelected);
        }
    }

    private void setBitmapRolloverSelected(int intValue, PicobolCheckbox cb) {
        this.bitmapRolloverSelected = intValue;
        if (cb != null) {
            cb.setBitmapRolloverSelected(this.bitmapRolloverSelected);
        }
    }

    private void setTitlePosition(int intValue, PicobolCheckbox cb) {
        this.titlePosition = intValue;
        if (cb != null) {
            cb.setTitlePosition(this.titlePosition);
        }
    }

    private void setBitmapWidth(int intValue, PicobolCheckbox cb) {
        this.bitmapWidth = intValue;
        if (cb != null) {
            cb.setBitmapWidth(this.bitmapWidth);
        }
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        String Return2 = DEFAULT_OFF_VALUE;
        int intValue = 0;
        boolean error = false;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        PicobolCheckbox cb = (PicobolCheckbox)this.guiComponent;
        boolean isrgb = false;
        switch (key) {
            case 295: {
                if (error) break;
                this.bitmapScale = intValue;
                if (cb == null) break;
                cb.setBitmapScale(this.bitmapScale);
                break;
            }
            case 409: {
                if (error) break;
                this.disabledColor = intValue;
                if (cb != null) {
                    Color[] cs = this.getColors(intValue);
                    cb.setDisabledBackground(cs[0]);
                    cb.setDisabledForeground(cs[1]);
                }
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 411: {
                isrgb = true;
            }
            case 410: {
                if (error) break;
                this.disabledBackgroundColor = intValue;
                this.disabledBackgroundRgb = isrgb;
                if (cb != null) {
                    Color bg = this.getBackgroundColor(intValue, isrgb);
                    cb.setDisabledBackground(bg);
                }
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 413: {
                isrgb = true;
            }
            case 412: {
                if (error) break;
                this.disabledForegroundColor = intValue;
                this.disabledForegroundRgb = isrgb;
                if (cb != null) {
                    Color fg = this.getForegroundColor(intValue, isrgb);
                    cb.setDisabledForeground(fg);
                }
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 414: {
                if (error) break;
                this.rolloverColor = intValue;
                if (cb != null) {
                    Color[] cs = this.getColors(intValue);
                    cb.setRolloverBackground(cs[0]);
                    cb.setRolloverForeground(cs[1]);
                }
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 416: {
                isrgb = true;
            }
            case 415: {
                if (error) break;
                this.rolloverBackgroundColor = intValue;
                this.rolloverBackgroundRgb = isrgb;
                if (cb != null) {
                    Color bg = this.getBackgroundColor(intValue, isrgb);
                    cb.setRolloverBackground(bg);
                }
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 418: {
                isrgb = true;
            }
            case 417: {
                if (error) break;
                this.rolloverForegroundColor = intValue;
                this.rolloverForegroundRgb = isrgb;
                if (cb != null) {
                    Color fg = this.getForegroundColor(intValue, isrgb);
                    cb.setRolloverForeground(fg);
                }
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 320: {
                if (error) break;
                this.leftTextAlign = intValue;
                if (cb != null) {
                    cb.setLeftTextAlignment(this.leftTextAlign);
                }
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 7: 
            case 12: {
                if (error) break;
                this.setBitmapNumber(intValue, cb);
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 8: {
                if (error) break;
                this.setBitmapDisabled(intValue, cb);
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 13: {
                if (error) break;
                this.setBitmapPressed(intValue, cb);
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 14: {
                if (error) break;
                this.setBitmapRollover(intValue, cb);
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 16: {
                if (error) break;
                this.setBitmapSelected(intValue, cb);
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 15: {
                if (error) break;
                this.setBitmapRolloverSelected(intValue, cb);
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 240: {
                if (error) break;
                this.setTitlePosition(intValue, cb);
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 20: {
                if (error) break;
                this.setBitmapWidth(intValue, cb);
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 294: {
                if (error) break;
                this.setBitmapDisabledSelected(intValue, cb);
                Return2 = DEFAULT_ON_VALUE;
                break;
            }
            case 424: {
                this.checkOffValue = value;
                break;
            }
            case 425: {
                this.checkOnValue = value;
                break;
            }
            case 325: 
            case 326: {
                isrgb = key.equals(ParamsValues.getParamValue("BORDER-COLOR-RGB"));
                if (intValue < 0 || isrgb) {
                    this.borderColorCmp = new ColorCmp(true);
                    this.borderColorIdx = -1;
                    this.borderColorCmp.setForeRGB(intValue);
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.borderColorCmp.getForeground(), false));
                } else {
                    this.borderColorCmp = new ColorCmp(intValue);
                    this.borderColorIdx = intValue;
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(this.borderColorCmp.getForeground());
                }
                this.setBoxedStyle();
                break;
            }
            case 374: {
                this.handleBorderWidths(value);
                this.setBoxedStyle();
                break;
            }
            case 427: 
            case 428: {
                isrgb = key.equals(ParamsValues.getParamValue("ROLLOVER-BORDER-COLOR-RGB"));
                if (intValue < 0 || isrgb) {
                    this.rolloverBorderColorCmp = new ColorCmp(true);
                    this.rolloverBorderColorIdx = -1;
                    this.rolloverBorderColorCmp.setForeRGB(intValue);
                    this.rolloverBorderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.rolloverBorderColorCmp.getForeground(), false));
                } else {
                    this.rolloverBorderColorCmp = new ColorCmp(intValue);
                    this.rolloverBorderColorIdx = intValue;
                    this.rolloverBorderColor = this.gf.getRemotePalette().getDefaultColor(this.rolloverBorderColorCmp.getForeground());
                }
                this.setRolloverBorderColor();
                break;
            }
            default: {
                return super.setProp(key, value, length);
            }
        }
        return Return2;
    }

    @Override
    public void setRowsCols(float r, float c) {
        this.rows = r;
    }

    @Override
    public void setStyle(int s, boolean set) {
        PicobolCheckbox cb = (PicobolCheckbox)this.guiComponent;
        if ((s & 0x10000) == 65536) {
            this.transparent = set;
            if (this.guiComponent != null) {
                ((PicobolCheckbox)this.guiComponent).setOpaque(!this.transparent);
            }
        }
        if ((s & 0x400000) == 0x400000) {
            this.selfAct = set;
            if (this.getComponent() != null) {
                this.getComponent().setSelfAct(this.selfAct);
            }
        }
        if ((s & 2) == 2) {
            this.leftText = set;
            if (cb != null) {
                cb.setLeftText(this.leftText);
            }
        }
        if ((s & 0x200) == 512) {
            this.vtop = set;
            if (cb != null) {
                cb.setVTop(this.vtop);
            }
        }
        if ((s & 0x400) == 1024) {
            this.multiline = set;
            if (cb != null) {
                cb.setMultiline(this.multiline);
            }
        }
        if ((s & 0x800) == 2048) {
            this.flat = set;
            if (cb != null) {
                cb.setFlat(set);
            }
        }
        if ((s & 0x8000) == 32768) {
            this.bitmapStyle = set;
            if (cb != null) {
                cb.setHasBitmap(this.bitmapStyle);
            }
        }
        if ((s & 0x1000) == 4096) {
            // empty if block
        }
        if ((s & 0x2000) == 8192) {
            // empty if block
        }
        if ((s & 0x4000) == 16384) {
            // empty if block
        }
    }

    @Override
    public void setTitle(String t) {
        this.title = t;
        if (this.guiComponent != null) {
            PicobolCheckbox cb = (PicobolCheckbox)this.guiComponent;
            if (t != null) {
                cb.setTitle(t);
                if (cb.getMnemonicChar() > '\u0000' && this.parentWindow != null) {
                    this.parentWindow.removeMnemonic(this);
                    this.parentWindow.addMnemonic(cb.getMnemonicChar(), this);
                }
            } else if (!this.bitmapStyle) {
                cb.setBoundsMinimized(this.x, this.y, this.width, this.height);
            }
        }
    }

    @Override
    public String setValue(String v) {
        int val;
        block7: {
            val = -1;
            try {
                val = Integer.parseInt(v.trim());
            }
            catch (NumberFormatException e) {
                this.valuealpha = v.trim();
                if (this.valuealpha == null) break block7;
                if (this.checkOffValue != null || this.checkOnValue != null) {
                    if (this.checkOffValue != null && this.valuealpha.equalsIgnoreCase(this.checkOffValue) || this.valuealpha.length() == 0) {
                        val = 0;
                    } else if (this.valuealpha.equalsIgnoreCase(this.checkOnValue)) {
                        val = 1;
                    }
                }
                val = 0;
            }
        }
        if (val != -1) {
            this.setState(val != 0);
        }
        return v;
    }

    @Override
    public void destroy() {
        PicobolCheckbox cb = (PicobolCheckbox)this.guiComponent;
        if (cb != null) {
            cb.removeOutAcceptListener();
            cb.removeActionListener(this.al);
            cb.removeKeyListener(this);
            this.al = null;
        }
        super.destroy();
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        boolean changestate = false;
        super.handleResponse(eventAction, rra);
        RemoteBaseGUIControl rbgc = this.getUponCtrl();
        if (rbgc != null && rbgc instanceof RemoteTab && ((RemoteTab)rbgc).isRibbon()) {
            changestate = true;
        }
        if (!(!this.hasClickOverrideFocusChange() || !this.getActiveAccept() && !changestate || eventAction != 0 && eventAction != 1 && eventAction != 2 || rra.getEventType() != 17 || this.gf != null && this.gf.getM31715callsetstatecheckbox() && this.isControlEditor() && this.hasClickOverrideFocusChange())) {
            this.setState(!((PicobolCheckbox)this.guiComponent).isSelected());
        }
    }

    @Override
    public void setCols(float cols) {
    }

    @Override
    public void setRows(float cols) {
    }

    @Override
    public Rectangle getRealBounds() {
        Rectangle Return2 = this.guiComponent != null ? this.guiComponent.getBounds() : new Rectangle(this.x, this.y, this.width, this.height);
        return Return2;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle Return2 = this.getRealBounds();
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                Return2.width -= 8;
            }
            if (!this.linesInPixel) {
                Return2.height -= 7;
            }
        }
        return Return2;
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle Return2 = this.getBounds();
        if (!this.bitmapStyle && Return2 != null && Return2.width > 0) {
            Return2.width = (int)((float)Return2.width - 17.0f);
        }
        return Return2;
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    protected void processMnemonic(char c) {
        super.processMnemonic(c);
        PicobolCheckbox cb = (PicobolCheckbox)this.guiComponent;
        if (cb != null) {
            cb.doClick(100);
        }
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        String t = null;
        if (ps.sizes > 0.0f) {
            return ps.sizes;
        }
        if (!this.bitmapStyle) {
            if (ps.sizesInPixel || this.bitmapStyle && !ps.sizesInCells || ps.sizesInCells) {
                if (this.title != null) {
                    t = this.title;
                }
                if (t != null) {
                    if (this.font != null) {
                        return (float)(this.font.computeScreenWidth(t) / this.font.computeScreenWidth(DEFAULT_OFF_VALUE)) + 1.2f;
                    }
                    return this.title.length();
                }
            } else {
                return 0.0f;
            }
        }
        return super.paramgetDefaultWidth(ps, origWidth);
    }

    @Override
    public void setSize(int w, int h, boolean setOnComp) {
        this.width = w;
        this.height = h;
        if (this.guiComponent != null && setOnComp) {
            this.updateLayoutManager();
            this.guiComponent.setSize(this.width, this.height);
        }
    }

    @Override
    public String getType() {
        return "checkbox";
    }

    @Override
    public void startCellEditing() {
        ((PicobolCheckbox)this.guiComponent).setSelected(!((PicobolCheckbox)this.guiComponent).isSelected());
        this.setState(((PicobolCheckbox)this.guiComponent).isSelected());
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(16, 17, 1001));
        this.pushEvent(cc, 4);
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(false, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean removelistener, Dimension scalebitmaptosize) {
        PicobolCheckbox cb = (PicobolCheckbox)this.guiComponent;
        cb.removeOutAcceptListener();
        cb.removeActionListener(this.al);
        cb.removeKeyListener(this);
        this.image = null;
        RemoteCheckBox clone = null;
        try {
            clone = (RemoteCheckBox)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.setComponent(null);
        clone.initialize();
        return clone;
    }

    @Override
    public Dimension getRendererSize() {
        Dimension Return2 = null;
        Return2 = this.guiComponent != null ? this.guiComponent.getSize() : new Dimension(this.width, this.height);
        if (Return2.width == 0) {
            if (this.title != null && this.title.length() > 0) {
                Return2.width = this.getGUIControlWidth(this.title.length());
            }
            if (Return2.width == 0) {
                Return2.width = (int)this.getDefaultWidth();
            }
        }
        if (Return2.height == 0) {
            Return2.height = (int)this.getDefaultHeight();
        }
        if (!this.bitmapStyle) {
            if ((float)Return2.width < 17.0f) {
                Return2.width = 17;
            }
            if ((float)Return2.height < 15.0f) {
                Return2.height = 15;
            }
        }
        return Return2;
    }

    @Override
    protected boolean mustreceivepressed() {
        return true;
    }

    @Override
    public void adjustBounds(Rectangle Return2) {
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                Return2.width -= 8;
            }
            if (!this.linesInPixel) {
                Return2.height -= 7;
            }
        }
    }

    @Override
    public String getCorrespondingValue(String tmp) {
        String Return2 = tmp;
        if (tmp != null && tmp.length() > 0) {
            if (this.checkOffValue != null && tmp.equalsIgnoreCase(DEFAULT_OFF_VALUE) || tmp.trim().length() == 0) {
                Return2 = this.checkOffValue;
            } else if (this.checkOnValue != null && tmp.equalsIgnoreCase(DEFAULT_ON_VALUE)) {
                Return2 = this.checkOnValue;
            }
        }
        return Return2;
    }

    @Override
    public JComponent getDragDropComponent() {
        return (PicobolCheckbox)this.guiComponent;
    }

    protected void setBoxedStyle() {
        PicobolCheckbox pb = (PicobolCheckbox)this.guiComponent;
        if (pb != null && this.borderWidths != null && this.borderWidths.size() > 0) {
            pb.setCustomBorder(this.borderWidths, this.borderColor);
        }
    }

    private void setRolloverBorderColor() {
        PicobolCheckbox pb = (PicobolCheckbox)this.guiComponent;
        if (pb != null) {
            pb.setRolloverBorderColor(this.rolloverBorderColor);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent evt) {
        if (this.guiComponent != null) {
            PicobolCheckbox pb = (PicobolCheckbox)this.guiComponent;
            pb.getModel().setArmed(false);
        }
        super.dragGestureRecognized(evt);
    }
}

