/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.Constants;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.FromToTransferHandler;
import com.iscobol.gui.client.swing.GridCell;
import com.iscobol.gui.client.swing.GridCellRenderer;
import com.iscobol.gui.client.swing.GridConstant;
import com.iscobol.gui.client.swing.GridViewS;
import com.iscobol.gui.client.swing.OutDragListener;
import com.iscobol.gui.client.swing.PicobolChoice;
import com.iscobol.gui.client.swing.PicobolDateEntry;
import com.iscobol.gui.client.swing.PicobolGrid;
import com.iscobol.gui.client.swing.PicobolListBox;
import com.iscobol.gui.client.swing.PicobolScrollPane;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDateEntry;
import com.iscobol.gui.client.swing.RemoteEntryField;
import com.iscobol.gui.client.swing.RemotePushButton;
import com.iscobol.rts.Factory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DropMode;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.TableColumnModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.undo.UndoManager;

class GridCellEditor
extends DefaultCellEditor
implements Constants,
GridConstant {
    static final int CHECK_DATA_TYPE_AUTOTERMINATE = 0;
    static final int CHECK_DATA_TYPE_FAIL = 1;
    static final int CHECK_DATA_TYPE_OK = 2;
    static final int CHECK_INPUT_FILTER_NONE = 0;
    static final int CHECK_INPUT_FILTER_FAIL = 1;
    static final int CHECK_INPUT_FILTER_OK = 2;
    GridCell jtf = null;
    GridViewS parent;
    int edRow = -1;
    int edRowmodel = -1;
    int edCol = -1;
    int edColModel = -1;
    KeyEvent saveKeyEventLoc;
    JComponent editorComponentOrig;
    UndoManager um;
    private JPopupMenu defaultPopup;
    private JMenuItem undo;
    private JMenuItem redo;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;
    private JMenuItem delete;
    private JMenuItem selectAll;
    private int editstate;
    private String restoreCellValue;
    private GridCellRenderer.CellDottedBorder cdborder = null;
    private JPanel jp;
    private JPanel contjp;
    private Border mborder = null;
    private int mbordersize = -1;
    private Dimension ddr = new Dimension();
    private String align = "";
    private int prop_CELL_ENTRY_COLOR = -1;
    private ColorCmp colorENTRYCELL;
    private boolean isforeorback;
    private boolean fireEvents = true;
    private boolean maxTextBytes = true;
    private FromToTransferHandler ftth = null;

    public GridCellEditor(GridViewS p, JTextField b, boolean maxTextBytes) {
        super(new JCheckBox());
        this.parent = p;
        this.editorComponent = b;
        this.editorComponentOrig = b;
        this.maxTextBytes = maxTextBytes;
        b.setDocument(new MyDocument(this));
        this.setClickCountToStart(20);
        this.addMyEditorListener(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.um = new UndoManager();
        b.getDocument().addUndoableEditListener(this.um);
        b.addMouseListener(new PopupListener());
        this.getDefaultPopup();
        this.createPanels();
    }

    private MyDocument getDocument() {
        if (this.editorComponent instanceof JTextField) {
            return (MyDocument)((JTextField)this.editorComponent).getDocument();
        }
        return null;
    }

    private void createPanels() {
        this.jp = new JPanel();
        this.jp.setLayout(null);
        this.jp.setBorder(null);
        this.contjp = new JPanel();
        this.contjp.setLayout(null);
        this.contjp.setBorder(null);
        this.contjp.add(this.jp);
    }

    private void keytypedbody(KeyEvent e) {
        RemoteBaseGUIControl rbgc = null;
        char comp = e.getKeyChar();
        if (!(!Character.isLetterOrDigit(comp) && comp != '+' && comp != '-' && comp != '.' && comp != ',' && comp != '$' && comp != '*' && comp != '/' && comp != '%' && comp != ' ' || this.jtf == null || (rbgc = this.jtf.getCellEditor(this.edColModel)) != null && rbgc.getComponent() != null)) {
            int offset = 0;
            int offsetstart = 0;
            int offsetend = 0;
            int textnosel = 0;
            if (((JTextField)this.editorComponent).getText() != null) {
                MyDocument doc = this.getDocument();
                offset = doc.length(((JTextField)this.editorComponent).getText());
                offsetstart = ((JTextField)this.editorComponent).getSelectionStart();
                offsetend = ((JTextField)this.editorComponent).getSelectionEnd();
                textnosel = offset - (offsetend - offsetstart);
            }
            if (this.parent.charInInputFilter(this.jtf.getColumnModel(), comp) == 1) {
                e.consume();
                return;
            }
            int rc = this.parent.charInDataType(this.jtf.getColumnModel(), e.getKeyChar(), offsetstart, textnosel, true);
            if (rc == 1) {
                Toolkit.getDefaultToolkit().beep();
                e.consume();
                return;
            }
            if (this.parent.charInDataTypeUpper(this.jtf.getColumnModel(), offsetstart, textnosel)) {
                e.setKeyChar(Character.toUpperCase(comp));
            } else if (this.parent.charInDataTypeLower(this.jtf.getColumnModel(), offsetstart, textnosel)) {
                e.setKeyChar(Character.toLowerCase(comp));
            } else if (this.parent.getGuiFactory().getGuiKdbUpper()) {
                e.setKeyChar(Character.toUpperCase(comp));
            } else if (this.parent.getGuiFactory().getGuiKdbLower()) {
                e.setKeyChar(Character.toLowerCase(comp));
            }
        }
    }

    private void keypressedbody(KeyEvent e) {
        RemoteBaseGUIControl rbgc = null;
        int finishreasonval = -1;
        if (e.isAltDown()) {
            this.parent.keyPressed(e);
        }
        if (e.isControlDown() && this.parent != null && this.parent.getGuiFactory() != null) {
            switch (e.getKeyCode()) {
                case 67: 
                case 86: 
                case 88: {
                    if (!this.parent.isDefaultShortcutsEnabled()) break;
                    return;
                }
            }
            int cobFun = this.parent.getGuiFactory().getRemoteVirtualKeyboard().mapKey(e);
            if (this.parent.getGuiFactory().getRemoteVirtualKeyboard().isSearchKey(e.getKeyCode(), e.isShiftDown(), e.isControlDown(), e.isAltDown(), "grid") && this.parent.hasFindPanel()) {
                return;
            }
            int kval = VirtualKeyboard.exception(cobFun);
            if (kval >= 0) {
                this.parent.setFinishReason(String.valueOf(kval));
                this.parent.keyPressed(e);
                this.fireEditingStopped(e);
            }
            return;
        }
        if (e.getKeyCode() == 27) {
            this.parent.setFinishReason(String.valueOf(-5));
            this.fireEditingCanceled();
        } else if (e.getKeyCode() != 16 && e.getKeyCode() != 37 && e.getKeyCode() != 39 && e.getKeyCode() != 8 && e.getKeyCode() != 36 && e.getKeyCode() != 35 && e.getKeyCode() != 32 && e.getKeyCode() != 20 && !this.parent.isDeleteTypedIsEditor(e) && !Character.isLetterOrDigit(e.getKeyChar()) && e.getKeyChar() == '\uffff') {
            switch (e.getKeyCode()) {
                case 112: {
                    this.parent.setFinishReason("1");
                    this.fireEditingStopped(e);
                    break;
                }
                case 113: {
                    this.parent.setFinishReason("2");
                    this.fireEditingStopped(e);
                    break;
                }
                case 114: {
                    this.parent.setFinishReason("3");
                    this.fireEditingStopped(e);
                    break;
                }
                case 115: {
                    this.parent.setFinishReason("4");
                    this.fireEditingStopped(e);
                    break;
                }
                case 116: {
                    this.parent.setFinishReason("5");
                    this.fireEditingStopped(e);
                    break;
                }
                case 117: {
                    this.parent.setFinishReason("6");
                    this.fireEditingStopped(e);
                    break;
                }
                case 118: {
                    this.parent.setFinishReason("7");
                    this.fireEditingStopped(e);
                    break;
                }
                case 119: {
                    this.parent.setFinishReason("8");
                    this.fireEditingStopped(e);
                    break;
                }
                case 120: {
                    this.parent.setFinishReason("9");
                    this.fireEditingStopped(e);
                    break;
                }
                case 121: {
                    this.parent.setFinishReason("10");
                    this.fireEditingStopped(e);
                    break;
                }
                case 122: {
                    this.parent.setFinishReason("11");
                    this.fireEditingStopped(e);
                    break;
                }
                case 123: {
                    this.parent.setFinishReason("12");
                    this.fireEditingStopped(e);
                    break;
                }
                case 61440: {
                    this.parent.setFinishReason("13");
                    this.fireEditingStopped(e);
                    break;
                }
                case 61441: {
                    this.parent.setFinishReason("14");
                    this.fireEditingStopped(e);
                    break;
                }
                case 61442: {
                    this.parent.setFinishReason("15");
                    this.fireEditingStopped(e);
                    break;
                }
                case 61443: {
                    this.parent.setFinishReason("16");
                    this.fireEditingStopped(e);
                    break;
                }
                case 61444: {
                    this.parent.setFinishReason("17");
                    this.fireEditingStopped(e);
                    break;
                }
                case 61445: {
                    this.parent.setFinishReason("18");
                    this.fireEditingStopped(e);
                    break;
                }
                case 61446: {
                    this.parent.setFinishReason("19");
                    this.fireEditingStopped(e);
                    break;
                }
                case 61447: {
                    this.parent.setFinishReason("20");
                    this.fireEditingStopped(e);
                    break;
                }
                case 38: 
                case 40: {
                    if (this.editorComponent != this.editorComponentOrig && (this.editorComponent instanceof PicobolGrid || this.editorComponent instanceof PicobolListBox || this.editorComponent instanceof PicobolChoice || this.editorComponent instanceof PicobolScrollPane || this.editorComponent instanceof PicobolDateEntry)) break;
                    this.saveKeyEventLoc = e;
                    finishreasonval = this.parent.getExtendedFinishReason() ? (e.getKeyCode() == 38 ? -12 : -13) : -4;
                    this.parent.setFinishReason(String.valueOf(finishreasonval));
                    break;
                }
                case 33: 
                case 34: {
                    this.saveKeyEventLoc = e;
                    finishreasonval = this.parent.getExtendedFinishReason() ? (e.getKeyCode() == 33 ? -9 : -10) : -4;
                    this.parent.setFinishReason(String.valueOf(finishreasonval));
                    break;
                }
                case 27: {
                    break;
                }
                case 10: {
                    this.parent.setFinishReason(String.valueOf(-6));
                    break;
                }
                case 9: {
                    this.saveKeyEventLoc = e;
                    if (!this.parent.getExtendedFinishReason() && (this.jtf == null || (rbgc = this.jtf.getCellEditor(this.edColModel)) == null || rbgc.getComponent() != null)) break;
                    finishreasonval = -7;
                    if (this.parent.getExtendedFinishReason() && e.isShiftDown()) {
                        finishreasonval = -11;
                    }
                    this.parent.setFinishReason(String.valueOf(finishreasonval));
                }
            }
            if (e.getKeyCode() != 18 && e.getKeyCode() != 17 && this.jtf != null && (rbgc = this.jtf.getCellEditor(this.edColModel)) != null && rbgc.getComponent() == null) {
                this.saveKeyEventLoc = e;
                this.fireEditingStopped();
            }
        } else if (e.getKeyCode() == 9) {
            finishreasonval = -7;
            if (this.parent.getExtendedFinishReason() && e.isShiftDown()) {
                finishreasonval = -11;
            }
            this.parent.setFinishReason(String.valueOf(finishreasonval));
            this.saveKeyEventLoc = e;
            if (this.jtf != null && (rbgc = this.jtf.getCellEditor(this.edColModel)) != null && rbgc.getComponent() == null) {
                this.fireEditingStopped();
            }
        } else if (e.getKeyCode() == 10) {
            this.parent.setFinishReason(String.valueOf(-6));
            this.fireEditingStopped();
            e.consume();
        } else if ((e.getKeyCode() == 39 || e.getKeyCode() == 37) && this.jtf != null && (rbgc = this.jtf.getCellEditor(this.edColModel)) != null && rbgc.getComponent() != null && rbgc.usedToEdit() && (rbgc.usedToRender() || this.parent.getEditorShowAlways(this.edColModel))) {
            this.saveKeyEventLoc = e;
            finishreasonval = this.parent.getExtendedFinishReason() ? (e.getKeyCode() == 37 ? -14 : -15) : -4;
            this.parent.setFinishReason(String.valueOf(finishreasonval));
            this.fireEditingStopped(e);
        }
    }

    private void addMyEditorListener(JComponent jc) {
        jc.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                GridCellEditor.this.keytypedbody(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                GridCellEditor.this.keypressedbody(e);
            }
        });
    }

    private void addMyEditorListenerEF(JComponent jc) {
        jc.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                GridCellEditor.this.keypressedbody(e);
            }
        });
    }

    @Override
    protected void fireEditingCanceled() {
        if (this.editorComponent != this.editorComponentOrig) {
            this.editorComponent.setBorder(null);
        }
        super.fireEditingCanceled();
        this.saveKeyEventLoc = null;
        if (this.edRow >= 0) {
            int rr = this.parent.getAbsoluteRowNoHeaderModel(this.edRow);
            this.parent.sendRet(16394, this.edCol, this.edRow + this.parent.getNumColHeadings(), true);
        }
    }

    public void superfireEditingStopped(boolean always) {
        if (!always && this.editorComponent != this.editorComponentOrig) {
            this.editorComponent.setBorder(null);
        }
        super.fireEditingStopped();
        this.editorComponent = this.editorComponentOrig;
    }

    @Override
    protected void fireEditingStopped() {
        this.fireEditingStopped(null);
    }

    public void fireEditingStopped(Object correspondingevent) {
        if (this.editstate != 1) {
            return;
        }
        this.parent.disableKeyboard();
        if (this.jtf != null) {
            this.getCellEditorValue();
        }
        this.setState(2);
        int rr = this.parent.getModel().convertRowIndexToView(this.edRowmodel);
        if (this.saveKeyEventLoc != null) {
            if (this.saveKeyEventLoc.getKeyCode() != 127) {
                this.parent.sendRet(16393, this.edCol, rr + this.parent.getNumColHeadings(), true, true, this.saveKeyEventLoc);
            }
            this.saveKeyEventLoc = null;
        } else {
            this.parent.sendRet(16393, this.edCol, rr + this.parent.getNumColHeadings(), true, true, correspondingevent);
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.editstate != 1) {
            return this.jtf;
        }
        String value = null;
        RemoteBaseGUIControl rbgc = this.jtf.getCellEditor(this.edColModel);
        value = rbgc != null ? (rbgc instanceof RemoteDateEntry ? ((RemoteDateEntry)rbgc).getTextFormatted() : rbgc.getValue()) : ((JTextField)this.editorComponent).getText();
        this.jtf.setTextNoTrim(value);
        this.parent.gestEditorInsertionValue(this.jtf, this.edRow, this.edCol);
        return this.jtf;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        int cfwpos;
        int cfw = this.parent.prop_CURSOR_FRAME_WIDTH;
        int n = cfwpos = cfw > 0 ? cfw : cfw * -1 + 1;
        if (cfw == 0) {
            cfwpos = 1;
        }
        this.jtf = (GridCell)value;
        this.edRow = row;
        this.edRowmodel = this.parent.getModel().convertRowIndexToModel(this.edRow);
        this.edCol = column;
        this.edColModel = this.parent.getModel().convertColumnIndexToModel(this.edCol);
        RemoteBaseGUIControl rbgc = null;
        JComponent crbgc = null;
        MyDocument doc = this.getDocument();
        if (this.jtf != null && (rbgc = this.jtf.getCellEditor(this.edColModel)) != null && rbgc.getComponent() != null) {
            boolean always = this.parent.getEditorShowAlways(this.edColModel);
            boolean selectall = false;
            rbgc.setParentWindow(this.parent.parent.getParentWindowId());
            rbgc.setActiveAccept(true, null);
            crbgc = (JComponent)((Object)rbgc.getComponent());
            String txt = null;
            txt = ((GridCell)value).getTextBeginEntry();
            if (txt == null) {
                if (((GridCell)value).getText() != null) {
                    txt = new String(((GridCell)value).getText());
                    rbgc.putEditorValue(txt);
                    if (doc != null && doc.length(txt) > 0) {
                        selectall = true;
                        rbgc.setAction(7);
                    }
                } else {
                    rbgc.setValue("");
                }
            } else if (doc != null && doc.length(txt) == 1) {
                if (rbgc instanceof RemoteEntryField && rbgc.getProp(96) != null) {
                    rbgc.setProp(new Integer(59), "-1", 1);
                    rbgc.setProp(new Integer(216), txt, 1);
                    rbgc.setProp(new Integer(59), "2", 1);
                } else {
                    rbgc.setValue(txt);
                    rbgc.setProp(new Integer(59), "2", 1);
                }
            }
            ((GridCell)value).setTextBeginEntry(null);
            if (!always) {
                this.editorComponent = crbgc;
            }
            if (!rbgc.hasEditListeners()) {
                if (!(rbgc instanceof RemoteEntryField)) {
                    rbgc.getComponent().removeKeyListener(rbgc);
                }
                if (crbgc instanceof PicobolGrid) {
                    this.addMyEditorListener(((PicobolGrid)crbgc).getJTable());
                } else if (rbgc instanceof RemoteEntryField) {
                    this.addMyEditorListenerEF(crbgc);
                } else {
                    this.addMyEditorListener(crbgc);
                }
                rbgc.setHasEditListeners(true);
            }
            if ((this.contjp = this.jtf.getContjp()) != null) {
                this.jp = this.jtf.getJp();
            } else {
                this.createPanels();
                this.contjp.setFocusable(false);
            }
            int colwidth = 0;
            int colDividers = 1;
            colwidth = this.parent.getColWidth(column);
            colDividers = this.parent.getDividersCell((GridCell)value, column);
            int rowheightdata = this.parent.getRowHeightData(row);
            int uno = colwidth -= colDividers;
            int due = rowheightdata + this.parent.getRowHeightDividers();
            TableColumnModel tcm = this.parent.getJTable().getColumnModel();
            if (column + 1 < tcm.getColumnCount()) {
                uno += colDividers;
            } else {
                colwidth += colDividers - 1;
                colDividers = 1;
            }
            this.contjp.setBorder(null);
            this.contjp.setBounds(0, 0, uno, due);
            this.ddr.setSize(uno, due);
            this.contjp.setSize(this.ddr);
            this.contjp.setPreferredSize(this.ddr);
            this.contjp.setMinimumSize(this.ddr);
            this.contjp.setMaximumSize(this.ddr);
            this.jp.setBorder(null);
            this.jp.setBounds(0, 0, colwidth, rowheightdata);
            this.ddr.setSize(colwidth, rowheightdata);
            this.jp.setSize(this.ddr);
            this.jp.setPreferredSize(this.ddr);
            this.jp.setMaximumSize(this.ddr);
            this.jp.setMinimumSize(this.ddr);
            crbgc.setBorder(null);
            Dimension d = rbgc.getRendererSize();
            if (d == null) {
                crbgc.setBounds(0, 0, colwidth, rowheightdata);
                d = this.ddr;
            } else {
                this.ddr.setSize(d.width, d.height);
                this.align = this.parent.getAlignmentCell((GridCell)value, column);
                if (this.align != null) {
                    if (this.align.startsWith("R") || this.align.startsWith("r")) {
                        crbgc.setLocation(colwidth - d.width - cfwpos, rowheightdata / 2 - d.height / 2);
                    } else if (this.align.startsWith("L") || this.align.startsWith("l")) {
                        crbgc.setLocation(cfwpos + 5, rowheightdata / 2 - d.height / 2);
                    } else if (this.align.startsWith("C") || this.align.startsWith("c")) {
                        crbgc.setLocation(colwidth / 2 - d.width / 2 + cfwpos, rowheightdata / 2 - d.height / 2);
                    }
                } else {
                    crbgc.setLocation(cfwpos, rowheightdata / 2 - d.height / 2);
                }
            }
            crbgc.setSize(d);
            crbgc.setPreferredSize(d);
            crbgc.setMaximumSize(d);
            crbgc.setMinimumSize(d);
            Component[] cs = this.jp.getComponents();
            if (cs == null || cs.length == 0 || cs[0] != crbgc) {
                if (this.jp.getComponentCount() > 0) {
                    this.jp.remove(0);
                }
                this.jp.add((Component)crbgc, 0);
            }
            this.jp.setBackground(table.getBackground());
            if (always && !selectall && !rbgc.isBackgroundSet()) {
                crbgc.setBackground(table.getBackground());
            }
            ColorCmp acolor = null;
            if (!rbgc.isBackgroundSet() && !rbgc.isForegroundSet() && (acolor = this.parent.getCellColor((GridCell)value, row + this.parent.getNumColHeadings(), column, isSelected, true, false, false, false, false, row + this.parent.getNumColHeadings())) != null) {
                if (!rbgc.isForegroundSet() && acolor.isForegroundSet()) {
                    this.jp.setForeground(this.parent.getColor(ColorCmp.getRealColor(acolor.getForeground(), this.parent.getForeIntensity(acolor))));
                    crbgc.setForeground(this.parent.getColor(ColorCmp.getRealColor(acolor.getForeground(), this.parent.getForeIntensity(acolor))));
                }
                if (!rbgc.isBackgroundSet() && acolor.isBackgroundSet()) {
                    this.jp.setBackground(this.parent.getColor(ColorCmp.getRealColor(acolor.getBackground(), this.parent.getBackIntensity(acolor))));
                    crbgc.setBackground(this.parent.getColor(ColorCmp.getRealColor(acolor.getBackground(), this.parent.getBackIntensity(acolor))));
                }
            }
            if (!(acolor != null && acolor.isBackgroundSet() || rbgc.isBackgroundSet())) {
                boolean isbackuiresourceforbutton = false;
                Color uic = table.getBackground();
                boolean bl = isbackuiresourceforbutton = rbgc instanceof RemotePushButton && uic instanceof ColorUIResource && uic.getRed() == 255 && uic.getBlue() == 255 && uic.getGreen() == 255;
                if (isbackuiresourceforbutton) {
                    crbgc.setBackground(this.parent.getColor(ColorCmp.getRealColor(7, this.parent.getBackIntensity(acolor))));
                }
            }
            if ((acolor = this.parent.getColorDivider()) != null) {
                this.contjp.setBackground(this.parent.getColor(acolor.getForeground()));
            }
            if (cfw >= 0) {
                int cfwup = cfw;
                if (this.mborder == null || this.mbordersize != cfw) {
                    this.mborder = BorderFactory.createMatteBorder(cfwup, cfwup, cfw, cfw, Color.black);
                    this.mbordersize = cfw;
                }
                this.jp.setBorder(this.mborder);
                if (crbgc != null && rbgc != null && rbgc.getRendererSize() == null) {
                    if (crbgc instanceof AbstractButton) {
                        ((AbstractButton)crbgc).setBorderPainted(true);
                    }
                    crbgc.setBorder(this.mborder);
                }
            } else if (this.parent.prop_CURSOR_FRAME_WIDTH < 0) {
                if (this.cdborder == null || this.cdborder.getOfs() != this.parent.prop_CURSOR_FRAME_WIDTH) {
                    this.cdborder = this.parent.getGridViewSDefRenderer().getCellDottedBorder(cfw * -1);
                }
                this.jp.setBorder(this.cdborder);
                if (crbgc != null && rbgc != null && rbgc.getRendererSize() == null) {
                    if (crbgc instanceof AbstractButton) {
                        ((AbstractButton)crbgc).setBorderPainted(true);
                    }
                    crbgc.setBorder(this.cdborder);
                }
            }
            this.jtf.setContjp(this.contjp);
            this.jtf.setJp(this.jp);
            if (always) {
                this.editorComponent = this.contjp;
            }
            return this.contjp;
        }
        ColorCmp acolor = null;
        this.editorComponent = this.editorComponentOrig;
        if (this.editorComponent instanceof GridViewS.MyJTextFieldJP) {
            ((GridViewS.MyJTextFieldJP)this.editorComponent).setPasswordField(this.jtf != null && this.jtf.getSecure() > 0);
        }
        if ((acolor = this.parent.getCellColor((GridCell)value, row + this.parent.getNumColHeadings(), column, isSelected, true, false, false, false, false, row + this.parent.getNumColHeadings())) != null) {
            if (acolor.isForegroundSet()) {
                ((JTextField)this.editorComponent).setForeground(this.parent.getColor(ColorCmp.getRealColor(acolor.getForeground(), this.parent.getForeIntensity(acolor))));
            }
            if (acolor.isBackgroundSet()) {
                ((JTextField)this.editorComponent).setBackground(this.parent.getColor(ColorCmp.getRealColor(acolor.getBackground(), this.parent.getBackIntensity(acolor))));
            }
        } else {
            if (this.colorENTRYCELL == null || !this.colorENTRYCELL.isForegroundSet()) {
                ((JTextField)this.editorComponent).setForeground(table.getForeground());
            }
            if (this.colorENTRYCELL == null || !this.colorENTRYCELL.isBackgroundSet()) {
                ((JTextField)this.editorComponent).setBackground(table.getBackground());
            }
        }
        if ((this.contjp = this.jtf.getContjp()) != null) {
            this.jp = this.jtf.getJp();
        } else {
            this.createPanels();
        }
        this.contjp.setFocusable(true);
        if (this.editorComponent instanceof GridViewS.MyJTextField) {
            ((GridViewS.MyJTextField)this.editorComponent).setTextBeginEntry(null);
            ((GridViewS.MyJTextField)this.editorComponent).setText("");
            doc = (MyDocument)((GridViewS.MyJTextField)this.editorComponent).getDocument();
        } else if (this.editorComponent instanceof GridViewS.MyJTextFieldJP) {
            ((GridViewS.MyJTextFieldJP)this.editorComponent).setTextBeginEntry(null);
            ((GridViewS.MyJTextFieldJP)this.editorComponent).setText("");
            doc = (MyDocument)((GridViewS.MyJTextFieldJP)this.editorComponent).getDocument();
        }
        String txt = null;
        Object align = null;
        int go = -1;
        if (((GridCell)value).getTextBeginEntry() == null) {
            txt = ((GridCell)value).getText() != null ? new String(((GridCell)value).getText()) : new String("");
            this.parent.enableKeyboard();
            this.fireEvents = false;
            ((JTextField)this.editorComponent).setText(this.getTextAlign(txt, (GridCell)value, this.edColModel));
            this.fireEvents = true;
            if (!this.parent.getNoAutosel()) {
                ((JTextField)this.editorComponent).selectAll();
            }
        } else {
            txt = new String(((GridCell)value).getTextBeginEntry());
            ((GridCell)value).setTextBeginEntry(null);
            if (doc != null && doc.length(txt) == 1) {
                if (this.parent.charInInputFilter(this.jtf.getColumnModel(), txt.charAt(0)) == 1) {
                    txt = "";
                }
                if (txt.length() > 0) {
                    go = this.parent.charInDataType(this.edColModel, txt.charAt(0), 0, 0, true);
                }
            } else {
                go = 2;
            }
            if (txt.length() > 0) {
                if (go == 1) {
                    txt = " ";
                    Toolkit.getDefaultToolkit().beep();
                } else if (this.parent.charInDataTypeUpper(this.edColModel, 0, 0)) {
                    txt = Factory.toUpperCase(txt, this.parent.getUpperLowerMethod());
                } else if (this.parent.charInDataTypeLower(this.edColModel, 0, 0)) {
                    txt = Factory.toLowerCase(txt, this.parent.getUpperLowerMethod());
                } else if (this.parent.getGuiFactory().getGuiKdbUpper()) {
                    txt = Factory.toUpperCase(txt, this.parent.getUpperLowerMethod());
                } else if (this.parent.getGuiFactory().getGuiKdbLower()) {
                    txt = Factory.toLowerCase(txt, this.parent.getUpperLowerMethod());
                }
            }
            this.parent.enableKeyboard();
            if (doc != null && doc.length(txt) == 1 && txt.equalsIgnoreCase(" ")) {
                ((JTextField)this.editorComponent).setText("");
                ((JTextField)this.editorComponent).setCaretPosition(0);
            } else if (!this.fireEvents || go != 0) {
                if (this.editorComponent instanceof GridViewS.MyJTextField) {
                    ((GridViewS.MyJTextField)this.editorComponent).setTextBeginEntry(this.getTextAlign(txt, (GridCell)value, this.edColModel));
                } else if (this.editorComponent instanceof GridViewS.MyJTextFieldJP) {
                    ((GridViewS.MyJTextFieldJP)this.editorComponent).setTextBeginEntry(this.getTextAlign(txt, (GridCell)value, this.edColModel));
                } else {
                    ((JTextField)this.editorComponent).setText(this.getTextAlign(txt, (GridCell)value, this.edColModel));
                    ((JTextField)this.editorComponent).setCaretPosition(txt.length());
                }
            } else {
                ((JTextField)this.editorComponent).setText(this.getTextAlign(txt, (GridCell)value, this.edColModel));
                ((JTextField)this.editorComponent).setCaretPosition(txt.length());
            }
        }
        int rr = this.parent.getModel().convertRowIndexToModel(row);
        LocalFontCmp lfc = this.parent.getCellFont((GridCell)value, rr + this.parent.getNumColHeadings(), this.edColModel);
        if (rbgc == null || !rbgc.isFontSet()) {
            if (lfc != null && lfc.getFont() != null) {
                ((JTextField)this.editorComponent).setFont(lfc.getFont());
            } else if (table != null && table.getFont() != null) {
                ((JTextField)this.editorComponent).setFont(table.getFont());
            }
        }
        if (this.fireEvents && go == 0) {
            this.editstate = 1;
            this.parent.setFinishReason(String.valueOf(-8));
            this.fireEditingStopped();
            return null;
        }
        return this.editorComponent;
    }

    private String getTextAlign(String txt, GridCell value, int column) {
        String Return2 = null;
        String align = null;
        align = this.parent.getAlignmentCell(value, column);
        if (align != null) {
            if (align.startsWith("R") || align.startsWith("r")) {
                ((JTextField)this.editorComponent).setHorizontalAlignment(4);
                if (txt != null) {
                    Return2 = ScreenUtility.rightTrim(txt);
                }
            } else if (align.startsWith("L") || align.startsWith("l") || align.startsWith("H") || align.startsWith("h")) {
                ((JTextField)this.editorComponent).setHorizontalAlignment(2);
                if (txt != null) {
                    Return2 = ScreenUtility.rightTrim(txt);
                }
            } else if (align.startsWith("C") || align.startsWith("c")) {
                ((JTextField)this.editorComponent).setHorizontalAlignment(0);
                Return2 = ScreenUtility.rightTrim(txt);
            } else {
                ((JTextField)this.editorComponent).setHorizontalAlignment(10);
                Return2 = txt;
            }
            if (Return2 != null) {
                // empty if block
            }
        } else {
            ((JTextField)this.editorComponent).setHorizontalAlignment(10);
            Return2 = txt;
        }
        return Return2;
    }

    private JPopupMenu getDefaultPopup() {
        if (this.defaultPopup == null) {
            this.defaultPopup = new JPopupMenu();
            this.undo = new JMenuItem(Factory.getSysMsg("undo"));
            this.undo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GridCellEditor.this.um.canUndo()) {
                        GridCellEditor.this.um.undo();
                    }
                }
            });
            this.defaultPopup.add(this.undo);
            this.redo = new JMenuItem(Factory.getSysMsg("redo"));
            this.redo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GridCellEditor.this.um.canRedo()) {
                        GridCellEditor.this.um.redo();
                    }
                }
            });
            this.defaultPopup.add(this.redo);
            this.defaultPopup.addSeparator();
            this.cut = new JMenuItem(Factory.getSysMsg("cut"));
            this.cut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JTextField)GridCellEditor.this.editorComponentOrig).cut();
                }
            });
            this.defaultPopup.add(this.cut);
            this.copy = new JMenuItem(Factory.getSysMsg("copy"));
            this.copy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JTextField)GridCellEditor.this.editorComponentOrig).copy();
                }
            });
            this.defaultPopup.add(this.copy);
            this.paste = new JMenuItem(Factory.getSysMsg("paste"));
            this.paste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JTextField)GridCellEditor.this.editorComponentOrig).paste();
                }
            });
            this.defaultPopup.add(this.paste);
            this.delete = new JMenuItem(Factory.getSysMsg("delete"));
            this.delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JTextField)GridCellEditor.this.editorComponentOrig).replaceSelection("");
                }
            });
            this.defaultPopup.add(this.delete);
            this.defaultPopup.addSeparator();
            this.selectAll = new JMenuItem(Factory.getSysMsg("selectall"));
            this.selectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JTextField)GridCellEditor.this.editorComponentOrig).selectAll();
                }
            });
            this.defaultPopup.add(this.selectAll);
        }
        MyDocument doc = (MyDocument)((JTextField)this.editorComponentOrig).getDocument();
        int textLen = doc.length(((JTextField)this.editorComponentOrig).getText());
        boolean hasSel = ((JTextField)this.editorComponentOrig).getSelectionStart() != ((JTextField)this.editorComponentOrig).getSelectionEnd();
        boolean isEditable = ((JTextField)this.editorComponentOrig).isEditable();
        this.undo.setEnabled(isEditable && this.um.canUndo());
        this.redo.setEnabled(isEditable && this.um.canRedo());
        this.cut.setEnabled(isEditable && hasSel);
        this.copy.setEnabled(hasSel);
        this.paste.setEnabled(isEditable && GridCellEditor.canPaste());
        this.delete.setEnabled(isEditable && hasSel);
        this.selectAll.setEnabled(textLen > 0);
        return this.defaultPopup;
    }

    public static boolean canPaste() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard().getContents(JTextField.class).isDataFlavorSupported(DataFlavor.stringFlavor);
        }
        catch (IllegalStateException ise) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Object getCellEditorControl() {
        return this.jtf;
    }

    public void setCellEditorValue(String s) {
        RemoteBaseGUIControl rbgc = null;
        if (this.jtf != null && (rbgc = this.jtf.getCellEditor(this.edColModel)) != null) {
            rbgc.setValue(s);
        } else if (this.editorComponent != null && this.editorComponent == this.editorComponentOrig) {
            ((JTextField)this.editorComponent).setText(s);
        }
    }

    public void setState(int s) {
        this.editstate = s;
    }

    public int getState() {
        return this.editstate;
    }

    public void gorestoreCellValue() {
        if (this.jtf != null) {
            this.jtf.setText(this.restoreCellValue);
        }
    }

    public void setrestoreCellValue(String s) {
        this.restoreCellValue = s;
    }

    public int getRow() {
        return this.edRow;
    }

    public int getCol() {
        return this.edCol;
    }

    public void setCellEditorControl(GridCell o) {
        RemoteBaseGUIControl rbgced = null;
        if (this.jtf != null) {
            rbgced = this.jtf.getCellEditor(-1);
        }
        this.jtf = o;
        if (rbgced != null && this.jtf != null) {
            this.jtf.setCellEditor(rbgced);
        }
    }

    public void setCellEntryColor(ColorCmp c, int value, boolean isfb) {
        this.prop_CELL_ENTRY_COLOR = c == null ? -1 : value;
        this.colorENTRYCELL = c;
        this.isforeorback = isfb;
        if (this.colorENTRYCELL != null) {
            if (this.colorENTRYCELL.isForegroundSet()) {
                this.editorComponentOrig.setForeground(this.parent.getColor(ColorCmp.getRealColor(this.colorENTRYCELL.getForeground(), this.parent.getForeIntensity(this.colorENTRYCELL))));
            }
            if (this.colorENTRYCELL.isBackgroundSet()) {
                this.editorComponentOrig.setBackground(this.parent.getColor(ColorCmp.getRealColor(this.colorENTRYCELL.getBackground(), this.parent.getBackIntensity(this.colorENTRYCELL))));
            }
        }
    }

    public int getPropCellEntryColor() {
        if (!this.isforeorback) {
            return this.prop_CELL_ENTRY_COLOR;
        }
        return -1;
    }

    public int getPropColorBackground() {
        if (this.colorENTRYCELL == null || !this.colorENTRYCELL.isBackgroundSet()) {
            return -1;
        }
        return this.colorENTRYCELL.getBackground();
    }

    public int getPropColorForeground() {
        if (this.colorENTRYCELL == null || !this.colorENTRYCELL.isForegroundSet()) {
            return -1;
        }
        return this.colorENTRYCELL.getForeground();
    }

    public ColorCmp getCellEntryColor() {
        return this.colorENTRYCELL;
    }

    public Component getMyComponent() {
        return this.editorComponent;
    }

    @Override
    public Component getComponent() {
        return this.editorComponent;
    }

    public boolean focusonMyEditing() {
        return this.focusonMyEditing(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean focusonMyEditing(PicobolWidget jc) {
        if (this.editorComponent != null) {
            this.editorComponent.setFocusable(true);
        }
        if (this.editorComponent instanceof JPanel) {
            Component[] cs = this.editorComponent.getComponents();
            if (cs == null || cs.length <= 0 || cs[0] == null) return false;
            if (!(cs[0] instanceof Container)) return cs[0].requestFocusInWindow();
            Component[] cs1 = ((Container)cs[0]).getComponents();
            if (cs1 == null || cs1.length <= 0 || cs1[0] == null) return false;
            return cs1[0].requestFocusInWindow();
        }
        if (this.editorComponent != null) {
            return this.editorComponent.requestFocusInWindow();
        }
        if (jc == null) return false;
        return jc.requestFocusInWindow();
    }

    void setMaxTextBytes(boolean maxTextBytes) {
        this.maxTextBytes = maxTextBytes;
    }

    public void setDragComponent(OutDragListener odlistener) {
        if (this.editorComponentOrig != null && this.editorComponentOrig instanceof JTextComponent) {
            if (odlistener != null) {
                ((JTextComponent)this.editorComponentOrig).setDropMode(DropMode.INSERT);
                ((JTextComponent)this.editorComponentOrig).setDragEnabled(true);
                this.ftth = new FromToTransferHandler(odlistener, 1);
                ((JTextComponent)this.editorComponentOrig).setTransferHandler(this.ftth);
            } else {
                ((JTextComponent)this.editorComponentOrig).setDragEnabled(false);
                if (this.ftth != null) {
                    ((JTextComponent)this.editorComponentOrig).setTransferHandler(null);
                }
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                GridCellEditor.this.getDefaultPopup().show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                GridCellEditor.this.getDefaultPopup().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class MyDocument
    extends PlainDocument {
        GridCellEditor gce;
        private int byteLength;

        MyDocument(GridCellEditor gce) {
            this.gce = gce;
        }

        int length() {
            return GridCellEditor.this.parent != null && GridCellEditor.this.parent.getEncoding() != null && GridCellEditor.this.maxTextBytes ? this.byteLength : this.getLength();
        }

        int length(String str) {
            try {
                return GridCellEditor.this.parent != null && GridCellEditor.this.parent.getEncoding() != null && GridCellEditor.this.maxTextBytes ? str.getBytes(GridCellEditor.this.parent.getEncoding()).length : str.length();
            }
            catch (UnsupportedEncodingException e) {
                return str.length();
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (SwingUtilities.isEventDispatchThread()) {
                this.myremove(offs, len);
            } else {
                try {
                    new IsguiWorker(true, () -> {
                        try {
                            this.myremove(offs, len);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }).start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void myremove(int offs, int len) throws BadLocationException {
            if (GridCellEditor.this.parent.getEncoding() != null && GridCellEditor.this.maxTextBytes) {
                try {
                    this.byteLength -= this.getText(offs, len).getBytes(GridCellEditor.this.parent.getEncoding()).length;
                }
                catch (Exception e) {
                    this.byteLength -= len;
                }
            }
            this.mysuperremove(offs, len);
        }

        private void mysuperremove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
        }

        public void setAllText(String t) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.mysetAllText(t);
            } else {
                try {
                    new IsguiWorker(true, () -> this.mysetAllText(t)).start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void mysetAllText(String t) {
            try {
                this.mysuperremove(0, this.getLength());
                this.mysuperinsertString(0, t, null);
                if (GridCellEditor.this.parent.getEncoding() != null && GridCellEditor.this.maxTextBytes) {
                    try {
                        this.byteLength = t.getBytes(GridCellEditor.this.parent.getEncoding()).length;
                    }
                    catch (UnsupportedEncodingException e) {
                        this.byteLength = t.length();
                    }
                }
                ((JTextField)GridCellEditor.this.editorComponentOrig).setCaretPosition(this.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (SwingUtilities.isEventDispatchThread()) {
                this.myinsertString(offs, str, a);
            } else {
                try {
                    new IsguiWorker(true, () -> {
                        try {
                            this.myinsertString(offs, str, a);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }).start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void myinsertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String newStr = "";
            MyDocument doc = GridCellEditor.this.getDocument();
            if (!this.gce.fireEvents) {
                for (int i = 0; i < str.length(); ++i) {
                    char comp = str.charAt(i);
                    if (GridCellEditor.this.parent.charInInputFilter(GridCellEditor.this.jtf.getColumnModel(), comp) == 1) continue;
                    newStr = GridCellEditor.this.parent.charInDataTypeUpper(GridCellEditor.this.jtf.getColumnModel(), offs, offs) ? newStr + Character.toUpperCase(comp) : (GridCellEditor.this.parent.charInDataTypeLower(GridCellEditor.this.jtf.getColumnModel(), offs, offs) ? newStr + Character.toLowerCase(comp) : (GridCellEditor.this.parent.getGuiFactory().getGuiKdbUpper() ? newStr + Character.toUpperCase(comp) : (GridCellEditor.this.parent.getGuiFactory().getGuiKdbLower() ? newStr + Character.toLowerCase(comp) : newStr + comp)));
                }
                if (doc != null && doc.length(newStr) > 0) {
                    this.finalintinsertString(offs, newStr, a);
                }
                return;
            }
            boolean go = true;
            int ret = -1;
            int charlen = 0;
            int myoffs = this.byteLength;
            for (int i = 0; go && i < str.length(); ++i) {
                char comp = str.charAt(i);
                if (GridCellEditor.this.parent.charInInputFilter(GridCellEditor.this.jtf.getColumnModel(), comp) == 1) continue;
                charlen = doc.length(String.valueOf(comp));
                ret = GridCellEditor.this.parent.charInDataType(GridCellEditor.this.jtf.getColumnModel(), comp, myoffs, myoffs + charlen - 1, false);
                if (ret == 1) {
                    if (newStr.length() > 0) {
                        this.finalintinsertString(offs, newStr, a);
                    }
                    Toolkit.getDefaultToolkit().beep();
                    go = false;
                    throw new BadLocationException(null, myoffs);
                }
                newStr = GridCellEditor.this.parent.charInDataTypeUpper(GridCellEditor.this.jtf.getColumnModel(), myoffs += charlen, myoffs + charlen - 1) ? newStr + Character.toUpperCase(comp) : (GridCellEditor.this.parent.charInDataTypeLower(GridCellEditor.this.jtf.getColumnModel(), myoffs, myoffs + charlen - 1) ? newStr + Character.toLowerCase(comp) : (GridCellEditor.this.parent.getGuiFactory().getGuiKdbUpper() ? newStr + Character.toUpperCase(comp) : (GridCellEditor.this.parent.getGuiFactory().getGuiKdbLower() ? newStr + Character.toLowerCase(comp) : newStr + comp)));
            }
            if (newStr.length() > 0) {
                this.finalintinsertString(offs, newStr, a);
                if (this.gce.fireEvents && ret == 0) {
                    GridCellEditor.this.parent.setFinishReason(String.valueOf(-8));
                    GridCellEditor.this.fireEditingStopped();
                }
            }
        }

        private void finalintinsertString(int offs, String newStr, AttributeSet a) throws BadLocationException {
            if (GridCellEditor.this.parent.getEncoding() != null && GridCellEditor.this.maxTextBytes) {
                try {
                    this.byteLength += newStr.getBytes(GridCellEditor.this.parent.getEncoding()).length;
                }
                catch (UnsupportedEncodingException e) {
                    this.byteLength += newStr.length();
                }
            }
            this.mysuperinsertString(offs, newStr, a);
        }

        private void mysuperinsertString(int offs, String newStr, AttributeSet a) throws BadLocationException {
            super.insertString(offs, newStr, a);
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (SwingUtilities.isEventDispatchThread()) {
                this.mysuperreplace(offset, length, text, attrs);
            } else {
                try {
                    new IsguiWorker(true, () -> {
                        try {
                            this.mysuperreplace(offset, length, text, attrs);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }).start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void mysuperreplace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(offset, length, text, attrs);
        }
    }
}

