/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.GridCell;
import com.iscobol.gui.client.swing.GridConstant;
import com.iscobol.gui.client.swing.GridViewS;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.rts.Factory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class FilterJPanel
extends JPanel
implements GridConstant {
    private static final long serialVersionUID = 124L;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private int numcolmodel;
    private JPanel panelbutton;
    private JList list;
    private JButton filterok;
    private JButton close;
    private FilterListener listener;
    private CheckBoxListEntry cbMenuItem = null;
    private CheckBoxListEntry filterall = null;
    private CheckBoxListEntry[] filtercb = null;
    private boolean[] filtercbsaved = null;
    private Object[] distinctValues = null;
    private GridCell agc = null;
    private Vector objectshidden = null;
    private int filtertype = 0;
    private GuiFactoryImpl gf;
    private JScrollPane listScroller = null;

    public FilterJPanel(GuiFactoryImpl gf, int numcolmodel, GridCell agc, int filtertype) {
        this.numcolmodel = numcolmodel;
        this.agc = agc;
        this.filtertype = filtertype;
        this.gf = gf;
    }

    public void init() {
        KeyAdapter kl = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent k) {
                if (k.getKeyCode() == 27) {
                    if (FilterJPanel.this.filtertype == 2) {
                        FilterJPanel.this.restoreCbSaved();
                        FilterJPanel.this.listener.exitFilterJPanel(FilterJPanel.this.numcolmodel, false);
                    } else {
                        FilterJPanel.this.responseOnAction(true);
                    }
                }
            }
        };
        this.setLayout(new BorderLayout());
        this.panelbutton = new JPanel();
        SpringLayout springLayout = new SpringLayout();
        this.panelbutton.setLayout(springLayout);
        this.panelbutton.setPreferredSize(new Dimension(200, 50));
        this.list = new JList();
        this.list.setModel(new DefaultListModel());
        this.list.setCellRenderer(new CheckboxCellRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Object obj;
                int index = FilterJPanel.this.list.locationToIndex(e.getPoint());
                if (index != -1 && (obj = FilterJPanel.this.list.getModel().getElementAt(index)) instanceof JCheckBox) {
                    JCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = (JCheckBox)obj).isSelected());
                    if (checkbox == FilterJPanel.this.filterall) {
                        FilterJPanel.this.selectall(checkbox.isSelected());
                    } else if (checkbox.isSelected() && FilterJPanel.this.isAllSelected()) {
                        FilterJPanel.this.filterall.setSelected(true);
                    } else {
                        FilterJPanel.this.filterall.setSelected(false);
                    }
                    if (!checkbox.isSelected() && FilterJPanel.this.isAllDeselected()) {
                        FilterJPanel.this.filterok.setEnabled(false);
                    } else {
                        FilterJPanel.this.filterok.setEnabled(true);
                    }
                    FilterJPanel.this.repaint();
                }
            }
        });
        this.list.setSelectionMode(0);
        this.loadlist();
        this.listScroller = new JScrollPane(this.list);
        this.listScroller.setAlignmentX(0.0f);
        String text = this.gf.getMessages().getMessage("ok");
        StringBuffer sb = new StringBuffer(text);
        int c = ScreenUtility.getMnemonicChar(sb);
        text = sb.toString();
        this.filterok = new JButton(text);
        this.filterok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterJPanel.this.responseOnAction();
                if (FilterJPanel.this.listener != null) {
                    FilterJPanel.this.listener.sendfinishfiltermsg();
                }
            }
        });
        text = this.gf.getMessages().getMessage("cancel");
        sb = new StringBuffer(text);
        c = ScreenUtility.getMnemonicChar(sb);
        text = sb.toString();
        this.close = new JButton(text);
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterJPanel.this.filtertype == 2) {
                    FilterJPanel.this.restoreCbSaved();
                    if (FilterJPanel.this.listener != null) {
                        FilterJPanel.this.listener.exitFilterJPanel(FilterJPanel.this.numcolmodel, false);
                    }
                } else {
                    FilterJPanel.this.responseOnAction(true);
                }
            }
        });
        this.filterok.setMnemonic('f');
        this.close.setMnemonic('c');
        this.panelbutton.add(this.filterok);
        this.panelbutton.add(this.close);
        this.add((Component)this.listScroller, "Center");
        this.add((Component)this.panelbutton, "South");
        this.filterok.addKeyListener(kl);
        this.close.addKeyListener(kl);
        springLayout.putConstraint("East", (Component)this.close, -2, "East", (Component)this.panelbutton);
        springLayout.putConstraint("South", (Component)this.close, -2, "South", (Component)this.panelbutton);
        springLayout.putConstraint("North", (Component)this.filterok, 0, "North", (Component)this.close);
        springLayout.putConstraint("East", (Component)this.filterok, -2, "West", (Component)this.close);
    }

    public void loadlist() {
        if (this.distinctValues != null) {
            ((DefaultListModel)this.list.getModel()).clear();
        }
        if ((this.distinctValues = this.listener.getDistinctValues(this.numcolmodel)) == null) {
            return;
        }
        this.filtercb = new CheckBoxListEntry[this.distinctValues.length];
        this.filtercbsaved = new boolean[this.distinctValues.length];
        if (this.distinctValues.length > 0) {
            GridViewS.FilterElement fe = null;
            this.filterall = this.cbMenuItem = new CheckBoxListEntry(Factory.getSysMsg("All"), null);
            ((DefaultListModel)this.list.getModel()).addElement(this.cbMenuItem);
            this.filterall.setSelected(true);
            String title = "";
            int visibleselected = 0;
            for (int i = 0; i < this.distinctValues.length; ++i) {
                fe = (GridViewS.FilterElement)this.distinctValues[i];
                title = fe.text;
                this.filtercb[i] = this.cbMenuItem = new CheckBoxListEntry(title, fe.correspondingtext);
                this.filtercbsaved[i] = fe.state;
                this.cbMenuItem.setSelected(fe.state);
                if (!fe.visible) {
                    this.cbMenuItem.setForeground(Color.red);
                } else {
                    if (fe.state) {
                        ++visibleselected;
                    }
                    ((DefaultListModel)this.list.getModel()).addElement(this.cbMenuItem);
                }
                this.cbMenuItem.setVisible(fe.visible);
            }
            this.filterall.setSelected(visibleselected == this.distinctValues.length);
        }
    }

    private void selectall(boolean b) {
        CheckBoxListEntry cbtmp = null;
        for (int i = 0; i < this.filtercb.length; ++i) {
            cbtmp = this.filtercb[i];
            if (cbtmp == null) continue;
            cbtmp.setSelected(b);
        }
    }

    private void visibleall(boolean b) {
        CheckBoxListEntry cbtmp = null;
        for (int i = 0; i < this.filtercb.length; ++i) {
            cbtmp = this.filtercb[i];
            if (cbtmp == null) continue;
            cbtmp.setVisible(b);
        }
    }

    public boolean isAllSelected() {
        boolean Return2 = true;
        CheckBoxListEntry cbtmp = null;
        for (int i = 0; Return2 && i < this.filtercb.length; ++i) {
            cbtmp = this.filtercb[i];
            if (cbtmp == null || cbtmp == this.filterall) continue;
            Return2 = cbtmp.isSelected();
        }
        return Return2;
    }

    private boolean isAllDeselected() {
        boolean Return2 = false;
        CheckBoxListEntry cbtmp = null;
        for (int i = 0; !Return2 && i < this.filtercb.length; ++i) {
            cbtmp = this.filtercb[i];
            if (cbtmp == null) continue;
            Return2 = cbtmp.isSelected();
        }
        return !Return2;
    }

    private boolean changed() {
        boolean Return2 = false;
        if (this.filtercb == null && this.filtercbsaved == null) {
            return Return2;
        }
        if (this.filtercb.length != this.filtercbsaved.length) {
            Return2 = true;
        } else {
            CheckBoxListEntry cble = null;
            boolean cblesaved = false;
            for (int i = 0; !Return2 && i < this.filtercb.length; ++i) {
                cble = this.filtercb[i];
                cblesaved = this.filtercbsaved[i];
                if (cble == null || !cble.isVisible() || cble.isSelected() == cblesaved) continue;
                Return2 = true;
            }
        }
        return Return2;
    }

    public void restoreCbSaved() {
        CheckBoxListEntry cble = null;
        boolean cblesaved = false;
        boolean cblall = true;
        for (int i = 0; i < this.filtercb.length; ++i) {
            cble = this.filtercb[i];
            cblesaved = this.filtercbsaved[i];
            cble.setSelected(cblesaved);
            if (!cblall || cblesaved) continue;
            cblall = false;
        }
        this.filterall.setSelected(cblall);
    }

    public void reloadCbSaved() {
        CheckBoxListEntry cble = null;
        boolean cblesaved = false;
        for (int i = 0; i < this.filtercb.length; ++i) {
            cble = this.filtercb[i];
            cblesaved = this.filtercbsaved[i];
            this.filtercbsaved[i] = cble.isSelected();
        }
    }

    public boolean haveobjectshidden() {
        return this.objectshidden != null && this.objectshidden.size() > 0;
    }

    private void responseOnAction() {
        this.responseOnAction(false);
        if (this.listener != null) {
            this.listener.exitFilterJPanel(this.numcolmodel, !this.haveobjectshidden());
        }
    }

    public void responseOnAction(boolean exit) {
        boolean changed = this.changed();
        if (this.listener != null) {
            this.listener.repaintHeader();
            if (exit) {
                this.listener.exitFilterJPanel(this.numcolmodel, !this.haveobjectshidden());
            } else if (this.filterall != null && this.filterall.isSelected()) {
                this.listener.filterTextClear(this.numcolmodel, true, this.objectshidden);
            } else if (changed) {
                if (this.objectshidden != null) {
                    this.listener.filterTextClear(this.numcolmodel, this.objectshidden);
                } else {
                    if (this.filtertype != 2) {
                        this.reloadCbSaved();
                    }
                    this.objectshidden = this.listener.filter(this.numcolmodel, this.filtercb);
                    this.agc.setFilterableDialogOpen(!this.haveobjectshidden());
                }
            }
        }
    }

    public void setFilterListener(FilterListener fl) {
        this.listener = fl;
    }

    public FilterListener getFilterListener() {
        return this.listener;
    }

    public void clearFilter() {
        if (this.listener != null) {
            this.listener.clearFilterTextClear(this.numcolmodel, this.filtercb, this.objectshidden);
        }
    }

    public void reloadFilter2(int numcolmodel) {
        if (this.listener != null) {
            if (this.filterall.isSelected() && numcolmodel >= 0 && this.numcolmodel == numcolmodel) {
                this.selectall(true);
                this.visibleall(true);
                this.filterall.setSelected(true);
            }
            this.objectshidden = this.listener.filter(numcolmodel, this.filtercb);
        }
    }

    public void reloadFilter() {
        if (this.listener != null && this.filtercb != null && (!this.isAllDeselected() || this.filterall.isSelected())) {
            this.objectshidden = this.listener.filter(this.numcolmodel, this.filtercb);
        }
    }

    public CheckBoxListEntry[] getFiltercb() {
        return this.filtercb;
    }

    public void addObjectHidden(Object o) {
        if (this.objectshidden == null) {
            this.objectshidden = new Vector();
        }
        this.objectshidden.add(o);
    }

    public void destroy() {
        this.removeAll();
        this.panelbutton.removeAll();
        this.panelbutton = null;
        this.list.removeAll();
        this.list = null;
        this.filterok = null;
        this.close = null;
        this.listener = null;
        this.cbMenuItem = null;
        this.filterall = null;
        this.filtercb = null;
        this.filtercbsaved = null;
        this.distinctValues = null;
        if (this.objectshidden != null && this.objectshidden.size() > 0) {
            this.objectshidden.removeAllElements();
        }
        this.objectshidden = null;
    }

    public int getFilterType() {
        return this.filtertype;
    }

    public int getNumColModel() {
        return this.numcolmodel;
    }

    public void setFontFilterComponents(Font f) {
        this.setFont(f);
        this.filterall.setFont(f);
        this.filterok.setFont(f);
        this.panelbutton.setFont(f);
        this.list.setFont(f);
        this.listScroller.setFont(f);
        this.close.setFont(f);
        CheckBoxListEntry cbtmp = null;
        for (int i = 0; i < this.filtercb.length; ++i) {
            cbtmp = this.filtercb[i];
            if (cbtmp == null) continue;
            cbtmp.setFont(f);
        }
    }

    class CheckboxCellRenderer
    extends DefaultListCellRenderer {
        CheckboxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof CheckBoxListEntry) {
                CheckBoxListEntry checkbox = (CheckBoxListEntry)value;
                checkbox.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
                return checkbox;
            }
            return super.getListCellRendererComponent((JList<?>)list, value.getClass().getName(), index, isSelected, cellHasFocus);
        }
    }

    public class CheckBoxListEntry
    extends JCheckBox {
        private Object value;
        private String correspondingValue;

        public CheckBoxListEntry(Object itemValue, String correspondingValue) {
            super(correspondingValue != null ? correspondingValue : (itemValue == null ? "" : "" + itemValue));
            this.value = null;
            this.correspondingValue = null;
            this.setValue(itemValue);
        }

        @Override
        public boolean isSelected() {
            return super.isSelected();
        }

        @Override
        public void setSelected(boolean selected) {
            super.setSelected(selected);
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setCorrespondigValue(String correspondingValue) {
            this.correspondingValue = correspondingValue;
        }

        public String getOriginalText() {
            return this.value == null ? "" : "" + this.value;
        }
    }

    public static interface FilterListener {
        public Vector filter(int var1, CheckBoxListEntry[] var2);

        public Object[] getDistinctValues(int var1);

        public void filterTextClear(int var1, Vector var2);

        public void filterTextClear(int var1, boolean var2, Vector var3);

        public void exitFilterJPanel(int var1, boolean var2);

        public void clearFilterTextClear(int var1, CheckBoxListEntry[] var2, Vector var3);

        public void repaintHeader();

        public void sendfinishfiltermsg();
    }
}

