/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.docking.eleritec.DefaultDockingPort;
import com.iscobol.docking.eleritec.DockingPort;
import com.iscobol.docking.swingx.MultiSplitLayout;
import com.iscobol.docking.swingx.MultiSplitPane;
import com.iscobol.gui.client.swing.DockablePanel;
import com.iscobol.gui.client.swing.MainPanel;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

public class DockingPanel
extends MainPanel {
    private MultiSplitPane multiSplitPane;
    private MultiSplitLayout mspLayout;
    private Hashtable ports = new Hashtable();
    private DefaultDockingPort firstPort;
    private String dockLayout;
    private HashSet winList = new HashSet();
    DockablePanel focused;

    public DockingPanel(String l) {
        super(false);
        this.setDockLayout(l);
    }

    public DockingPanel(RemoteDisplayWindow dw, boolean b) {
        super(dw, b);
    }

    public DockingPanel(boolean b) {
        super(b);
    }

    void addDockable(DockablePanel dp) {
        this.winList.add(dp);
        dp.setFocused(true);
    }

    public void setDockLayout(String l) {
        this.dockLayout = l;
        this.init();
    }

    public String getDockLayout() {
        return MultiSplitLayout.getModel(this.mspLayout.getModel());
    }

    @Override
    public void setVisible(boolean b) {
        if (this.firstPort == null && b) {
            this.init();
        }
        super.setVisible(b);
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.multiSplitPane = new MultiSplitPane();
        this.mspLayout = this.multiSplitPane.getMultiSplitLayout();
        if (this.dockLayout != null) {
            this.mspLayout.setModel(MultiSplitLayout.parseModel(this.dockLayout));
        }
        ArrayList ls = new ArrayList();
        MultiSplitLayout.Node n = this.mspLayout.getModel();
        if (n != null) {
            DockingPanel.getLeaves(ls, n);
            for (MultiSplitLayout.Leaf lf : ls) {
                String name = lf.getName();
                DefaultDockingPort port = new DefaultDockingPort(name);
                this.ports.put(name, port);
                this.multiSplitPane.add((Component)port, name);
                if (this.firstPort != null) continue;
                this.firstPort = port;
            }
        }
        if (this.firstPort == null) {
            this.firstPort = new DefaultDockingPort("");
            this.ports.put("", this.firstPort);
            this.multiSplitPane.add((Component)this.firstPort, "");
        }
        this.add((Component)this.multiSplitPane, "Center");
    }

    public DockingPort getPort(String name) {
        DockingPort Return2 = (DockingPort)this.ports.get(name);
        if (Return2 == null) {
            Return2 = this.firstPort;
        }
        return Return2;
    }

    private static void getLeaves(List v, MultiSplitLayout.Node root) {
        if (root instanceof MultiSplitLayout.Split) {
            MultiSplitLayout.Split split = (MultiSplitLayout.Split)root;
            for (MultiSplitLayout.Node child : split.getChildren()) {
                DockingPanel.getLeaves(v, child);
            }
        } else if (root instanceof MultiSplitLayout.Leaf) {
            v.add(root);
        }
    }

    private List getLeaves() {
        ArrayList Return2 = new ArrayList();
        MultiSplitLayout.Node n = this.mspLayout.getModel();
        if (n != null) {
            DockingPanel.getLeaves(Return2, n);
        }
        return Return2;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setLayoutManager(String type, String defaults) {
    }

    public void unsetLayoutManager() {
    }

    @Override
    public LayoutManager getLayout() {
        return null;
    }
}

