/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.client.swing.CobolEvent;
import com.iscobol.gui.client.swing.CobolEventListener;
import com.iscobol.gui.client.swing.SearchKeyEventListener;
import java.net.URL;
import java.util.Vector;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;

public class DesktopWebBrowser
extends WebBrowser
implements WebBrowserListener,
Constants {
    private Vector listeners = new Vector();
    private boolean busy;
    private URL nextURL;
    private String statusText = "";
    private boolean nomsgbeforenavigate = false;
    private String progress = "";

    public DesktopWebBrowser() {
        super(false);
        this.addWebBrowserListener(this);
    }

    protected DesktopWebBrowser(URL url) {
        super(url, false);
        this.addWebBrowserListener(this);
    }

    public void addCobolEventListener(CobolEventListener cel) {
        this.listeners.addElement(cel);
    }

    public void removeCobolEventListener(CobolEventListener cel) {
        this.listeners.removeElement(cel);
    }

    public void addSearchKeyEventListener(SearchKeyEventListener skl) {
    }

    public void removeSearchKeyEventListener(SearchKeyEventListener skl) {
    }

    private void pushEvent(int cobev) {
        CobolEvent ce = new CobolEvent(this, 7, cobev);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            try {
                ((CobolEventListener)this.listeners.elementAt(i)).cobolEvent(ce);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean willOpenURL(URL url) {
        if (!this.nomsgbeforenavigate && this.nextURL == null) {
            this.nextURL = url;
            this.busy = true;
            this.pushEvent(16429);
            return false;
        }
        return super.willOpenURL(url);
    }

    public void doOpenURL() {
        if (this.nextURL != null) {
            this.setURL(this.nextURL);
        }
    }

    public void abortOpenURL() {
        this.nextURL = null;
        this.busy = false;
    }

    public URL getURL() {
        return this.nextURL == null ? super.getURL() : this.nextURL;
    }

    public void initializationCompleted(WebBrowserEvent event) {
    }

    public void documentCompleted(WebBrowserEvent event) {
        this.busy = false;
        this.nextURL = null;
        this.pushEvent(16430);
    }

    public void downloadCompleted(WebBrowserEvent event) {
        this.pushEvent(16432);
    }

    public void downloadError(WebBrowserEvent event) {
        this.pushEvent(16432);
    }

    public void downloadProgress(WebBrowserEvent event) {
        this.progress = event.getData();
        this.pushEvent(16433);
    }

    public void downloadStarted(WebBrowserEvent event) {
        this.pushEvent(16431);
    }

    public void statusTextChange(WebBrowserEvent event) {
        this.statusText = event.getData();
        this.pushEvent(16434);
    }

    public void windowClose(WebBrowserEvent event) {
    }

    public void titleChange(WebBrowserEvent event) {
        this.pushEvent(16435);
    }

    public boolean isBusy() {
        return this.busy;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getProgress() {
        return this.progress;
    }

    public void setNoMsgBeforeNavigate(boolean b) {
        this.nomsgbeforenavigate = b;
    }
}

