/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.MultilineLabel;
import com.iscobol.gui.client.swing.PicobolLabel;
import com.iscobol.gui.client.swing.PicobolMultilineLabel;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import java.awt.AWTEvent;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class CompositeLabel
extends JComponent
implements PicobolWidget,
Accessible {
    private PicobolMultilineLabel mylabel;
    private PicobolLabel label;
    private CardLayout layout;
    private PicobolWidget shownLabel;
    private boolean vertical;
    private String text;
    private boolean noKeyLetter;
    private boolean left;
    private boolean right;
    private boolean center;
    private final boolean alwaysShowPicobolLabel;
    private final Color disabledTextColor;
    private boolean enabled = true;
    private Color foreground;

    public CompositeLabel(boolean alwaysShowPicobolLabel) {
        this.alwaysShowPicobolLabel = alwaysShowPicobolLabel;
        Color c = UIManager.getColor("Label.disabledForeground");
        if (c == null) {
            c = UIManager.getColor("Label.disabledText");
        }
        this.disabledTextColor = c;
        this.layout = new CardLayout(0, 0);
        this.label = new PicobolLabel();
        if (this.alwaysShowPicobolLabel) {
            this.label.setMultiline(true);
        }
        this.mylabel = new PicobolMultilineLabel();
        this.foreground = this.label.getForeground();
        this.setLayout(this.layout);
        this.add((Component)this.mylabel, "mylabel");
        this.add((Component)this.label, "label");
        if (this.alwaysShowPicobolLabel) {
            this.showPicobolLabel();
        } else {
            this.showMultilineLabel();
        }
    }

    public void showPicobolLabel() {
        this.layout.show(this, "label");
        this.shownLabel = this.label;
    }

    public void showMultilineLabel() {
        this.layout.show(this, "mylabel");
        this.shownLabel = this.mylabel;
    }

    private boolean shouldShowPicobolLabel() {
        return this.alwaysShowPicobolLabel || this.vertical || this.text != null && RemoteBaseGUIControl.isHtml(this.text);
    }

    public void setVertical(boolean v) {
        boolean b = this.shouldShowPicobolLabel();
        this.vertical = v;
        this.updateShownLabel(b);
        this.label.setVertical(v);
    }

    private void updateShownLabel(boolean b) {
        if (b != this.shouldShowPicobolLabel()) {
            if (b) {
                this.showMultilineLabel();
            } else {
                this.showPicobolLabel();
            }
        }
    }

    public void setTop(boolean v) {
        boolean b = this.shouldShowPicobolLabel();
        this.vertical = v;
        this.updateShownLabel(b);
        this.label.setTop(v);
    }

    public void setBottom(boolean v) {
        boolean b = this.shouldShowPicobolLabel();
        this.vertical = v;
        this.updateShownLabel(b);
        this.label.setBottom(v);
    }

    public void setCentered(boolean v) {
        this.center = v;
        this.label.setCentered(v);
        this.mylabel.setTextAlignment(v ? 0 : 2);
    }

    public void setLeft(boolean v) {
        this.left = v;
        this.label.setLeft(v);
        this.mylabel.setTextAlignment(2);
    }

    public void setRight(boolean v) {
        this.right = v;
        this.label.setRight(v);
        this.mylabel.setTextAlignment(v ? 4 : 2);
    }

    public void setTransparent(boolean t) {
        this.label.setTransparent(t);
        this.mylabel.setTransparent(t);
    }

    public void setTitle(String t) {
        boolean b = this.shouldShowPicobolLabel();
        this.text = t;
        this.updateShownLabel(b);
        if (t != null && (this.right || this.center || this.left)) {
            t = CompositeLabel.mytrim(t);
        }
        this.label.setTitle(t);
        this.mysetTitle(t);
    }

    private void mysetTitle(String t) {
        if (t == null) {
            t = "";
        }
        int mnemonicIndex = -1;
        if (!this.noKeyLetter) {
            StringBuffer sb = new StringBuffer(t);
            mnemonicIndex = ScreenUtility.getMnemonicIdx(sb);
            t = sb.toString();
        }
        this.mylabel.setText(t);
        this.mylabel.setMnemonicIndex(mnemonicIndex);
    }

    public void setNoKeyLetter(boolean b) {
        this.noKeyLetter = b;
        this.label.setNoKeyLetter(b);
        String t = this.text;
        if (t != null && (this.right || this.center || this.left)) {
            t = CompositeLabel.mytrim(t);
        }
        this.mysetTitle(t);
    }

    private static String mytrim(String s) {
        int i;
        int j = s.length();
        for (i = 0; i < j && s.charAt(i) == ' '; ++i) {
        }
        --j;
        while (j > i && s.charAt(j) == ' ') {
            --j;
        }
        return s.substring(i, j + 1);
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public PicobolLabel getPicobolLabel() {
        return this.label;
    }

    public MultilineLabel getMultilineLabel() {
        return this.mylabel;
    }

    @Override
    public void setActiveAccept(boolean b) {
        this.shownLabel.setActiveAccept(b);
    }

    @Override
    public boolean getActiveAccept() {
        return this.shownLabel.getActiveAccept();
    }

    @Override
    public void setSelfAct(boolean b) {
    }

    @Override
    public boolean getSelfAct() {
        return false;
    }

    @Override
    public void asyncProcessEvent(AWTEvent e) {
        this.shownLabel.asyncProcessEvent(e);
    }

    public void setBorder(boolean t) {
        super.setBorder(t ? BorderFactory.createLineBorder(Color.black) : null);
        this.label.updateAlignment();
    }

    @Override
    public void setEnabled(boolean e) {
        if (this.label != null) {
            if (e != this.enabled) {
                this.enabled = e;
                this.label.setEnabled(e);
                this.mylabel.setEnabled(e);
                if (e) {
                    this.label.setForeground(this.foreground);
                    this.mylabel.setForeground(this.foreground);
                } else {
                    this.label.setForeground(this.disabledTextColor);
                    this.mylabel.setForeground(this.disabledTextColor);
                }
            }
        } else {
            super.setEnabled(e);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.label != null) {
            this.label.setBackground(c);
            this.mylabel.setBackground(c);
        }
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.label != null) {
            this.foreground = c;
            if (this.enabled) {
                this.label.setForeground(c);
                this.mylabel.setForeground(c);
            }
        }
    }

    @Override
    public void setFont(Font f) {
        Font old = super.getFont();
        if (old != null && f != null && old.getName() == f.getName() && old.getStyle() == f.getStyle() && old.getSize() == f.getSize()) {
            return;
        }
        super.setFont(f);
        if (this.label != null) {
            this.label.setFont(f);
            this.mylabel.setFont(f);
        }
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        if (this.label != null) {
            this.label.addMouseListener(ml);
            this.mylabel.addMouseListener(ml);
        } else {
            super.addMouseListener(ml);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener ml) {
        if (this.label != null) {
            this.label.addMouseMotionListener(ml);
            this.mylabel.addMouseMotionListener(ml);
        } else {
            super.addMouseMotionListener(ml);
        }
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        if (this.label != null) {
            this.label.removeMouseListener(ml);
            this.mylabel.removeMouseListener(ml);
        } else {
            super.removeMouseListener(ml);
        }
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener ml) {
        if (this.label != null) {
            this.label.removeMouseMotionListener(ml);
            this.mylabel.removeMouseMotionListener(ml);
        } else {
            super.removeMouseMotionListener(ml);
        }
    }

    @Override
    public void setToolTipText(String ttt) {
        if (this.label != null) {
            this.label.setToolTipText(ttt);
            this.mylabel.setToolTipText(ttt);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.shownLabel != null) {
            return this.shownLabel.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCompositeLabel();
        }
        return this.accessibleContext;
    }

    private class AccessibleCompositeLabel
    extends JComponent.AccessibleJComponent {
        private AccessibleCompositeLabel() {
            super(CompositeLabel.this);
        }

        @Override
        public String getAccessibleName() {
            String name = this.accessibleName;
            if (name == null) {
                name = (String)CompositeLabel.this.getClientProperty("AccessibleName");
            }
            if (name == null) {
                name = CompositeLabel.this.text;
            }
            if (name == null) {
                name = super.getAccessibleName();
            }
            return name;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            return null;
        }

        @Override
        public AccessibleText getAccessibleText() {
            return null;
        }

        @Override
        public String getToolTipText() {
            return CompositeLabel.this.label != null ? CompositeLabel.this.label.getToolTipText() : null;
        }

        @Override
        public String getTitledBorderText() {
            return null;
        }

        @Override
        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }
    }
}

