/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.spellchecker;

import com.iscobol.gui.client.spellchecker.Span;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;

public class SpellChecker {
    public static final int MISSPELLING;
    private static final boolean isSupported;
    private static final Method languages_getLanguageForShortName;
    private static final Constructor jlanguagetool;
    private static final Method jlanguagetool_check;
    private static final Method rulematch_getFromPos;
    private static final Method rulematch_getToPos;
    private static final Method rulematch_getShortMessage;
    private static final Method rulematch_getMessage;
    private static final Method rulematch_getSuggestedReplacements;
    private static final Method rulematch_getRule;
    private static final Method rule_getLocQualityIssueType;
    private static final Map languageTools;
    private static final Object defaultLanguage;

    private SpellChecker() {
    }

    public static boolean isSupported() {
        return isSupported;
    }

    public static Span[] check(String text, String language) throws Exception {
        Object languageTool;
        if (!isSupported) {
            throw new Exception("Spell checking not supported!");
        }
        if ("default".equals(language)) {
            languageTool = defaultLanguage;
        } else {
            languageTool = languageTools.get(language);
            if (languageTool == null) {
                Object lan = languages_getLanguageForShortName.invoke(null, language);
                languageTool = jlanguagetool.newInstance(lan);
                languageTools.put(language, languageTool);
            }
        }
        List result = (List)jlanguagetool_check.invoke(languageTool, text);
        Span[] Return2 = new Span[result.size()];
        int i = 0;
        Object[] noargs = new Object[]{};
        ListIterator lit = result.listIterator();
        while (lit.hasNext()) {
            Object elem = lit.next();
            int fromPos = (Integer)rulematch_getFromPos.invoke(elem, noargs);
            int toPos = (Integer)rulematch_getToPos.invoke(elem, noargs);
            String msg = (String)rulematch_getShortMessage.invoke(elem, noargs);
            String desc = (String)rulematch_getMessage.invoke(elem, noargs);
            if (msg == null || msg.length() == 0) {
                msg = desc;
            }
            List repl = (List)rulematch_getSuggestedReplacements.invoke(elem, noargs);
            Object rule = rulematch_getRule.invoke(elem, noargs);
            int lqi = ((Enum)rule_getLocQualityIssueType.invoke(rule, noargs)).ordinal();
            Return2[i] = new Span(fromPos, toPos, msg, desc, repl, lqi);
            ++i;
        }
        return Return2;
    }

    static {
        languageTools = new HashMap();
        Method getLanguageForShortName = null;
        Constructor<?> jlantool = null;
        Method check = null;
        Method getFromPos = null;
        Method getToPos = null;
        Method getShortMessage = null;
        Method getMessage = null;
        Method getSuggestedReplacements = null;
        Method getRule = null;
        Method getLocQualityIssueType = null;
        Object defLanTool = null;
        int mp = -1;
        boolean isSupp = false;
        try {
            Class<?> languagesc = Class.forName("org.languagetool.Languages");
            try {
                getLanguageForShortName = languagesc.getMethod("getLanguageForShortName", String.class);
            }
            catch (NoSuchMethodException ex) {
                getLanguageForShortName = languagesc.getMethod("getLanguageForShortCode", String.class);
            }
            Method getLanguageForLocale = languagesc.getMethod("getLanguageForLocale", Locale.class);
            Object defLan = getLanguageForLocale.invoke(null, Locale.getDefault());
            Class<?> languagec = Class.forName("org.languagetool.Language");
            Class<?> jlanguagetoolc = Class.forName("org.languagetool.JLanguageTool");
            jlantool = jlanguagetoolc.getConstructor(languagec);
            defLanTool = jlantool.newInstance(defLan);
            check = jlanguagetoolc.getMethod("check", String.class);
            Class<?> rulematch = Class.forName("org.languagetool.rules.RuleMatch");
            getFromPos = rulematch.getMethod("getFromPos", new Class[0]);
            getToPos = rulematch.getMethod("getToPos", new Class[0]);
            getShortMessage = rulematch.getMethod("getShortMessage", new Class[0]);
            getMessage = rulematch.getMethod("getMessage", new Class[0]);
            getSuggestedReplacements = rulematch.getMethod("getSuggestedReplacements", new Class[0]);
            getRule = rulematch.getMethod("getRule", new Class[0]);
            Class<?> rule = Class.forName("org.languagetool.rules.Rule");
            getLocQualityIssueType = rule.getMethod("getLocQualityIssueType", new Class[0]);
            Class<?> itsissuetype = Class.forName("org.languagetool.rules.ITSIssueType");
            Field misspelling = itsissuetype.getField("Misspelling");
            mp = ((Enum)misspelling.get(null)).ordinal();
            isSupp = true;
        }
        catch (Throwable t) {
            new Exception("Spell checking not supported!", t).printStackTrace();
        }
        languages_getLanguageForShortName = getLanguageForShortName;
        jlanguagetool = jlantool;
        jlanguagetool_check = check;
        rulematch_getFromPos = getFromPos;
        rulematch_getToPos = getToPos;
        rulematch_getMessage = getMessage;
        rulematch_getShortMessage = getShortMessage;
        rulematch_getSuggestedReplacements = getSuggestedReplacements;
        rulematch_getRule = getRule;
        rule_getLocQualityIssueType = getLocQualityIssueType;
        MISSPELLING = mp;
        defaultLanguage = defLanTool;
        isSupported = isSupp;
    }
}

