/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.AWTEvent;
import charva.awt.event.FocusEvent;
import charva.awt.event.FocusListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.KeyListener;
import charva.awt.event.MouseEvent;
import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.charva.GuiFactoryImpl;
import com.iscobol.gui.client.charva.MyKeyEvent;
import com.iscobol.gui.client.charva.PicobolTextEvent;
import com.iscobol.gui.client.charva.PicobolTextListener;
import com.iscobol.gui.client.charva.PicobolWidget;
import com.iscobol.gui.client.charva.Terminal;
import com.iscobol.gui.client.charva.TerminalModel;
import com.iscobol.rts.Factory;

public class TerminalAccept
extends Component
implements PicobolWidget,
KeyListener,
FocusListener {
    private static final char UNDERSCORE_CHAR = '_';
    private static final long NOT_SET = 0xFFFFFFFFFFFFFFFL;
    private final boolean alphaAutoClear;
    private final boolean numericAutoClear;
    private final boolean editedFormatted;
    private final boolean updateFromScreen;
    private final boolean cl2endFillSpaces;
    private final int[] dataRange;
    private String undo;
    private InpData inp = new InpData();
    private Terminal tt;
    private TerminalModel tm;
    private int col;
    private int line;
    private int length;
    private Dimension size;
    private boolean isNumeric;
    private int attr;
    private boolean autoTermination;
    private PicobolTextListener listener;
    private boolean activeAccept;
    private boolean update;
    private boolean prompt;
    private char promptChar;
    private boolean upper;
    private boolean lower;
    private boolean full;
    private boolean required;
    private boolean zeroFill;
    private long savebackcolor = 0xFFFFFFFFFFFFFFFL;
    private long savetermattr = 0xFFFFFFFFFFFFFFFL;
    private Justification just;
    private GuiFactoryImpl gf;
    private char promptCharOrig;
    private boolean promptAll;
    private String promptAllStr;
    private int taMaxIdx;
    private final boolean noAutoClear;
    private final int upperLowerMethod;
    private boolean compilerOptionCR;
    public boolean dorepaint = true;

    private static final boolean isEditing(char c) {
        switch (c) {
            case '+': 
            case '-': 
            case '9': 
            case 'Z': {
                return false;
            }
        }
        return true;
    }

    public TerminalAccept(GuiFactoryImpl gf) {
        String[] ss;
        this.promptCharOrig = this.promptChar = gf.getCsProperty().get("iscobol.terminal.screen_prompt", '_');
        this.promptAllStr = gf.getCsProperty().get("iscobol.terminal.screen_prompt_all", "");
        if (this.promptAllStr != null && (this.promptAllStr.equalsIgnoreCase("YES") || this.promptAllStr.equalsIgnoreCase("PROTECTED"))) {
            this.promptAll = true;
        }
        this.alphaAutoClear = gf.getCsProperty().get("iscobol.terminal.alpha_autoclear", false);
        this.noAutoClear = gf.getCsProperty().get("iscobol.terminal.no_autoclear", false);
        this.numericAutoClear = gf.getCsProperty().get("iscobol.terminal.numeric_autoclear", true);
        this.editedFormatted = gf.getCsProperty().get("iscobol.terminal.edited_formatted", false);
        this.updateFromScreen = gf.getCsProperty().get("iscobol.terminal.update_from_screen", false);
        this.cl2endFillSpaces = gf.getCsProperty().get("iscobol.terminal.cl2end_fill_spaces", false);
        this.upperLowerMethod = gf.getUpperLowerMethod();
        String s = gf.getCsProperty().get("iscobol.terminal.data_range", null);
        int[] dr = null;
        if (s != null && (ss = s.split("\\,")).length > 0) {
            if (ss.length == 1) {
                try {
                    dr = new int[]{Integer.parseInt(ss[0]), Integer.MAX_VALUE};
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    dr = new int[]{Integer.parseInt(ss[0]), Integer.parseInt(ss[1])};
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.dataRange = dr;
        this.gf = gf;
    }

    public void repaint() {
        this.repaint(true);
    }

    private void repaint(boolean cursorOn) {
        if (this.tm != null) {
            if (cursorOn && this.isVisible()) {
                if (this.inp.isAtEnd()) {
                    this.tm.setCaretAt(this.col + this.inp.col - 1, this.line, this);
                } else {
                    this.tm.setCaretAt(this.col + this.inp.col, this.line, this);
                }
            } else {
                this.tm.unsetCaret(this);
            }
        }
        if (this.tt != null && this.dorepaint) {
            this.tt.repaint();
        }
        this.dorepaint = true;
    }

    public void display() {
        this.display(this.promptAll, true);
    }

    public void display(boolean prmpt) {
        this.display(prmpt, true);
    }

    public void display(boolean prmpt, boolean changeattr) {
        if (this.length == 0) {
            return;
        }
        this.tm.move(this.col, this.line);
        if (changeattr) {
            this.tm.setAttr(this.attr);
            this.tm.setBackColor(this.getBackground());
            this.tm.setForeColor(this.getForeground());
        }
        char[] data = this.compilerOptionCR ? this.inp.getDataCompilerOptionCR() : (this.just != null && !prmpt && (!this.noAutoClear || this.update) ? this.just.get(this.inp.getData(this.prompt & prmpt)) : this.inp.getData(this.prompt & prmpt));
        this.taMaxIdx = Math.max(this.taMaxIdx, this.inp.idx);
        if (this.noAutoClear && !this.update && this.taMaxIdx < data.length) {
            char[] c = this.tm.getTextAt(this.line, this.col + this.taMaxIdx, data.length - this.taMaxIdx);
            System.arraycopy(c, 0, data, this.taMaxIdx, c.length);
        }
        this.tm.addstr(data);
        this.repaint(prmpt);
    }

    public void setPicture(String p, boolean dpc) {
        if (this.inp != null) {
            this.inp.setPicture(p, dpc);
        }
    }

    public void initializerowcol(int c, int l) {
        this.col = c;
        this.line = l;
    }

    public void initialize(Terminal t, int c, int l, String iniVal, int ll, String pict, boolean decPointComma) {
        this.col = c;
        this.line = l;
        this.length = ll;
        this.tt = t;
        this.tm = t.getTerminalModel();
        int tmWidth = this.tm.getWidth();
        int len = this.col + ll <= tmWidth ? ll : (tmWidth > this.col ? tmWidth - this.col : 0);
        this.size = len == 0 ? new Dimension(1, this.tm.getCharDim().height) : new Dimension(this.tm.getCharDim().width * len, this.tm.getCharDim().height);
        this.inp.setLen(len);
        this.inp.setPicture(pict, decPointComma);
        if (this.updateFromScreen) {
            iniVal = this.tm.acceptFromScreen(this.line + 1, this.col + 1, len);
        }
        if (iniVal != null && iniVal.length() >= 0) {
            this.undo = iniVal;
            this.inp.setValue(this.undo);
        }
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void keyPressed(KeyEvent e) {
        this.keyPressed(e, true);
    }

    public void keyPressed(KeyEvent e, boolean internalcall) {
        if (this.length == 0) {
            return;
        }
        int keyCode = e.getKeyCode();
        if (keyCode == 12) {
            Toolkit.getDefaultToolkit().redrawWin();
            Toolkit.getDefaultToolkit().sync();
            return;
        }
        if (keyCode == 24) {
            this.inp.clear();
            this.display(true);
            return;
        }
        if (keyCode == 26) {
            this.inp.clear();
            this.inp.setValue(this.undo);
            this.display(true);
            return;
        }
        if (keyCode >= 1 && keyCode <= 26) {
            return;
        }
        MyKeyEvent eawt = new MyKeyEvent();
        eawt.setKeyChar(e.getKeyChar());
        eawt.setKeyCode(e.getKeyCode());
        int cobFun = this.gf.getMyRemoteVirtualKeyboard().mapKey(eawt, e.getKeyCode());
        int editingvalue = VirtualKeyboard.editing(cobFun);
        switch (editingvalue) {
            case 65536: {
                this.resetInsMode();
                if (internalcall && this.listener.getFirstLast(e)) break;
                if (this.inp.home()) {
                    this.repaint();
                    break;
                }
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 131072: {
                this.resetInsMode();
                if (internalcall && this.listener.getFirstLast(e)) break;
                if (this.inp.end()) {
                    this.repaint();
                    break;
                }
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 851968: {
                this.toggleInsMode();
                this.repaint();
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 720896: {
                boolean b;
                if (this.isNumeric && !this.numericAutoClear) {
                    b = this.inp.delNnac();
                } else {
                    this.inp.delcur();
                    b = true;
                }
                if (b) {
                    this.display(true);
                    break;
                }
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 786432: {
                boolean b;
                boolean bl = b = this.isNumeric && !this.numericAutoClear ? this.inp.delNnac() : this.inp.delch();
                if (b) {
                    this.display(true);
                    break;
                }
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 589824: {
                this.resetInsMode();
                if (this.inp.myleft()) {
                    this.repaint();
                    break;
                }
                this.listener.inputTerminated(e);
                break;
            }
            case 655360: {
                this.resetInsMode();
                if (this.inp.myright()) {
                    this.repaint();
                    break;
                }
                this.listener.inputTerminated(e);
                break;
            }
            case 917504: {
                this.inp.clear();
                this.display(true);
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
                break;
            }
            case 983040: {
                if (this.cl2endFillSpaces) {
                    while (this.inp.idx < this.inp.len) {
                        this.inp.addch(' ');
                    }
                    this.display(true);
                    if (!this.autoTermination) break;
                    this.check();
                    this.listener.inputTerminated(new PicobolTextEvent(this, 303));
                    break;
                }
                if (this.isNumeric && !this.numericAutoClear) {
                    this.inp.cl2EndNnac();
                } else {
                    this.inp.cl2End();
                }
                this.display(true);
                if (VirtualKeyboard.exception(cobFun) < 0) break;
                this.listener.inputTerminated(e);
            }
        }
        if (!e.isActionKey() && editingvalue == 0) {
            char ch = e.getKeyChar();
            ch = e.getKeyCode() == 32 ? (char)' ' : (char)Toolkit.key2ASCII((int)e.getKeyCode()).charAt(0);
            if (this.isNumeric) {
                boolean ok = Character.isDigit(ch);
                boolean addDecPoint = false;
                boolean addSign = false;
                int signIdx = -1;
                if (!ok) {
                    if (this.numericAutoClear) {
                        ok = ch == ',' || ch == '.' || ch == '/' || ch == ' ' || ch == '-';
                    } else {
                        addSign = ch == '-' || ch == '+';
                        if (addSign) {
                            if (this.inp.isSigned) {
                                for (signIdx = this.inp.getFirstDigitIdx() - 1; signIdx >= 0 && this.inp.isEditingIndex(signIdx); --signIdx) {
                                }
                                if (this.inp.decPointIdx > 0 && signIdx > this.inp.decPointIdx) {
                                    signIdx = this.inp.decPointIdx - 1;
                                }
                                if (signIdx < 0) {
                                    signIdx = 0;
                                }
                                ok = true;
                            }
                        } else if (ch == this.inp.decPointChar) {
                            ok = addDecPoint = this.inp.idx <= this.inp.decPointIdx;
                        }
                    }
                }
                if (ok) {
                    if (addDecPoint) {
                        this.inp.addDecPoint();
                    } else if (addSign) {
                        if (ch == '-') {
                            ((InpData)this.inp).data[signIdx] = 45;
                        } else if (this.inp.data[signIdx] == '-') {
                            ((InpData)this.inp).data[signIdx] = 32;
                        }
                    } else {
                        this.inp.addch(ch);
                    }
                    this.display(true);
                } else if (ch != '\u0107' && ch != '\u014a') {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (ch >= ' ' && ch != '\u007f') {
                if (keyCode > 127 && keyCode <= 249) {
                    this.inp.addch((char)keyCode);
                } else if (this.upper) {
                    this.inp.addch(Character.toUpperCase(ch));
                } else if (this.lower) {
                    this.inp.addch(Character.toLowerCase(ch));
                } else if (this.gf.getKdbUpper()) {
                    this.inp.addch(Character.toUpperCase(ch));
                } else if (this.gf.getKdbLower()) {
                    this.inp.addch(Character.toLowerCase(ch));
                } else {
                    this.inp.addch(ch);
                }
                this.display(true);
            }
            if (this.autoTermination) {
                boolean terminate;
                boolean bl = terminate = this.inp.idx >= this.inp.getLastNotEditIdx();
                if (!this.numericAutoClear && this.isNumeric && this.update) {
                    boolean bl2 = terminate && this.inp.isSignificantDigit(this.inp.getFirstNotEditIdx(this.inp.decPointIdx >= 0 ? this.inp.leadingZ : 0)) ? true : (terminate = false);
                }
                if (terminate) {
                    this.check();
                    this.listener.inputTerminated(new PicobolTextEvent(this, 303));
                }
            }
        }
    }

    public void keyTyped(KeyEvent e) {
        this.keyPressed(e);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void addTextListener(PicobolTextListener l) {
        this.listener = l;
    }

    public void removeTextListener() {
        this.listener = null;
    }

    public void setUnderline(boolean b) {
        if (b) {
            if (this.promptChar == '_') {
                this.promptChar = (char)32;
            }
            this.attr |= 0x2000000;
        } else {
            this.attr &= 0xFDFFFFFF;
            this.promptChar = this.promptCharOrig;
        }
    }

    public void setBold(boolean b) {
        this.attr = b ? (this.attr |= 0x1000000) : (this.attr &= 0xFEFFFFFF);
    }

    public void setNoEcho(boolean b) {
        if (b) {
            this.attr |= 0x10000000;
            if (this.updateFromScreen) {
                this.inp.setValue("");
            }
        } else {
            this.attr &= 0xEFFFFFFF;
        }
    }

    public void setBlink(boolean b) {
        this.attr = b ? (this.attr |= 0x8000000) : (this.attr &= 0xF7FFFFFF);
    }

    public void setReverse(boolean b) {
        this.attr = b ? (this.attr |= 0x4000000) : (this.attr &= 0xFBFFFFFF);
    }

    public void setAuto(boolean b) {
        this.autoTermination = b;
    }

    public void setUpdate(boolean b) {
        this.update = b;
    }

    public void setPrompt(boolean b) {
        this.prompt = b;
    }

    public void setPromptChar(char c) {
        this.promptChar = c;
    }

    public void setLower(boolean b) {
        this.lower = b;
    }

    public void setUpper(boolean b) {
        this.upper = b;
    }

    public void setFull(boolean b) {
        this.full = b;
    }

    public void setRequired(boolean b) {
        this.required = b;
    }

    public void setZeroFill(boolean b) {
        this.zeroFill = b;
    }

    public void focusGained(CobolFocusEvent e) {
        if (this.length == 0) {
            return;
        }
        this.tm.move(this.col, this.line);
        this.savebackcolor = this.tm.getBackColor();
        this.savetermattr = this.tm.getTermAttr();
        this.tm.setAttr(this.attr);
        this.tm.setBackColor(this.getBackground());
        this.tm.setForeColor(this.getForeground());
        if (this.update || this.prompt) {
            this.tm.addstr(this.inp.getData(this.prompt));
        }
        this.tm.move(this.col + this.inp.idx, this.line);
        this.tm.setCaretAt(this.col + this.inp.col, this.line, this);
        if (this.alphaAutoClear && (!this.isNumeric || this.inp.pict != null && this.editedFormatted) || this.numericAutoClear && this.isNumeric && (this.inp.pict == null || !this.editedFormatted)) {
            this.inp.setSelectedAll(true);
        }
        this.tt.repaint();
    }

    public void focusLost(CobolFocusEvent e) {
        if (this.length == 0) {
            return;
        }
        this.tm.unsetCaret(this);
        this.inp.col = (this.inp.idx = 0);
        this.resetInsMode();
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
        this.tt.repaint();
    }

    @Override
    public void setActiveAccept(boolean b) {
        if (!b && this.promptAll && (this.activeAccept && this.promptAllStr.equalsIgnoreCase("PROTECTED") || !this.activeAccept)) {
            this.display(false);
        }
        this.activeAccept = b;
    }

    @Override
    public void asyncProcessEvent(AWTEvent e) {
    }

    protected void processEvent(AWTEvent evt_) {
        if (evt_ instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)evt_);
        } else if (evt_ instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)evt_);
        } else if (evt_ instanceof MouseEvent) {
            this.processMouseEvent((MouseEvent)evt_);
        }
    }

    @Override
    public boolean getActiveAccept() {
        return this.activeAccept;
    }

    @Override
    public void setSelfAct(boolean b) {
    }

    @Override
    public boolean getSelfAct() {
        return false;
    }

    public void setSize(int w, int h) {
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.size != null) {
            super.setBounds(x, y, this.size.width, this.size.height);
        } else {
            super.setBounds(x, y, 1, 1);
        }
    }

    public void setValue(String v) {
        this.inp.setValue(v);
        this.display(this.promptAll);
    }

    public void refreshValue(String v) {
        this.inp.setValue(v);
        this.display(this.promptAll, false);
    }

    public String getValue() {
        String Return2 = this.inp.getValue();
        if (this.just != null) {
            Return2 = this.just.get(Return2, this.inp.getLength());
        }
        if (this.upper) {
            return Factory.toUpperCase(Return2, this.upperLowerMethod);
        }
        if (this.lower) {
            return Factory.toLowerCase(Return2, this.upperLowerMethod);
        }
        if (this.gf.getKdbUpper()) {
            return Factory.toUpperCase(Return2, this.upperLowerMethod);
        }
        if (this.gf.getKdbLower()) {
            return Factory.toLowerCase(Return2, this.upperLowerMethod);
        }
        return Return2;
    }

    public void setNumeric(boolean b) {
        this.isNumeric = b;
    }

    public void setCursorPos(int crs) {
        this.setCursorPos(crs, false);
    }

    public void setCursorPos(int crs, boolean saveselctedall) {
        if (this.update && crs > 0 && (crs >> 16) - 1 == this.line) {
            boolean savesa = this.inp.selectedAll;
            if (this.isNumeric && saveselctedall) {
                this.inp.selectedAll = false;
            }
            this.inp.setOffset((crs & 0xFFFF) - 1 - this.col);
            if (this.isNumeric && saveselctedall) {
                this.inp.selectedAll = savesa;
            }
        }
    }

    public void setJustification(Justification j) {
        this.just = j;
    }

    public int getCursorPos() {
        return this.line + 1 << 16 | this.col + this.inp.getOffset() + 1;
    }

    public int getOffset() {
        return this.inp.getOffset();
    }

    public int getIdx() {
        return this.inp.getIdx();
    }

    public String check() {
        if (this.length == 0) {
            return null;
        }
        if (this.required && this.inp.idx == 0) {
            return Factory.getSysMsg("ef_input_required_msg");
        }
        if (this.full && this.inp.idx != this.inp.len && this.inp.idx != 0) {
            return Factory.getSysMsg("ef_input_filled_msg");
        }
        if (this.zeroFill) {
            this.inp.end();
            while (this.inp.idx < this.inp.len) {
                this.inp.addch('0');
            }
        }
        this.display(this.promptAll);
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
        return null;
    }

    public void setKdbUpper(boolean b) {
        if (b) {
            this.setKdbLower(false);
        }
    }

    public void setKdbLower(boolean b) {
        if (b) {
            this.setKdbUpper(false);
        }
    }

    public void debug(int i) {
    }

    public Dimension minimumSize() {
        return new Dimension(0, 0);
    }

    public int getHeight() {
        return 0;
    }

    public int getWidth() {
        return 0;
    }

    public Dimension getSize() {
        return new Dimension(0, 0);
    }

    public void draw() {
    }

    @Override
    public void setSize(Dimension d) {
    }

    @Override
    public void setLocation(Point d) {
    }

    @Override
    public void setForeground(Color d) {
        super.setForeground(d);
    }

    @Override
    public void setBackground(Color d) {
        super.setBackground(d);
    }

    public void setParent(Container container_) {
        if (container_ != null) {
            super.setParent(container_);
        }
    }

    public void focusLost(FocusEvent fe) {
    }

    public void focusGained(FocusEvent fe) {
    }

    private void resetInsMode() {
        if (this.inp.insMode) {
            this.toggleInsMode();
        }
    }

    private void toggleInsMode() {
        this.tm.insertCursor = this.inp.insMode = !this.inp.insMode;
        this.inp.selectedAll = false;
    }

    public void saveBGandAttr() {
        if (this.savebackcolor == 0xFFFFFFFFFFFFFFFL) {
            this.savebackcolor = this.tm.getBackColor();
        }
        if (this.savetermattr == 0xFFFFFFFFFFFFFFFL) {
            this.savetermattr = this.tm.getTermAttr();
        }
    }

    public void restoreBGandAttr() {
        if (this.savebackcolor != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setBackColor((int)this.savebackcolor);
            this.savebackcolor = 0xFFFFFFFFFFFFFFFL;
        }
        if (this.savetermattr != 0xFFFFFFFFFFFFFFFL) {
            this.tm.setTermAttr((int)this.savetermattr);
            this.savetermattr = 0xFFFFFFFFFFFFFFFL;
        }
    }

    private static final char[] normalizePic(String p) {
        int iLen;
        if (p != null && (iLen = p.length()) > 0) {
            StringBuilder sb = new StringBuilder();
            char lChar = '\u0000';
            for (int i = 0; i < iLen; ++i) {
                char c = p.charAt(i);
                if (c == '(') {
                    int pLen = 0;
                    while (Character.isDigit(c = p.charAt(++i))) {
                        pLen *= 10;
                        pLen += Character.digit(c, 10);
                    }
                    --pLen;
                    for (int j = 0; j < pLen; ++j) {
                        sb.append(lChar);
                    }
                    continue;
                }
                lChar = c;
                sb.append(lChar);
            }
            char[] Return2 = sb.toString().toCharArray();
            block6: for (int i = 0; i < Return2.length; ++i) {
                switch (Return2[i]) {
                    case 'B': 
                    case 'b': {
                        Return2[i] = 32;
                        continue block6;
                    }
                }
            }
            return Return2;
        }
        return null;
    }

    private char getValidChar(char c) {
        return (char)(this.dataRange == null || c >= this.dataRange[0] && c <= this.dataRange[1] ? c : 32);
    }

    public void setCompilerOptionCR(boolean b) {
        this.compilerOptionCR = b;
    }

    private class InpData {
        private char[] data;
        private int len;
        private int maxIdx;
        private int idx;
        private int col;
        private boolean selectedAll;
        private boolean insMode;
        private char[] pict;
        private char decPointChar;
        private int decPointIdx;
        private boolean isSigned;
        private int leadingZ;

        InpData() {
        }

        void setPicture(String p, boolean dpc) {
            this.pict = TerminalAccept.normalizePic(p);
            if (this.pict != null) {
                boolean numNoAC;
                this.decPointChar = (char)(dpc ? 44 : 46);
                boolean foundEditing = false;
                boolean bl = numNoAC = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear;
                if (this.pict[0] == 'S') {
                    this.isSigned = true;
                    this.pict[0] = 57;
                }
                this.decPointIdx = -1;
                for (int i = this.pict.length - 1; i >= 0; --i) {
                    foundEditing |= TerminalAccept.isEditing(this.pict[i]);
                    if (!numNoAC) continue;
                    if (this.pict[i] == this.decPointChar) {
                        this.decPointIdx = i;
                    }
                    this.isSigned |= this.pict[i] == '-' || this.pict[i] == '+';
                }
                int end = this.decPointIdx >= 0 ? this.decPointIdx - 1 : this.pict.length - 1;
                this.leadingZ = 0;
                while (this.leadingZ <= end && (this.pict[this.leadingZ] == 'z' || this.pict[this.leadingZ] == 'Z' || this.isEditingIndex(this.leadingZ))) {
                    ++this.leadingZ;
                }
                if (!foundEditing) {
                    this.pict = null;
                }
            } else {
                this.decPointChar = (char)46;
                this.decPointIdx = -1;
                this.isSigned = true;
                this.leadingZ = 0;
            }
        }

        public void setSelectedAll(boolean b) {
            this.selectedAll = !TerminalAccept.this.updateFromScreen && b;
        }

        public void setLen(int len) {
            this.len = len;
            if (this.data != null) {
                if (len != this.data.length) {
                    int i;
                    char[] od = this.data;
                    this.data = new char[len];
                    int n = i = len <= od.length ? len : od.length;
                    while (--i >= 0) {
                        this.data[i] = od[i];
                    }
                }
            } else {
                this.data = new char[len];
            }
        }

        private boolean isEditingIndex(int idx) {
            return this.pict != null && idx < this.pict.length && TerminalAccept.isEditing(this.pict[idx]);
        }

        void setValue(String val) {
            block19: {
                block17: {
                    char[] ini;
                    int ml;
                    block18: {
                        int offset;
                        char[] ini2;
                        int i;
                        int i2;
                        boolean numNoAC;
                        if (val == null || val.length() <= 0) break block17;
                        if (this.data == null) {
                            this.setLen(val.length());
                        }
                        boolean bl = numNoAC = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear;
                        if (!numNoAC) break block18;
                        val = val.trim();
                        if (this.decPointIdx > 0) {
                            int idx = val.lastIndexOf(this.decPointChar);
                            if (idx < 0 || idx == val.length() - 1) {
                                int end = this.decPointIdx - this.leadingZ;
                                while (val.length() > end && val.charAt(0) == '0') {
                                    val = val.substring(1);
                                }
                                val = val + this.decPointChar;
                                for (i2 = this.decPointIdx + 1; i2 < this.pict.length; ++i2) {
                                    val = this.isEditingIndex(i2) ? val + this.pict[i2] : val + '0';
                                }
                            } else {
                                char[] aftDecPoint = val.substring(idx + 1).toCharArray();
                                val = val.substring(0, idx + 1);
                                i = 0;
                                for (int j = this.decPointIdx + 1; j < this.pict.length; ++j) {
                                    val = this.isEditingIndex(j) ? val + this.pict[j] : (i < aftDecPoint.length ? val + aftDecPoint[i++] : val + '0');
                                }
                            }
                        } else if (this.pict != null && this.leadingZ > 0) {
                            int end = this.pict.length - this.leadingZ;
                            while (val.length() > end && val.charAt(0) == '0') {
                                val = val.substring(1);
                            }
                        }
                        int ml2 = this.len <= (ini2 = val.toCharArray()).length ? this.len : ini2.length;
                        for (i2 = 0; i2 < this.len - ml2; ++i2) {
                            this.data[i2] = 32;
                        }
                        this.maxIdx = this.len;
                        boolean insertEditChars = TerminalAccept.this.editedFormatted && this.pict != null && this.len <= ini2.length;
                        i = 0;
                        for (int j = this.len - ml2; i < ini2.length && j < this.data.length; ++i, ++j) {
                            this.data[j] = insertEditChars && TerminalAccept.isEditing(this.pict[j]) ? this.pict[j] : ini2[i];
                        }
                        int maxOffset = this.decPointIdx > 0 ? this.decPointIdx - 1 : this.len - 1;
                        for (offset = Math.min(this.len - ml2, maxOffset); offset < maxOffset && (this.data[offset] == ' ' || this.data[offset] == '-'); ++offset) {
                        }
                        if (this.isEditingIndex(offset)) break block19;
                        int decPointSave = this.decPointIdx;
                        char[] pictSave = this.pict;
                        this.pict = null;
                        this.decPointIdx = -1;
                        this.setOffset(offset);
                        this.pict = pictSave;
                        this.decPointIdx = decPointSave;
                        break block19;
                    }
                    for (int i = ml = this.len <= (ini = val.toCharArray()).length ? this.len : ini.length; i < this.len; ++i) {
                        this.data[i] = 32;
                    }
                    --ml;
                    while (ml >= 0 && ini[ml] == ' ') {
                        --ml;
                    }
                    ++ml;
                    this.maxIdx = ml--;
                    while (ml >= 0) {
                        this.data[ml] = TerminalAccept.this.getValidChar(ini[ml]);
                        --ml;
                    }
                    break block19;
                }
                for (int i = 0; i < this.len; ++i) {
                    this.data[i] = 32;
                }
            }
        }

        public String getValue() {
            return new String(this.data, 0, this.maxIdx);
        }

        public void clear() {
            this.idx = 0;
            this.col = 0;
            this.maxIdx = 0;
        }

        public void cl2End() {
            this.maxIdx = this.col = this.idx;
        }

        void cl2EndNnac() {
            boolean hasDecPoint;
            int currIdx = this.idx;
            if (currIdx >= this.len) {
                currIdx = this.len - 1;
            }
            boolean bl = hasDecPoint = this.decPointIdx >= 0;
            if (!hasDecPoint || this.idx < this.decPointIdx) {
                int i;
                int n = this.idx = hasDecPoint ? this.decPointIdx - 1 : this.len - 1;
                while (this.isEditingIndex(this.idx)) {
                    --this.idx;
                }
                int diff = 0;
                for (i = currIdx; i <= this.idx; ++i) {
                    if (this.isEditingIndex(i)) continue;
                    ++diff;
                }
                for (i = 0; i < diff; ++i) {
                    this.delNnac();
                }
                this.idx = hasDecPoint ? (this.col = this.decPointIdx) : (this.col = this.len);
            } else {
                if (currIdx == this.decPointIdx) {
                    ++currIdx;
                }
                while (currIdx < this.len) {
                    if (!this.isEditingIndex(currIdx)) {
                        this.data[currIdx] = 48;
                    }
                    ++currIdx;
                }
            }
        }

        void addDecPoint() {
            int tmpIdx = this.idx;
            this.idx = this.decPointIdx - 1;
            for (int i = this.decPointIdx - 1; i >= tmpIdx; --i) {
                if (this.isEditingIndex(i)) continue;
                this.delNnac();
            }
            this.col = this.idx = this.decPointIdx + 1;
        }

        boolean addch(char c) {
            if (this.selectedAll) {
                this.clear();
                this.selectedAll = false;
            }
            if (TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear) {
                int n;
                int n2 = n = this.decPointIdx > 0 && this.idx <= this.decPointIdx ? this.decPointIdx : this.len;
                if (this.idx < n) {
                    int i;
                    if (this.insMode) {
                        for (i = n - 1; i > this.idx; --i) {
                            int j = i - 1;
                            while (this.isEditingIndex(j)) {
                                --j;
                            }
                            this.data[i] = this.data[j];
                            i = j + 1;
                        }
                        if (this.maxIdx < n) {
                            ++this.maxIdx;
                        }
                    }
                    this.data[this.idx] = c;
                    ++this.idx;
                    ++this.col;
                    if (this.idx > this.maxIdx) {
                        for (i = this.idx - 2; i >= this.maxIdx; --i) {
                            this.data[i] = 32;
                        }
                        this.maxIdx = this.idx;
                    }
                    if (this.idx < n && !this.insMode && this.isEditingIndex(this.idx)) {
                        return this.addch(this.pict[this.idx]);
                    }
                    return true;
                }
                this.addNnac(c);
                return false;
            }
            if (this.idx < this.len) {
                int i;
                if (this.insMode) {
                    int n = i = this.maxIdx < this.len ? this.maxIdx : this.maxIdx - 1;
                    while (i > this.idx) {
                        this.data[i] = this.data[i - 1];
                        --i;
                    }
                    if (this.maxIdx < this.len) {
                        ++this.maxIdx;
                    }
                }
                this.data[this.idx] = c;
                ++this.idx;
                this.col += TerminalAccept.this.tm.dblWidth(c) ? 2 : 1;
                if (this.idx > this.maxIdx) {
                    for (i = this.idx - 2; i >= this.maxIdx; --i) {
                        this.data[i] = 32;
                    }
                    this.maxIdx = this.idx;
                }
                if (TerminalAccept.this.editedFormatted && this.isEditingIndex(this.idx)) {
                    return this.addch(this.pict[this.idx]);
                }
                return true;
            }
            if (this.idx > 0) {
                this.data[this.idx - 1] = c;
            }
            return false;
        }

        private int getFirstNotEditIdx(int r) {
            while (r < this.data.length && this.isEditingIndex(r)) {
                ++r;
            }
            return r;
        }

        private int getLastNotEditIdx() {
            int r;
            for (r = this.len - 1; r >= 0 && this.isEditingIndex(r); --r) {
            }
            return r + 1;
        }

        private boolean isSignificantDigit(int idx) {
            return this.data[idx] != ' ' && this.data[idx] != '+' && this.data[idx] != '-';
        }

        private int getFirstDigitIdx() {
            int firstDigitIdx;
            for (firstDigitIdx = 0; firstDigitIdx < this.data.length && (!this.isSignificantDigit(firstDigitIdx) || this.isEditingIndex(firstDigitIdx)); ++firstDigitIdx) {
            }
            return firstDigitIdx;
        }

        private void addNnac(char c) {
            int idx1;
            int idx0;
            boolean decPart;
            boolean bl = decPart = this.decPointIdx > 0 && this.idx > this.decPointIdx;
            if (decPart) {
                idx0 = this.decPointIdx + 1;
                idx1 = this.data.length;
            } else {
                idx0 = 0;
                idx1 = this.decPointIdx > 0 ? this.decPointIdx : this.data.length;
            }
            int firstDigitIdx = this.getFirstDigitIdx();
            if (!decPart && firstDigitIdx > 0) {
                int editing = 0;
                for (int i = idx0 + 1; i < idx1; ++i) {
                    if (this.isEditingIndex(i)) {
                        if (i >= firstDigitIdx - 1) {
                            this.data[i] = this.pict[i];
                        }
                        ++editing;
                        continue;
                    }
                    this.data[i - 1 - editing] = this.data[i];
                    editing = 0;
                }
            } else if (this.idx > 0 && this.idx == this.decPointIdx && this.getFirstDigitIdx() == 0) {
                this.right();
                this.addch(c);
                return;
            }
            this.data[idx1 - 1] = c;
        }

        public boolean isAtEnd() {
            return this.idx == this.len;
        }

        public void delcur() {
            this.selectedAll = false;
            if (this.idx < this.maxIdx) {
                for (int i = this.idx + 1; i < this.maxIdx; ++i) {
                    this.data[i - 1] = this.data[i];
                }
                if (this.maxIdx > 0) {
                    this.data[--this.maxIdx] = 32;
                }
                if (this.idx > this.maxIdx) {
                    this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx]) ? 2 : 1;
                    --this.idx;
                }
            }
        }

        boolean delNnac() {
            this.selectedAll = false;
            int idx = this.idx;
            if (idx >= this.len) {
                idx = this.len - 1;
            }
            while (this.isEditingIndex(idx)) {
                --idx;
            }
            int n = this.decPointIdx > 0 ? (idx > this.decPointIdx ? this.decPointIdx + 1 : 0) : 0;
            int firstDigitIdx = this.getFirstDigitIdx();
            ++firstDigitIdx;
            while (this.isEditingIndex(firstDigitIdx)) {
                ++firstDigitIdx;
            }
            block2: for (int i = idx; i > n; --i) {
                if (this.pict != null) {
                    if (i < this.pict.length && TerminalAccept.isEditing(this.pict[i])) {
                        if (i > firstDigitIdx) continue;
                        this.data[i] = 32;
                        continue;
                    }
                    for (int j = i - 1; j >= n; --j) {
                        if (j < this.pict.length && TerminalAccept.isEditing(this.pict[j])) continue;
                        this.data[i] = this.data[j];
                        continue block2;
                    }
                    continue;
                }
                this.data[i] = this.data[i - 1];
            }
            if (!this.isEditingIndex(n)) {
                this.data[n] = this.decPointIdx > 0 && n > this.decPointIdx ? 48 : 32;
                ++idx;
                while (idx != this.decPointIdx && idx < this.len && this.isEditingIndex(idx)) {
                    this.data[idx] = 32;
                    ++idx;
                }
                this.idx = idx;
                this.col = idx;
            }
            return true;
        }

        public boolean delch() {
            boolean Return2;
            this.selectedAll = false;
            if (this.idx > 0) {
                this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx - 1]) ? 2 : 1;
                if (this.idx > this.maxIdx) {
                    --this.idx;
                } else {
                    for (int i = this.idx; i < this.maxIdx; ++i) {
                        this.data[i - 1] = this.data[i];
                    }
                    --this.idx;
                    this.data[--this.maxIdx] = 32;
                }
                if (TerminalAccept.this.editedFormatted && this.isEditingIndex(this.idx)) {
                    return this.delch();
                }
                Return2 = true;
            } else {
                Return2 = false;
            }
            return Return2;
        }

        boolean myleft() {
            if (this.idx == 0 || this.getValue() != null && this.getValue().length() == 0 && this.idx == 0) {
                return false;
            }
            return this.left();
        }

        public boolean left() {
            this.selectedAll = false;
            if (this.idx > 0) {
                this.col -= TerminalAccept.this.tm.dblWidth(this.data[this.idx - 1]) ? 2 : 1;
                --this.idx;
                if ((TerminalAccept.this.editedFormatted || this.idx != this.decPointIdx) && this.isEditingIndex(this.idx)) {
                    return this.left();
                }
                return true;
            }
            return false;
        }

        boolean myright() {
            String v = this.getValue();
            int c = this.col;
            if (v != null && v.length() != 0 && v.length() == c) {
                return false;
            }
            return this.right();
        }

        public boolean right() {
            this.selectedAll = false;
            if (this.idx < (TerminalAccept.this.update ? this.len - 1 : this.maxIdx)) {
                this.col += TerminalAccept.this.tm.dblWidth(this.data[this.idx]) ? 2 : 1;
                ++this.idx;
                if (this.pict != null && this.idx < this.pict.length && TerminalAccept.isEditing(this.pict[this.idx])) {
                    this.right();
                }
                return true;
            }
            return false;
        }

        public boolean home() {
            int newIdx;
            this.selectedAll = false;
            boolean Return2 = this.idx != 0;
            this.col = this.idx = (newIdx = TerminalAccept.this.isNumeric && !TerminalAccept.this.numericAutoClear ? this.getFirstDigitIdx() : 0);
            return Return2;
        }

        public boolean end() {
            boolean Return2;
            this.selectedAll = false;
            if (this.maxIdx == this.len) {
                Return2 = this.idx != this.maxIdx - 1;
                this.idx = this.maxIdx - 1;
            } else {
                Return2 = this.idx != this.maxIdx;
                this.idx = this.maxIdx;
            }
            this.col = 0;
            for (int i = 0; i < this.idx; ++i) {
                this.col += TerminalAccept.this.tm.dblWidth(this.data[i]) ? 2 : 1;
            }
            return Return2;
        }

        public void setOffset(int offs) {
            if (offs > 0) {
                while (this.idx < this.len && this.idx < offs) {
                    if (this.data[this.idx] >= ' ' && this.data[this.idx] != '\u007f') {
                        this.addch(this.data[this.idx]);
                        continue;
                    }
                    this.addch(' ');
                }
            }
            if (this.maxIdx > 0 && offs < this.maxIdx) {
                this.idx = offs;
                this.col = 0;
                for (int i = 0; i < this.idx; ++i) {
                    this.col += TerminalAccept.this.tm.dblWidth(this.data[i]) ? 2 : 1;
                }
            }
        }

        public int getOffset() {
            return this.col;
        }

        int getIdx() {
            return this.idx;
        }

        int getLength() {
            return this.len;
        }

        public char[] getData(boolean prmpt) {
            if (prmpt) {
                for (int i = this.maxIdx; i < this.len; ++i) {
                    this.data[i] = TerminalAccept.this.promptChar;
                }
            } else {
                for (int i = this.maxIdx; i < this.len; ++i) {
                    this.data[i] = 32;
                }
            }
            return this.data;
        }

        public char[] getDataCompilerOptionCR() {
            return this.data;
        }
    }
}

