/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.ScaleLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public class ZoomLayout
extends ScaleLayout {
    private float maxFontZoom;
    private float minFontZoom;

    public ZoomLayout(Container container, String defaultSettings) {
        this(container, defaultSettings, 0, 0);
    }

    public ZoomLayout(Container container, String defaultSettings, int defMinFontZoom, int defMaxFontZoom) {
        super(container, defaultSettings);
        Integer i = (Integer)this.cTypeLayoutDatas.get("max-font-zoom");
        if (i != null) {
            this.maxFontZoom = i.floatValue() / 100.0f;
            this.cTypeLayoutDatas.remove("max-font-zoom");
        } else {
            this.maxFontZoom = (float)defMaxFontZoom / 100.0f;
        }
        i = (Integer)this.cTypeLayoutDatas.get("min-font-zoom");
        if (i != null) {
            this.minFontZoom = i.floatValue() / 100.0f;
            this.cTypeLayoutDatas.remove("min-font-zoom");
        } else {
            this.minFontZoom = (float)defMinFontZoom / 100.0f;
        }
    }

    @Override
    public void addLayoutComponent(Component comp, IscobolLayout.LayoutData data) {
        this.addLayoutComponent(comp, (Object)data);
    }

    @Override
    public void addLayoutComponent(Component comp, Object data) {
        if (data == null) {
            data = this.createLayoutData(comp, 0, 1, 0, 1, "0", null);
        } else if (!(data instanceof ZoomLayoutData)) {
            throw new IllegalArgumentException("ZoomLayoutData object required.");
        }
        super.addLayoutComponent(comp, data);
        ((ZoomLayoutData)data).setOrigFont(comp.getFont());
    }

    @Override
    public IscobolLayout.LayoutData createLayoutData(Component comp, int maxWidth, int minWidth, int maxHeight, int minHeight, String ld, String controlType) {
        return new ZoomLayoutData(comp, maxWidth, minWidth, maxHeight, minHeight, ld);
    }

    @Override
    protected void layoutContainer(Dimension currContainerSize) {
        super.layoutContainer(currContainerSize);
        float resizeFontDelta = this.getResizeFontDelta();
        for (Component comp : this.constraintsTable.keySet()) {
            Font of;
            ZoomLayoutData lData = (ZoomLayoutData)this.constraintsTable.get(comp);
            if ((lData.getAction() & 0x10) != 16 || (of = lData.getOrigFont()) == null) continue;
            comp.setFont(of.deriveFont(of.getSize2D() * resizeFontDelta));
            for (FontProvider provider : lData.additionalFonts.keySet()) {
                Font f = (Font)lData.additionalFonts.get(provider);
                if (f == null) {
                    f = provider.getFont();
                    lData.additionalFonts.put(provider, f);
                }
                if (f == null) continue;
                provider.setFont(f.deriveFont(f.getSize2D() * resizeFontDelta));
            }
        }
    }

    private float getResizeFontDelta() {
        float Return2 = this.containerHeightDelta;
        if (this.minFontZoom > 0.0f && this.containerHeightDelta < this.minFontZoom) {
            Return2 = this.minFontZoom;
        }
        if (this.maxFontZoom > 0.0f && this.containerHeightDelta > this.maxFontZoom) {
            Return2 = this.maxFontZoom;
        }
        return Return2;
    }

    @Override
    public String getDefaultLayoutDataString(String controltype) {
        try {
            controltype = controltype.toLowerCase();
            Integer o = (Integer)this.cTypeLayoutDatas.get(controltype);
            if (o != null) {
                return o.toString();
            }
            return String.valueOf(119);
        }
        catch (Exception ex) {
            return "0";
        }
    }

    public static class ZoomLayoutData
    extends IscobolLayout.DefaultLayoutData {
        private Font origFont;
        private Map<FontProvider, Font> additionalFonts = new HashMap<FontProvider, Font>();

        public ZoomLayoutData(Component comp, int maxWidth, int minWidth, int maxHeight, int minHeight, String ldString) {
            super(comp, maxWidth, minWidth, maxHeight, minHeight, ldString, null);
        }

        public void putAdditionalOrigFont(FontProvider fontProvider) {
            this.additionalFonts.put(fontProvider, fontProvider.getFont());
        }

        public void removeAdditionalOrigFont(FontProvider fontProvider) {
            this.additionalFonts.remove(fontProvider);
        }

        public void setOrigFont(Font font) {
            this.origFont = font;
        }

        public Font getOrigFont() {
            return this.origFont;
        }
    }

    public static interface FontProvider {
        public Font getFont();

        public void setFont(Font var1);
    }
}

