/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.VirtualKeyboard;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.TerminalModel;
import com.iscobol.logger.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Terminal
extends Component
implements PropertyChangeListener {
    private static final int DEFAULT_BLINK_RATE = 600;
    private TerminalModel tm;
    private boolean needPaint;
    private boolean empty = true;
    private Dimension charDim;
    private final Logger guiLog = KeyboardBuffer.guiLog;
    private int cursorType;
    private int cursorBlink;
    private CursorTimer cursorTimer;
    AbstractGuiFactoryImpl gf;

    public Terminal(AbstractGuiFactoryImpl gf) {
        this.gf = gf;
        this.tm = new TerminalModel(gf);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Component[] carray;
                Container wparent;
                Component focusowner;
                KeyboardFocusManager manager;
                if (Terminal.this.guiLog != null) {
                    Terminal.this.guiLog.info("Terminal: keyPressed [" + e + "] focus owner [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() + "] focus cycle root [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentFocusCycleRoot() + "] focused window [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() + "] active window [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() + "]");
                }
                int cobFun = Terminal.this.gf.getRemoteVirtualKeyboard().mapKey(e);
                boolean altpausepressed = false;
                if (e instanceof KeyEvent && e.getKeyCode() == 19 && e.getID() == 401 && e.isAltDown()) {
                    altpausepressed = true;
                } else if (VirtualKeyboard.isException(cobFun) && VirtualKeyboard.exception(cobFun) == 65534) {
                    altpausepressed = true;
                }
                if (altpausepressed && (manager = KeyboardFocusManager.getCurrentKeyboardFocusManager()) != null && (focusowner = manager.getFocusOwner()) == Terminal.this && (wparent = Terminal.this.getParent()) != null && (carray = wparent.getComponents()) != null && carray.length > 0) {
                    if (Terminal.this.guiLog != null) {
                        Terminal.this.guiLog.info("Terminal: keyPressed wparent [" + wparent + "] num components [" + carray.length + "]");
                    }
                    Component firstc = null;
                    for (int i = 0; i < carray.length; ++i) {
                        if (carray[i] != null) {
                            if (firstc == null && carray[i] != Terminal.this) {
                                firstc = carray[i];
                            }
                            if (Terminal.this.guiLog == null) continue;
                            Terminal.this.guiLog.info("Terminal: components [" + i + "] [" + carray[i] + "] hasfocus [" + carray[i].hasFocus() + "] isfocusable [" + carray[i].isFocusable() + "] visible [" + carray[i].isVisible() + "] newfocus [" + firstc + "]");
                            continue;
                        }
                        if (Terminal.this.guiLog == null) continue;
                        Terminal.this.guiLog.info("Terminal: components [" + i + "] [" + carray[i] + "]");
                    }
                    if (firstc != null && firstc.isFocusable() && firstc.isVisible()) {
                        firstc.requestFocusInWindow();
                    }
                }
            }
        });
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private void init() {
        try {
            Class[] params = new Class[]{Boolean.TYPE};
            Terminal.class.getMethod("setFocusable", params).invoke((Object)this, new Boolean(true));
            Terminal.class.getMethod("setFocusTraversalKeysEnabled", params).invoke((Object)this, new Boolean(false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(float colf, float linef, LocalFontCmp font, int w, int h) {
        int cols = (int)Math.ceil(colf);
        int lines = (int)Math.ceil(linef);
        this.init();
        Font f = font.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        if (fm.charWidth('W') != fm.charWidth('i')) {
            f = new Font("Monospaced", f.getStyle(), f.getSize());
        }
        this.setFont(f);
        this.charDim = new Dimension();
        this.charDim.width = w / cols;
        this.charDim.height = h / lines;
        if (w % cols > cols / 2) {
            ++this.charDim.width;
        }
        if (h % lines > lines / 2) {
            ++this.charDim.height;
        }
        this.gf.getCsProperty().addPropertyChangeListener(this);
        this.tm.init(cols, lines, this.charDim, this.getFontMetrics(f));
        this.cursorType = this.gf.getCsProperty().get("iscobol.terminal.cursor_type", 2);
        this.cursorBlink = this.gf.getCsProperty().get("iscobol.terminal.cursor_blink", 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.gf != null) {
            int val;
            if (evt.getPropertyName().equals("iscobol.terminal.cursor_type")) {
                this.cursorType = this.gf.getCsProperty().get("iscobol.terminal.cursor_type", 2);
                if (this.cursorBlink == 0) {
                    this.tm.setCursorType(this.cursorType);
                }
            } else if (evt.getPropertyName().equals("iscobol.terminal.cursor_blink") && (val = this.gf.getCsProperty().get("iscobol.terminal.cursor_blink", 0)) != this.cursorBlink) {
                this.cursorBlink = val;
                if (this.cursorBlink > 0) {
                    this.restartCursorTimer();
                } else {
                    this.tm.setCursorType(this.cursorType);
                    if (this.cursorTimer != null) {
                        this.cursorTimer.stopped = true;
                        this.cursorTimer.interrupt();
                        this.cursorTimer = null;
                    }
                }
            }
        }
    }

    public boolean moveAt(int col, int line) {
        return this.tm.move(col, line);
    }

    public Rectangle display(int col, int line, String data, int size, Color fore, int attrs, Color back, Justification j, boolean isNational) {
        this.needPaint = true;
        this.empty = false;
        this.restartCursorTimer();
        if (this.moveAt(col, line)) {
            this.repaint();
        }
        return this.tm.addstr(j.get(data, size), size, fore, attrs, back, isNational);
    }

    public TerminalModel getTerminalModel() {
        this.needPaint = true;
        this.restartCursorTimer();
        return this.tm;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.tm.getPreferredSize();
    }

    private void restartCursorTimer() {
        if (this.cursorBlink > 0) {
            if (this.cursorTimer != null) {
                this.cursorTimer.interrupt();
            } else {
                this.cursorTimer = new CursorTimer();
                this.cursorTimer.delay = this.cursorBlink == 1 ? 600 : this.cursorBlink;
                this.cursorTimer.start();
            }
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.needPaint) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(Color.green);
            this.tm.paint(g2d);
        } else {
            super.paint(g);
        }
    }

    public void setBackground(int x, int y, int w, int h, Color c) {
        this.tm.setBackground(x, y, w, h, c);
    }

    public void setForeground(int x, int y, int w, int h, Color c, int attr) {
        this.tm.setForeground(x, y, w, h, c, attr);
    }

    @Override
    public void setBackground(Color c) {
        this.tm.setBackground(c);
        super.setBackground(c);
    }

    public void setBackColor(Color c) {
        this.tm.setBackColor(c);
    }

    public void setForeColor(Color c) {
        this.tm.setForeColor(c);
    }

    public String acceptFromScreen(int line, int col, int size) {
        return this.tm.acceptFromScreen(line, col, size);
    }

    public String attrFromScreen(int line, int col, int size) {
        return this.tm.attrFromScreen(line, col, size);
    }

    public void writeToScreen(int line, int col, int size, String chr, String atr) {
        this.tm.writeToScreen(line, col, size, chr, atr);
    }

    public void changeWidth(int nw) {
        this.tm.changeWidth(nw);
        this.setSize(this.getPreferredSize());
    }

    public void end() {
        this.gf.getCsProperty().removePropertyChangeListener(this);
        this.tm.end();
        this.needPaint = false;
        this.tm = null;
        this.gf = null;
        if (this.cursorTimer != null) {
            this.cursorTimer.interrupt();
            this.cursorTimer = null;
        }
    }

    public Dimension getCharDim() {
        return this.charDim;
    }

    @Override
    public void repaint() {
    }

    public void myrepaint() {
        super.repaint();
    }

    private class CursorTimer
    implements Runnable {
        private int delay = 600;
        private Thread thread;
        private boolean cursorVisible;
        private boolean stopped;

        private CursorTimer() {
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    Thread.sleep(this.delay);
                    if (Terminal.this.tm == null) {
                        return;
                    }
                    Terminal.this.tm.setCursorType(this.cursorVisible ? Terminal.this.cursorType : 0);
                    Terminal.this.needPaint = true;
                    Terminal.this.repaint();
                    this.cursorVisible = !this.cursorVisible;
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        void interrupt() {
            this.thread.interrupt();
        }

        void start() {
            this.thread = new Thread(this);
            this.thread.setName(Terminal.class.getName() + ".CursorTimer");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }
}

