/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.ScreenUtility;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class LocalImage {
    private Image theImage;
    private byte[] imageBytes;
    private boolean lightGrayTransparent;
    private int type;
    private final int bitmapLoadMethod;

    public LocalImage(Image img, int type, int bitmapLoadMethod) {
        this.theImage = img;
        this.type = type;
        this.bitmapLoadMethod = bitmapLoadMethod;
    }

    public LocalImage(byte[] imageBytes, int type, boolean lgTransp, int bitmapLoadMethod) {
        this.imageBytes = imageBytes;
        this.type = type;
        this.lightGrayTransparent = lgTransp;
        this.bitmapLoadMethod = bitmapLoadMethod;
    }

    public Image getImage() {
        if (this.theImage == null && this.imageBytes != null) {
            this.theImage = ScreenUtility.createImage(this.imageBytes, new int[]{this.type}, true, this.lightGrayTransparent, this.bitmapLoadMethod);
            this.imageBytes = null;
        }
        return this.theImage;
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        Image im = this.getImage();
        return im != null ? im.getWidth(null) : 0;
    }

    public int getHeight() {
        Image im = this.getImage();
        return im != null ? im.getHeight(null) : 0;
    }

    public byte[] save(String fileName, char format, int jpegQuality, int transparentColor, boolean saveOnClient) {
        String formatName;
        Image theImage = this.getImage();
        if (theImage == null) {
            return new byte[0];
        }
        switch (format) {
            case 'b': {
                formatName = "bmp";
                break;
            }
            case 'g': {
                formatName = "gif";
                break;
            }
            case 'j': {
                formatName = "jpg";
                break;
            }
            default: {
                formatName = "png";
            }
        }
        ImageWriter writer = ImageIO.getImageWritersByFormatName(formatName).next();
        Image img = theImage;
        JPEGImageWriteParam params = null;
        int imageType = 1;
        if ("jpg".equals(formatName)) {
            params = new JPEGImageWriteParam(null);
            params.setCompressionMode(2);
            params.setCompressionQuality((float)jpegQuality / 100.0f);
        } else if ("png".equals(formatName) || "gif".equals(formatName)) {
            if (transparentColor >= 0) {
                img = ScreenUtility.makeColorTransparent(img, transparentColor);
            }
            imageType = 2;
        }
        try {
            ImageOutputStreamImpl ios;
            ByteArrayOutputStream baos = null;
            if (saveOnClient) {
                ios = new FileImageOutputStream(new File(fileName));
            } else {
                baos = new ByteArrayOutputStream();
                ios = new MemoryCacheImageOutputStream(baos);
            }
            writer.setOutput(ios);
            writer.write(null, new IIOImage(LocalImage.getBufferedImage(img, imageType), null, null), params);
            ios.close();
            writer.dispose();
            if (saveOnClient) {
                return new byte[]{1};
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return new byte[0];
        }
    }

    private static BufferedImage getBufferedImage(Image img, int imageType) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        MediaTracker mt = new MediaTracker(new Component(){});
        mt.addImage(img, 1);
        try {
            mt.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), imageType);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

