/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.client.ClientHandler;
import com.iscobol.interfaces.runtime.IIDEClientHandler;
import com.iscobol.interfaces.runtime.IIDEClientHelper;
import com.iscobol.interfaces.runtime.IIDESettings;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rpc.dualrpc.client.AbstractClientRpcHandler;
import com.iscobol.rpc.dualrpc.client.DualRpcClient;
import com.iscobol.rpc.dualrpc.client.IClientCallbackHandler;
import com.iscobol.rts.Auth;
import com.iscobol.rts.Factory;
import com.iscobol.types.CobolVar;
import com.iscobol.types.PicN;
import com.iscobol.types.PicXAnyLength;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;

public class IDEClientHandler
extends AbstractClientRpcHandler
implements IIDEClientHandler,
IClientCallbackHandler {
    private IIDEClientHelper helper;
    private DualRpcClient caller;

    @Override
    public void connect(String hostName, int portNumber) throws Exception {
        DualRpcClient client = new DualRpcClient(hostName, portNumber);
        client.setDefaultCallTimeoutInSeconds(0);
        client.registerClientSideHandler(this);
        IscobolMessageSerializer messageSerializer = new IscobolMessageSerializer();
        client.setMessageSerializer(messageSerializer);
        client.setCallbackHandler(this);
        client.connect();
        this.caller = client;
        this.caller.call("com.iscobol.as.IDEHandler", "isIDE");
    }

    public Object[] login(byte[] challenge, boolean retry) {
        Object[] login;
        if (this.helper != null && (login = this.helper.login(retry)) != null && login[0] != null && login[1] != null) {
            char[] passwd = (char[])login[1];
            int pwdSize = passwd.length * 2;
            PicN cPwd = new PicN(new byte[pwdSize], 0, pwdSize, null, null, "", false, false);
            cPwd.set(passwd, false);
            PicXAnyLength rand = Factory.getVarXAnyLength(new byte[0], 0, 0, false, null, null, null, "rand", false, false);
            rand.set(challenge);
            PicXAnyLength hPwd = new PicXAnyLength(new byte[0], 0, 0, null, null, "", false, false);
            PicXAnyLength hhPw = new PicXAnyLength(new byte[0], 0, 0, null, null, "", false, false);
            String alg = Auth.getAlgorithmFromChallenge(rand);
            Auth.getDigest(new CobolVar[]{hPwd, cPwd}, alg);
            Auth.getDigest(new CobolVar[]{hhPw, rand, hPwd}, alg);
            byte[] hashPasswd = ((CobolVar)hhPw).getMemory();
            return new Object[]{login[0], hashPasswd};
        }
        return null;
    }

    public IIDESettings getNewConfiguration() {
        if (this.helper != null) {
            return this.helper.getNewConfiguration();
        }
        return null;
    }

    @Override
    public void setHelper(IIDEClientHelper helper) {
        this.helper = helper;
    }

    @Override
    public IIDEClientHelper getHelper() {
        return this.helper;
    }

    @Override
    public IIDESettings getServerConfiguration() throws Exception {
        if (this.caller != null) {
            return (IIDESettings)this.caller.call("com.iscobol.as.IDEHandler", "getConfiguration");
        }
        return null;
    }

    @Override
    public void setServerConfiguration() throws Exception {
        if (this.caller != null) {
            this.caller.call("com.iscobol.as.IDEHandler", "setConfiguration");
        }
    }

    @Override
    public void brokenConnection() {
        if (this.helper != null) {
            this.helper.brokenConnection();
        }
    }

    @Override
    public String[] list(String parentDir, boolean selectDir, String[] filterExtensions) throws Exception {
        if (this.caller != null) {
            return (String[])this.caller.call("com.iscobol.as.IDEHandler", "list", parentDir, (Object)selectDir, filterExtensions);
        }
        return null;
    }

    @Override
    public String[] getIscobolLibraryFiles() throws Exception {
        if (this.caller != null) {
            return (String[])this.caller.call("com.iscobol.as.IDEHandler", "getIscobolLibraryFiles");
        }
        return null;
    }

    @Override
    public boolean[] needsToBeCompiled(String[] files, long[] timestamps) throws Exception {
        if (this.caller != null) {
            return (boolean[])this.caller.call("com.iscobol.compiler.remote.server.IDERemoteCompilerHandler", "needsToBeCompiled", files, timestamps);
        }
        return null;
    }

    @Override
    public String clean(String[] files) throws Exception {
        if (this.caller != null) {
            return (String)this.caller.call("com.iscobol.compiler.remote.server.IDERemoteCompilerHandler", "clean", files);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 5) {
            throw new IllegalArgumentException("wrong parameters");
        }
        HashMap<String, Object> ideParams = new HashMap<String, Object>();
        ideParams.put("od", args[3]);
        ideParams.put("runMode", args[4]);
        int i = 5;
        if (args.length > i && args[i].equals("-c") && args.length > i + 1) {
            String confFile = args[i + 1];
            try {
                FileInputStream in = new FileInputStream(confFile);
                byte[] b = new byte[in.available()];
                in.read(b);
                in.close();
                ideParams.put("confFile", b);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            i += 2;
        }
        String[] debugArgs = null;
        if (args.length > i) {
            debugArgs = new String[]{"true", "0", "false"};
        }
        new ClientHandler().init(args[0], args[1], "0", args[2], new String[0], null, false, null, null, false, debugArgs, false, null, ideParams, null);
    }
}

