/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.gui.ScreenUtility;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializableImage
implements Serializable {
    private transient Image image;
    private static final long serialVersionUID = 11421251452614251L;

    public SerializableImage(Image img) {
        this.image = img;
    }

    public Image getImage() {
        return this.image;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        PixelGrabber grabber = new PixelGrabber(this.image, 0, 0, -1, -1, true);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        ScreenUtility io = new ScreenUtility();
        Object pix = grabber.getPixels();
        Dimension dim = new Dimension(this.image.getWidth(io), this.image.getHeight(io));
        stream.writeObject(dim);
        stream.writeObject(pix);
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            stream.defaultReadObject();
            Dimension dim = (Dimension)stream.readObject();
            Object img = stream.readObject();
            int[] pix = (int[])img;
            this.image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(dim.width, dim.height, pix, 0, dim.width));
        }
        catch (ClassNotFoundException e) {
            throw new IOException();
        }
    }
}

