/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import java.util.Vector;

public class JavaBeanUtilities {
    public static final int INIT_PARAM_ALPHANUMERIC = 1001;
    public static final int INIT_PARAM_NUMERIC = 1002;

    public static Method getMethod(Class beanType, boolean isStatic, Method[] beanMethods, String methodName, String signature, Object[] parameters) throws Throwable {
        Method meth;
        if (signature != null) {
            Class[] parTypes = JavaBeanUtilities.signatureToTypes(signature);
            meth = beanType.getMethod(methodName, parTypes);
            if (isStatic && !JavaBeanUtilities.isStatic(meth)) {
                throw new NoSuchMethodException();
            }
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    parameters[i] = JavaBeanUtilities.checkType(parTypes[i], parameters[i]);
                }
            }
        } else {
            Method[] meths = JavaBeanUtilities.getMethods(methodName, parameters, beanMethods, isStatic);
            if (meths.length == 0) {
                throw new NoSuchMethodException();
            }
            if (meths.length > 1) {
                StringBuffer errMsg = new StringBuffer("Ambiguous method invokation:\n");
                for (int i = 0; i < meths.length; ++i) {
                    errMsg.append("   " + JavaBeanUtilities.getMethodSignature(meths[i]) + "\n");
                }
                throw new NoSuchMethodException(errMsg.toString());
            }
            if (parameters != null) {
                Class<?>[] parTypes = meths[0].getParameterTypes();
                for (int i = 0; i < parameters.length; ++i) {
                    parameters[i] = JavaBeanUtilities.checkType(parTypes[i], parameters[i]);
                }
            }
            meth = meths[0];
        }
        return meth;
    }

    public static Object callMethod(Class beanType, Object theBean, Method[] beanMethods, String methodName, String signature, Object[] parameters) throws Throwable {
        Method m = JavaBeanUtilities.getMethod(beanType, theBean == null, beanMethods, methodName, signature, parameters);
        return m.invoke(theBean, parameters);
    }

    private static String getMethodSignature(Method m) throws Exception {
        StringBuffer Return2 = new StringBuffer();
        Class<?> retType = m.getReturnType();
        if (retType.isArray()) {
            int i = 0;
            while (retType.isArray()) {
                retType = retType.getComponentType();
                ++i;
            }
            Return2.append(retType.getName());
            for (int j = 0; j < i; ++j) {
                Return2.append("[]");
            }
        } else {
            Return2.append(retType.getName());
        }
        Return2.append(" " + m.getName());
        Return2.append("(");
        Class<?>[] params = m.getParameterTypes();
        for (int k = 0; k < params.length; ++k) {
            Class<?> parType;
            if (k > 0) {
                Return2.append(",");
            }
            if ((parType = params[k]).isArray()) {
                int i = 0;
                while (parType.isArray()) {
                    parType = parType.getComponentType();
                    ++i;
                }
                Return2.append(parType.getName());
                for (int j = 0; j < i; ++j) {
                    Return2.append("[]");
                }
                continue;
            }
            Return2.append(parType.getName());
        }
        Return2.append(")");
        return Return2.toString();
    }

    public static Object checkType(Class parType, Object src) {
        if (src instanceof INumericVar) {
            if (parType.isAssignableFrom(INumericVar.class)) {
                return src;
            }
            INumericVar nv = (INumericVar)src;
            if (!nv.isInteger()) {
                if (parType == Float.TYPE) {
                    return new Float(nv.tofloat());
                }
                if (parType == Double.TYPE) {
                    return new Double(nv.todouble());
                }
            } else {
                if (parType == Byte.TYPE) {
                    return new Byte(nv.tobyte());
                }
                if (parType == Short.TYPE) {
                    return new Short(nv.toshort());
                }
                if (parType == Integer.TYPE) {
                    return new Integer(nv.toint());
                }
                if (parType == Long.TYPE) {
                    return new Long(nv.tolong());
                }
                if (parType == Float.TYPE) {
                    return new Float(nv.tofloat());
                }
                if (parType == Double.TYPE) {
                    return new Double(nv.todouble());
                }
                if (parType == Boolean.TYPE) {
                    return new Boolean(nv.toint() != 0);
                }
            }
        } else if (src instanceof ICobolVar) {
            String str;
            if (parType.isAssignableFrom(ICobolVar.class)) {
                return src;
            }
            if (parType == String.class) {
                return ScreenUtility.rightTrim(src.toString());
            }
            if (parType == Character.TYPE && (str = src.toString()).length() > 0) {
                return new Character(str.charAt(0));
            }
        } else if (src instanceof String) {
            String str = (String)src;
            if (parType == String.class) {
                return src;
            }
            if (parType == Character.TYPE && str.length() == 1) {
                return new Character(str.charAt(0));
            }
        }
        return src;
    }

    private static boolean isStatic(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }

    private static Method[] getMethods(String name, Object[] params, Method[] beanMethods, boolean onlyStatic) throws Exception {
        if (params == null) {
            params = new Object[]{};
        }
        Vector<Method> Return2 = new Vector<Method>();
        for (int i = 0; i < beanMethods.length; ++i) {
            Class<?>[] parTypes;
            if (onlyStatic && !JavaBeanUtilities.isStatic(beanMethods[i]) || !beanMethods[i].getName().equals(name) || (parTypes = beanMethods[i].getParameterTypes()).length != params.length) continue;
            boolean ok = true;
            for (int j = 0; j < parTypes.length; ++j) {
                if (JavaBeanUtilities.isAssignableFrom(parTypes[j], params[j])) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            Return2.addElement(beanMethods[i]);
        }
        Method[] ret = new Method[Return2.size()];
        Return2.toArray(ret);
        return ret;
    }

    public static boolean isAssignableFrom(Class parType, Object param) {
        if (param == null) {
            return !parType.isPrimitive();
        }
        if (param instanceof INumericVar) {
            if (parType.isAssignableFrom(INumericVar.class)) {
                return true;
            }
            INumericVar nv = (INumericVar)param;
            if (!nv.isInteger()) {
                return parType == Float.TYPE || parType == Double.TYPE;
            }
            return parType == Byte.TYPE || parType == Short.TYPE || parType == Integer.TYPE || parType == Long.TYPE || parType == Float.TYPE || parType == Double.TYPE || parType == Boolean.TYPE;
        }
        if (param instanceof ICobolVar) {
            return parType.isAssignableFrom(ICobolVar.class) || parType.isAssignableFrom(String.class) || parType == Character.TYPE && param.toString().length() == 1;
        }
        if (param instanceof String) {
            return parType.isAssignableFrom(String.class) || parType == Character.TYPE && param.toString().length() == 1;
        }
        if (param instanceof Character) {
            return parType.isAssignableFrom(Character.class) || parType == Character.TYPE;
        }
        if (param instanceof Byte) {
            return parType.isAssignableFrom(Byte.class) || parType == Byte.TYPE;
        }
        if (param instanceof Short) {
            return parType.isAssignableFrom(Short.class) || parType == Short.TYPE;
        }
        if (param instanceof Integer) {
            return parType.isAssignableFrom(Integer.class) || parType == Integer.TYPE;
        }
        if (param instanceof Long) {
            return parType.isAssignableFrom(Long.class) || parType == Long.TYPE;
        }
        if (param instanceof Float) {
            return parType.isAssignableFrom(Float.class) || parType == Float.TYPE;
        }
        if (param instanceof Double) {
            return parType.isAssignableFrom(Double.class) || parType == Double.TYPE;
        }
        if (param instanceof Boolean) {
            return parType.isAssignableFrom(Boolean.class) || parType == Boolean.TYPE;
        }
        return parType.isInstance(param);
    }

    public static Class[] signatureToTypes(String sign) throws Exception {
        StringTokenizer stk = new StringTokenizer(sign.replaceAll(" ", ""), ",");
        Vector v = new Vector();
        while (stk.hasMoreTokens()) {
            String className;
            String tk = stk.nextToken();
            int dim = 0;
            int idx = tk.indexOf("[]");
            if (idx >= 0) {
                className = tk.substring(0, idx);
                dim = 1;
                while ((idx = tk.indexOf("[]", idx + 2)) >= 0) {
                    ++dim;
                }
            } else {
                className = tk;
            }
            if (className.equals("char")) {
                if (dim > 0) {
                    v.addElement(Class.forName(JavaBeanUtilities.addBrackets(dim) + "C"));
                    continue;
                }
                v.addElement(Character.TYPE);
                continue;
            }
            if (className.equals("boolean")) {
                if (dim > 0) {
                    v.addElement(Class.forName(JavaBeanUtilities.addBrackets(dim) + "Z"));
                    continue;
                }
                v.addElement(Boolean.TYPE);
                continue;
            }
            if (className.equals("byte")) {
                if (dim > 0) {
                    v.addElement(Class.forName(JavaBeanUtilities.addBrackets(dim) + "B"));
                    continue;
                }
                v.addElement(Byte.TYPE);
                continue;
            }
            if (className.equals("short")) {
                if (dim > 0) {
                    v.addElement(Class.forName(JavaBeanUtilities.addBrackets(dim) + "S"));
                    continue;
                }
                v.addElement(Short.TYPE);
                continue;
            }
            if (className.equals("int")) {
                if (dim > 0) {
                    v.addElement(Class.forName(JavaBeanUtilities.addBrackets(dim) + "I"));
                    continue;
                }
                v.addElement(Integer.TYPE);
                continue;
            }
            if (className.equals("long")) {
                if (dim > 0) {
                    v.addElement(Class.forName(JavaBeanUtilities.addBrackets(dim) + "J"));
                    continue;
                }
                v.addElement(Long.TYPE);
                continue;
            }
            if (className.equals("float")) {
                if (dim > 0) {
                    v.addElement(Class.forName(JavaBeanUtilities.addBrackets(dim) + "F"));
                    continue;
                }
                v.addElement(Float.TYPE);
                continue;
            }
            if (className.equals("double")) {
                if (dim > 0) {
                    v.addElement(Class.forName(JavaBeanUtilities.addBrackets(dim) + "D"));
                    continue;
                }
                v.addElement(Double.TYPE);
                continue;
            }
            if (dim > 0) {
                v.addElement(Class.forName(JavaBeanUtilities.addBrackets(dim) + "L" + className + ";"));
                continue;
            }
            v.addElement(Class.forName(className));
        }
        Class[] Return2 = new Class[v.size()];
        v.toArray(Return2);
        return Return2;
    }

    private static String addBrackets(int n) {
        String s = "";
        for (int i = 0; i < n; ++i) {
            s = s + "[";
        }
        return s;
    }
}

