/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import com.iscobol.rts.Config;
import java.awt.Color;

public class ColorCmp
implements Cloneable {
    public static final int BLACK = 0;
    public static final int BLUE = 1;
    public static final int GREEN = 2;
    public static final int CYAN = 3;
    public static final int RED = 4;
    public static final int MAGENTA = 5;
    public static final int BROWN = 6;
    public static final int WHITE = 7;
    private int foreground = -1;
    private int background = -1;
    private boolean reverse;
    private boolean underline;
    private boolean backHighIntensity;
    private boolean foreHighIntensity;
    private boolean protectedAttribute;
    private boolean blink;
    private boolean foregroundSet;
    private boolean backgroundSet;
    private boolean foreIntensitySet;
    private boolean backIntensitySet;

    public ColorCmp() {
        this(true);
    }

    public ColorCmp(boolean isStandard) {
        this.setStandard(isStandard);
    }

    public ColorCmp(ColorCmp cc) {
        this.copyColor(cc);
    }

    public ColorCmp(int col) {
        if (col == 0) {
            col = 1;
        }
        this.setColor(col, (col & 0x3E0) > 0);
    }

    public void setStandard(boolean isStandard) {
        if (isStandard) {
            this.foreground = 0;
            this.background = 7;
        } else {
            this.foreground = 7;
            this.background = 0;
            this.backHighIntensity = false;
        }
    }

    public void setColor(int col) {
        this.setColor(col, (col & 0x3E0) > 0);
    }

    public void setColor(int color, boolean isForegroundAndBackground) {
        if (color >= 131072) {
            color %= 131072;
            this.backHighIntensity = true;
            this.backIntensitySet = true;
        }
        if (color >= 65536 && color < 131072) {
            color -= 65536;
            this.backHighIntensity = false;
            this.backIntensitySet = true;
        }
        if (color >= 32768 && color < 65536) {
            color -= 32768;
            this.protectedAttribute = true;
        }
        if (color >= 16384 && color < 32768) {
            this.blink = true;
            color -= 16384;
        }
        if (color >= 8192 && color < 16384) {
            this.underline = true;
            color -= 8192;
        }
        if (color >= 4096 && color < 8192) {
            color -= 4096;
            this.foreHighIntensity = true;
            this.foreIntensitySet = true;
        }
        if (color >= 2048 && color < 4096) {
            this.foreHighIntensity = false;
            this.foreIntensitySet = true;
            color -= 2048;
        }
        if (color >= 1024 && color < 2048) {
            this.reverse = true;
            color -= 1024;
        }
        if (color >= 544 && color < 1024) {
            color -= 512;
        }
        if (isForegroundAndBackground) {
            if (color <= 543) {
                if (color < 32) {
                    this.setForeNoRGB(color - 1);
                } else if (color < 64) {
                    this.setBackground(0);
                    this.setForeNoRGB(color - 32 - 1);
                } else if (color < 96) {
                    this.setBackground(1);
                    this.setForeNoRGB(color - 64 - 1);
                } else if (color < 128) {
                    this.setBackground(2);
                    this.setForeNoRGB(color - 96 - 1);
                } else if (color < 160) {
                    this.setBackground(3);
                    this.setForeNoRGB(color - 128 - 1);
                } else if (color < 192) {
                    this.setBackground(4);
                    this.setForeNoRGB(color - 160 - 1);
                } else if (color < 224) {
                    this.setBackground(5);
                    this.setForeNoRGB(color - 192 - 1);
                } else if (color < 256) {
                    this.setBackground(6);
                    this.setForeNoRGB(color - 224 - 1);
                } else if (color <= 287) {
                    this.setBackground(7);
                    if (color > 256) {
                        if (color <= 272) {
                            this.setForeNoRGB(color - 256 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (color <= 319) {
                    this.setBackground(8);
                    if (color > 288) {
                        if (color <= 304) {
                            this.setForeNoRGB(color - 288 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (color <= 351) {
                    this.setBackground(9);
                    if (color > 320) {
                        if (color <= 336) {
                            this.setForeNoRGB(color - 320 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (color <= 383) {
                    this.setBackground(10);
                    if (color > 352) {
                        if (color <= 368) {
                            this.setForeNoRGB(color - 352 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (color <= 415) {
                    this.setBackground(11);
                    if (color > 384) {
                        if (color <= 400) {
                            this.setForeNoRGB(color - 384 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (color <= 447) {
                    this.setBackground(12);
                    if (color > 416) {
                        if (color <= 432) {
                            this.setForeNoRGB(color - 416 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (color <= 479) {
                    this.setBackground(13);
                    if (color > 448) {
                        if (color <= 464) {
                            this.setForeNoRGB(color - 448 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (color <= 511) {
                    this.setBackground(14);
                    if (color > 480) {
                        if (color <= 496) {
                            this.setForeNoRGB(color - 480 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                } else if (color <= 543) {
                    this.setBackground(15);
                    if (color > 512) {
                        if (color <= 528) {
                            this.setForeNoRGB(color - 512 - 1);
                        } else {
                            this.setForeNoRGB(0);
                        }
                    }
                }
            }
        } else if (color != 0) {
            this.setForeground(color - 1);
        }
    }

    private static int encodeAlpha(int idx) {
        int Return2 = idx & 0x7F000000;
        return Return2;
    }

    private static int decodeAlpha(int idx) {
        int Return2 = idx & 0x7F000000;
        if ((Return2 <<= 1) == 0 || Return2 == -33554432) {
            Return2 = -16777216;
        } else if (Return2 == 0x2000000) {
            Return2 = 0;
        }
        return Return2;
    }

    public static int encodeRGBColor(int idx) {
        return -(idx & 0xFFFFFF | ColorCmp.encodeAlpha(idx));
    }

    public static int decodeRGBColor(int idx) {
        idx = -idx;
        return idx & 0xFFFFFF | ColorCmp.decodeAlpha(idx);
    }

    public int getForeground() {
        return this.foreground;
    }

    public int getBackground() {
        return this.background;
    }

    public static boolean isRGB(int colorIdx) {
        return colorIdx < 0;
    }

    public static int getRealColor(int colorIdx, boolean hi) {
        if (ColorCmp.isRGB(colorIdx)) {
            return colorIdx;
        }
        if (colorIdx > 15) {
            colorIdx %= 16;
        }
        if (hi && colorIdx < 8) {
            colorIdx += 8;
        }
        return colorIdx;
    }

    public static int getRealColorBack(int colorIdx, boolean hi) {
        if (colorIdx == 0 && hi) {
            return colorIdx;
        }
        return ColorCmp.getRealColor(colorIdx, hi);
    }

    public static Color getRGBColor(int colorIdx) {
        Color Return2 = new Color(ColorCmp.decodeRGBColor(colorIdx), true);
        return Return2;
    }

    private void setForeNoRGB(int fg) {
        if (fg >= 0) {
            this.setForeground(fg);
        }
    }

    public void setForeground(int fg) {
        if (ColorCmp.isRGB(fg)) {
            this.foreground = fg;
            this.foregroundSet = true;
        } else if (fg >= 0) {
            this.foreground = fg % 16;
            this.foregroundSet = true;
        }
    }

    public void setForeRGB(int fg) {
        this.foreground = ColorCmp.isRGB(fg) ? fg : ColorCmp.encodeRGBColor(fg);
        this.foregroundSet = true;
    }

    public void setBackground(int bg) {
        if (ColorCmp.isRGB(bg)) {
            this.background = bg;
            this.backgroundSet = true;
        } else if (bg >= 0) {
            this.background = bg % 16;
            this.backgroundSet = true;
        }
    }

    public void setBackRGB(int bg) {
        this.background = ColorCmp.isRGB(bg) ? bg : ColorCmp.encodeRGBColor(bg);
        this.backgroundSet = true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException _ex) {
            throw new RuntimeException(_ex);
        }
    }

    public void copyColor(ColorCmp cc) {
        this.foreground = cc.foreground;
        this.background = cc.background;
        this.foreHighIntensity = cc.foreHighIntensity;
        this.foreIntensitySet = cc.foreIntensitySet;
        this.backHighIntensity = cc.backHighIntensity;
        this.backIntensitySet = cc.backIntensitySet;
        this.reverse = false;
        this.underline = false;
        this.blink = false;
        this.protectedAttribute = cc.protectedAttribute;
    }

    public void setReverse(boolean v) {
        this.reverse = v;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public void setUnderline(boolean v) {
        this.underline = v;
    }

    public boolean getUnderline() {
        return this.underline;
    }

    public void setBackHighIntensity(boolean v) {
        this.backHighIntensity = v;
        this.backIntensitySet = true;
    }

    public void setForeHighIntensity(boolean v) {
        this.foreHighIntensity = v;
        this.foreIntensitySet = true;
    }

    private void colormapSet(int cm, ColorCmp pc, boolean force) {
        int c = -1;
        if (force && pc != null) {
            c = cm & 0xF;
            if (c != 0) {
                this.setForeground(c - 1);
            } else if (c == 0) {
                this.setForeground(15);
            }
            c = (cm & 0x1E0) >>> 5;
            if (c != 0) {
                this.setBackground(c - 1);
            }
        } else if (pc == null) {
            if (!this.isForegroundSet() && (c = cm & 0xF) != 0) {
                this.setForeground(c - 1);
            } else if (c == 0) {
                this.setForeground(15);
            }
            if (!this.isBackgroundSet() && (c = (cm & 0x1E0) >>> 5) != 0) {
                this.setBackground(c - 1);
            }
        } else {
            if (!this.isForegroundSet() && !pc.isForegroundSet() && (c = cm & 0xF) != 0) {
                this.setForeground(c - 1);
            } else if (c == 0) {
                this.setForeground(15);
            }
            if (!this.isBackgroundSet() && !pc.isBackgroundSet() && (c = (cm & 0x1E0) >>> 5) != 0) {
                this.setBackground(c - 1);
            }
        }
    }

    public void evalColorMap(ColorCmp pc) {
        if (this.foreIntensitySet) {
            if (this.foreHighIntensity) {
                int cm = Config.getProperty("iscobol.colormap.high", 0);
                if (cm != 0) {
                    this.colormapSet(cm, pc, true);
                    this.foreIntensitySet = false;
                }
            } else {
                int cm = Config.getProperty("iscobol.colormap.low", 0);
                if (cm != 0) {
                    this.colormapSet(cm, pc, true);
                    this.foreIntensitySet = false;
                }
            }
        } else {
            int cm = Config.getProperty("iscobol.colormap.default", 0);
            if (cm != 0) {
                this.colormapSet(cm, pc, false);
            }
        }
    }

    public boolean getProtectedAttribute() {
        return this.protectedAttribute;
    }

    public void setProtectedAttribute(boolean b) {
        this.protectedAttribute = b;
    }

    public boolean getForeHighIntensity() {
        return this.foreHighIntensity;
    }

    public boolean getBackHighIntensity() {
        return this.backHighIntensity;
    }

    public void setBlink(boolean v) {
        this.blink = v;
    }

    public boolean getBlink() {
        return this.blink;
    }

    public boolean isForegroundSet() {
        return this.foregroundSet;
    }

    public boolean isBackgroundSet() {
        return this.backgroundSet;
    }

    public boolean isForeIntensitySet() {
        return this.foreIntensitySet;
    }

    public boolean isBackIntensitySet() {
        return this.backIntensitySet;
    }

    public String toString() {
        String Return2 = ColorCmp.isRGB(this.foreground) ? "[fg=" + Integer.toHexString(ColorCmp.decodeRGBColor(this.foreground)) + "]" : "fg=" + this.foreground + ",fs=" + this.foregroundSet + ",fh=" + this.foreHighIntensity + ",fi=" + this.foreIntensitySet + "]";
        Return2 = ColorCmp.isRGB(this.background) ? Return2 + " [bg=" + Integer.toHexString(ColorCmp.decodeRGBColor(this.background)) + "]" : Return2 + " [bg=" + this.background + ",bs=" + this.backgroundSet + ",bh=" + this.backHighIntensity + ",bi=" + this.backIntensitySet + "]";
        Return2 = Return2 + ",pr=" + this.protectedAttribute + ",ul=" + this.underline + ",rv=" + this.reverse + ",bl=" + this.blink;
        return Return2;
    }
}

