/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.easydb;

import com.iscobol.easydb.Condition;
import com.iscobol.easydb.EdbiIs;
import com.iscobol.easydb.EdbiIsCommon;
import com.iscobol.easydb.Field;
import com.iscobol.easydb.FieldList;
import com.iscobol.easydb.Segment;
import com.iscobol.easydb.SegmentList;
import com.iscobol.easydb.StringList;
import com.iscobol.easydb.Table;

public class Index
implements EdbiIsCommon {
    public int offset;
    public int size;
    public int xmlLine;
    public boolean idxdups;
    public FieldList idxfields = new FieldList();
    public StringList namePart = new StringList();
    public SegmentList segments;
    public String whereLine = "";
    public String tableSpace;
    public String storIni;
    public String storNext;
    public String storIncr;
    public String hint;
    public String hintIdx;
    public String cobName;
    public String sqlName;
    public boolean isSplit;
    public int segNum;
    public EdbiIs edbi;

    public Index(EdbiIs edb, boolean d) {
        this.edbi = edb;
        this.isSplit = false;
        this.xmlLine = 0;
        this.hint = "";
        this.hintIdx = "";
        this.tableSpace = this.edbi.getOption("-oti=") != null ? this.edbi.getOption("-oti=") : "";
        this.storIni = this.edbi.getOption("-oii=") != null ? this.edbi.getOption("-oii=") : "";
        this.storNext = this.edbi.getOption("-oni=") != null ? this.edbi.getOption("-oni=") : "";
        this.storIncr = this.edbi.getOption("-opi=") != null ? this.edbi.getOption("-opi=") : "";
        this.segments = new SegmentList();
    }

    public Index(EdbiIs edbi, FieldList fl, Index idx, Condition con, Table par) {
        if (edbi.hasDebug()) {
            System.err.println("Enter in creation of multiple index");
        }
        this.idxdups = idx.idxdups;
        this.isSplit = idx.isSplit;
        this.tableSpace = idx.tableSpace;
        this.storIni = idx.storIni;
        this.storNext = idx.storNext;
        this.storIncr = idx.storIncr;
        this.segNum = idx.segNum;
        this.segments = idx.segments;
        Segment seg = idx.segments.getFirst();
        this.xmlLine = idx.xmlLine;
        this.hint = idx.hint;
        this.hintIdx = idx.hintIdx;
        while (seg != null) {
            if (edbi.hasDebug()) {
                System.err.println("Segment offset[" + seg.offset + "] size[" + seg.size + "]");
            }
            boolean found = false;
            Field tfld = fl.getFirst();
            while (tfld != null) {
                if ((tfld.xmlcondition == con.number || tfld.origcondition == -1) && tfld.xmloffset >= seg.offset && tfld.xmloffset < seg.offset + seg.size && tfld.xmloffset + tfld.xmlsize <= seg.offset + seg.size) {
                    found = true;
                    if (tfld.getCobName().equalsIgnoreCase("FILLER")) {
                        edbi.printErr(18, this.cobName + " the index cannot contain FILLER fields", idx.xmlLine);
                        return;
                    }
                    if (par.getByName(tfld.getCobName()) == null) {
                        par.fields.addItem(tfld);
                        FieldList nSqlFields = new FieldList();
                        Field fld = par.sqlfields.getFirst();
                        boolean added = false;
                        while (fld != null) {
                            if (!added && tfld.xmloffset <= fld.xmloffset) {
                                nSqlFields.addItem(tfld);
                                added = true;
                            }
                            nSqlFields.addItem(fld);
                            fld = par.sqlfields.getNext();
                        }
                        if (!added) {
                            nSqlFields.addItem(tfld);
                        }
                        par.sqlfields = nSqlFields;
                    }
                    this.idxfields.addItem(tfld);
                    if (edbi.hasDebug()) {
                        System.err.println("Add in index [" + tfld.getCobName() + "] found [" + tfld.xmlcondition + "] for [" + con.number + "] offset[" + tfld.xmloffset + "] size[" + tfld.xmlsize + "]");
                    }
                }
                tfld = fl.getNext();
            }
            if (!found) {
                edbi.printErr(18, " segment non found for condition number " + con.number, idx.xmlLine);
                return;
            }
            seg = idx.segments.getNext();
        }
        if (this.idxdups && (edbi.getOption("-dpld") != null || edbi.getOption("-dsld") != null || edbi.getOption("-dmld") != null)) {
            String name = edbi.getOidName();
            String len = "18";
            String dec = "0";
            int dbtype = edbi.getOption("-dpld") != null ? 6 : (edbi.getOption("-dmld") != null ? 3 : 2);
            Field fld = new Field(name, name, 2, 0, 18, 0, len, dec, dbtype);
            this.idxfields.addItem(fld);
            if (edbi.hasDebug()) {
                System.err.println("   Added OID in index");
            }
        }
        if (edbi.hasDebug()) {
            System.err.println("Exit from creation index multi");
        }
    }

    public void clearIndex() {
        this.idxfields = new FieldList();
    }
}

